/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.executor;

import lombok.Generated;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.Analyzer;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.executor.ExecutionContext;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.planner.PlanContext;
import org.opensearch.sql.planner.Planner;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.split.Split;

public class QueryService {
    private final Analyzer analyzer;
    private final ExecutionEngine executionEngine;
    private final Planner planner;

    public void execute(UnresolvedPlan plan, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        try {
            this.executePlan(this.analyze(plan), PlanContext.emptyPlanContext(), listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void executePlan(LogicalPlan plan, PlanContext planContext, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        try {
            planContext.getSplit().ifPresentOrElse(split -> this.executionEngine.execute(this.plan(plan), new ExecutionContext((Split)split), listener), () -> this.executionEngine.execute(this.plan(plan), ExecutionContext.emptyExecutionContext(), listener));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void explain(UnresolvedPlan plan, ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        try {
            this.executionEngine.explain(this.plan(this.analyze(plan)), listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public LogicalPlan analyze(UnresolvedPlan plan) {
        return this.analyzer.analyze(plan, new AnalysisContext());
    }

    public PhysicalPlan plan(LogicalPlan plan) {
        return this.planner.plan(plan);
    }

    @Generated
    public QueryService(Analyzer analyzer, ExecutionEngine executionEngine, Planner planner) {
        this.analyzer = analyzer;
        this.executionEngine = executionEngine;
        this.planner = planner;
    }
}

