"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.looksLikeMarkdownFilePath = exports.looksLikeMarkdownUri = void 0;
const path = require("path");
const vscode_uri_1 = require("vscode-uri");
function looksLikeMarkdownUri(config, resolvedHrefPath) {
    return looksLikeMarkdownExt(config, vscode_uri_1.Utils.extname(resolvedHrefPath));
}
exports.looksLikeMarkdownUri = looksLikeMarkdownUri;
function looksLikeMarkdownFilePath(config, fileName) {
    return looksLikeMarkdownExt(config, path.extname(fileName));
}
exports.looksLikeMarkdownFilePath = looksLikeMarkdownFilePath;
function looksLikeMarkdownExt(config, rawExt) {
    return config.markdownFileExtensions.includes(rawExt.toLowerCase().replace('.', ''));
}
//# sourceMappingURL=file.js.map