/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.common.exception;

public class AnomalyDetectionException
extends RuntimeException {
    private String anomalyDetectorId;
    private boolean countedInStats = true;

    public AnomalyDetectionException(String message) {
        super(message);
    }

    public AnomalyDetectionException(String anomalyDetectorId, String message) {
        super(message);
        this.anomalyDetectorId = anomalyDetectorId;
    }

    public AnomalyDetectionException(String adID, String message, Throwable cause) {
        super(message, cause);
        this.anomalyDetectorId = adID;
    }

    public AnomalyDetectionException(Throwable cause) {
        super(cause);
    }

    public AnomalyDetectionException(String adID, Throwable cause) {
        super(cause);
        this.anomalyDetectorId = adID;
    }

    public String getAnomalyDetectorId() {
        return this.anomalyDetectorId;
    }

    public boolean isCountedInStats() {
        return this.countedInStats;
    }

    public AnomalyDetectionException countedInStats(boolean countInStats) {
        this.countedInStats = countInStats;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Anomaly Detector ");
        sb.append(this.anomalyDetectorId);
        sb.append(' ');
        sb.append(super.toString());
        return sb.toString();
    }
}

