/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class RecordComponentBinding
extends VariableBinding {
    public ReferenceBinding declaringRecord;
    public BlockScope declaringScope;

    public RecordComponentBinding(ReferenceBinding referenceBinding, RecordComponent recordComponent, TypeBinding typeBinding, int n) {
        super(recordComponent.name, typeBinding, n, null);
        this.declaringRecord = referenceBinding;
        recordComponent.binding = this;
    }

    public RecordComponentBinding(char[] cArray, TypeBinding typeBinding, int n, ReferenceBinding referenceBinding) {
        super(cArray, typeBinding, n, null);
        this.declaringRecord = referenceBinding;
    }

    @Override
    public final int kind() {
        return 131072;
    }

    @Override
    public char[] computeUniqueKey(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.declaringRecord.computeUniqueKey(false));
        stringBuilder.append('#');
        stringBuilder.append(this.name);
        int n = stringBuilder.length();
        char[] cArray = new char[n];
        stringBuilder.getChars(0, n, cArray, 0);
        return cArray;
    }

    public char[] genericSignature() {
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        return this.type.genericTypeSignature();
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        RecordComponentBinding recordComponentBinding = this.original();
        ReferenceBinding referenceBinding = recordComponentBinding.declaringRecord;
        if (referenceBinding == null) {
            return Binding.NO_ANNOTATIONS;
        }
        return referenceBinding.retrieveAnnotations(recordComponentBinding);
    }

    @Override
    public long getAnnotationTagBits() {
        RecordComponentBinding recordComponentBinding = this.original();
        if ((recordComponentBinding.tagBits & 0x200000000L) == 0L && recordComponentBinding.declaringRecord instanceof SourceTypeBinding) {
            ClassScope classScope = ((SourceTypeBinding)recordComponentBinding.declaringRecord).scope;
            if (classScope == null) {
                this.tagBits |= 0x600000000L;
                return 0L;
            }
            TypeDeclaration typeDeclaration = classScope.referenceContext;
            RecordComponent recordComponent = typeDeclaration.declarationOf(recordComponentBinding);
            if (recordComponent != null) {
                ASTNode.resolveAnnotations((BlockScope)typeDeclaration.initializerScope, recordComponent.annotations, recordComponentBinding);
            }
        }
        return recordComponentBinding.tagBits;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public RecordComponentBinding original() {
        return this;
    }

    @Override
    public void setAnnotations(AnnotationBinding[] annotationBindingArray, boolean bl) {
        this.declaringRecord.storeAnnotations(this, annotationBindingArray, bl);
    }

    public RecordComponent sourceRecordComponent() {
        if (!(this.declaringRecord instanceof SourceTypeBinding)) {
            return null;
        }
        SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)this.declaringRecord;
        RecordComponent[] recordComponentArray = sourceTypeBinding.scope.referenceContext.recordComponents;
        if (recordComponentArray != null) {
            int n = recordComponentArray.length;
            while (--n >= 0) {
                if (this != recordComponentArray[n].binding) continue;
                return recordComponentArray[n];
            }
        }
        return null;
    }
}

