import { RequestLogger } from "../logging";
import { Request } from "matrix-appservice-bridge";
export type BridgeRequestEvent = Request<{
    event_id: string;
    sender: string;
    type: string;
    state_key?: string;
    room_id: string;
    content: Record<string, unknown>;
    origin_server_ts: number;
}>;
export type BridgeRequestData = {
    isFromIrc?: boolean;
    event_id?: string;
    room_id?: string;
    type?: string;
} | null;
export declare class BridgeRequest {
    private req;
    log: RequestLogger;
    constructor(req: Request<BridgeRequestData>);
    getId(): string;
    getPromise(): Promise<unknown>;
    resolve(thing?: unknown): void;
    reject(err?: unknown): void;
    static HandleExceptionForSentry(req: Request<BridgeRequestData>, state: "fail" | "dead"): void;
}
export declare enum BridgeRequestErr {
    ERR_VIRTUAL_USER = 0,
    ERR_NOT_MAPPED = 1,
    ERR_DROPPED = 2
}
