/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.conditional.cases;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.conditional.cases.WhenClause;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.FunctionName;

public class CaseClause
extends FunctionExpression {
    private final List<WhenClause> whenClauses;
    private final Expression defaultResult;

    public CaseClause(List<WhenClause> whenClauses, Expression defaultResult) {
        super(FunctionName.of("case"), CaseClause.concatArgs(whenClauses, defaultResult));
        this.whenClauses = whenClauses;
        this.defaultResult = defaultResult;
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        for (WhenClause when : this.whenClauses) {
            if (!when.isTrue(valueEnv)) continue;
            return when.valueOf(valueEnv);
        }
        return this.defaultResult == null ? ExprNullValue.of() : this.defaultResult.valueOf(valueEnv);
    }

    @Override
    public ExprType type() {
        List<ExprType> types = this.allResultTypes();
        return types.isEmpty() ? ExprCoreType.UNDEFINED : types.get(0);
    }

    @Override
    public <T, C> T accept(ExpressionNodeVisitor<T, C> visitor, C context) {
        return visitor.visitCase(this, context);
    }

    public List<ExprType> allResultTypes() {
        List<ExprType> types = this.whenClauses.stream().map(WhenClause::type).collect(Collectors.toList());
        if (this.defaultResult != null) {
            types.add(this.defaultResult.type());
        }
        types.removeIf(type -> type == ExprCoreType.UNDEFINED);
        return types;
    }

    private static List<Expression> concatArgs(List<WhenClause> whenClauses, Expression defaultResult) {
        ImmutableList.Builder args = ImmutableList.builder();
        whenClauses.forEach(arg_0 -> ((ImmutableList.Builder)args).add(arg_0));
        if (defaultResult != null) {
            args.add((Object)defaultResult);
        }
        return args.build();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaseClause)) {
            return false;
        }
        CaseClause other = (CaseClause)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<WhenClause> this$whenClauses = this.getWhenClauses();
        List<WhenClause> other$whenClauses = other.getWhenClauses();
        if (this$whenClauses == null ? other$whenClauses != null : !((Object)this$whenClauses).equals(other$whenClauses)) {
            return false;
        }
        Expression this$defaultResult = this.getDefaultResult();
        Expression other$defaultResult = other.getDefaultResult();
        return !(this$defaultResult == null ? other$defaultResult != null : !this$defaultResult.equals(other$defaultResult));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CaseClause;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<WhenClause> $whenClauses = this.getWhenClauses();
        result = result * 59 + ($whenClauses == null ? 43 : ((Object)$whenClauses).hashCode());
        Expression $defaultResult = this.getDefaultResult();
        result = result * 59 + ($defaultResult == null ? 43 : $defaultResult.hashCode());
        return result;
    }

    @Generated
    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    @Generated
    public Expression getDefaultResult() {
        return this.defaultResult;
    }

    @Override
    @Generated
    public String toString() {
        return "CaseClause(whenClauses=" + this.getWhenClauses() + ", defaultResult=" + this.getDefaultResult() + ")";
    }
}

