/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.matching;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Match;
import com.facebook.presto.matching.Matcher;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.matching.pattern.CapturePattern;
import com.facebook.presto.matching.pattern.EqualsPattern;
import com.facebook.presto.matching.pattern.FilterPattern;
import com.facebook.presto.matching.pattern.TypeOfPattern;
import com.facebook.presto.matching.pattern.WithPattern;
import java.util.Optional;
import java.util.function.Function;

public class DefaultMatcher
implements Matcher {
    public static final Matcher DEFAULT_MATCHER = new DefaultMatcher();

    @Override
    public <T> Match<T> match(Pattern<T> pattern, Object object, Captures captures) {
        if (pattern.previous() != null) {
            Match<?> match = this.match(pattern.previous(), object, captures);
            return match.flatMap(value -> pattern.accept(this, value, match.captures()));
        }
        return pattern.accept(this, object, captures);
    }

    @Override
    public <T> Match<T> matchTypeOf(TypeOfPattern<T> typeOfPattern, Object object, Captures captures) {
        Class<T> expectedClass = typeOfPattern.expectedClass();
        if (expectedClass.isInstance(object)) {
            return Match.of(expectedClass.cast(object), captures);
        }
        return Match.empty();
    }

    @Override
    public <T> Match<T> matchWith(WithPattern<T> withPattern, Object object, Captures captures) {
        Function<Object, Optional<?>> property = withPattern.getProperty().getFunction();
        Optional<?> propertyValue = property.apply(object);
        Match propertyMatch = propertyValue.map(value -> this.match(withPattern.getPattern(), value, captures)).orElse(Match.empty());
        return propertyMatch.map(ignored -> object);
    }

    @Override
    public <T> Match<T> matchCapture(CapturePattern<T> capturePattern, Object object, Captures captures) {
        return Match.of(object, captures.addAll(Captures.ofNullable(capturePattern.capture(), object)));
    }

    @Override
    public <T> Match<T> matchEquals(EqualsPattern<T> equalsPattern, Object object, Captures captures) {
        return Match.of(object, captures).filter(equalsPattern.expectedValue()::equals);
    }

    @Override
    public <T> Match<T> matchFilter(FilterPattern<T> filterPattern, Object object, Captures captures) {
        return Match.of(object, captures).filter(filterPattern.predicate());
    }
}

