import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  DeleteStackInstancesInput,
  DeleteStackInstancesOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface DeleteStackInstancesCommandInput
  extends DeleteStackInstancesInput {}
export interface DeleteStackInstancesCommandOutput
  extends DeleteStackInstancesOutput,
    __MetadataBearer {}
export declare class DeleteStackInstancesCommand extends $Command<
  DeleteStackInstancesCommandInput,
  DeleteStackInstancesCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: DeleteStackInstancesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DeleteStackInstancesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DeleteStackInstancesCommandInput,
    DeleteStackInstancesCommandOutput
  >;
  private serialize;
  private deserialize;
}
