//// (c) 1992-2023 Intel Corporation.                            
// Intel, the Intel logo, Intel, MegaCore, NIOS II, Quartus and TalkBack words    
// and logos are trademarks of Intel Corporation or its subsidiaries in the U.S.  
// and/or other countries. Other marks and brands may be claimed as the property  
// of others. See Trademarks on intel.com for full list of Intel trademarks or    
// the Trademarks & Brands Names Database (if Intel) or See www.Intel.com/legal (if Altera) 
// Your use of Intel Corporation's design tools, logic functions and other        
// software and tools, and its AMPP partner logic functions, and any output       
// files any of the foregoing (including device programming or simulation         
// files), and any associated documentation or information are expressly subject  
// to the terms and conditions of the Altera Program License Subscription         
// Agreement, Intel MegaCore Function License Agreement, or other applicable      
// license agreement, including, without limitation, that your use is for the     
// sole purpose of programming logic devices manufactured by Intel and sold by    
// Intel or its authorized distributors.  Please refer to the applicable          
// agreement for further details.                                                 


// This IP is a simple wrapper around acl_stream_fifo.v with modified port name. 
// to match acl_channel_fifo.v

`default_nettype none

module acl_channel_fifo_sideband
import hld_memory_depth_quantization_pkg::*;
#(
    //core spec
    parameter int FIFO_DEPTH = 0,               //minimum depth of the fifo, 0 means bypass, note that the fifo depth is inflated to take advantage of all the memory available in mlab or m20k
    parameter int DATA_W = 32,                  //width of the data path excluding side band signals
    parameter int STALL_ON_ALMOSTFULL = 0,      //0 means avst_out_ready comes from fifo full, 1 means avst_out_ready comes from fifo almost full
    parameter int ALMOST_FULL_VALUE = -1,       //-1 means almost full acts as full, otherwise this is the fifo occupancy threshold at which almost_full asserts

    //reset
    parameter bit ASYNC_RESET = 1,              //how do the registers CONSUME reset: 1 means registers are reset asynchronously, 0 means registers are reset synchronously
    parameter bit SYNCHRONIZE_RESET = 0,        //before consumption, do we SYNCHRONIZE the reset: 1 means use a synchronizer (assume reset arrived asynchronously), 0 means passthrough (assume reset was already synchronized)

    //avalon releated
    parameter int DELAY_READY = 0,              //for avalon streaming ready latency for stream_out
    parameter int USES_PACKETS = 0,             //whether to use the sideband signals startofpacket and endofpacket
    parameter int EMPTY_W = 0,                  //0 means don't use the sideband signal empty, otherwise this indicates the width of the empty signal (Avalon streaming ready, not stall latency empty)

    //consolidation of channel capacity
    parameter bit BYPASS_ALMOST_FULL = 0,       //set to 1 when iord provides the almost full signal for the iowr full detector, this means the stream is bypassed
    parameter int INTER_KERNEL_PIPELINING = 0,  //add pipelining before the fifo to ease placement

    //error correction codes
    parameter     enable_ecc = "FALSE",         //legal values are "FALSE" or "TRUE"

    //derived parameters
    parameter int EMPTY_PORT_WIDTH = (EMPTY_W > 0) ? EMPTY_W : 1

)
(
    input  wire                          clock,
    input  wire                          resetn,

    //all interfaces are stall/valid unless the fifo is depth 0 (but in that case iord and iowr talk to each other directly, so stream doesn't care if handshake is stall latency or not)
    input  wire                          avst_in_valid,
    input  wire             [DATA_W-1:0] avst_in_data,
    output logic                         avst_in_ready,
    input  wire                          avst_in_startofpacket,    // only used if USES_PACKETS == 1
    input  wire                          avst_in_endofpacket,      // only used if USES_PACKETS == 1
    input  wire   [EMPTY_PORT_WIDTH-1:0] avst_in_empty,            // only used if EMPTY_W > 0

    input  wire                          avst_out_almost_full,
    input  wire                          avst_out_ready,
    output logic            [DATA_W-1:0] avst_out_data,
    output logic                         avst_out_valid,
    output logic                         avst_out_startofpacket,  // only used if USES_PACKETS == 1
    output logic                         avst_out_endofpacket,    // only used if USES_PACKETS == 1
    output logic  [EMPTY_PORT_WIDTH-1:0] avst_out_empty,          // only used if EMPTY_W > 0
    output logic                         almost_full,
    output logic  [1:0]                  ecc_err_status  // ecc status signals
);

    ///////////////////////////////////////
    // Parameter checking
    //
    // Generate an error if any illegal parameter settings or combinations are used
    ///////////////////////////////////////
    initial /* synthesis enable_verilog_initial_construct */
    begin
        if (EMPTY_PORT_WIDTH != ((EMPTY_W > 0) ? EMPTY_W : 1))
            $fatal(1, "Illegal parameteriazation, EMPTY_PORT_WIDTH must be not be specified when instantiating this module, it must be left at its default value");
    end

    acl_stream_fifo
   #(
      .FIFO_DEPTH(FIFO_DEPTH),
      .DATA_W(DATA_W),
      .STALL_ON_ALMOSTFULL(STALL_ON_ALMOSTFULL),
      .ALMOST_FULL_VALUE(ALMOST_FULL_VALUE),
      .ASYNC_RESET(ASYNC_RESET),
      .SYNCHRONIZE_RESET(SYNCHRONIZE_RESET),
      .DELAY_READY(DELAY_READY),
      .USES_PACKETS(USES_PACKETS),
      .EMPTY_W(EMPTY_W),
      .BYPASS_ALMOST_FULL(BYPASS_ALMOST_FULL),
      .INTER_KERNEL_PIPELINING(INTER_KERNEL_PIPELINING),
      .enable_ecc(enable_ecc)
   )
   acl_stream_fifo_inst
   (
      .clock(clock),
      .resetn(resetn),
      // AVST avst_in
      .stream_in_valid(avst_in_valid),
      .stream_in_ready(avst_in_ready),
      .stream_in_data(avst_in_data),
      .stream_in_startofpacket(avst_in_startofpacket),
      .stream_in_endofpacket(avst_in_endofpacket),
      .stream_in_empty(avst_in_empty),
      // AVST avst_out
      .stream_out_valid(avst_out_valid),
      .stream_out_ready(avst_out_ready),
      .stream_out_data(avst_out_data),
      .stream_out_startofpacket(avst_out_startofpacket),
      .stream_out_endofpacket(avst_out_endofpacket),
      .stream_out_empty(avst_out_empty),
      .almost_full(almost_full),
      .ecc_err_status(ecc_err_status)
   );

endmodule

`default_nettype wire
