# 
# acl_clock_crossing_bridge "ACL AVMM Clock Crossing Bridge" v1.0
#  2018.10.01.00:00:00
# This hw.tcl was derived from acl_hyper_optimized_ccb_hw.tcl
# 

# 
# request TCL package from ACDS 17.0
# 
package require -exact qsys 17.0

# 
# module acl_clock_crossing_bridge
# 
set_module_property DESCRIPTION ""
set_module_property NAME acl_clock_crossing_bridge
set_module_property VERSION 1.0
set_module_property INTERNAL false
set_module_property OPAQUE_ADDRESS_MAP true
set_module_property AUTHOR ""
set_module_property DISPLAY_NAME "ACL AVMM Clock Crossing Bridge"
set_module_property INSTANTIATE_IN_SYSTEM_MODULE true
set_module_property EDITABLE true
set_module_property REPORT_TO_TALKBACK false
set_module_property ALLOW_GREYBOX_GENERATION false
set_module_property REPORT_HIERARCHY false


# 
# file sets
# 
add_fileset QUARTUS_SYNTH QUARTUS_SYNTH "" ""
set_fileset_property QUARTUS_SYNTH TOP_LEVEL acl_clock_crossing_bridge
set_fileset_property QUARTUS_SYNTH ENABLE_RELATIVE_INCLUDE_PATHS false
set_fileset_property QUARTUS_SYNTH ENABLE_FILE_OVERWRITE_MODE false

add_fileset_file acl_clock_crossing_bridge.sv               SYSTEM_VERILOG PATH     acl_clock_crossing_bridge.sv
add_fileset_file acl_dcfifo.sv                              SYSTEM_VERILOG PATH     acl_dcfifo.sv
add_fileset_file acl_reset_handler.sv                       SYSTEM_VERILOG PATH     ../../acl_reset_handler.sv
add_fileset_file acl_parameter_assert.svh                   SYSTEM_VERILOG PATH     ../../acl_parameter_assert.svh
add_fileset_file acl_width_clip.svh                         SYSTEM_VERILOG PATH     ../../acl_width_clip.svh

add_fileset SIM_VERILOG SIM_VERILOG "" ""
set_fileset_property SIM_VERILOG TOP_LEVEL acl_clock_crossing_bridge
set_fileset_property SIM_VERILOG ENABLE_RELATIVE_INCLUDE_PATHS false
set_fileset_property SIM_VERILOG ENABLE_FILE_OVERWRITE_MODE false

add_fileset_file acl_clock_crossing_bridge.sv               SYSTEM_VERILOG PATH     acl_clock_crossing_bridge.sv
add_fileset_file acl_dcfifo.sv                              SYSTEM_VERILOG PATH     acl_dcfifo.sv
add_fileset_file acl_reset_handler.sv                       SYSTEM_VERILOG PATH     ../../acl_reset_handler.sv
add_fileset_file acl_parameter_assert.svh                   SYSTEM_VERILOG PATH     ../../acl_parameter_assert.svh
add_fileset_file acl_width_clip.svh                         SYSTEM_VERILOG PATH     ../../acl_width_clip.svh

# 
# parameters
# 
add_parameter ADDRESS_WIDTH INTEGER 32
set_parameter_property ADDRESS_WIDTH DEFAULT_VALUE 32
set_parameter_property ADDRESS_WIDTH DISPLAY_NAME "Address width"
set_parameter_property ADDRESS_WIDTH TYPE INTEGER
set_parameter_property ADDRESS_WIDTH UNITS None
set_parameter_property ADDRESS_WIDTH HDL_PARAMETER true
set_parameter_property ADDRESS_WIDTH AFFECTS_ELABORATION true

add_parameter DATA_WIDTH INTEGER 32
set_parameter_property DATA_WIDTH DEFAULT_VALUE 32
set_parameter_property DATA_WIDTH DISPLAY_NAME "Data width"
set_parameter_property DATA_WIDTH TYPE INTEGER
set_parameter_property DATA_WIDTH UNITS None
set_parameter_property DATA_WIDTH HDL_PARAMETER false
set_parameter_property DATA_WIDTH AFFECTS_ELABORATION true

add_parameter BURSTCOUNT_WIDTH INTEGER 5
set_parameter_property BURSTCOUNT_WIDTH DEFAULT_VALUE 5
set_parameter_property BURSTCOUNT_WIDTH DISPLAY_NAME "Burstcount width"
set_parameter_property BURSTCOUNT_WIDTH TYPE INTEGER
set_parameter_property BURSTCOUNT_WIDTH UNITS None
set_parameter_property BURSTCOUNT_WIDTH HDL_PARAMETER true
set_parameter_property BURSTCOUNT_WIDTH AFFECTS_ELABORATION true

add_parameter BYTEENABLE_WIDTH INTEGER 64
set_parameter_property BYTEENABLE_WIDTH DEFAULT_VALUE 64
set_parameter_property BYTEENABLE_WIDTH DISPLAY_NAME "Byteenable width"
set_parameter_property BYTEENABLE_WIDTH TYPE INTEGER
set_parameter_property BYTEENABLE_WIDTH UNITS None
set_parameter_property BYTEENABLE_WIDTH HDL_PARAMETER true
set_parameter_property BYTEENABLE_WIDTH AFFECTS_ELABORATION true

add_parameter CMD_DCFIFO_MIN_DEPTH INTEGER 32
set_parameter_property CMD_DCFIFO_MIN_DEPTH DEFAULT_VALUE 32
set_parameter_property CMD_DCFIFO_MIN_DEPTH DISPLAY_NAME "Command DCFIFO depth"
set_parameter_property CMD_DCFIFO_MIN_DEPTH TYPE INTEGER
set_parameter_property CMD_DCFIFO_MIN_DEPTH UNITS None
set_parameter_property CMD_DCFIFO_MIN_DEPTH HDL_PARAMETER true
set_parameter_property CMD_DCFIFO_MIN_DEPTH AFFECTS_ELABORATION true

add_parameter RSP_DCFIFO_MIN_DEPTH INTEGER 512
set_parameter_property RSP_DCFIFO_MIN_DEPTH DEFAULT_VALUE 512
set_parameter_property RSP_DCFIFO_MIN_DEPTH DISPLAY_NAME "Response DCFIFO depth"
set_parameter_property RSP_DCFIFO_MIN_DEPTH TYPE INTEGER
set_parameter_property RSP_DCFIFO_MIN_DEPTH UNITS None
set_parameter_property RSP_DCFIFO_MIN_DEPTH HDL_PARAMETER true
set_parameter_property RSP_DCFIFO_MIN_DEPTH AFFECTS_ELABORATION true

add_parameter AGENT_STALL_LATENCY INTEGER 0
set_parameter_property AGENT_STALL_LATENCY DEFAULT_VALUE 0
set_parameter_property AGENT_STALL_LATENCY DISPLAY_NAME "Agent port waitrequest allowance"
set_parameter_property AGENT_STALL_LATENCY TYPE INTEGER
set_parameter_property AGENT_STALL_LATENCY UNITS None
set_parameter_property AGENT_STALL_LATENCY HDL_PARAMETER true
set_parameter_property AGENT_STALL_LATENCY AFFECTS_ELABORATION true

add_parameter HOST_STALL_LATENCY INTEGER 0
set_parameter_property HOST_STALL_LATENCY DEFAULT_VALUE 0
set_parameter_property HOST_STALL_LATENCY DISPLAY_NAME "Host port waitrequest allowance"
set_parameter_property HOST_STALL_LATENCY TYPE INTEGER
set_parameter_property HOST_STALL_LATENCY UNITS None
set_parameter_property HOST_STALL_LATENCY HDL_PARAMETER true
set_parameter_property HOST_STALL_LATENCY AFFECTS_ELABORATION true

add_parameter USE_WRITE_ACK INTEGER 0
set_parameter_property USE_WRITE_ACK DEFAULT_VALUE 0
set_parameter_property USE_WRITE_ACK DISPLAY_NAME "Use write acknowledge, intended only for AXI on HBM"
set_parameter_property USE_WRITE_ACK TYPE INTEGER
set_parameter_property USE_WRITE_ACK UNITS None
set_parameter_property USE_WRITE_ACK HDL_PARAMETER true
set_parameter_property USE_WRITE_ACK AFFECTS_ELABORATION true

# 
# connection point agent_clk
# 
add_interface agent_clk clock end
set_interface_property agent_clk clockRate 0
set_interface_property agent_clk ENABLED true
set_interface_property agent_clk EXPORT_OF ""
set_interface_property agent_clk PORT_NAME_MAP ""
set_interface_property agent_clk CMSIS_SVD_VARIABLES ""
set_interface_property agent_clk SVD_ADDRESS_GROUP ""

add_interface_port agent_clk s_clock clk Input 1

# 
# connection point agent
# 
add_interface agent avalon end
set_interface_property agent addressUnits SYMBOLS
set_interface_property agent associatedClock agent_clk
set_interface_property agent associatedReset host_reset
set_interface_property agent bitsPerSymbol 8
set_interface_property agent bridgedAddressOffset ""
set_interface_property agent bridgesToMaster "host"
set_interface_property agent burstOnBurstBoundariesOnly false
set_interface_property agent burstcountUnits WORDS
set_interface_property agent explicitAddressSpan 0
set_interface_property agent holdTime 0
set_interface_property agent linewrapBursts false
set_interface_property agent maximumPendingReadTransactions 64
set_interface_property agent maximumPendingWriteTransactions 0
set_interface_property agent minimumResponseLatency 6
set_interface_property agent readLatency 0
set_interface_property agent readWaitTime 0
set_interface_property agent setupTime 0
set_interface_property agent timingUnits Cycles
set_interface_property agent transparentBridge false
set_interface_property agent waitrequestAllowance 0
set_interface_property agent writeWaitTime 0
set_interface_property agent ENABLED true
set_interface_property agent EXPORT_OF ""
set_interface_property agent PORT_NAME_MAP ""
set_interface_property agent CMSIS_SVD_VARIABLES ""
set_interface_property agent SVD_ADDRESS_GROUP ""

add_interface_port agent s_read read Input 1
add_interface_port agent s_write write Input 1
add_interface_port agent s_address address Input ADDRESS_WIDTH
add_interface_port agent s_burstcount burstcount Input BURSTCOUNT_WIDTH
add_interface_port agent s_byteenable byteenable Input BYTEENABLE_WIDTH
add_interface_port agent s_writedata writedata Input DATA_WIDTH
add_interface_port agent s_waitrequest waitrequest Output 1
add_interface_port agent s_readdatavalid readdatavalid Output 1
add_interface_port agent s_readdata readdata Output DATA_WIDTH

set_interface_assignment agent embeddedsw.configuration.isFlash 0
set_interface_assignment agent embeddedsw.configuration.isMemoryDevice 0
set_interface_assignment agent embeddedsw.configuration.isNonVolatileStorage 0
set_interface_assignment agent embeddedsw.configuration.isPrintableDevice 0

# 
# connection point agent_writeack -- this write ack is not avalon conformant, expose it separately
# 
add_interface agent_writeack conduit start
set_interface_property agent_writeack ENABLED true
set_interface_property agent_writeack associatedClock agent_clk
set_interface_property agent_writeack associatedReset ""
add_interface_port agent_writeack s_writeack writeack Output 1

# 
# connection point host_clk
# 
add_interface host_clk clock end
set_interface_property host_clk clockRate 0
set_interface_property host_clk ENABLED true
set_interface_property host_clk EXPORT_OF ""
set_interface_property host_clk PORT_NAME_MAP ""
set_interface_property host_clk CMSIS_SVD_VARIABLES ""
set_interface_property host_clk SVD_ADDRESS_GROUP ""

add_interface_port host_clk m_clock clk Input 1

# 
# connection point host_reset
# 
add_interface host_reset reset end
set_interface_property host_reset associatedClock ""
set_interface_property host_reset synchronousEdges NONE
set_interface_property host_reset ENABLED true
set_interface_property host_reset EXPORT_OF ""
set_interface_property host_reset PORT_NAME_MAP ""
set_interface_property host_reset CMSIS_SVD_VARIABLES ""
set_interface_property host_reset SVD_ADDRESS_GROUP ""

add_interface_port host_reset async_resetn reset_n Input 1

# 
# connection point host
# 
add_interface host avalon start
set_interface_property host addressUnits SYMBOLS
set_interface_property host associatedClock host_clk
set_interface_property host associatedReset host_reset
set_interface_property host bitsPerSymbol 8
set_interface_property host burstOnBurstBoundariesOnly false
set_interface_property host burstcountUnits WORDS
set_interface_property host doStreamReads false
set_interface_property host doStreamWrites false
set_interface_property host holdTime 0
set_interface_property host linewrapBursts false
set_interface_property host maximumPendingReadTransactions 64
set_interface_property host maximumPendingWriteTransactions 0
set_interface_property host minimumResponseLatency 1
set_interface_property host readLatency 0
set_interface_property host readWaitTime 0
set_interface_property host setupTime 0
set_interface_property host timingUnits Cycles
set_interface_property host waitrequestAllowance 0
set_interface_property host writeWaitTime 0
set_interface_property host ENABLED true
set_interface_property host EXPORT_OF ""
set_interface_property host PORT_NAME_MAP ""
set_interface_property host CMSIS_SVD_VARIABLES ""
set_interface_property host SVD_ADDRESS_GROUP ""

add_interface_port host m_read read Output 1
add_interface_port host m_write write Output 1
add_interface_port host m_address address Output ADDRESS_WIDTH
add_interface_port host m_burstcount burstcount Output BURSTCOUNT_WIDTH
add_interface_port host m_byteenable byteenable Output BYTEENABLE_WIDTH
add_interface_port host m_writedata writedata Output DATA_WIDTH
add_interface_port host m_waitrequest waitrequest Input 1
add_interface_port host m_readdatavalid readdatavalid Input 1
add_interface_port host m_readdata readdata Input DATA_WIDTH

# 
# connection point host_writeack -- this write ack is not avalon conformant, expose it separately
# 
add_interface host_writeack conduit end
set_interface_property host_writeack ENABLED true
set_interface_property host_writeack associatedClock host_clk
set_interface_property host_writeack associatedReset ""
add_interface_port host_writeack m_writeack writeack Input 1
