"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeRelativePath = exports.isParentDir = void 0;
const path = require("path");
const vscode_uri_1 = require("vscode-uri");
const schemes_1 = require("./schemes");
function isParentDir(parent, maybeChild) {
    if (parent.scheme === maybeChild.scheme && parent.authority === maybeChild.authority) {
        const relative = path.relative(parent.path, maybeChild.path);
        return !relative.startsWith('..');
    }
    return false;
}
exports.isParentDir = isParentDir;
function computeRelativePath(fromDoc, toDoc, preferDotSlash = false) {
    if (fromDoc.scheme === toDoc.scheme && fromDoc.scheme !== schemes_1.Schemes.untitled) {
        const rootDir = vscode_uri_1.Utils.dirname(fromDoc);
        let newLink = path.posix.relative(rootDir.path, toDoc.path);
        if (preferDotSlash && !(newLink.startsWith('../') || newLink.startsWith('..\\'))) {
            newLink = './' + newLink;
        }
        return newLink;
    }
    return undefined;
}
exports.computeRelativePath = computeRelativePath;
//# sourceMappingURL=path.js.map