/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jruby.util.collections.AbstractEntry;
import org.jruby.util.collections.Counter;
import org.jruby.util.unsafe.UnsafeHolder;
import sun.misc.Unsafe;

public class NonBlockingHashMapLong<TypeV>
extends AbstractMap<Long, TypeV>
implements ConcurrentMap<Long, TypeV>,
Serializable {
    private static final long serialVersionUID = 1234123412341234124L;
    private static final int REPROBE_LIMIT = 10;
    private static final Unsafe _unsafe = UnsafeHolder.U;
    private static final int _Obase;
    private static final int _Oscale;
    private static final int _Lbase;
    private static final int _Lscale;
    private static final AtomicReferenceFieldUpdater<NonBlockingHashMapLong, CHM> _chmUpdater;
    private static final AtomicReferenceFieldUpdater<NonBlockingHashMapLong, Object> _val_1Updater;
    private volatile transient CHM _chm;
    private volatile transient Object _val_1;
    private transient long _last_resize_milli;
    private final boolean _opt_for_space;
    private static final int MIN_SIZE_LOG = 4;
    private static final int MIN_SIZE = 16;
    private static final Object NO_MATCH_OLD;
    private static final Object MATCH_ANY;
    private static final Object TOMBSTONE;
    private static final Prime TOMBPRIME;
    private static final long NO_KEY = 0L;
    private transient Counter _reprobes = new Counter();

    private final boolean CAS_chm(CHM old, CHM nnn) {
        return _chmUpdater.compareAndSet(this, old, nnn);
    }

    private final boolean CAS_val_1(Object old, Object nnn) {
        return _val_1Updater.compareAndSet(this, old, nnn);
    }

    public long reprobes() {
        long r = this._reprobes.get();
        this._reprobes = new Counter();
        return r;
    }

    private static final int reprobe_limit(int len) {
        return 10 + (len >> 2);
    }

    public NonBlockingHashMapLong() {
        this(16, true);
    }

    public NonBlockingHashMapLong(int initial_sz) {
        this(initial_sz, true);
    }

    public NonBlockingHashMapLong(boolean opt_for_space) {
        this(1, opt_for_space);
    }

    public NonBlockingHashMapLong(int initial_sz, boolean opt_for_space) {
        this._opt_for_space = opt_for_space;
        this.initialize(initial_sz);
    }

    private final void initialize(int initial_sz) {
        if (initial_sz < 0) {
            throw new IllegalArgumentException();
        }
        int i2 = 4;
        while (1 << i2 < initial_sz) {
            ++i2;
        }
        this._chm = new CHM(this, new Counter(), i2);
        this._val_1 = TOMBSTONE;
        this._last_resize_milli = System.currentTimeMillis();
    }

    @Override
    public int size() {
        return (this._val_1 == TOMBSTONE ? 0 : 1) + this._chm.size();
    }

    public boolean containsKey(long key2) {
        return this.get(key2) != null;
    }

    public boolean contains(Object val) {
        return this.containsValue(val);
    }

    @Override
    public TypeV put(long key2, TypeV val) {
        return this.putIfMatch(key2, val, NO_MATCH_OLD);
    }

    @Override
    public TypeV putIfAbsent(long key2, TypeV val) {
        return this.putIfMatch(key2, val, TOMBSTONE);
    }

    public TypeV remove(long key2) {
        return this.putIfMatch(key2, TOMBSTONE, NO_MATCH_OLD);
    }

    public boolean remove(long key2, Object val) {
        return this.putIfMatch(key2, TOMBSTONE, val) == val;
    }

    @Override
    public TypeV replace(long key2, TypeV val) {
        return this.putIfMatch(key2, val, MATCH_ANY);
    }

    @Override
    public boolean replace(long key2, TypeV oldValue, TypeV newValue) {
        return this.putIfMatch(key2, newValue, oldValue) == oldValue;
    }

    private final TypeV putIfMatch(long key2, Object newVal, Object oldVal) {
        if (oldVal == null || newVal == null) {
            throw new NullPointerException();
        }
        if (key2 == 0L) {
            Object curVal = this._val_1;
            if (oldVal == NO_MATCH_OLD || curVal == oldVal || oldVal == MATCH_ANY && curVal != TOMBSTONE || oldVal.equals(curVal)) {
                this.CAS_val_1(curVal, newVal);
            }
            return (TypeV)(curVal == TOMBSTONE ? null : curVal);
        }
        Object res = this._chm.putIfMatch(key2, newVal, oldVal);
        assert (!(res instanceof Prime));
        assert (res != null);
        return (TypeV)(res == TOMBSTONE ? null : res);
    }

    @Override
    public void clear() {
        CHM newchm = new CHM(this, new Counter(), 4);
        while (!this.CAS_chm(this._chm, newchm)) {
        }
        this.CAS_val_1(this._val_1, TOMBSTONE);
    }

    @Override
    public boolean containsValue(Object val) {
        if (val == null) {
            return false;
        }
        if (val == this._val_1) {
            return true;
        }
        for (TypeV V : this.values()) {
            if (V != val && !V.equals(val)) continue;
            return true;
        }
        return false;
    }

    public final TypeV get(long key2) {
        if (key2 == 0L) {
            Object V = this._val_1;
            return (TypeV)(V == TOMBSTONE ? null : V);
        }
        Object V = this._chm.get_impl(key2);
        assert (!(V instanceof Prime));
        assert (V != TOMBSTONE);
        return (TypeV)V;
    }

    @Override
    public TypeV get(Object key2) {
        return key2 instanceof Long ? (TypeV)this.get((Long)key2) : null;
    }

    @Override
    public TypeV remove(Object key2) {
        return key2 instanceof Long ? (TypeV)this.remove((Long)key2) : null;
    }

    @Override
    public boolean remove(Object key2, Object Val) {
        return key2 instanceof Long ? this.remove((Long)key2, Val) : false;
    }

    @Override
    public boolean containsKey(Object key2) {
        return key2 instanceof Long ? this.containsKey((Long)key2) : false;
    }

    @Override
    public TypeV putIfAbsent(Long key2, TypeV val) {
        return this.putIfAbsent((long)key2, val);
    }

    @Override
    public TypeV replace(Long key2, TypeV Val) {
        return this.replace((long)key2, Val);
    }

    @Override
    public TypeV put(Long key2, TypeV val) {
        return this.put((long)key2, val);
    }

    @Override
    public boolean replace(Long key2, TypeV oldValue, TypeV newValue) {
        return this.replace((long)key2, oldValue, newValue);
    }

    private final void help_copy() {
        CHM topchm = this._chm;
        if (topchm._newchm == null) {
            return;
        }
        topchm.help_copy_impl(false);
    }

    public Enumeration<TypeV> elements() {
        return new SnapshotV();
    }

    @Override
    public Collection<TypeV> values() {
        return new AbstractCollection<TypeV>(){

            @Override
            public void clear() {
                NonBlockingHashMapLong.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMapLong.this.size();
            }

            @Override
            public boolean contains(Object v) {
                return NonBlockingHashMapLong.this.containsValue(v);
            }

            @Override
            public Iterator<TypeV> iterator() {
                return new SnapshotV();
            }
        };
    }

    public Enumeration<Long> keys() {
        return new IteratorLong();
    }

    @Override
    public Set<Long> keySet() {
        return new AbstractSet<Long>(){

            @Override
            public void clear() {
                NonBlockingHashMapLong.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMapLong.this.size();
            }

            @Override
            public boolean contains(Object k) {
                return NonBlockingHashMapLong.this.containsKey(k);
            }

            @Override
            public boolean remove(Object k) {
                return NonBlockingHashMapLong.this.remove(k) != null;
            }

            public IteratorLong iterator() {
                return new IteratorLong();
            }
        };
    }

    @Override
    public Set<Map.Entry<Long, TypeV>> entrySet() {
        return new AbstractSet<Map.Entry<Long, TypeV>>(){

            @Override
            public void clear() {
                NonBlockingHashMapLong.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingHashMapLong.this.size();
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return NonBlockingHashMapLong.this.remove(e.getKey(), e.getValue());
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object v = NonBlockingHashMapLong.this.get(e.getKey());
                return v.equals(e.getValue());
            }

            @Override
            public Iterator<Map.Entry<Long, TypeV>> iterator() {
                return new SnapshotE();
            }
        };
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (long K : this.keySet()) {
            TypeV V = this.get(K);
            s2.writeLong(K);
            s2.writeObject(V);
        }
        s2.writeLong(0L);
        s2.writeObject(null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.initialize(16);
        while (true) {
            long K = s2.readLong();
            Object V = s2.readObject();
            if (K == 0L && V == null) break;
            this.put(K, (TypeV)V);
        }
    }

    static {
        if (_unsafe != null) {
            _Obase = _unsafe.arrayBaseOffset(Object[].class);
            _Oscale = _unsafe.arrayIndexScale(Object[].class);
            _Lbase = _unsafe.arrayBaseOffset(long[].class);
            _Lscale = _unsafe.arrayIndexScale(long[].class);
        } else {
            _Lscale = 0;
            _Lbase = 0;
            _Oscale = 0;
            _Obase = 0;
        }
        _chmUpdater = AtomicReferenceFieldUpdater.newUpdater(NonBlockingHashMapLong.class, CHM.class, "_chm");
        _val_1Updater = AtomicReferenceFieldUpdater.newUpdater(NonBlockingHashMapLong.class, Object.class, "_val_1");
        NO_MATCH_OLD = new Object();
        MATCH_ANY = new Object();
        TOMBSTONE = new Object();
        TOMBPRIME = new Prime(TOMBSTONE);
    }

    private class SnapshotE
    implements Iterator<Map.Entry<Long, TypeV>> {
        final SnapshotV _ss;

        public SnapshotE() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.remove();
        }

        @Override
        public Map.Entry<Long, TypeV> next() {
            this._ss.next();
            return new NBHMLEntry(this._ss._prevK, this._ss._prevV);
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }
    }

    private class NBHMLEntry
    extends AbstractEntry<Long, TypeV> {
        NBHMLEntry(Long k, TypeV v) {
            super(k, v);
        }

        @Override
        public TypeV setValue(TypeV val) {
            if (val == null) {
                throw new NullPointerException();
            }
            this._val = val;
            return NonBlockingHashMapLong.this.put((Long)this._key, val);
        }
    }

    public class IteratorLong
    implements Iterator<Long>,
    Enumeration<Long> {
        private final SnapshotV _ss;

        public IteratorLong() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.remove();
        }

        @Override
        public Long next() {
            this._ss.next();
            return this._ss._prevK;
        }

        public long nextLong() {
            this._ss.next();
            return this._ss._prevK;
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }

        @Override
        public Long nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private final class SnapshotV
    implements Iterator<TypeV>,
    Enumeration<TypeV> {
        final CHM _sschm;
        private int _idx;
        private long _nextK;
        private long _prevK;
        private TypeV _nextV;
        private TypeV _prevV;

        public SnapshotV() {
            CHM topchm;
            while (true) {
                topchm = NonBlockingHashMapLong.this._chm;
                if (topchm._newchm == null) break;
                topchm.help_copy_impl(true);
            }
            this._sschm = topchm;
            this._idx = -1;
            this.next();
        }

        int length() {
            return this._sschm._keys.length;
        }

        long key(int idx) {
            return this._sschm._keys[idx];
        }

        @Override
        public boolean hasNext() {
            return this._nextV != null;
        }

        @Override
        public TypeV next() {
            if (this._idx != -1 && this._nextV == null) {
                throw new NoSuchElementException();
            }
            this._prevK = this._nextK;
            this._prevV = this._nextV;
            this._nextV = null;
            if (this._idx == -1) {
                this._idx = 0;
                this._nextK = 0L;
                this._nextV = NonBlockingHashMapLong.this.get(this._nextK);
                if (this._nextV != null) {
                    return this._prevV;
                }
            }
            while (this._idx < this.length()) {
                this._nextK = this.key(this._idx++);
                if (this._nextK == 0L || (this._nextV = NonBlockingHashMapLong.this.get(this._nextK)) == null) continue;
                break;
            }
            return this._prevV;
        }

        @Override
        public void remove() {
            if (this._prevV == null) {
                throw new IllegalStateException();
            }
            this._sschm.putIfMatch(this._prevK, TOMBSTONE, this._prevV);
            this._prevV = null;
        }

        @Override
        public TypeV nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private static final class CHM<TypeV>
    implements Serializable {
        final NonBlockingHashMapLong _nbhml;
        private final Counter _size;
        private final Counter _slots;
        volatile CHM _newchm;
        private static final AtomicReferenceFieldUpdater<CHM, CHM> _newchmUpdater = AtomicReferenceFieldUpdater.newUpdater(CHM.class, CHM.class, "_newchm");
        volatile long _resizers;
        private static final AtomicLongFieldUpdater<CHM> _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_resizers");
        final long[] _keys;
        final Object[] _vals;
        volatile long _copyIdx = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyIdxUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyIdx");
        volatile long _copyDone = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyDoneUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyDone");

        public int size() {
            return (int)this._size.get();
        }

        public int slots() {
            return (int)this._slots.get();
        }

        final boolean CAS_newchm(CHM newchm) {
            return _newchmUpdater.compareAndSet(this, null, newchm);
        }

        private final boolean CAS_key(int idx, long old, long key2) {
            assert (idx >= 0 && idx < this._keys.length);
            if (_unsafe != null) {
                int rawIndex = _Lbase + idx * _Lscale;
                return _unsafe.compareAndSwapLong(this._keys, rawIndex, old, key2);
            }
            return this.CAS_keyFallback(idx, old, key2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean CAS_keyFallback(int idx, long old, long key2) {
            long[] keys2;
            long[] lArray = keys2 = this._keys;
            synchronized (keys2) {
                if (keys2[idx] != old) {
                    // ** MonitorExit[var7_5] (shouldn't be in output)
                    return false;
                }
                keys2[idx] = key2;
                // ** MonitorExit[var7_5] (shouldn't be in output)
                return true;
            }
        }

        private final boolean CAS_val(int idx, Object old, Object val) {
            assert (idx >= 0 && idx < this._vals.length);
            if (_unsafe != null) {
                int rawIndex = _Obase + idx * _Oscale;
                return _unsafe.compareAndSwapObject(this._vals, rawIndex, old, val);
            }
            return this.CAS_valFallback(idx, old, val);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean CAS_valFallback(int idx, Object old, Object val) {
            Object[] vals;
            Object[] objectArray = vals = this._vals;
            synchronized (vals) {
                if (vals[idx] != old) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return false;
                }
                vals[idx] = val;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return true;
            }
        }

        CHM(NonBlockingHashMapLong nbhml, Counter size2, int logsize) {
            this._nbhml = nbhml;
            this._size = size2;
            this._slots = new Counter();
            this._keys = new long[1 << logsize];
            this._vals = new Object[1 << logsize];
        }

        private final Object get_impl(long key2) {
            int len = this._keys.length;
            int idx = (int)(key2 & (long)(len - 1));
            int reprobe_cnt = 0;
            while (true) {
                long K = this._keys[idx];
                Object V = this._vals[idx];
                if (K == 0L) {
                    return null;
                }
                if (key2 == K) {
                    if (!(V instanceof Prime)) {
                        if (V == TOMBSTONE) {
                            return null;
                        }
                        CHM newchm = this._newchm;
                        return V;
                    }
                    return this.copy_slot_and_check(idx, key2).get_impl(key2);
                }
                if (++reprobe_cnt >= NonBlockingHashMapLong.reprobe_limit(len)) {
                    return this._newchm == null ? null : this.copy_slot_and_check(idx, key2).get_impl(key2);
                }
                idx = idx + 1 & len - 1;
            }
        }

        private final Object putIfMatch(long key2, Object putval, Object expVal) {
            assert (putval != null);
            assert (!(putval instanceof Prime));
            assert (!(expVal instanceof Prime));
            int len = this._keys.length;
            int idx = (int)(key2 & (long)(len - 1));
            int reprobe_cnt = 0;
            long K = 0L;
            Object V = null;
            while (true) {
                V = this._vals[idx];
                K = this._keys[idx];
                if (K == 0L) {
                    if (putval == TOMBSTONE) {
                        return putval;
                    }
                    if (this.CAS_key(idx, 0L, key2)) {
                        this._slots.add(1L);
                        break;
                    }
                    K = this._keys[idx];
                    assert (K != 0L);
                }
                if (K == key2) break;
                if (++reprobe_cnt >= NonBlockingHashMapLong.reprobe_limit(len)) {
                    CHM newchm = this.resize();
                    if (expVal != null) {
                        this._nbhml.help_copy();
                    }
                    return newchm.putIfMatch(key2, putval, expVal);
                }
                idx = idx + 1 & len - 1;
            }
            if (putval == V) {
                return V;
            }
            if (V == null && this.tableFull(reprobe_cnt, len) || V instanceof Prime) {
                this.resize();
                return this.copy_slot_and_check(idx, expVal).putIfMatch(key2, putval, expVal);
            }
            do {
                assert (!(V instanceof Prime));
                if (!(expVal == NO_MATCH_OLD || V == expVal || expVal == MATCH_ANY && V != TOMBSTONE && V != null || V == null && expVal == TOMBSTONE || expVal != null && expVal.equals(V))) {
                    return V;
                }
                if (!this.CAS_val(idx, V, putval)) continue;
                if (expVal != null) {
                    if ((V == null || V == TOMBSTONE) && putval != TOMBSTONE) {
                        this._size.add(1L);
                    }
                    if (V != null && V != TOMBSTONE && putval == TOMBSTONE) {
                        this._size.add(-1L);
                    }
                }
                return V == null && expVal != null ? TOMBSTONE : V;
            } while (!((V = this._vals[idx]) instanceof Prime));
            return this.copy_slot_and_check(idx, expVal).putIfMatch(key2, putval, expVal);
        }

        private final boolean tableFull(int reprobe_cnt, int len) {
            return reprobe_cnt >= 10 && this._slots.estimate_get() >= (long)NonBlockingHashMapLong.reprobe_limit(len);
        }

        private final CHM resize() {
            int sz;
            CHM newchm = this._newchm;
            if (newchm != null) {
                return newchm;
            }
            int oldlen = this._keys.length;
            int newsz = sz = this.size();
            if (this._nbhml._opt_for_space) {
                if (sz >= oldlen >> 1) {
                    newsz = oldlen << 1;
                }
            } else if (sz >= oldlen >> 2) {
                newsz = oldlen << 1;
                if (sz >= oldlen >> 1) {
                    newsz = oldlen << 2;
                }
            }
            long tm = System.currentTimeMillis();
            long q = 0L;
            if (newsz <= oldlen && tm <= this._nbhml._last_resize_milli + 10000L) {
                newsz = oldlen << 1;
            }
            if (newsz < oldlen) {
                newsz = oldlen;
            }
            int log22 = 4;
            while (1 << log22 < newsz) {
                ++log22;
            }
            long r = this._resizers;
            while (!_resizerUpdater.compareAndSet(this, r, r + 1L)) {
                r = this._resizers;
            }
            int megs = (1 << log22 << 1) + 4 << 3 >> 20;
            if (r >= 2L && megs > 0) {
                newchm = this._newchm;
                if (newchm != null) {
                    return newchm;
                }
                try {
                    Thread.sleep(8 * megs);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if ((newchm = this._newchm) != null) {
                return newchm;
            }
            newchm = new CHM(this._nbhml, this._size, log22);
            if (this._newchm != null) {
                return this._newchm;
            }
            if (!this.CAS_newchm(newchm)) {
                newchm = this._newchm;
            }
            return newchm;
        }

        private final void help_copy_impl(boolean copy_all) {
            CHM newchm = this._newchm;
            assert (newchm != null);
            int oldlen = this._keys.length;
            int MIN_COPY_WORK = Math.min(oldlen, 1024);
            int panic_start = -1;
            int copyidx = -9999;
            while (this._copyDone < (long)oldlen) {
                if (panic_start == -1) {
                    copyidx = (int)this._copyIdx;
                    while (copyidx < oldlen << 1 && !_copyIdxUpdater.compareAndSet(this, copyidx, copyidx + MIN_COPY_WORK)) {
                        copyidx = (int)this._copyIdx;
                    }
                    if (copyidx >= oldlen << 1) {
                        panic_start = copyidx;
                    }
                }
                int workdone = 0;
                for (int i2 = 0; i2 < MIN_COPY_WORK; ++i2) {
                    if (!this.copy_slot(copyidx + i2 & oldlen - 1)) continue;
                    ++workdone;
                }
                if (workdone > 0) {
                    this.copy_check_and_promote(workdone);
                }
                copyidx += MIN_COPY_WORK;
                if (copy_all || panic_start != -1) continue;
                return;
            }
            this.copy_check_and_promote(0);
        }

        private final CHM copy_slot_and_check(int idx, Object should_help) {
            assert (this._newchm != null);
            if (this.copy_slot(idx)) {
                this.copy_check_and_promote(1);
            }
            if (should_help != null) {
                this._nbhml.help_copy();
            }
            return this._newchm;
        }

        private final void copy_check_and_promote(int workdone) {
            int oldlen = this._keys.length;
            long copyDone = this._copyDone;
            long nowDone = copyDone + (long)workdone;
            assert (nowDone <= (long)oldlen);
            if (workdone > 0) {
                while (!_copyDoneUpdater.compareAndSet(this, copyDone, nowDone)) {
                    copyDone = this._copyDone;
                    nowDone = copyDone + (long)workdone;
                    assert (nowDone <= (long)oldlen);
                }
            }
            if (nowDone == (long)oldlen && this._nbhml._chm == this && this._nbhml.CAS_chm(this, this._newchm)) {
                this._nbhml._last_resize_milli = System.currentTimeMillis();
            }
        }

        private boolean copy_slot(int idx) {
            boolean copied_into_new;
            long key2;
            while ((key2 = this._keys[idx]) == 0L) {
                this.CAS_key(idx, 0L, idx + this._keys.length);
            }
            Object oldval = this._vals[idx];
            while (!(oldval instanceof Prime)) {
                Prime box;
                Prime prime = box = oldval == null || oldval == TOMBSTONE ? TOMBPRIME : new Prime(oldval);
                if (this.CAS_val(idx, oldval, box)) {
                    if (box == TOMBPRIME) {
                        return true;
                    }
                    oldval = box;
                    break;
                }
                oldval = this._vals[idx];
            }
            if (oldval == TOMBPRIME) {
                return false;
            }
            Object old_unboxed = ((Prime)oldval)._V;
            assert (old_unboxed != TOMBSTONE);
            boolean bl = copied_into_new = this._newchm.putIfMatch(key2, old_unboxed, null) == null;
            while (!this.CAS_val(idx, oldval, TOMBPRIME)) {
                oldval = this._vals[idx];
            }
            return copied_into_new;
        }
    }

    private static final class Prime {
        final Object _V;

        Prime(Object V) {
            this._V = V;
        }

        static Object unbox(Object V) {
            return V instanceof Prime ? ((Prime)V)._V : V;
        }
    }
}

