
#ifndef MPVQT_EXPORT_H
#define MPVQT_EXPORT_H

#ifdef MPVQT_STATIC_DEFINE
#  define MPVQT_EXPORT
#  define MPVQT_NO_EXPORT
#else
#  ifndef MPVQT_EXPORT
#    ifdef MpvQt_EXPORTS
        /* We are building this library */
#      define MPVQT_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define MPVQT_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef MPVQT_NO_EXPORT
#    define MPVQT_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef MPVQT_DECL_DEPRECATED
#  define MPVQT_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef MPVQT_DECL_DEPRECATED_EXPORT
#  define MPVQT_DECL_DEPRECATED_EXPORT MPVQT_EXPORT MPVQT_DECL_DEPRECATED
#endif

#ifndef MPVQT_DECL_DEPRECATED_NO_EXPORT
#  define MPVQT_DECL_DEPRECATED_NO_EXPORT MPVQT_NO_EXPORT MPVQT_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef MPVQT_NO_DEPRECATED
#    define MPVQT_NO_DEPRECATED
#  endif
#endif
#include <mpvqt_version.h>

#define MPVQT_DECL_DEPRECATED_TEXT(text) MPVQT_DECL_DEPRECATED

#if defined(MPVQT_NO_DEPRECATED)
#  undef MPVQT_DEPRECATED
#  define MPVQT_DEPRECATED_EXPORT MPVQT_EXPORT
#  define MPVQT_DEPRECATED_NO_EXPORT MPVQT_NO_EXPORT
#elif defined(MPVQT_NO_DEPRECATED_WARNINGS)
#  define MPVQT_DEPRECATED
#  define MPVQT_DEPRECATED_EXPORT MPVQT_EXPORT
#  define MPVQT_DEPRECATED_NO_EXPORT MPVQT_NO_EXPORT
#else
#  define MPVQT_DEPRECATED MPVQT_DECL_DEPRECATED
#  define MPVQT_DEPRECATED_EXPORT MPVQT_DECL_DEPRECATED_EXPORT
#  define MPVQT_DEPRECATED_NO_EXPORT MPVQT_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define MPVQT_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define MPVQT_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef MPVQT_NO_DEPRECATED
#  define MPVQT_DISABLE_DEPRECATED_BEFORE_AND_AT MPVQT_VERSION
#endif
#ifdef MPVQT_NO_DEPRECATED_WARNINGS
#  define MPVQT_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef MPVQT_DEPRECATED_WARNINGS_SINCE
#  ifdef MPVQT_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define MPVQT_DEPRECATED_WARNINGS_SINCE MPVQT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define MPVQT_DEPRECATED_WARNINGS_SINCE MPVQT_VERSION
#  endif
#endif

#ifndef MPVQT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define MPVQT_DISABLE_DEPRECATED_BEFORE_AND_AT 0x10000
#endif

#ifdef MPVQT_DEPRECATED
#  define MPVQT_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > MPVQT_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define MPVQT_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* MPVQT_EXPORT_H */
