/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.transfer;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.transfer.OWLObjectDragSource;
import org.protege.editor.owl.ui.transfer.TransferableOWLObject;
import org.semanticweb.owlapi.model.OWLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OWLObjectDragGestureListener
implements DragGestureListener {
    private final Cursor dragCursor = Cursor.getPredefinedCursor(13);
    private final JComponent component;
    private final OWLEditorKit owlEditorKit;
    private static final Logger logger = LoggerFactory.getLogger(OWLObjectDragGestureListener.class);

    protected OWLObjectDragGestureListener(OWLEditorKit owlEditorKit, JComponent component) {
        this.component = component;
        this.owlEditorKit = owlEditorKit;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        if (!this.canPerformDrag()) {
            return;
        }
        if (this.getSelectedObjects().isEmpty()) {
            return;
        }
        TransferableOWLObject transferable = new TransferableOWLObject(this.owlEditorKit.getModelManager(), this.getSelectedObjects());
        this.setupDragOriginator();
        try {
            dge.startDrag(this.dragCursor, transferable, new OWLDragSourceAdapter(this.component));
        }
        catch (InvalidDnDOperationException e) {
            logger.debug("Invalid drop operation");
        }
    }

    protected boolean canPerformDrag() {
        return true;
    }

    protected abstract List<OWLObject> getSelectedObjects();

    protected abstract JComponent getRendererComponent();

    protected abstract Dimension getRendererComponentSize();

    protected abstract Point getImageOffset();

    protected Image createImage() {
        JComponent component = this.getRendererComponent();
        component.setSize(this.getRendererComponentSize());
        BufferedImage img = new BufferedImage(component.getWidth(), component.getHeight(), 2);
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.6f));
        component.paint(g2);
        return img;
    }

    private void setupDragOriginator() {
        if (this.component instanceof OWLObjectDragSource) {
            ((OWLObjectDragSource)((Object)this.component)).setDragOriginater(true);
        }
    }

    private static class OWLDragSourceAdapter
    extends DragSourceAdapter {
        private Component component;

        public OWLDragSourceAdapter(Component component) {
            this.component = component;
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (this.component instanceof OWLObjectDragSource) {
                ((OWLObjectDragSource)((Object)this.component)).setDragOriginater(false);
            }
        }
    }
}

