# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
Bnd module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_bnd.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Bnd
else:
    import _Bnd

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Bnd.delete_SwigPyIterator

    def value(self):
        return _Bnd.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Bnd.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Bnd.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Bnd.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Bnd.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Bnd.SwigPyIterator_copy(self)

    def next(self):
        return _Bnd.SwigPyIterator_next(self)

    def __next__(self):
        return _Bnd.SwigPyIterator___next__(self)

    def previous(self):
        return _Bnd.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Bnd.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Bnd.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Bnd.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Bnd.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Bnd.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Bnd.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Bnd.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Bnd:
_Bnd.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _Bnd.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.TColgp
import OCC.Core.BVH

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_Bnd_HArray1OfBox2d_Create():
    return _Bnd.Handle_Bnd_HArray1OfBox2d_Create()

def Handle_Bnd_HArray1OfBox2d_DownCast(t):
    return _Bnd.Handle_Bnd_HArray1OfBox2d_DownCast(t)

def Handle_Bnd_HArray1OfBox2d_IsNull(t):
    return _Bnd.Handle_Bnd_HArray1OfBox2d_IsNull(t)

def Handle_Bnd_HArray1OfBox_Create():
    return _Bnd.Handle_Bnd_HArray1OfBox_Create()

def Handle_Bnd_HArray1OfBox_DownCast(t):
    return _Bnd.Handle_Bnd_HArray1OfBox_DownCast(t)

def Handle_Bnd_HArray1OfBox_IsNull(t):
    return _Bnd.Handle_Bnd_HArray1OfBox_IsNull(t)

def Handle_Bnd_HArray1OfSphere_Create():
    return _Bnd.Handle_Bnd_HArray1OfSphere_Create()

def Handle_Bnd_HArray1OfSphere_DownCast(t):
    return _Bnd.Handle_Bnd_HArray1OfSphere_DownCast(t)

def Handle_Bnd_HArray1OfSphere_IsNull(t):
    return _Bnd.Handle_Bnd_HArray1OfSphere_IsNull(t)
class Bnd_Array1OfBox(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Bnd.Bnd_Array1OfBox_begin(self)

    def end(self):
        return _Bnd.Bnd_Array1OfBox_end(self)

    def cbegin(self):
        return _Bnd.Bnd_Array1OfBox_cbegin(self)

    def cend(self):
        return _Bnd.Bnd_Array1OfBox_cend(self)

    def __init__(self, *args):
        _Bnd.Bnd_Array1OfBox_swiginit(self, _Bnd.new_Bnd_Array1OfBox(*args))

    def Init(self, theValue):
        return _Bnd.Bnd_Array1OfBox_Init(self, theValue)

    def Size(self):
        return _Bnd.Bnd_Array1OfBox_Size(self)

    def Length(self):
        return _Bnd.Bnd_Array1OfBox_Length(self)

    def IsEmpty(self):
        return _Bnd.Bnd_Array1OfBox_IsEmpty(self)

    def Lower(self):
        return _Bnd.Bnd_Array1OfBox_Lower(self)

    def Upper(self):
        return _Bnd.Bnd_Array1OfBox_Upper(self)

    def IsDeletable(self):
        return _Bnd.Bnd_Array1OfBox_IsDeletable(self)

    def IsAllocated(self):
        return _Bnd.Bnd_Array1OfBox_IsAllocated(self)

    def Assign(self, theOther):
        return _Bnd.Bnd_Array1OfBox_Assign(self, theOther)

    def Move(self, theOther):
        return _Bnd.Bnd_Array1OfBox_Move(self, theOther)

    def Set(self, *args):
        return _Bnd.Bnd_Array1OfBox_Set(self, *args)

    def First(self):
        return _Bnd.Bnd_Array1OfBox_First(self)

    def ChangeFirst(self):
        return _Bnd.Bnd_Array1OfBox_ChangeFirst(self)

    def Last(self):
        return _Bnd.Bnd_Array1OfBox_Last(self)

    def ChangeLast(self):
        return _Bnd.Bnd_Array1OfBox_ChangeLast(self)

    def Value(self, theIndex):
        return _Bnd.Bnd_Array1OfBox_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Bnd.Bnd_Array1OfBox_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Bnd.Bnd_Array1OfBox___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Bnd.Bnd_Array1OfBox_SetValue(self, theIndex, theItem)

    def Resize(self, theLower, theUpper, theToCopyData):
        return _Bnd.Bnd_Array1OfBox_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _Bnd.delete_Bnd_Array1OfBox

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register Bnd_Array1OfBox in _Bnd:
_Bnd.Bnd_Array1OfBox_swigregister(Bnd_Array1OfBox)
class Bnd_Array1OfBox2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Bnd.Bnd_Array1OfBox2d_begin(self)

    def end(self):
        return _Bnd.Bnd_Array1OfBox2d_end(self)

    def cbegin(self):
        return _Bnd.Bnd_Array1OfBox2d_cbegin(self)

    def cend(self):
        return _Bnd.Bnd_Array1OfBox2d_cend(self)

    def __init__(self, *args):
        _Bnd.Bnd_Array1OfBox2d_swiginit(self, _Bnd.new_Bnd_Array1OfBox2d(*args))

    def Init(self, theValue):
        return _Bnd.Bnd_Array1OfBox2d_Init(self, theValue)

    def Size(self):
        return _Bnd.Bnd_Array1OfBox2d_Size(self)

    def Length(self):
        return _Bnd.Bnd_Array1OfBox2d_Length(self)

    def IsEmpty(self):
        return _Bnd.Bnd_Array1OfBox2d_IsEmpty(self)

    def Lower(self):
        return _Bnd.Bnd_Array1OfBox2d_Lower(self)

    def Upper(self):
        return _Bnd.Bnd_Array1OfBox2d_Upper(self)

    def IsDeletable(self):
        return _Bnd.Bnd_Array1OfBox2d_IsDeletable(self)

    def IsAllocated(self):
        return _Bnd.Bnd_Array1OfBox2d_IsAllocated(self)

    def Assign(self, theOther):
        return _Bnd.Bnd_Array1OfBox2d_Assign(self, theOther)

    def Move(self, theOther):
        return _Bnd.Bnd_Array1OfBox2d_Move(self, theOther)

    def Set(self, *args):
        return _Bnd.Bnd_Array1OfBox2d_Set(self, *args)

    def First(self):
        return _Bnd.Bnd_Array1OfBox2d_First(self)

    def ChangeFirst(self):
        return _Bnd.Bnd_Array1OfBox2d_ChangeFirst(self)

    def Last(self):
        return _Bnd.Bnd_Array1OfBox2d_Last(self)

    def ChangeLast(self):
        return _Bnd.Bnd_Array1OfBox2d_ChangeLast(self)

    def Value(self, theIndex):
        return _Bnd.Bnd_Array1OfBox2d_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Bnd.Bnd_Array1OfBox2d_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Bnd.Bnd_Array1OfBox2d___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Bnd.Bnd_Array1OfBox2d_SetValue(self, theIndex, theItem)

    def Resize(self, theLower, theUpper, theToCopyData):
        return _Bnd.Bnd_Array1OfBox2d_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _Bnd.delete_Bnd_Array1OfBox2d

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register Bnd_Array1OfBox2d in _Bnd:
_Bnd.Bnd_Array1OfBox2d_swigregister(Bnd_Array1OfBox2d)
class Bnd_Array1OfSphere(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Bnd.Bnd_Array1OfSphere_begin(self)

    def end(self):
        return _Bnd.Bnd_Array1OfSphere_end(self)

    def cbegin(self):
        return _Bnd.Bnd_Array1OfSphere_cbegin(self)

    def cend(self):
        return _Bnd.Bnd_Array1OfSphere_cend(self)

    def __init__(self, *args):
        _Bnd.Bnd_Array1OfSphere_swiginit(self, _Bnd.new_Bnd_Array1OfSphere(*args))

    def Init(self, theValue):
        return _Bnd.Bnd_Array1OfSphere_Init(self, theValue)

    def Size(self):
        return _Bnd.Bnd_Array1OfSphere_Size(self)

    def Length(self):
        return _Bnd.Bnd_Array1OfSphere_Length(self)

    def IsEmpty(self):
        return _Bnd.Bnd_Array1OfSphere_IsEmpty(self)

    def Lower(self):
        return _Bnd.Bnd_Array1OfSphere_Lower(self)

    def Upper(self):
        return _Bnd.Bnd_Array1OfSphere_Upper(self)

    def IsDeletable(self):
        return _Bnd.Bnd_Array1OfSphere_IsDeletable(self)

    def IsAllocated(self):
        return _Bnd.Bnd_Array1OfSphere_IsAllocated(self)

    def Assign(self, theOther):
        return _Bnd.Bnd_Array1OfSphere_Assign(self, theOther)

    def Move(self, theOther):
        return _Bnd.Bnd_Array1OfSphere_Move(self, theOther)

    def Set(self, *args):
        return _Bnd.Bnd_Array1OfSphere_Set(self, *args)

    def First(self):
        return _Bnd.Bnd_Array1OfSphere_First(self)

    def ChangeFirst(self):
        return _Bnd.Bnd_Array1OfSphere_ChangeFirst(self)

    def Last(self):
        return _Bnd.Bnd_Array1OfSphere_Last(self)

    def ChangeLast(self):
        return _Bnd.Bnd_Array1OfSphere_ChangeLast(self)

    def Value(self, theIndex):
        return _Bnd.Bnd_Array1OfSphere_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Bnd.Bnd_Array1OfSphere_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Bnd.Bnd_Array1OfSphere___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Bnd.Bnd_Array1OfSphere_SetValue(self, theIndex, theItem)

    def Resize(self, theLower, theUpper, theToCopyData):
        return _Bnd.Bnd_Array1OfSphere_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _Bnd.delete_Bnd_Array1OfSphere

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register Bnd_Array1OfSphere in _Bnd:
_Bnd.Bnd_Array1OfSphere_swigregister(Bnd_Array1OfSphere)
class Bnd_B2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theCenter: gp_XY
        theHSize: gp_XY

        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _Bnd.Bnd_B2d_swiginit(self, _Bnd.new_Bnd_B2d(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_XY

        Return
        -------
        None

        Description
        -----------
        Update the box by a point.

        Parameters
        ----------
        thePnt: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Update the box by a point.

        Parameters
        ----------
        theBox: Bnd_B2d

        Return
        -------
        None

        Description
        -----------
        Update the box by another box.

        """
        return _Bnd.Bnd_B2d_Add(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reset the box data.

        """
        return _Bnd.Bnd_B2d_Clear(self, *args)

    def CornerMax(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        Query a box corner: (center + hsize). you must make sure that the box is not void (see isvoid()), otherwise the method returns irrelevant result.

        """
        return _Bnd.Bnd_B2d_CornerMax(self, *args)

    def CornerMin(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        Query a box corner: (center - hsize). you must make sure that the box is not void (see isvoid()), otherwise the method returns irrelevant result.

        """
        return _Bnd.Bnd_B2d_CornerMin(self, *args)

    def Enlarge(self, *args):
        r"""

        Parameters
        ----------
        theDiff: float

        Return
        -------
        None

        Description
        -----------
        Extend the box by the absolute value of thediff.

        """
        return _Bnd.Bnd_B2d_Enlarge(self, *args)

    def IsIn(self, *args):
        r"""

        Parameters
        ----------
        theBox: Bnd_B2d

        Return
        -------
        bool

        Description
        -----------
        Check that the box 'this' is inside the given box 'thebox'. returns true if 'this' box is fully inside 'thebox'.

        Parameters
        ----------
        theBox: Bnd_B2d
        theTrsf: gp_Trsf2d

        Return
        -------
        bool

        Description
        -----------
        Check that the box 'this' is inside the given box 'thebox' transformed by 'thetrsf'. returns true if 'this' box is fully inside the transformed 'thebox'.

        """
        return _Bnd.Bnd_B2d_IsIn(self, *args)

    def IsOut(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_XY

        Return
        -------
        bool

        Description
        -----------
        Check the given point for the inclusion in the box. returns true if the point is outside.

        Parameters
        ----------
        theCenter: gp_XY
        theRadius: float
        isCircleHollow: bool (optional, default to Standard_False)

        Return
        -------
        bool

        Description
        -----------
        Check a circle for the intersection with the current box. returns true if there is no intersection between boxes.

        Parameters
        ----------
        theOtherBox: Bnd_B2d

        Return
        -------
        bool

        Description
        -----------
        Check the given box for the intersection with the current box. returns true if there is no intersection between boxes.

        Parameters
        ----------
        theOtherBox: Bnd_B2d
        theTrsf: gp_Trsf2d

        Return
        -------
        bool

        Description
        -----------
        Check the given box oriented by the given transformation for the intersection with the current box. returns true if there is no intersection between boxes.

        Parameters
        ----------
        theLine: gp_Ax2d

        Return
        -------
        bool

        Description
        -----------
        Check the given line for the intersection with the current box. returns true if there is no intersection.

        Parameters
        ----------
        theP0: gp_XY
        theP1: gp_XY

        Return
        -------
        bool

        Description
        -----------
        Check the segment defined by the couple of input points for the intersection with the current box. returns true if there is no intersection.

        """
        return _Bnd.Bnd_B2d_IsOut(self, *args)

    def IsVoid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the box is void (non-initialized).

        """
        return _Bnd.Bnd_B2d_IsVoid(self, *args)

    def Limit(self, *args):
        r"""

        Parameters
        ----------
        theOtherBox: Bnd_B2d

        Return
        -------
        bool

        Description
        -----------
        Limit the box by the internals of theotherbox. returns true if the limitation takes place, otherwise false indicating that the boxes do not intersect.

        """
        return _Bnd.Bnd_B2d_Limit(self, *args)

    def SetCenter(self, *args):
        r"""

        Parameters
        ----------
        theCenter: gp_XY

        Return
        -------
        None

        Description
        -----------
        Set the center coordinates.

        """
        return _Bnd.Bnd_B2d_SetCenter(self, *args)

    def SetHSize(self, *args):
        r"""

        Parameters
        ----------
        theHSize: gp_XY

        Return
        -------
        None

        Description
        -----------
        Set the hsize (half-diagonal) coordinates. all components of thehsize must be non-negative.

        """
        return _Bnd.Bnd_B2d_SetHSize(self, *args)

    def SquareExtent(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Query the square diagonal. if the box is void (see method isvoid()) then a very big real value is returned.

        """
        return _Bnd.Bnd_B2d_SquareExtent(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theTrsf: gp_Trsf2d

        Return
        -------
        Bnd_B2d

        Description
        -----------
        Transform the bounding box with the given transformation. the resulting box will be larger if thetrsf contains rotation.

        """
        return _Bnd.Bnd_B2d_Transformed(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Bnd.delete_Bnd_B2d

# Register Bnd_B2d in _Bnd:
_Bnd.Bnd_B2d_swigregister(Bnd_B2d)
class Bnd_B2f(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theCenter: gp_XY
        theHSize: gp_XY

        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _Bnd.Bnd_B2f_swiginit(self, _Bnd.new_Bnd_B2f(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_XY

        Return
        -------
        None

        Description
        -----------
        Update the box by a point.

        Parameters
        ----------
        thePnt: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Update the box by a point.

        Parameters
        ----------
        theBox: Bnd_B2f

        Return
        -------
        None

        Description
        -----------
        Update the box by another box.

        """
        return _Bnd.Bnd_B2f_Add(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reset the box data.

        """
        return _Bnd.Bnd_B2f_Clear(self, *args)

    def CornerMax(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        Query a box corner: (center + hsize). you must make sure that the box is not void (see isvoid()), otherwise the method returns irrelevant result.

        """
        return _Bnd.Bnd_B2f_CornerMax(self, *args)

    def CornerMin(self, *args):
        r"""
        Return
        -------
        gp_XY

        Description
        -----------
        Query a box corner: (center - hsize). you must make sure that the box is not void (see isvoid()), otherwise the method returns irrelevant result.

        """
        return _Bnd.Bnd_B2f_CornerMin(self, *args)

    def Enlarge(self, *args):
        r"""

        Parameters
        ----------
        theDiff: float

        Return
        -------
        None

        Description
        -----------
        Extend the box by the absolute value of thediff.

        """
        return _Bnd.Bnd_B2f_Enlarge(self, *args)

    def IsIn(self, *args):
        r"""

        Parameters
        ----------
        theBox: Bnd_B2f

        Return
        -------
        bool

        Description
        -----------
        Check that the box 'this' is inside the given box 'thebox'. returns true if 'this' box is fully inside 'thebox'.

        Parameters
        ----------
        theBox: Bnd_B2f
        theTrsf: gp_Trsf2d

        Return
        -------
        bool

        Description
        -----------
        Check that the box 'this' is inside the given box 'thebox' transformed by 'thetrsf'. returns true if 'this' box is fully inside the transformed 'thebox'.

        """
        return _Bnd.Bnd_B2f_IsIn(self, *args)

    def IsOut(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_XY

        Return
        -------
        bool

        Description
        -----------
        Check the given point for the inclusion in the box. returns true if the point is outside.

        Parameters
        ----------
        theCenter: gp_XY
        theRadius: float
        isCircleHollow: bool (optional, default to Standard_False)

        Return
        -------
        bool

        Description
        -----------
        Check a circle for the intersection with the current box. returns true if there is no intersection between boxes.

        Parameters
        ----------
        theOtherBox: Bnd_B2f

        Return
        -------
        bool

        Description
        -----------
        Check the given box for the intersection with the current box. returns true if there is no intersection between boxes.

        Parameters
        ----------
        theOtherBox: Bnd_B2f
        theTrsf: gp_Trsf2d

        Return
        -------
        bool

        Description
        -----------
        Check the given box oriented by the given transformation for the intersection with the current box. returns true if there is no intersection between boxes.

        Parameters
        ----------
        theLine: gp_Ax2d

        Return
        -------
        bool

        Description
        -----------
        Check the given line for the intersection with the current box. returns true if there is no intersection.

        Parameters
        ----------
        theP0: gp_XY
        theP1: gp_XY

        Return
        -------
        bool

        Description
        -----------
        Check the segment defined by the couple of input points for the intersection with the current box. returns true if there is no intersection.

        """
        return _Bnd.Bnd_B2f_IsOut(self, *args)

    def IsVoid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the box is void (non-initialized).

        """
        return _Bnd.Bnd_B2f_IsVoid(self, *args)

    def Limit(self, *args):
        r"""

        Parameters
        ----------
        theOtherBox: Bnd_B2f

        Return
        -------
        bool

        Description
        -----------
        Limit the box by the internals of theotherbox. returns true if the limitation takes place, otherwise false indicating that the boxes do not intersect.

        """
        return _Bnd.Bnd_B2f_Limit(self, *args)

    def SetCenter(self, *args):
        r"""

        Parameters
        ----------
        theCenter: gp_XY

        Return
        -------
        None

        Description
        -----------
        Set the center coordinates.

        """
        return _Bnd.Bnd_B2f_SetCenter(self, *args)

    def SetHSize(self, *args):
        r"""

        Parameters
        ----------
        theHSize: gp_XY

        Return
        -------
        None

        Description
        -----------
        Set the hsize (half-diagonal) coordinates. all components of thehsize must be non-negative.

        """
        return _Bnd.Bnd_B2f_SetHSize(self, *args)

    def SquareExtent(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Query the square diagonal. if the box is void (see method isvoid()) then a very big real value is returned.

        """
        return _Bnd.Bnd_B2f_SquareExtent(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theTrsf: gp_Trsf2d

        Return
        -------
        Bnd_B2f

        Description
        -----------
        Transform the bounding box with the given transformation. the resulting box will be larger if thetrsf contains rotation.

        """
        return _Bnd.Bnd_B2f_Transformed(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Bnd.delete_Bnd_B2f

# Register Bnd_B2f in _Bnd:
_Bnd.Bnd_B2f_swigregister(Bnd_B2f)
class Bnd_B3d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theCenter: gp_XYZ
        theHSize: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _Bnd.Bnd_B3d_swiginit(self, _Bnd.new_Bnd_B3d(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Update the box by a point.

        Parameters
        ----------
        thePnt: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Update the box by a point.

        Parameters
        ----------
        theBox: Bnd_B3d

        Return
        -------
        None

        Description
        -----------
        Update the box by another box.

        """
        return _Bnd.Bnd_B3d_Add(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reset the box data.

        """
        return _Bnd.Bnd_B3d_Clear(self, *args)

    def CornerMax(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Query the upper corner: (center + hsize). you must make sure that the box is not void (see isvoid()), otherwise the method returns irrelevant result.

        """
        return _Bnd.Bnd_B3d_CornerMax(self, *args)

    def CornerMin(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Query the lower corner: (center - hsize). you must make sure that the box is not void (see isvoid()), otherwise the method returns irrelevant result.

        """
        return _Bnd.Bnd_B3d_CornerMin(self, *args)

    def Enlarge(self, *args):
        r"""

        Parameters
        ----------
        theDiff: float

        Return
        -------
        None

        Description
        -----------
        Extend the box by the absolute value of thediff.

        """
        return _Bnd.Bnd_B3d_Enlarge(self, *args)

    def IsIn(self, *args):
        r"""

        Parameters
        ----------
        theBox: Bnd_B3d

        Return
        -------
        bool

        Description
        -----------
        Check that the box 'this' is inside the given box 'thebox'. returns true if 'this' box is fully inside 'thebox'.

        Parameters
        ----------
        theBox: Bnd_B3d
        theTrsf: gp_Trsf

        Return
        -------
        bool

        Description
        -----------
        Check that the box 'this' is inside the given box 'thebox' transformed by 'thetrsf'. returns true if 'this' box is fully inside the transformed 'thebox'.

        """
        return _Bnd.Bnd_B3d_IsIn(self, *args)

    def IsOut(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_XYZ

        Return
        -------
        bool

        Description
        -----------
        Check the given point for the inclusion in the box. returns true if the point is outside.

        Parameters
        ----------
        theCenter: gp_XYZ
        theRadius: float
        isSphereHollow: bool (optional, default to Standard_False)

        Return
        -------
        bool

        Description
        -----------
        Check a sphere for the intersection with the current box. returns true if there is no intersection between boxes. if the parameter 'isspherehollow' is true, then the intersection is not reported for a box that is completely inside the sphere (otherwise this method would report an intersection).

        Parameters
        ----------
        theOtherBox: Bnd_B3d

        Return
        -------
        bool

        Description
        -----------
        Check the given box for the intersection with the current box. returns true if there is no intersection between boxes.

        Parameters
        ----------
        theOtherBox: Bnd_B3d
        theTrsf: gp_Trsf

        Return
        -------
        bool

        Description
        -----------
        Check the given box oriented by the given transformation for the intersection with the current box. returns true if there is no intersection between boxes.

        Parameters
        ----------
        theLine: gp_Ax1
        isRay: bool (optional, default to Standard_False)
        theOverthickness: float (optional, default to 0.0)

        Return
        -------
        bool

        Description
        -----------
        Check the given line for the intersection with the current box. returns true if there is no intersection. isray==true means intersection check with the positive half-line theoverthickness is the addition to the size of the current box (may be negative). if positive, it can be treated as the thickness of the line 'theline' or the radius of the cylinder along 'theline'.

        Parameters
        ----------
        thePlane: gp_Ax3

        Return
        -------
        bool

        Description
        -----------
        Check the given plane for the intersection with the current box. returns true if there is no intersection.

        """
        return _Bnd.Bnd_B3d_IsOut(self, *args)

    def IsVoid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the box is void (non-initialized).

        """
        return _Bnd.Bnd_B3d_IsVoid(self, *args)

    def Limit(self, *args):
        r"""

        Parameters
        ----------
        theOtherBox: Bnd_B3d

        Return
        -------
        bool

        Description
        -----------
        Limit the box by the internals of theotherbox. returns true if the limitation takes place, otherwise false indicating that the boxes do not intersect.

        """
        return _Bnd.Bnd_B3d_Limit(self, *args)

    def SetCenter(self, *args):
        r"""

        Parameters
        ----------
        theCenter: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Set the center coordinates.

        """
        return _Bnd.Bnd_B3d_SetCenter(self, *args)

    def SetHSize(self, *args):
        r"""

        Parameters
        ----------
        theHSize: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Set the hsize (half-diagonal) coordinates. all components of thehsize must be non-negative.

        """
        return _Bnd.Bnd_B3d_SetHSize(self, *args)

    def SquareExtent(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Query the square diagonal. if the box is void (see method isvoid()) then a very big real value is returned.

        """
        return _Bnd.Bnd_B3d_SquareExtent(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theTrsf: gp_Trsf

        Return
        -------
        Bnd_B3d

        Description
        -----------
        Transform the bounding box with the given transformation. the resulting box will be larger if thetrsf contains rotation.

        """
        return _Bnd.Bnd_B3d_Transformed(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Bnd.delete_Bnd_B3d

# Register Bnd_B3d in _Bnd:
_Bnd.Bnd_B3d_swigregister(Bnd_B3d)
class Bnd_B3f(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theCenter: gp_XYZ
        theHSize: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _Bnd.Bnd_B3f_swiginit(self, _Bnd.new_Bnd_B3f(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Update the box by a point.

        Parameters
        ----------
        thePnt: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Update the box by a point.

        Parameters
        ----------
        theBox: Bnd_B3f

        Return
        -------
        None

        Description
        -----------
        Update the box by another box.

        """
        return _Bnd.Bnd_B3f_Add(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reset the box data.

        """
        return _Bnd.Bnd_B3f_Clear(self, *args)

    def CornerMax(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Query the upper corner: (center + hsize). you must make sure that the box is not void (see isvoid()), otherwise the method returns irrelevant result.

        """
        return _Bnd.Bnd_B3f_CornerMax(self, *args)

    def CornerMin(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Query the lower corner: (center - hsize). you must make sure that the box is not void (see isvoid()), otherwise the method returns irrelevant result.

        """
        return _Bnd.Bnd_B3f_CornerMin(self, *args)

    def Enlarge(self, *args):
        r"""

        Parameters
        ----------
        theDiff: float

        Return
        -------
        None

        Description
        -----------
        Extend the box by the absolute value of thediff.

        """
        return _Bnd.Bnd_B3f_Enlarge(self, *args)

    def IsIn(self, *args):
        r"""

        Parameters
        ----------
        theBox: Bnd_B3f

        Return
        -------
        bool

        Description
        -----------
        Check that the box 'this' is inside the given box 'thebox'. returns true if 'this' box is fully inside 'thebox'.

        Parameters
        ----------
        theBox: Bnd_B3f
        theTrsf: gp_Trsf

        Return
        -------
        bool

        Description
        -----------
        Check that the box 'this' is inside the given box 'thebox' transformed by 'thetrsf'. returns true if 'this' box is fully inside the transformed 'thebox'.

        """
        return _Bnd.Bnd_B3f_IsIn(self, *args)

    def IsOut(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_XYZ

        Return
        -------
        bool

        Description
        -----------
        Check the given point for the inclusion in the box. returns true if the point is outside.

        Parameters
        ----------
        theCenter: gp_XYZ
        theRadius: float
        isSphereHollow: bool (optional, default to Standard_False)

        Return
        -------
        bool

        Description
        -----------
        Check a sphere for the intersection with the current box. returns true if there is no intersection between boxes. if the parameter 'isspherehollow' is true, then the intersection is not reported for a box that is completely inside the sphere (otherwise this method would report an intersection).

        Parameters
        ----------
        theOtherBox: Bnd_B3f

        Return
        -------
        bool

        Description
        -----------
        Check the given box for the intersection with the current box. returns true if there is no intersection between boxes.

        Parameters
        ----------
        theOtherBox: Bnd_B3f
        theTrsf: gp_Trsf

        Return
        -------
        bool

        Description
        -----------
        Check the given box oriented by the given transformation for the intersection with the current box. returns true if there is no intersection between boxes.

        Parameters
        ----------
        theLine: gp_Ax1
        isRay: bool (optional, default to Standard_False)
        theOverthickness: float (optional, default to 0.0)

        Return
        -------
        bool

        Description
        -----------
        Check the given line for the intersection with the current box. returns true if there is no intersection. isray==true means intersection check with the positive half-line theoverthickness is the addition to the size of the current box (may be negative). if positive, it can be treated as the thickness of the line 'theline' or the radius of the cylinder along 'theline'.

        Parameters
        ----------
        thePlane: gp_Ax3

        Return
        -------
        bool

        Description
        -----------
        Check the given plane for the intersection with the current box. returns true if there is no intersection.

        """
        return _Bnd.Bnd_B3f_IsOut(self, *args)

    def IsVoid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the box is void (non-initialized).

        """
        return _Bnd.Bnd_B3f_IsVoid(self, *args)

    def Limit(self, *args):
        r"""

        Parameters
        ----------
        theOtherBox: Bnd_B3f

        Return
        -------
        bool

        Description
        -----------
        Limit the box by the internals of theotherbox. returns true if the limitation takes place, otherwise false indicating that the boxes do not intersect.

        """
        return _Bnd.Bnd_B3f_Limit(self, *args)

    def SetCenter(self, *args):
        r"""

        Parameters
        ----------
        theCenter: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Set the center coordinates.

        """
        return _Bnd.Bnd_B3f_SetCenter(self, *args)

    def SetHSize(self, *args):
        r"""

        Parameters
        ----------
        theHSize: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Set the hsize (half-diagonal) coordinates. all components of thehsize must be non-negative.

        """
        return _Bnd.Bnd_B3f_SetHSize(self, *args)

    def SquareExtent(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Query the square diagonal. if the box is void (see method isvoid()) then a very big real value is returned.

        """
        return _Bnd.Bnd_B3f_SquareExtent(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        theTrsf: gp_Trsf

        Return
        -------
        Bnd_B3f

        Description
        -----------
        Transform the bounding box with the given transformation. the resulting box will be larger if thetrsf contains rotation.

        """
        return _Bnd.Bnd_B3f_Transformed(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Bnd.delete_Bnd_B3f

# Register Bnd_B3f in _Bnd:
_Bnd.Bnd_B3f_swigregister(Bnd_B3f)
class Bnd_BoundSortBox(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty comparison algorithm for bounding boxes. the bounding boxes are then defined using the initialize function.

        """
        _Bnd.Bnd_BoundSortBox_swiginit(self, _Bnd.new_Bnd_BoundSortBox(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        theBox: Bnd_Box
        boxIndex: int

        Return
        -------
        None

        Description
        -----------
        Adds the bounding box thebox at position boxindex in the array of boxes to be sorted by this comparison algorithm. this function is used only in conjunction with the third syntax described in the synopsis of initialize. //! exceptions: //! - standard_outofrange if boxindex is not in the range [ 1,nbcomponents ] where nbcomponents is the maximum number of bounding boxes declared for this comparison algorithm at initialization. //! - standard_multiplydefined if a box already exists at position boxindex in the array of boxes to be sorted by this comparison algorithm.

        """
        return _Bnd.Bnd_BoundSortBox_Add(self, *args)

    def Compare(self, *args):
        r"""

        Parameters
        ----------
        theBox: Bnd_Box

        Return
        -------
        TColStd_ListOfInteger

        Description
        -----------
        Compares the bounding box thebox, with the set of bounding boxes to be sorted by this comparison algorithm, and returns the list of intersecting bounding boxes as a list of indexes on the array of bounding boxes used by this algorithm.

        Parameters
        ----------
        P: gp_Pln

        Return
        -------
        TColStd_ListOfInteger

        Description
        -----------
        Compares the plane p with the set of bounding boxes to be sorted by this comparison algorithm, and returns the list of intersecting bounding boxes as a list of indexes on the array of bounding boxes used by this algorithm.

        """
        return _Bnd.Bnd_BoundSortBox_Compare(self, *args)

    def Destroy(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Bnd.Bnd_BoundSortBox_Destroy(self, *args)

    def Dump(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Bnd.Bnd_BoundSortBox_Dump(self, *args)

    def Initialize(self, *args):
        r"""

        Parameters
        ----------
        CompleteBox: Bnd_Box
        SetOfBox: Bnd_HArray1OfBox

        Return
        -------
        None

        Description
        -----------
        Initializes this comparison algorithm with - the set of bounding boxes setofbox.

        Parameters
        ----------
        SetOfBox: Bnd_HArray1OfBox

        Return
        -------
        None

        Description
        -----------
        Initializes this comparison algorithm with - the set of bounding boxes setofbox, where completebox is given as the global bounding box of setofbox.

        Parameters
        ----------
        CompleteBox: Bnd_Box
        nbComponents: int

        Return
        -------
        None

        Description
        -----------
        Initializes this comparison algorithm, giving it only - the maximum number nbcomponents of the bounding boxes to be managed. use the add function to define the array of bounding boxes to be sorted by this algorithm.

        """
        return _Bnd.Bnd_BoundSortBox_Initialize(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Bnd.delete_Bnd_BoundSortBox

# Register Bnd_BoundSortBox in _Bnd:
_Bnd.Bnd_BoundSortBox_swigregister(Bnd_BoundSortBox)
class Bnd_Box(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty box. the constructed box is qualified void. its gap is null.

        Parameters
        ----------
        theMin: gp_Pnt
        theMax: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Creates a bounding box, it contains: - minimum/maximum point of bounding box, the constructed box is qualified void. its gap is null.

        """
        _Bnd.Bnd_Box_swiginit(self, _Bnd.new_Bnd_Box(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        Other: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Adds the box <other> to <self>.

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Adds a pnt to the box.

        Parameters
        ----------
        P: gp_Pnt
        D: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Extends <self> from the pnt <p> in the direction <d>.

        Parameters
        ----------
        D: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Extends the box in the given direction, i.e. adds an half-line. the box may become infinite in 1,2 or 3 directions.

        """
        return _Bnd.Bnd_Box_Add(self, *args)

    def CornerMax(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the upper corner of this bounding box. the gap is included. if this bounding box is infinite (i.e. 'open'), returned values may be equal to +/- precision::infinite(). standard_constructionerror exception will be thrown if the box is void. if isvoid().

        """
        return _Bnd.Bnd_Box_CornerMax(self, *args)

    def CornerMin(self, *args):
        r"""
        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns the lower corner of this bounding box. the gap is included. if this bounding box is infinite (i.e. 'open'), returned values may be equal to +/- precision::infinite(). standard_constructionerror exception will be thrown if the box is void. if isvoid().

        """
        return _Bnd.Bnd_Box_CornerMin(self, *args)

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        Other: Bnd_Box

        Return
        -------
        float

        Description
        -----------
        Computes the minimum distance between two boxes.

        """
        return _Bnd.Bnd_Box_Distance(self, *args)

    def Dump(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Bnd.Bnd_Box_Dump(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _Bnd.Bnd_Box_DumpJsonToString(self, depth)

    def Enlarge(self, *args):
        r"""

        Parameters
        ----------
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Enlarges the box with a tolerance value. (minvalues-abs(<tol>) and maxvalues+abs(<tol>)) this means that the minimum values of its x, y and z intervals of definition, when they are finite, are reduced by the absolute value of tol, while the maximum values are increased by the same amount.

        """
        return _Bnd.Bnd_Box_Enlarge(self, *args)

    def FinitePart(self, *args):
        r"""
        Return
        -------
        Bnd_Box

        Description
        -----------
        Returns a finite part of an infinite bounding box (returns self if this is already finite box). this can be a void box in case if its sides has been defined as infinite (open) without adding any finite points. warning! this method relies on open flags, the infinite points added using add() method will be returned as is.

        """
        return _Bnd.Bnd_Box_FinitePart(self, *args)

    def Get(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theXmin: float
        theYmin: float
        theZmin: float
        theXmax: float
        theYmax: float
        theZmax: float

        Description
        -----------
        Returns the bounds of this bounding box. the gap is included. if this bounding box is infinite (i.e. 'open'), returned values may be equal to +/- precision::infinite(). standard_constructionerror exception will be thrown if the box is void. if isvoid().

        """
        return _Bnd.Bnd_Box_Get(self, *args)

    def GetGap(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the gap of this bounding box.

        """
        return _Bnd.Bnd_Box_GetGap(self, *args)

    def HasFinitePart(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this box has finite part.

        """
        return _Bnd.Bnd_Box_HasFinitePart(self, *args)

    def InitFromJsonString(self, json_string):
        r"""InitFromJsonString(Bnd_Box self, std::string json_string) -> bool"""
        return _Bnd.Bnd_Box_InitFromJsonString(self, json_string)

    def IsOpen(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box has at least one open direction.

        """
        return _Bnd.Bnd_Box_IsOpen(self, *args)

    def IsOpenXmax(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is open in the xmax direction.

        """
        return _Bnd.Bnd_Box_IsOpenXmax(self, *args)

    def IsOpenXmin(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is open in the xmin direction.

        """
        return _Bnd.Bnd_Box_IsOpenXmin(self, *args)

    def IsOpenYmax(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is open in the ymax direction.

        """
        return _Bnd.Bnd_Box_IsOpenYmax(self, *args)

    def IsOpenYmin(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is open in the ymix direction.

        """
        return _Bnd.Bnd_Box_IsOpenYmin(self, *args)

    def IsOpenZmax(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is open in the zmax direction.

        """
        return _Bnd.Bnd_Box_IsOpenZmax(self, *args)

    def IsOpenZmin(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is open in the zmin direction.

        """
        return _Bnd.Bnd_Box_IsOpenZmin(self, *args)

    def IsOut(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        bool

        Description
        -----------
        Returns true if the pnt is out the box.

        Parameters
        ----------
        L: gp_Lin

        Return
        -------
        bool

        Description
        -----------
        Returns false if the line intersects the box.

        Parameters
        ----------
        P: gp_Pln

        Return
        -------
        bool

        Description
        -----------
        Returns false if the plane intersects the box.

        Parameters
        ----------
        Other: Bnd_Box

        Return
        -------
        bool

        Description
        -----------
        Returns false if the <box> intersects or is inside <self>.

        Parameters
        ----------
        Other: Bnd_Box
        T: gp_Trsf

        Return
        -------
        bool

        Description
        -----------
        Returns false if the transformed <box> intersects or is inside <self>.

        Parameters
        ----------
        T1: gp_Trsf
        Other: Bnd_Box
        T2: gp_Trsf

        Return
        -------
        bool

        Description
        -----------
        Returns false if the transformed <box> intersects or is inside the transformed box <self>.

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt
        D: gp_Dir

        Return
        -------
        bool

        Description
        -----------
        Returns false if the flat band lying between two parallel lines represented by their reference points <p1>, <p2> and direction <d> intersects the box.

        """
        return _Bnd.Bnd_Box_IsOut(self, *args)

    def IsThin(self, *args):
        r"""

        Parameters
        ----------
        tol: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if isxthin, isythin and iszthin are all true, i.e. if the box is thin in all three dimensions.

        """
        return _Bnd.Bnd_Box_IsThin(self, *args)

    def IsVoid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is empty (void flag).

        """
        return _Bnd.Bnd_Box_IsVoid(self, *args)

    def IsWhole(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is infinite in all 6 directions (wholespace flag).

        """
        return _Bnd.Bnd_Box_IsWhole(self, *args)

    def IsXThin(self, *args):
        r"""

        Parameters
        ----------
        tol: float

        Return
        -------
        bool

        Description
        -----------
        True if xmax-xmin < tol.

        """
        return _Bnd.Bnd_Box_IsXThin(self, *args)

    def IsYThin(self, *args):
        r"""

        Parameters
        ----------
        tol: float

        Return
        -------
        bool

        Description
        -----------
        True if ymax-ymin < tol.

        """
        return _Bnd.Bnd_Box_IsYThin(self, *args)

    def IsZThin(self, *args):
        r"""

        Parameters
        ----------
        tol: float

        Return
        -------
        bool

        Description
        -----------
        True if zmax-zmin < tol.

        """
        return _Bnd.Bnd_Box_IsZThin(self, *args)

    def OpenXmax(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        The box will be infinitely long in the xmax direction.

        """
        return _Bnd.Bnd_Box_OpenXmax(self, *args)

    def OpenXmin(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        The box will be infinitely long in the xmin direction.

        """
        return _Bnd.Bnd_Box_OpenXmin(self, *args)

    def OpenYmax(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        The box will be infinitely long in the ymax direction.

        """
        return _Bnd.Bnd_Box_OpenYmax(self, *args)

    def OpenYmin(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        The box will be infinitely long in the ymin direction.

        """
        return _Bnd.Bnd_Box_OpenYmin(self, *args)

    def OpenZmax(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        The box will be infinitely long in the zmax direction.

        """
        return _Bnd.Bnd_Box_OpenZmax(self, *args)

    def OpenZmin(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        The box will be infinitely long in the zmin direction.

        """
        return _Bnd.Bnd_Box_OpenZmin(self, *args)

    def Set(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Sets this bounding box so that it bounds - the point p. this involves first setting this bounding box to be void and then adding the point p.

        Parameters
        ----------
        P: gp_Pnt
        D: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Sets this bounding box so that it bounds the half-line defined by point p and direction d, i.e. all points m defined by m=p+u*d, where u is greater than or equal to 0, are inside the bounding volume. this involves first setting this box to be void and then adding the half-line.

        """
        return _Bnd.Bnd_Box_Set(self, *args)

    def SetGap(self, *args):
        r"""

        Parameters
        ----------
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Set the gap of this bounding box to abs(tol).

        """
        return _Bnd.Bnd_Box_SetGap(self, *args)

    def SetVoid(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets this bounding box so that it is empty. all points are outside a void box.

        """
        return _Bnd.Bnd_Box_SetVoid(self, *args)

    def SetWhole(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets this bounding box so that it covers the whole of 3d space. it is infinitely long in all directions.

        """
        return _Bnd.Bnd_Box_SetWhole(self, *args)

    def SquareExtent(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the squared diagonal of me.

        """
        return _Bnd.Bnd_Box_SquareExtent(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        T: gp_Trsf

        Return
        -------
        Bnd_Box

        Description
        -----------
        Returns a bounding box which is the result of applying the transformation t to this bounding box. warning applying a geometric transformation (for example, a rotation) to a bounding box generally increases its dimensions. this is not optimal for algorithms which use it.

        """
        return _Bnd.Bnd_Box_Transformed(self, *args)

    def Update(self, *args):
        r"""

        Parameters
        ----------
        aXmin: float
        aYmin: float
        aZmin: float
        aXmax: float
        aYmax: float
        aZmax: float

        Return
        -------
        None

        Description
        -----------
        Enlarges this bounding box, if required, so that it contains at least: - interval [ axmin,axmax ] in the 'x direction', - interval [ aymin,aymax ] in the 'y direction', - interval [ azmin,azmax ] in the 'z direction';.

        Parameters
        ----------
        X: float
        Y: float
        Z: float

        Return
        -------
        None

        Description
        -----------
        Adds a point of coordinates (x,y,z) to this bounding box.

        """
        return _Bnd.Bnd_Box_Update(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = Bnd_Box()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of Bnd_Box')


    __repr__ = _dumps_object

    __swig_destroy__ = _Bnd.delete_Bnd_Box

# Register Bnd_Box in _Bnd:
_Bnd.Bnd_Box_swigregister(Bnd_Box)
class Bnd_Box2d(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty 2d bounding box. the constructed box is qualified void. its gap is null.

        """
        _Bnd.Bnd_Box2d_swiginit(self, _Bnd.new_Bnd_Box2d(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        Other: Bnd_Box2d

        Return
        -------
        None

        Description
        -----------
        Adds the 2d box <other> to <self>.

        Parameters
        ----------
        thePnt: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Adds the 2d point.

        Parameters
        ----------
        thePnt: gp_Pnt2d
        theDir: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        Extends bounding box from thepnt in the direction thedir.

        Parameters
        ----------
        D: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        Extends the box in the given direction, i.e. adds a half-line. the box may become infinite in 1 or 2 directions.

        """
        return _Bnd.Bnd_Box2d_Add(self, *args)

    def Dump(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Bnd.Bnd_Box2d_Dump(self, *args)

    def Enlarge(self, *args):
        r"""

        Parameters
        ----------
        theTol: float

        Return
        -------
        None

        Description
        -----------
        Enlarges the box with a tolerance value. this means that the minimum values of its x and y intervals of definition, when they are finite, are reduced by the absolute value of tol, while the maximum values are increased by the same amount.

        """
        return _Bnd.Bnd_Box2d_Enlarge(self, *args)

    def Get(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        aXmin: float
        aYmin: float
        aXmax: float
        aYmax: float

        Description
        -----------
        Returns the bounds of this 2d bounding box. the gap is included. if this bounding box is infinite (i.e. 'open'), returned values may be equal to +/- precision::infinite(). if isvoid().

        """
        return _Bnd.Bnd_Box2d_Get(self, *args)

    def GetGap(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the gap of this 2d bounding box.

        """
        return _Bnd.Bnd_Box2d_GetGap(self, *args)

    def IsOpenXmax(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is open in the xmax direction.

        """
        return _Bnd.Bnd_Box2d_IsOpenXmax(self, *args)

    def IsOpenXmin(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is open in the xmin direction.

        """
        return _Bnd.Bnd_Box2d_IsOpenXmin(self, *args)

    def IsOpenYmax(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is open in the ymax direction.

        """
        return _Bnd.Bnd_Box2d_IsOpenYmax(self, *args)

    def IsOpenYmin(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is open in the ymin direction.

        """
        return _Bnd.Bnd_Box2d_IsOpenYmin(self, *args)

    def IsOut(self, *args):
        r"""

        Parameters
        ----------
        P: gp_Pnt2d

        Return
        -------
        bool

        Description
        -----------
        Returns true if the 2d pnt <p> is out <self>.

        Parameters
        ----------
        theL: gp_Lin2d

        Return
        -------
        bool

        Description
        -----------
        Returns true if the line doesn't intersect the box.

        Parameters
        ----------
        theP0: gp_Pnt2d
        theP1: gp_Pnt2d

        Return
        -------
        bool

        Description
        -----------
        Returns true if the segment doesn't intersect the box.

        Parameters
        ----------
        Other: Bnd_Box2d

        Return
        -------
        bool

        Description
        -----------
        Returns true if <box2d> is out <self>.

        Parameters
        ----------
        theOther: Bnd_Box2d
        theTrsf: gp_Trsf2d

        Return
        -------
        bool

        Description
        -----------
        Returns true if transformed <box2d> is out <self>.

        Parameters
        ----------
        T1: gp_Trsf2d
        Other: Bnd_Box2d
        T2: gp_Trsf2d

        Return
        -------
        bool

        Description
        -----------
        Compares a transformed bounding with a transformed bounding. the default implementation is to make a copy of <self> and <other>, to transform them and to test.

        """
        return _Bnd.Bnd_Box2d_IsOut(self, *args)

    def IsVoid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this 2d bounding box is empty (void flag).

        """
        return _Bnd.Bnd_Box2d_IsVoid(self, *args)

    def IsWhole(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if this bounding box is infinite in all 4 directions (whole space flag).

        """
        return _Bnd.Bnd_Box2d_IsWhole(self, *args)

    def OpenXmax(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        The box will be infinitely long in the xmax direction.

        """
        return _Bnd.Bnd_Box2d_OpenXmax(self, *args)

    def OpenXmin(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        The box will be infinitely long in the xmin direction.

        """
        return _Bnd.Bnd_Box2d_OpenXmin(self, *args)

    def OpenYmax(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        The box will be infinitely long in the ymax direction.

        """
        return _Bnd.Bnd_Box2d_OpenYmax(self, *args)

    def OpenYmin(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        The box will be infinitely long in the ymin direction.

        """
        return _Bnd.Bnd_Box2d_OpenYmin(self, *args)

    def Set(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Sets this 2d bounding box so that it bounds the point p. this involves first setting this bounding box to be void and then adding the point pthe rectangle bounds the point <p>.

        Parameters
        ----------
        thePnt: gp_Pnt2d
        theDir: gp_Dir2d

        Return
        -------
        None

        Description
        -----------
        Sets this 2d bounding box so that it bounds the half-line defined by point p and direction d, i.e. all points m defined by m=p+u*d, where u is greater than or equal to 0, are inside the bounding area. this involves first setting this 2d box to be void and then adding the half-line.

        """
        return _Bnd.Bnd_Box2d_Set(self, *args)

    def SetGap(self, *args):
        r"""

        Parameters
        ----------
        Tol: float

        Return
        -------
        None

        Description
        -----------
        Set the gap of this 2d bounding box to abs(tol).

        """
        return _Bnd.Bnd_Box2d_SetGap(self, *args)

    def SetVoid(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets this 2d bounding box so that it is empty. all points are outside a void box.

        """
        return _Bnd.Bnd_Box2d_SetVoid(self, *args)

    def SetWhole(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sets this bounding box so that it covers the whole 2d space, i.e. it is infinite in all directions.

        """
        return _Bnd.Bnd_Box2d_SetWhole(self, *args)

    def SquareExtent(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Computes the squared diagonal of me.

        """
        return _Bnd.Bnd_Box2d_SquareExtent(self, *args)

    def Transformed(self, *args):
        r"""

        Parameters
        ----------
        T: gp_Trsf2d

        Return
        -------
        Bnd_Box2d

        Description
        -----------
        Returns a bounding box which is the result of applying the transformation t to this bounding box. warning applying a geometric transformation (for example, a rotation) to a bounding box generally increases its dimensions. this is not optimal for algorithms which use it.

        """
        return _Bnd.Bnd_Box2d_Transformed(self, *args)

    def Update(self, *args):
        r"""

        Parameters
        ----------
        aXmin: float
        aYmin: float
        aXmax: float
        aYmax: float

        Return
        -------
        None

        Description
        -----------
        Enlarges this 2d bounding box, if required, so that it contains at least: - interval [ axmin,axmax ] in the 'x direction', - interval [ aymin,aymax ] in the 'y direction'.

        Parameters
        ----------
        X: float
        Y: float

        Return
        -------
        None

        Description
        -----------
        Adds a point of coordinates (x,y) to this bounding box.

        """
        return _Bnd.Bnd_Box2d_Update(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = Bnd_Box2d()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of Bnd_Box2d')


    __repr__ = _dumps_object

    __swig_destroy__ = _Bnd.delete_Bnd_Box2d

# Register Bnd_Box2d in _Bnd:
_Bnd.Bnd_Box2d_swigregister(Bnd_Box2d)
class Bnd_OBB(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theCenter: gp_Pnt
        theXDirection: gp_Dir
        theYDirection: gp_Dir
        theZDirection: gp_Dir
        theHXSize: float
        theHYSize: float
        theHZSize: float

        Return
        -------
        None

        Description
        -----------
        Constructor taking all defining parameters.

        Parameters
        ----------
        theBox: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Constructor to create obb from aabb.

        """
        _Bnd.Bnd_OBB_swiginit(self, _Bnd.new_Bnd_OBB(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        theOther: Bnd_OBB

        Return
        -------
        None

        Description
        -----------
        Rebuilds this in order to include all previous objects (which it was created from) and theother.

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Rebuilds this in order to include all previous objects (which it was created from) and thep.

        """
        return _Bnd.Bnd_OBB_Add(self, *args)

    def Center(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Returns the center of obb.

        """
        return _Bnd.Bnd_OBB_Center(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _Bnd.Bnd_OBB_DumpJsonToString(self, depth)

    def Enlarge(self, *args):
        r"""

        Parameters
        ----------
        theGapAdd: float

        Return
        -------
        None

        Description
        -----------
        Enlarges the box with the given value.

        """
        return _Bnd.Bnd_OBB_Enlarge(self, *args)

    def GetVertex(self, *args):
        r"""

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        bool

        Description
        -----------
        Returns the array of vertices in <this>. the local coordinate of the vertex depending on the index of the array are follow: index == 0: (-xhsize(), -yhsize(), -zhsize()) index == 1: ( xhsize(), -yhsize(), -zhsize()) index == 2: (-xhsize(), yhsize(), -zhsize()) index == 3: ( xhsize(), yhsize(), -zhsize()) index == 4: (-xhsize(), -yhsize(), zhsize()) index == 5: ( xhsize(), -yhsize(), zhsize()) index == 6: (-xhsize(), yhsize(), zhsize()) index == 7: ( xhsize(), yhsize(), zhsize()).

        """
        return _Bnd.Bnd_OBB_GetVertex(self, *args)

    def IsAABox(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the box is axes aligned.

        """
        return _Bnd.Bnd_OBB_IsAABox(self, *args)

    def IsCompletelyInside(self, *args):
        r"""

        Parameters
        ----------
        theOther: Bnd_OBB

        Return
        -------
        bool

        Description
        -----------
        Check if the theother is completely inside *this.

        """
        return _Bnd.Bnd_OBB_IsCompletelyInside(self, *args)

    def IsOut(self, *args):
        r"""

        Parameters
        ----------
        theOther: Bnd_OBB

        Return
        -------
        bool

        Description
        -----------
        Check if the box do not interfere the other box.

        Parameters
        ----------
        theP: gp_Pnt

        Return
        -------
        bool

        Description
        -----------
        Check if the point is inside of <this>.

        """
        return _Bnd.Bnd_OBB_IsOut(self, *args)

    def IsVoid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Checks if the box is empty.

        """
        return _Bnd.Bnd_OBB_IsVoid(self, *args)

    def Position(self, *args):
        r"""
        Return
        -------
        gp_Ax3

        Description
        -----------
        Returns the local coordinates system of this oriented box. so that applying it to axis-aligned box ((-xhsize, -yhsize, -zhsize), (xhsize, yhsize, zhsize)) will produce this oriented box. @code gp_trsf aloc; aloc.settransformation (theobb.position(), gp::xoy()); @endcode.

        """
        return _Bnd.Bnd_OBB_Position(self, *args)

    def ReBuild(self, *args):
        r"""

        Parameters
        ----------
        theListOfPoints: TColgp_Array1OfPnt
        theListOfTolerances: TColStd_Array1OfReal * (optional, default to 0)
        theIsOptimal: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Creates new obb covering every point in thelistofpoints. tolerance of every such point is set by *thelistoftolerances array. if this array is not void (not null-pointer) then the resulted bnd_obb will be enlarged using tolerances of points lying on the box surface. <theisoptimal> flag defines the mode in which the obb will be built. constructing optimal box takes more time, but the resulting box is usually more tight. in case of construction of optimal obb more possible axes are checked.

        """
        return _Bnd.Bnd_OBB_ReBuild(self, *args)

    def SetAABox(self, *args):
        r"""

        Parameters
        ----------
        theFlag: bool

        Return
        -------
        None

        Description
        -----------
        Sets the flag for axes aligned box.

        """
        return _Bnd.Bnd_OBB_SetAABox(self, *args)

    def SetCenter(self, *args):
        r"""

        Parameters
        ----------
        theCenter: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Sets the center of obb.

        """
        return _Bnd.Bnd_OBB_SetCenter(self, *args)

    def SetVoid(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears this box.

        """
        return _Bnd.Bnd_OBB_SetVoid(self, *args)

    def SetXComponent(self, *args):
        r"""

        Parameters
        ----------
        theXDirection: gp_Dir
        theHXSize: float

        Return
        -------
        None

        Description
        -----------
        Sets the x component of obb - direction and size.

        """
        return _Bnd.Bnd_OBB_SetXComponent(self, *args)

    def SetYComponent(self, *args):
        r"""

        Parameters
        ----------
        theYDirection: gp_Dir
        theHYSize: float

        Return
        -------
        None

        Description
        -----------
        Sets the y component of obb - direction and size.

        """
        return _Bnd.Bnd_OBB_SetYComponent(self, *args)

    def SetZComponent(self, *args):
        r"""

        Parameters
        ----------
        theZDirection: gp_Dir
        theHZSize: float

        Return
        -------
        None

        Description
        -----------
        Sets the z component of obb - direction and size.

        """
        return _Bnd.Bnd_OBB_SetZComponent(self, *args)

    def SquareExtent(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns square diagonal of this box.

        """
        return _Bnd.Bnd_OBB_SquareExtent(self, *args)

    def XDirection(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Returns the x direction of obb.

        """
        return _Bnd.Bnd_OBB_XDirection(self, *args)

    def XHSize(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the x dimension of obb.

        """
        return _Bnd.Bnd_OBB_XHSize(self, *args)

    def YDirection(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Returns the y direction of obb.

        """
        return _Bnd.Bnd_OBB_YDirection(self, *args)

    def YHSize(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the y dimension of obb.

        """
        return _Bnd.Bnd_OBB_YHSize(self, *args)

    def ZDirection(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Returns the z direction of obb.

        """
        return _Bnd.Bnd_OBB_ZDirection(self, *args)

    def ZHSize(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the z dimension of obb.

        """
        return _Bnd.Bnd_OBB_ZHSize(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = Bnd_OBB()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of Bnd_OBB')


    __repr__ = _dumps_object

    __swig_destroy__ = _Bnd.delete_Bnd_OBB

# Register Bnd_OBB in _Bnd:
_Bnd.Bnd_OBB_swigregister(Bnd_OBB)
class Bnd_Range(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Default constructor. creates void range.

        Parameters
        ----------
        theMin: float
        theMax: float

        Return
        -------
        None

        Description
        -----------
        Constructor. never creates void range.

        """
        _Bnd.Bnd_Range_swiginit(self, _Bnd.new_Bnd_Range(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        theParameter: float

        Return
        -------
        None

        Description
        -----------
        Extends <this> to include theparameter.

        Parameters
        ----------
        theRange: Bnd_Range

        Return
        -------
        None

        Description
        -----------
        Extends this range to include both ranges. @sa use method ::union() to check if two ranges overlap method merging.

        """
        return _Bnd.Bnd_Range_Add(self, *args)

    def Common(self, *args):
        r"""

        Parameters
        ----------
        theOther: Bnd_Range

        Return
        -------
        None

        Description
        -----------
        Replaces <this> with common-part of <this> and theother.

        """
        return _Bnd.Bnd_Range_Common(self, *args)

    def Delta(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns range value (max-min). returns negative value for void range.

        """
        return _Bnd.Bnd_Range_Delta(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _Bnd.Bnd_Range_DumpJsonToString(self, depth)

    def Enlarge(self, *args):
        r"""

        Parameters
        ----------
        theDelta: float

        Return
        -------
        None

        Description
        -----------
        Extends this to the given value (in both side).

        """
        return _Bnd.Bnd_Range_Enlarge(self, *args)

    def GetBounds(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theFirstPar: float
        theLastPar: float

        Description
        -----------
        Obtain first and last boundary of <this>. if <this> is void the method returns false.

        """
        return _Bnd.Bnd_Range_GetBounds(self, *args)

    def GetIntermediatePoint(self, *args):
        r"""

        Parameters
        ----------
        theLambda: float

        Return
        -------
        theParameter: float

        Description
        -----------
        Obtain theparameter satisfied to the equation (theparameter-min)/(max-min) == thelambda. * thelambda == 0 --> min boundary will be returned; * thelambda == 0.5 --> middle point will be returned; * thelambda == 1 --> max boundary will be returned; * thelambda < 0 --> the value less than min will be returned; * thelambda > 1 --> the value greater than max will be returned. if <this> is void the method returns false.

        """
        return _Bnd.Bnd_Range_GetIntermediatePoint(self, *args)

    def GetMax(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        thePar: float

        Description
        -----------
        Obtain max boundary of <this>. if <this> is void the method returns false.

        """
        return _Bnd.Bnd_Range_GetMax(self, *args)

    def GetMin(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        thePar: float

        Description
        -----------
        Obtain min boundary of <this>. if <this> is void the method returns false.

        """
        return _Bnd.Bnd_Range_GetMin(self, *args)

    def IsIntersected(self, *args):
        r"""

        Parameters
        ----------
        theVal: float
        thePeriod: float (optional, default to 0.0)

        Return
        -------
        int

        Description
        -----------
        Checks if <this> intersects values like theval+k*theperiod, where k is an integer number (k = 0, +/-1, +/-2, ...). returns: 0 - if <this> does not intersect the theval+k*theperiod. 1 - if <this> intersects theval+k*theperiod. 2 - if myfirst or/and mylast are equal to theval+k*theperiod. //! attention!!! if (myfirst == mylast) then this function will return only either 0 or 2.

        """
        return _Bnd.Bnd_Range_IsIntersected(self, *args)

    def IsOut(self, *args):
        r"""

        Parameters
        ----------
        theValue: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if the value is out of this range.

        Parameters
        ----------
        theRange: Bnd_Range

        Return
        -------
        bool

        Description
        -----------
        Returns true if the given range is out of this range.

        """
        return _Bnd.Bnd_Range_IsOut(self, *args)

    def IsVoid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Is <this> initialized.

        """
        return _Bnd.Bnd_Range_IsVoid(self, *args)

    def SetVoid(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Initializes <this> by default parameters. makes <this> void.

        """
        return _Bnd.Bnd_Range_SetVoid(self, *args)

    def Shift(self, *args):
        r"""

        Parameters
        ----------
        theVal: float

        Return
        -------
        None

        Description
        -----------
        Shifts <*this> by theval.

        """
        return _Bnd.Bnd_Range_Shift(self, *args)

    def Shifted(self, *args):
        r"""

        Parameters
        ----------
        theVal: float

        Return
        -------
        Bnd_Range

        Description
        -----------
        Returns the copy of <*this> shifted by theval.

        """
        return _Bnd.Bnd_Range_Shifted(self, *args)

    def Split(self, *args):
        r"""

        Parameters
        ----------
        theVal: float
        theList: NCollection_List<Bnd_Range>
        thePeriod: float (optional, default to 0.0)

        Return
        -------
        None

        Description
        -----------
        Splits <this> to several sub-ranges by theval value (e.g. range [3, 15] will be split by theval==5 to the two ranges: [3, 5] and [5, 15]). new ranges will be pushed to thelist (thelist must be initialized correctly before calling this method). if theperiod != 0.0 then at least one boundary of new ranges (if <*this> intersects theval+k*theperiod) will be equal to theval+theperiod*k, where k is an integer number (k = 0, +/-1, +/-2, ...). (let theperiod in above example be 4 ==> we will obtain four ranges: [3, 5], [5, 9], [9, 13] and [13, 15].

        """
        return _Bnd.Bnd_Range_Split(self, *args)

    def TrimFrom(self, *args):
        r"""

        Parameters
        ----------
        theValLower: float

        Return
        -------
        None

        Description
        -----------
        Trims the first value in range by the given lower limit. marks range as void if the given lower value is greater than range max.

        """
        return _Bnd.Bnd_Range_TrimFrom(self, *args)

    def TrimTo(self, *args):
        r"""

        Parameters
        ----------
        theValUpper: float

        Return
        -------
        None

        Description
        -----------
        Trim the last value in range by the given upper limit. marks range as void if the given upper value is smaller than range max.

        """
        return _Bnd.Bnd_Range_TrimTo(self, *args)

    def Union(self, *args):
        r"""

        Parameters
        ----------
        theOther: Bnd_Range

        Return
        -------
        bool

        Description
        -----------
        Joins *this and theother to one interval. replaces *this to the result. returns false if the operation cannot be done (e.g. input arguments are empty or separated). @sa use method ::add() to merge two ranges unconditionally.

        """
        return _Bnd.Bnd_Range_Union(self, *args)

    def __eq_wrapper__(self, other):
        r"""Json string serializer."""
        return _Bnd.Bnd_Range___eq_wrapper__(self, other)

    def __eq__(self, right):
        try:
            return self.__eq_wrapper__(right)
        except:
            return False


    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = Bnd_Range()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of Bnd_Range')


    __repr__ = _dumps_object

    __swig_destroy__ = _Bnd.delete_Bnd_Range

# Register Bnd_Range in _Bnd:
_Bnd.Bnd_Range_swigregister(Bnd_Range)
class Bnd_Sphere(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        Parameters
        ----------
        theCntr: gp_XYZ
        theRad: float
        theU: int
        theV: int

        Return
        -------
        None

        Description
        -----------
        Constructor of a definite sphere.

        """
        _Bnd.Bnd_Sphere_swiginit(self, _Bnd.new_Bnd_Sphere(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        theOther: Bnd_Sphere

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Bnd.Bnd_Sphere_Add(self, *args)

    def Center(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        Returns center of sphere object.

        """
        return _Bnd.Bnd_Sphere_Center(self, *args)

    def Distance(self, *args):
        r"""

        Parameters
        ----------
        theNode: gp_XYZ

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Bnd.Bnd_Sphere_Distance(self, *args)

    def Distances(self, *args):
        r"""

        Parameters
        ----------
        theXYZ: gp_XYZ

        Return
        -------
        theMin: float
        theMax: float

        Description
        -----------
        Calculate and return minimal and maximal distance to sphere. note: this function is tightly optimized; any modifications may affect performance!.

        """
        return _Bnd.Bnd_Sphere_Distances(self, *args)

    def IsOut(self, *args):
        r"""

        Parameters
        ----------
        theOther: Bnd_Sphere

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        thePnt: gp_XYZ

        Return
        -------
        theMaxDist: float

        Description
        -----------
        No available documentation.

        """
        return _Bnd.Bnd_Sphere_IsOut(self, *args)

    def IsValid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns validity status, indicating that this sphere corresponds to a real entity.

        """
        return _Bnd.Bnd_Sphere_IsValid(self, *args)

    def Project(self, *args):
        r"""

        Parameters
        ----------
        theNode: gp_XYZ
        theProjNode: gp_XYZ

        Return
        -------
        theDist: float
        theInside: bool

        Description
        -----------
        Projects a point on entity. returns true if success.

        """
        return _Bnd.Bnd_Sphere_Project(self, *args)

    def Radius(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the radius value.

        """
        return _Bnd.Bnd_Sphere_Radius(self, *args)

    def SetValid(self, *args):
        r"""

        Parameters
        ----------
        isValid: bool

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Bnd.Bnd_Sphere_SetValid(self, *args)

    def SquareDistance(self, *args):
        r"""

        Parameters
        ----------
        theNode: gp_XYZ

        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Bnd.Bnd_Sphere_SquareDistance(self, *args)

    def SquareDistances(self, *args):
        r"""

        Parameters
        ----------
        theXYZ: gp_XYZ

        Return
        -------
        theMin: float
        theMax: float

        Description
        -----------
        Calculate and return minimal and maximal distance to sphere. note: this function is tightly optimized; any modifications may affect performance!.

        """
        return _Bnd.Bnd_Sphere_SquareDistances(self, *args)

    def SquareExtent(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        No available documentation.

        """
        return _Bnd.Bnd_Sphere_SquareExtent(self, *args)

    def U(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the u parameter on shape.

        """
        return _Bnd.Bnd_Sphere_U(self, *args)

    def V(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the v parameter on shape.

        """
        return _Bnd.Bnd_Sphere_V(self, *args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = Bnd_Sphere()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of Bnd_Sphere')


    __repr__ = _dumps_object

    __swig_destroy__ = _Bnd.delete_Bnd_Sphere

# Register Bnd_Sphere in _Bnd:
_Bnd.Bnd_Sphere_swigregister(Bnd_Sphere)
class Bnd_Tools(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Bnd2BVH(*args):
        r"""

        Parameters
        ----------
        theBox: Bnd_Box2d

        Return
        -------
        BVH_Box<float, 2 >

        Description
        -----------
        Converts the given bnd_box2d to bvh_box.

        Parameters
        ----------
        theBox: Bnd_Box

        Return
        -------
        BVH_Box<float, 3 >

        Description
        -----------
        Converts the given bnd_box to bvh_box.

        """
        return _Bnd.Bnd_Tools_Bnd2BVH(*args)

    def __getstate__(self):
        return self.DumpJsonToString()


    def __setstate__(self, state):
        inst = Bnd_Tools()
        if inst.InitFromJsonString(state):
            self.this = inst.this
        else:
            raise IOError('Failed to set state of Bnd_Tools')


    __repr__ = _dumps_object


    def __init__(self):
        _Bnd.Bnd_Tools_swiginit(self, _Bnd.new_Bnd_Tools())
    __swig_destroy__ = _Bnd.delete_Bnd_Tools

# Register Bnd_Tools in _Bnd:
_Bnd.Bnd_Tools_swigregister(Bnd_Tools)
class Bnd_HArray1OfBox2d(Bnd_Array1OfBox2d, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _Bnd.Bnd_HArray1OfBox2d_swiginit(self, _Bnd.new_Bnd_HArray1OfBox2d(*args))

    def Array1(self):
        return _Bnd.Bnd_HArray1OfBox2d_Array1(self)

    def ChangeArray1(self):
        return _Bnd.Bnd_HArray1OfBox2d_ChangeArray1(self)


    @staticmethod
    def DownCast(t):
      return Handle_Bnd_HArray1OfBox2d_DownCast(t)

    __swig_destroy__ = _Bnd.delete_Bnd_HArray1OfBox2d

# Register Bnd_HArray1OfBox2d in _Bnd:
_Bnd.Bnd_HArray1OfBox2d_swigregister(Bnd_HArray1OfBox2d)
class Bnd_HArray1OfBox(Bnd_Array1OfBox, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _Bnd.Bnd_HArray1OfBox_swiginit(self, _Bnd.new_Bnd_HArray1OfBox(*args))

    def Array1(self):
        return _Bnd.Bnd_HArray1OfBox_Array1(self)

    def ChangeArray1(self):
        return _Bnd.Bnd_HArray1OfBox_ChangeArray1(self)


    @staticmethod
    def DownCast(t):
      return Handle_Bnd_HArray1OfBox_DownCast(t)

    __swig_destroy__ = _Bnd.delete_Bnd_HArray1OfBox

# Register Bnd_HArray1OfBox in _Bnd:
_Bnd.Bnd_HArray1OfBox_swigregister(Bnd_HArray1OfBox)
class Bnd_HArray1OfSphere(Bnd_Array1OfSphere, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _Bnd.Bnd_HArray1OfSphere_swiginit(self, _Bnd.new_Bnd_HArray1OfSphere(*args))

    def Array1(self):
        return _Bnd.Bnd_HArray1OfSphere_Array1(self)

    def ChangeArray1(self):
        return _Bnd.Bnd_HArray1OfSphere_ChangeArray1(self)


    @staticmethod
    def DownCast(t):
      return Handle_Bnd_HArray1OfSphere_DownCast(t)

    __swig_destroy__ = _Bnd.delete_Bnd_HArray1OfSphere

# Register Bnd_HArray1OfSphere in _Bnd:
_Bnd.Bnd_HArray1OfSphere_swigregister(Bnd_HArray1OfSphere)



@deprecated
def Bnd_Tools_Bnd2BVH(*args):
	return Bnd_Tools.Bnd2BVH(*args)

@deprecated
def Bnd_Tools_Bnd2BVH(*args):
	return Bnd_Tools.Bnd2BVH(*args)



