/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.v2.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualvm.lib.charts.swing.Utils;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerFeature;
import org.graalvm.visualvm.lib.profiler.v2.impl.Bundle;
import org.graalvm.visualvm.lib.ui.UIUtils;

public class FeaturesView
extends JPanel {
    private JTabbedPane tabs;
    private final Component defaultView;
    private JLabel hintLabel;
    private final Color hintColor;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();
    private static final int XMAR = 40;
    private static final int YMAR = 40;

    public FeaturesView(Component defaultView, String buttonString) {
        if (UIUtils.isOracleLookAndFeel()) {
            this.setOpaque(true);
            this.setBackground(UIUtils.getProfilerResultsBackground());
        } else {
            this.setOpaque(false);
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout(0, 0));
        if (defaultView != null) {
            JScrollPane sp = new JScrollPane(defaultView, 20, 31){

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            sp.getVerticalScrollBar().setUnitIncrement(20);
            sp.setBorder(null);
            sp.setViewportBorder(null);
            this.defaultView = sp;
            this.add(this.defaultView, "Center");
        } else {
            this.defaultView = null;
        }
        if (buttonString != null) {
            this.hintLabel = new JLabel();
            this.hintLabel.setIcon(Icons.getIcon((String)"GeneralIcons.Info"));
            this.hintLabel.setIconTextGap(this.hintLabel.getIconTextGap() + 1);
            this.hintLabel.setOpaque(false);
            Font font = new JToolTip().getFont();
            Color f = this.hintLabel.getForeground();
            int r = f.getRed() + 70;
            r = r > 255 ? f.getRed() - 70 : Math.min(r, 70);
            int g = f.getGreen() + 70;
            g = g > 255 ? f.getRed() - 70 : Math.min(g, 70);
            int b = f.getBlue() + 70;
            b = b > 255 ? f.getRed() - 70 : Math.min(b, 70);
            this.hintLabel.setText("<html><body text=\"rgb(" + r + ", " + g + ", " + b + ")\" style=\"font-size: " + font.getSize() + "pt; font-family: " + font.getName() + ";\">" + Bundle.FeaturesView_noData("<b>" + buttonString + "</b>") + "</body></html>");
            this.hintLabel.setSize(this.hintLabel.getPreferredSize());
            Color c = UIUtils.getProfilerResultsBackground();
            this.hintColor = Utils.checkedColor((Color)new Color(c.getRed(), c.getGreen(), c.getBlue(), 245));
        } else {
            this.hintColor = null;
        }
    }

    public final void resetNoDataHint() {
        this.hintLabel = null;
        this.repaint();
    }

    public final void addFeature(ProfilerFeature feature) {
        if (this.tabs == null) {
            if (this.defaultView != null) {
                this.remove(this.defaultView);
            }
            this.tabs = this.createTabs();
            this.add((Component)this.tabs, "Center");
        }
        JPanel container = this.createContainer(feature);
        this.tabs.addTab(feature.getName(), feature.getIcon(), container, null);
        this.doLayout();
        this.repaint();
        this.fireViewOrIndexChanged();
    }

    private JPanel createContainer(ProfilerFeature feature) {
        JPanel container = new JPanel(new BorderLayout(0, 0));
        container.putClientProperty(ProfilerFeature.class, feature);
        JPanel results = feature.getResultsUI();
        JPanel xresults = new JPanel(new BorderLayout()){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if (FeaturesView.this.hintLabel != null) {
                    Dimension dim = FeaturesView.this.hintLabel.getSize();
                    int x = (this.getWidth() - dim.width) / 2;
                    int y = (this.getHeight() - dim.height) / 2;
                    g.setColor(FeaturesView.this.hintColor);
                    g.fillRect(x - 40, y - 40, dim.width + 80, dim.height + 80);
                    g.setColor(Color.LIGHT_GRAY);
                    g.drawRect(x - 40, y - 40, dim.width + 80, dim.height + 80);
                    g.translate(x, y);
                    FeaturesView.this.hintLabel.paint(g);
                    g.translate(-x, -y);
                }
            }
        };
        xresults.add((Component)results, "Center");
        container.add((Component)xresults, "Center");
        JPanel settings = feature.getSettingsUI();
        if (settings != null) {
            JPanel pan = new JPanel(new BorderLayout(0, 0)){

                @Override
                public void setVisible(boolean visible) {
                    super.setVisible(visible);
                    for (Component c : this.getComponents()) {
                        c.setVisible(visible);
                    }
                }
            };
            pan.setOpaque(true);
            pan.setBackground(UIUtils.getProfilerResultsBackground());
            pan.add((Component)settings, "Center");
            JSeparator sep = UIUtils.createHorizontalLine((Color)pan.getBackground());
            pan.add((Component)sep, "South");
            pan.setVisible(settings.isVisible());
            container.add((Component)pan, "North");
        }
        return container;
    }

    public final void removeFeature(ProfilerFeature feature) {
        if (this.tabs != null) {
            this.tabs.remove(feature.getResultsUI());
            this.doLayout();
            this.repaint();
            if (this.tabs.getTabCount() == 0) {
                this.removeFeatures();
            } else {
                this.fireViewOrIndexChanged();
            }
        }
    }

    public final void removeFeatures() {
        this.removeAll();
        this.tabs = null;
        if (this.defaultView != null) {
            this.add(this.defaultView, "Center");
        }
        this.doLayout();
        this.repaint();
        this.fireViewOrIndexChanged();
    }

    public final ProfilerFeature getSelectedFeature() {
        if (this.tabs == null) {
            return null;
        }
        JPanel container = (JPanel)this.tabs.getSelectedComponent();
        return (ProfilerFeature)container.getClientProperty(ProfilerFeature.class);
    }

    public final void selectFeature(ProfilerFeature feature) {
        if (this.tabs == null) {
            return;
        }
        for (Component c : this.tabs.getComponents()) {
            if (((JComponent)c).getClientProperty(ProfilerFeature.class) != feature) continue;
            this.tabs.setSelectedComponent(c);
        }
    }

    public final void selectFeature(int index) {
        if (this.tabs == null) {
            return;
        }
        this.tabs.setSelectedIndex(index);
    }

    public final void selectPreviousFeature() {
        if (this.tabs == null) {
            return;
        }
        int index = UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex());
        this.tabs.setSelectedIndex(index);
    }

    public final void selectNextFeature() {
        if (this.tabs == null) {
            return;
        }
        int index = UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex());
        this.tabs.setSelectedIndex(index);
    }

    public final void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public final void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public final void fireViewOrIndexChanged() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private JTabbedPane createTabs() {
        JTabbedPane tp = new JTabbedPane(3){

            @Override
            protected final void fireStateChanged() {
                super.fireStateChanged();
                FeaturesView.this.fireViewOrIndexChanged();
            }
        };
        tp.setOpaque(false);
        if (UIUtils.isAquaLookAndFeel()) {
            tp.setBorder(BorderFactory.createEmptyBorder(-13, -11, 0, -10));
        } else {
            tp.setBorder(BorderFactory.createEmptyBorder());
            Insets i = UIManager.getInsets("TabbedPane.contentBorderInsets");
            int bottomOffset = 0;
            if (UIUtils.isMetalLookAndFeel()) {
                bottomOffset = -i.bottom + 1;
            } else if (UIUtils.isWindowsLookAndFeel()) {
                bottomOffset = -i.bottom;
            }
            if (i != null) {
                tp.setBorder(BorderFactory.createEmptyBorder(-i.top, -i.left, bottomOffset, -i.right));
            }
        }
        tp.getActionMap().getParent().remove("navigatePageUp");
        tp.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeaturesView.this.selectPreviousFeature();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeaturesView.this.selectNextFeature();
            }
        });
        return tp;
    }
}

