/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.modelset.Atom;
import org.jmol.modelset.Text;
import org.jmol.render.LabelsRenderer;
import org.jmol.render.TextRenderer;
import org.jmol.shape.Echo;
import org.jmol.util.C;

public class EchoRenderer
extends LabelsRenderer {
    private boolean haveTranslucent;

    @Override
    protected boolean render() {
        String frameTitle;
        if (this.vwr.isPreviewOnly) {
            return false;
        }
        Echo echo = (Echo)this.shape;
        this.sppm = this.vwr.getBoolean(603979845) ? this.vwr.getScalePixelsPerAngstrom(true) * 10000.0f : 0.0f;
        this.imageFontScaling = this.vwr.imageFontScaling;
        this.haveTranslucent = false;
        int alias = this.g3d.isAntialiased() ? 4 : 0;
        for (Text t : echo.objects.values()) {
            this.renderEcho(t, alias);
        }
        if (echo.scaleObject != null) {
            this.renderEcho(echo.scaleObject, alias);
        }
        if (!this.isExport && (frameTitle = this.vwr.getFrameTitle()) != null && frameTitle.length() > 0 && this.g3d.setC(this.vwr.cm.colixBackgroundContrast)) {
            this.renderFrameTitle(this.vwr.formatText(frameTitle));
        }
        return this.haveTranslucent;
    }

    private void renderEcho(Text t, int alias) {
        if (!t.visible || t.hidden) {
            return;
        }
        if (t.pointerPt instanceof Atom && !((Atom)t.pointerPt).checkVisible()) {
            return;
        }
        if (t.valign == 4) {
            TextRenderer.calcBarPixelsXYZ(this.vwr, t, this.pt0i, true);
        }
        if (t.pymolOffset != null) {
            t.getPymolScreenOffset(t.xyz, this.pt0i, this.zSlab, this.pTemp, this.sppm);
        } else if (t.movableZPercent != Integer.MAX_VALUE) {
            int z = this.vwr.tm.zValueFromPercent(t.movableZPercent % 1000);
            if (t.valign == 4 && Math.abs(t.movableZPercent) >= 1000) {
                z = this.pt0i.z - this.vwr.tm.zValueFromPercent(0) + z;
            }
            t.setZs(z, z);
        }
        if (t.pointerPt == null) {
            t.pointer = 0;
        } else {
            t.pointer = 1;
            this.tm.transformPtScr(t.pointerPt, this.pt0i);
            t.atomX = this.pt0i.x;
            t.atomY = this.pt0i.y;
            t.atomZ = this.pt0i.z;
            if (t.zSlab == Integer.MIN_VALUE) {
                t.zSlab = 1;
            }
        }
        if (TextRenderer.render(this.vwr, t, this.g3d, this.sppm, this.imageFontScaling, null, this.xy, this.pt2i, (short)0, 0, alias) && t.valign == 1 && t.align == 12) {
            this.vwr.noFrankEcho = false;
        }
        if (C.renderPass2(t.bgcolix) || C.renderPass2(t.colix)) {
            this.haveTranslucent = true;
        }
    }

    private void renderFrameTitle(String frameTitle) {
        this.vwr.gdata.setFontBold("arial", (int)(24.0f * this.imageFontScaling));
        int y = (int)Math.floor((float)(this.vwr.getScreenHeight() * (this.g3d.isAntialiased() ? 2 : 1)) - 10.0f * this.imageFontScaling);
        int x = (int)Math.floor(5.0f * this.imageFontScaling);
        this.g3d.drawStringNoSlab(frameTitle, null, x, y, 0, (short)0);
    }
}

