"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testTransformDisabled = exports.testTransform2 = exports.testTransform = exports.testRollup2 = exports.testRollup = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const testRollup = {
  _id: "test1",
  _version: 3,
  _seq_no: 7,
  _primary_term: 1,
  rollup: {
    rollup_id: "test1",
    enabled: true,
    schedule: {
      interval: {
        period: 1,
        unit: "Minutes",
        start_time: 1602100553
      }
    },
    last_updated_time: 1602100553,
    description: "An example job that rolls up the sample ecommerce data",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    target_index: "test_rollup",
    page_size: 1000,
    delay: 0,
    continuous: false,
    metadata_id: null,
    enabledTime: null,
    lastUpdatedTime: null,
    schemaVersion: 1,
    dimensions: [{
      date_histogram: {
        source_field: "order_date",
        fixed_interval: "90m",
        timezone: "America/Los_Angeles"
      }
    }, {
      terms: {
        source_field: "customer_gender"
      }
    }, {
      terms: {
        source_field: "geoip.city_name"
      }
    }, {
      terms: {
        source_field: "geoip.region_name"
      }
    }, {
      terms: {
        source_field: "day_of_week"
      }
    }],
    metrics: [{
      source_field: "taxless_total_price",
      metrics: [{
        avg: {}
      }, {
        sum: {}
      }, {
        max: {}
      }, {
        min: {}
      }, {
        value_count: {}
      }]
    }, {
      source_field: "total_quantity",
      metrics: [{
        avg: {}
      }, {
        max: {}
      }]
    }]
  },
  metadata: {
    test1: {
      metadata_id: "GSCm3HUBeGRB78cDQju6",
      rollup_metadata: {
        rollup_id: "test1",
        last_updated_time: 1605724690355,
        status: "finished",
        failure_reason: null,
        stats: {
          pages_processed: 5,
          documents_processed: 4675,
          rollups_indexed: 3627,
          index_time_in_millis: 1522,
          search_time_in_millis: 1168
        }
      }
    }
  }
};
exports.testRollup = testRollup;
const testRollup2 = {
  _id: "test2",
  _version: 3,
  _seq_no: 7,
  _primary_term: 1,
  rollup: {
    rollup_id: "test2",
    enabled: false,
    schedule: {
      interval: {
        period: 1,
        unit: "Minutes",
        start_time: 1602100553
      }
    },
    last_updated_time: 1602100553,
    description: "Another example job that rolls up the sample ecommerce data",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    target_index: "test_rollup2",
    page_size: 1000,
    delay: 0,
    continuous: false,
    dimensions: [{
      date_histogram: {
        source_field: "order_date",
        fixed_interval: "60m",
        timezone: "America/Los_Angeles"
      }
    }, {
      terms: {
        source_field: "customer_gender"
      }
    }, {
      terms: {
        source_field: "geoip.city_name"
      }
    }, {
      terms: {
        source_field: "geoip.region_name"
      }
    }, {
      terms: {
        source_field: "day_of_week"
      }
    }, {
      terms: {
        source_field: "day_of_week_i"
      }
    }],
    metrics: [{
      source_field: "taxless_total_price",
      metrics: [{
        avg: {}
      }, {
        sum: {}
      }, {
        max: {}
      }, {
        min: {}
      }, {
        value_count: {}
      }]
    }, {
      source_field: "total_quantity",
      metrics: [{
        avg: {}
      }, {
        max: {}
      }]
    }]
  },
  metadata: {
    test2: {
      metadata_id: "GSCm3HUBeGRB78cDQju6",
      rollup_metadata: {
        rollup_id: "test2",
        last_updated_time: 1605724690355,
        status: "failed",
        failure_reason: "Cannot create target index.",
        stats: {
          pages_processed: 0,
          documents_processed: 0,
          rollups_indexed: 0,
          index_time_in_millis: 0,
          search_time_in_millis: 0
        }
      }
    }
  }
};
exports.testRollup2 = testRollup2;
const testTransform = {
  _id: "test1",
  _seqNo: 6,
  _primaryTerm: 1,
  transform: {
    transform_id: "test1",
    schema_version: 11,
    schedule: {
      interval: {
        start_time: 1632951884470,
        period: 1,
        unit: "Minutes"
      }
    },
    metadata_id: "tFttMG7OTAehIakVVsAA-g",
    updated_at: 1632951944840,
    enabled: false,
    enabled_at: null,
    description: "",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    data_selection_query: {
      match: {
        customer_gender: {
          query: "FEMALE",
          operator: "OR",
          prefix_length: 0,
          max_expansions: 50,
          fuzzy_transpositions: true,
          lenient: false,
          zero_terms_query: "NONE",
          auto_generate_synonyms_phrase_query: true,
          boost: 1
        }
      }
    },
    target_index: "t",
    page_size: 1000,
    groups: [{
      terms: {
        source_field: "currency",
        target_field: "currency_terms"
      }
    }],
    aggregations: {}
  },
  metadata: {
    test1: {
      metadata_id: "tFttMG7OTAehIakVVsAA-g",
      transform_metadata: {
        transform_id: "test1",
        last_updated_at: 1632951944827,
        status: "finished",
        failure_reason: null,
        stats: {
          pages_processed: 2,
          documents_processed: 2433,
          documents_indexed: 1,
          index_time_in_millis: 37,
          search_time_in_millis: 11
        }
      }
    }
  }
};
exports.testTransform = testTransform;
const testTransform2 = {
  _id: "test1",
  _version: 3,
  _seqNo: 7,
  _primaryTerm: 1,
  transform: {
    transform_id: "test1",
    enabled: true,
    schedule: {
      interval: {
        period: 1,
        unit: "Minutes",
        start_time: 1602100553
      }
    },
    metadata_id: null,
    updated_at: 1619725487957,
    enabled_at: 1619725487956,
    description: "Test transform using ecommerce data",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    target_index: "test_transform",
    data_selection_query: {
      match_all: {}
    },
    page_size: 1000,
    roles: [],
    groups: [{
      terms: {
        source_field: "customer_gender",
        target_field: "gender"
      }
    }, {
      terms: {
        source_field: "day_of_week",
        target_field: "day"
      }
    }],
    aggregations: {
      quantity: {
        sum: {
          field: "total_quantity"
        }
      }
    }
  },
  metadata: {
    test1: {
      metadata_id: "GSCm3HUBeGRB78cDQju6",
      transform_metadata: {
        transform_id: "test1",
        last_updated_time: 1605724690355,
        status: "finished",
        failure_reason: null,
        stats: {
          pages_processed: 5,
          documents_processed: 4675,
          transforms_indexed: 3627,
          index_time_in_millis: 1522,
          search_time_in_millis: 1168
        }
      }
    }
  }
};
exports.testTransform2 = testTransform2;
const testTransformDisabled = {
  _id: "test1",
  _version: 3,
  _seq_no: 7,
  _primary_term: 1,
  transform: {
    transform_id: "test1",
    enabled: false,
    schedule: {
      interval: {
        period: 1,
        unit: "Minutes",
        start_time: 1602100553
      }
    },
    metadata_id: null,
    updated_at: 1619725487957,
    enabled_at: 1619725487956,
    description: "Test transform using ecommerce data",
    source_index: "opensearch_dashboards_sample_data_ecommerce",
    target_index: "test_transform",
    data_selection_query: {
      match_all: {}
    },
    page_size: 1000,
    roles: [],
    groups: [{
      terms: {
        source_field: "customer_gender",
        target_field: "gender"
      }
    }, {
      terms: {
        source_field: "day_of_week",
        target_field: "day"
      }
    }],
    aggregations: {
      quantity: {
        sum: {
          field: "total_quantity"
        }
      }
    }
  },
  metadata: {
    test1: {
      metadata_id: "GSCm3HUBeGRB78cDQju6",
      transform_metadata: {
        transform_id: "test1",
        last_updated_time: 1605724690355,
        status: "started",
        failure_reason: null,
        stats: {
          pages_processed: 5,
          documents_processed: 4675,
          transforms_indexed: 3627,
          index_time_in_millis: 1522,
          search_time_in_millis: 1168
        }
      }
    }
  }
};
exports.testTransformDisabled = testTransformDisabled;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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