/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search;

import java.util.Locale;
import lombok.Generated;
import org.apache.lucene.search.ScoreMode;

public class HitsThresholdChecker {
    private int hitCount;
    private final int totalHitsThreshold;

    public HitsThresholdChecker(int totalHitsThreshold) {
        if (totalHitsThreshold < 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "totalHitsThreshold must be >= 0, got %d", totalHitsThreshold));
        }
        if (totalHitsThreshold == Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "totalHitsThreshold must be less than max integer value", new Object[0]));
        }
        this.totalHitsThreshold = totalHitsThreshold;
    }

    protected void incrementHitCount() {
        ++this.hitCount;
    }

    protected boolean isThresholdReached() {
        return this.hitCount >= this.getTotalHitsThreshold();
    }

    protected ScoreMode scoreMode() {
        return ScoreMode.TOP_SCORES;
    }

    @Generated
    public int getTotalHitsThreshold() {
        return this.totalHitsThreshold;
    }
}

