/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.codeexplorer.task.CollectionAdapter;
import org.freeplane.plugin.codeexplorer.task.FileTypeAdapter;
import org.freeplane.plugin.codeexplorer.task.MapAdapter;
import org.freeplane.plugin.codeexplorer.task.OptionalTypeAdapter;
import org.freeplane.plugin.codeexplorer.task.UserDefinedCodeExplorerConfiguration;

public class CodeExplorerConfigurations {
    private static final String CODE_EXPLORER_CONFIGURATION_FILE_PROPERTY = "code.explorer_configuration_file";
    private List<UserDefinedCodeExplorerConfiguration> configurations;
    private static final Gson OBJECT_MAPPER = new GsonBuilder().registerTypeAdapter(File.class, (Object)new FileTypeAdapter()).registerTypeAdapterFactory(OptionalTypeAdapter.FACTORY).registerTypeHierarchyAdapter(Collection.class, (Object)new CollectionAdapter()).registerTypeHierarchyAdapter(Map.class, (Object)new MapAdapter()).setPrettyPrinting().create();
    private static final Type CONFIGURATIONS_TYPE = new TypeToken<List<UserDefinedCodeExplorerConfiguration>>(){}.getType();

    public CodeExplorerConfigurations(List<UserDefinedCodeExplorerConfiguration> configurations) {
        this.configurations = configurations;
    }

    public List<UserDefinedCodeExplorerConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<UserDefinedCodeExplorerConfiguration> configurations) {
        this.configurations = configurations;
    }

    public void saveConfiguration() {
        this.saveConfiguration(CodeExplorerConfigurations.getConfigurationFile());
    }

    private static File getConfigurationFile() {
        return ResourceController.getResourceController().getFile(CODE_EXPLORER_CONFIGURATION_FILE_PROPERTY);
    }

    void saveConfiguration(File file) {
        try (FileWriter writer = new FileWriter(file);){
            if (!this.configurations.isEmpty()) {
                OBJECT_MAPPER.toJson(this.configurations, (Appendable)writer);
            }
        }
        catch (JsonIOException | IOException e) {
            LogUtils.severe((Throwable)e);
        }
    }

    public static CodeExplorerConfigurations loadConfigurations() {
        return CodeExplorerConfigurations.loadConfigurations(CodeExplorerConfigurations.getConfigurationFile());
    }

    static CodeExplorerConfigurations loadConfigurations(File configurationFile) {
        ArrayList<UserDefinedCodeExplorerConfiguration> configurations = !configurationFile.exists() ? new ArrayList() : CodeExplorerConfigurations.fromJsonFile(configurationFile);
        return new CodeExplorerConfigurations(configurations);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<UserDefinedCodeExplorerConfiguration> fromJsonFile(File configurationFile) {
        try (FileReader reader = new FileReader(configurationFile);){
            List configurations = (List)OBJECT_MAPPER.fromJson((Reader)reader, CONFIGURATIONS_TYPE);
            if (configurations == null) return Collections.emptyList();
            configurations.forEach(UserDefinedCodeExplorerConfiguration::initialize);
            List list = configurations;
            return list;
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
        return Collections.emptyList();
    }
}

