/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PageRange {
    int beg;
    int end;
    final int m_num_pages;
    final String m_argv;

    PageRange(int num_pages, String argv) {
        this.m_num_pages = num_pages;
        this.m_argv = argv;
    }

    int parse_bound(String bound) {
        if (bound.equals("end")) {
            return this.m_num_pages;
        }
        return Integer.parseInt(bound);
    }

    void out_of_range_error(String where) {
        System.err.println("Error: Range " + where + " page number exceeds size of PDF");
        System.err.println("   here: " + this.m_argv);
        System.err.println("   input PDF has: " + this.m_num_pages + " pages.");
        System.err.println("   Exiting.");
    }

    boolean parse(StringBuilder unparsed) {
        String page_regex = "(r?)(end|[0-9]*)";
        Pattern range_regex = Pattern.compile(page_regex + "(-" + page_regex + ")?");
        Matcher m = range_regex.matcher(unparsed.toString());
        m.lookingAt();
        unparsed.delete(m.start(), m.end());
        String pre_reverse = m.group(1);
        String pre_range = m.group(2);
        String hyphen = m.group(3);
        String post_reverse = m.group(4);
        String post_range = m.group(5);
        return this.parse(pre_reverse, pre_range, post_reverse, post_range);
    }

    boolean parse(String pre_reverse, String pre_range, String post_reverse, String post_range) {
        this.beg = 0;
        if (!pre_range.isEmpty()) {
            boolean pre_reverse_b;
            this.beg = this.parse_bound(pre_range);
            if (this.m_num_pages < this.beg) {
                this.out_of_range_error("start");
                return false;
            }
            boolean bl = pre_reverse_b = !pre_reverse.isEmpty();
            if (pre_reverse_b) {
                this.beg = this.m_num_pages - this.beg + 1;
            }
        }
        this.end = this.beg;
        if (post_range != null && !post_range.isEmpty()) {
            boolean post_reverse_b;
            this.end = this.parse_bound(post_range);
            if (this.m_num_pages < this.end) {
                this.out_of_range_error("end");
                return false;
            }
            boolean bl = post_reverse_b = !post_reverse.isEmpty();
            if (post_reverse_b) {
                this.end = this.m_num_pages - this.end + 1;
            }
        }
        return true;
    }
}

