from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TopoDS import *
from OCC.Core.TopOpeBRepDS import *
from OCC.Core.TopAbs import *
from OCC.Core.TopTools import *
from OCC.Core.TopOpeBRepTool import *
from OCC.Core.gp import *
from OCC.Core.TCollection import *
from OCC.Core.TColStd import *

# the following typedef cannot be wrapped as is
TopOpeBRepBuild_IndexedDataMapOfShapeVertexInfo = NewType("TopOpeBRepBuild_IndexedDataMapOfShapeVertexInfo", Any)
TopOpeBRepBuild_PBuilder = NewType("TopOpeBRepBuild_PBuilder", TopOpeBRepBuild_Builder)
TopOpeBRepBuild_PGTopo = NewType("TopOpeBRepBuild_PGTopo", TopOpeBRepBuild_GTopo)
TopOpeBRepBuild_PWireEdgeSet = NewType("TopOpeBRepBuild_PWireEdgeSet", TopOpeBRepBuild_WireEdgeSet)

class TopOpeBRepBuild_ListOfListOfLoop:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> TopOpeBRepBuild_ListOfLoop: ...
    def Last(self) -> TopOpeBRepBuild_ListOfLoop: ...
    def Append(self, theItem: TopOpeBRepBuild_ListOfLoop) -> TopOpeBRepBuild_ListOfLoop: ...
    def Prepend(self, theItem: TopOpeBRepBuild_ListOfLoop) -> TopOpeBRepBuild_ListOfLoop: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> TopOpeBRepBuild_ListOfLoop: ...
    def SetValue(self, theIndex: int, theValue: TopOpeBRepBuild_ListOfLoop) -> None: ...

class TopOpeBRepBuild_ListOfLoop:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class TopOpeBRepBuild_ListOfPave:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> False: ...
    def Last(self) -> False: ...
    def Append(self, theItem: False) -> False: ...
    def Prepend(self, theItem: False) -> False: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> False: ...
    def SetValue(self, theIndex: int, theValue: False) -> None: ...

class TopOpeBRepBuild_ListOfShapeListOfShape:
    def __init__(self) -> None: ...
    def __len__(self) -> int: ...
    def Size(self) -> int: ...
    def Clear(self) -> None: ...
    def First(self) -> TopOpeBRepBuild_ShapeListOfShape: ...
    def Last(self) -> TopOpeBRepBuild_ShapeListOfShape: ...
    def Append(self, theItem: TopOpeBRepBuild_ShapeListOfShape) -> TopOpeBRepBuild_ShapeListOfShape: ...
    def Prepend(self, theItem: TopOpeBRepBuild_ShapeListOfShape) -> TopOpeBRepBuild_ShapeListOfShape: ...
    def RemoveFirst(self) -> None: ...
    def Reverse(self) -> None: ...
    def Value(self, theIndex: int) -> TopOpeBRepBuild_ShapeListOfShape: ...
    def SetValue(self, theIndex: int, theValue: TopOpeBRepBuild_ShapeListOfShape) -> None: ...

class TopOpeBRepBuild_LoopEnum(IntEnum):
    TopOpeBRepBuild_ANYLOOP: int = ...
    TopOpeBRepBuild_BOUNDARY: int = ...
    TopOpeBRepBuild_BLOCK: int = ...

TopOpeBRepBuild_ANYLOOP = TopOpeBRepBuild_LoopEnum.TopOpeBRepBuild_ANYLOOP
TopOpeBRepBuild_BOUNDARY = TopOpeBRepBuild_LoopEnum.TopOpeBRepBuild_BOUNDARY
TopOpeBRepBuild_BLOCK = TopOpeBRepBuild_LoopEnum.TopOpeBRepBuild_BLOCK

class TopOpeBRepBuild_AreaBuilder:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, LS: TopOpeBRepBuild_LoopSet, LC: TopOpeBRepBuild_LoopClassifier, ForceClass: Optional[bool] = False) -> None: ...
    def ADD_LISTOFLoop_TO_LISTOFLoop(self, LOL1: TopOpeBRepBuild_ListOfLoop, LOL2: TopOpeBRepBuild_ListOfLoop, s: Optional[None] = None, s1: Optional[None] = None, s2: Optional[None] = None) -> None: ...
    def ADD_Loop_TO_LISTOFLoop(self, L: TopOpeBRepBuild_Loop, LOL: TopOpeBRepBuild_ListOfLoop, s: Optional[None] = None) -> None: ...
    def InitArea(self) -> int: ...
    def InitAreaBuilder(self, LS: TopOpeBRepBuild_LoopSet, LC: TopOpeBRepBuild_LoopClassifier, ForceClass: Optional[bool] = False) -> None: ...
    def InitLoop(self) -> int: ...
    def Loop(self) -> TopOpeBRepBuild_Loop: ...
    def MoreArea(self) -> bool: ...
    def MoreLoop(self) -> bool: ...
    def NextArea(self) -> None: ...
    def NextLoop(self) -> None: ...
    def REM_Loop_FROM_LISTOFLoop(self, ITLOL: TopOpeBRepBuild_ListIteratorOfListOfLoop, LOL: TopOpeBRepBuild_ListOfLoop, s: Optional[None] = None) -> None: ...

class TopOpeBRepBuild_BlockBuilder:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, SS: TopOpeBRepBuild_ShapeSet) -> None: ...
    def AddElement(self, S: TopoDS_Shape) -> int: ...
    def BlockIterator(self) -> TopOpeBRepBuild_BlockIterator: ...
    def CurrentBlockIsRegular(self) -> bool: ...
    @overload
    def Element(self, BI: TopOpeBRepBuild_BlockIterator) -> TopoDS_Shape: ...
    @overload
    def Element(self, I: int) -> TopoDS_Shape: ...
    @overload
    def Element(self, S: TopoDS_Shape) -> int: ...
    @overload
    def ElementIsValid(self, BI: TopOpeBRepBuild_BlockIterator) -> bool: ...
    @overload
    def ElementIsValid(self, I: int) -> bool: ...
    def InitBlock(self) -> None: ...
    def MakeBlock(self, SS: TopOpeBRepBuild_ShapeSet) -> None: ...
    def MoreBlock(self) -> bool: ...
    def NextBlock(self) -> None: ...
    @overload
    def SetValid(self, BI: TopOpeBRepBuild_BlockIterator, isvalid: bool) -> None: ...
    @overload
    def SetValid(self, I: int, isvalid: bool) -> None: ...

class TopOpeBRepBuild_BlockIterator:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Lower: int, Upper: int) -> None: ...
    def Extent(self) -> int: ...
    def Initialize(self) -> None: ...
    def More(self) -> bool: ...
    def Next(self) -> None: ...
    def Value(self) -> int: ...

class TopOpeBRepBuild_Builder:
    def __init__(self, BT: TopOpeBRepDS_BuildTool) -> None: ...
    def AddONPatchesSFS(self, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    def BuildEdges(self, DS: TopOpeBRepDS_HDataStructure) -> None: ...
    def BuildTool(self) -> TopOpeBRepDS_BuildTool: ...
    def BuildVertices(self, DS: TopOpeBRepDS_HDataStructure) -> None: ...
    def ChangeBuildTool(self) -> TopOpeBRepDS_BuildTool: ...
    def ChangeClassify(self, B: bool) -> None: ...
    def ChangeMSplit(self, s: TopAbs_State) -> TopOpeBRepDS_DataMapOfShapeListOfShapeOn1State: ...
    def ChangeSplit(self, S: TopoDS_Shape, TB: TopAbs_State) -> TopTools_ListOfShape: ...
    def Classify(self) -> bool: ...
    def Clear(self) -> None: ...
    def ClearMaps(self) -> None: ...
    @staticmethod
    def Contains(S: TopoDS_Shape, L: TopTools_ListOfShape) -> bool: ...
    def DataStructure(self) -> TopOpeBRepDS_HDataStructure: ...
    def End(self) -> None: ...
    def FillOnPatches(self, anEdgesON: TopTools_ListOfShape, aBaseFace: TopoDS_Shape, avoidMap: TopTools_IndexedMapOfOrientedShape) -> None: ...
    def FillSecEdgeAncestorMap(self, aShapeRank: int, aMapON: TopTools_MapOfShape, anAncMap: TopTools_DataMapOfShapeShape) -> None: ...
    def FindFacesTouchingEdge(self, aFace: TopoDS_Shape, anEdge: TopoDS_Shape, aShRank: int, aFaces: TopTools_ListOfShape) -> None: ...
    def FindIsKPart(self) -> int: ...
    def FindSameDomain(self, L1: TopTools_ListOfShape, L2: TopTools_ListOfShape) -> None: ...
    def FindSameDomainSameOrientation(self, LSO: TopTools_ListOfShape, LDO: TopTools_ListOfShape) -> None: ...
    def FindSameRank(self, L1: TopTools_ListOfShape, R: int, L2: TopTools_ListOfShape) -> None: ...
    def GClearMaps(self) -> None: ...
    @staticmethod
    def GContains(S: TopoDS_Shape, L: TopTools_ListOfShape) -> bool: ...
    @overload
    @staticmethod
    def GCopyList(Lin: TopTools_ListOfShape, i1: int, i2: int, Lou: TopTools_ListOfShape) -> None: ...
    @overload
    @staticmethod
    def GCopyList(Lin: TopTools_ListOfShape, Lou: TopTools_ListOfShape) -> None: ...
    def GEDBUMakeEdges(self, EF: TopoDS_Shape, EDBU: TopOpeBRepBuild_EdgeBuilder, LOE: TopTools_ListOfShape) -> None: ...
    def GFABUMakeFaces(self, FF: TopoDS_Shape, FABU: TopOpeBRepBuild_FaceBuilder, LOF: TopTools_ListOfShape, MWisOld: TopTools_DataMapOfShapeInteger) -> None: ...
    @overload
    def GFillCurveTopologyWES(self, F: TopoDS_Shape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    @overload
    def GFillCurveTopologyWES(self, IT: TopOpeBRepDS_CurveIterator, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def GFillEdgePVS(self, E: TopoDS_Shape, LE2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, PVS: TopOpeBRepBuild_PaveSet) -> None: ...
    def GFillEdgeWES(self, E: TopoDS_Shape, LF2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def GFillEdgesPVS(self, LE1: TopTools_ListOfShape, LE2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, PVS: TopOpeBRepBuild_PaveSet) -> None: ...
    def GFillFaceSFS(self, F1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    def GFillFaceWES(self, F: TopoDS_Shape, LF2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def GFillFacesWES(self, LF1: TopTools_ListOfShape, LF2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def GFillFacesWESK(self, LF1: TopTools_ListOfShape, LF2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet, K: int) -> None: ...
    def GFillFacesWESMakeFaces(self, LF1: TopTools_ListOfShape, LF2: TopTools_ListOfShape, LSO: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo) -> None: ...
    def GFillONPartsWES(self, F: TopoDS_Shape, G: TopOpeBRepBuild_GTopo, LSclass: TopTools_ListOfShape, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    @overload
    def GFillPointTopologyPVS(self, E: TopoDS_Shape, G: TopOpeBRepBuild_GTopo, PVS: TopOpeBRepBuild_PaveSet) -> None: ...
    @overload
    def GFillPointTopologyPVS(self, E: TopoDS_Shape, IT: TopOpeBRepDS_PointIterator, G: TopOpeBRepBuild_GTopo, PVS: TopOpeBRepBuild_PaveSet) -> None: ...
    def GFillShellSFS(self, SH1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    def GFillSolidSFS(self, SO1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    def GFillSolidsSFS(self, LSO1: TopTools_ListOfShape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    @overload
    def GFillSurfaceTopologySFS(self, SO1: TopoDS_Shape, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    @overload
    def GFillSurfaceTopologySFS(self, IT: TopOpeBRepDS_SurfaceIterator, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    def GFillWireWES(self, W: TopoDS_Shape, LF2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    @overload
    def GFindSamDom(self, S: TopoDS_Shape, L1: TopTools_ListOfShape, L2: TopTools_ListOfShape) -> None: ...
    @overload
    def GFindSamDom(self, L1: TopTools_ListOfShape, L2: TopTools_ListOfShape) -> None: ...
    @overload
    def GFindSamDomSODO(self, S: TopoDS_Shape, LSO: TopTools_ListOfShape, LDO: TopTools_ListOfShape) -> None: ...
    @overload
    def GFindSamDomSODO(self, LSO: TopTools_ListOfShape, LDO: TopTools_ListOfShape) -> None: ...
    def GFindSameRank(self, L1: TopTools_ListOfShape, R: int, L2: TopTools_ListOfShape) -> None: ...
    def GIsShapeOf(self, S: TopoDS_Shape, I12: int) -> bool: ...
    def GKeepShape(self, S: TopoDS_Shape, Lref: TopTools_ListOfShape, T: TopAbs_State) -> bool: ...
    def GKeepShape1(self, S: TopoDS_Shape, Lref: TopTools_ListOfShape, T: TopAbs_State, pos: TopAbs_State) -> bool: ...
    def GKeepShapes(self, S: TopoDS_Shape, Lref: TopTools_ListOfShape, T: TopAbs_State, Lin: TopTools_ListOfShape, Lou: TopTools_ListOfShape) -> None: ...
    def GMapShapes(self, S1: TopoDS_Shape, S2: TopoDS_Shape) -> None: ...
    def GMergeEdgeWES(self, E: TopoDS_Shape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def GMergeEdges(self, LE1: TopTools_ListOfShape, LE2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo) -> None: ...
    def GMergeFaceSFS(self, F: TopoDS_Shape, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    def GMergeFaces(self, LF1: TopTools_ListOfShape, LF2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo) -> None: ...
    def GMergeSolids(self, LSO1: TopTools_ListOfShape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo) -> None: ...
    def GPVSMakeEdges(self, EF: TopoDS_Shape, PVS: TopOpeBRepBuild_PaveSet, LOE: TopTools_ListOfShape) -> None: ...
    def GParamOnReference(self, V: TopoDS_Vertex, E: TopoDS_Edge) -> Tuple[bool, float]: ...
    def GSFSMakeSolids(self, SOF: TopoDS_Shape, SFS: TopOpeBRepBuild_ShellFaceSet, LOSO: TopTools_ListOfShape) -> None: ...
    def GSOBUMakeSolids(self, SOF: TopoDS_Shape, SOBU: TopOpeBRepBuild_SolidBuilder, LOSO: TopTools_ListOfShape) -> None: ...
    def GShapeRank(self, S: TopoDS_Shape) -> int: ...
    def GSplitEdge(self, E: TopoDS_Shape, G: TopOpeBRepBuild_GTopo, LSclass: TopTools_ListOfShape) -> None: ...
    def GSplitEdgeWES(self, E: TopoDS_Shape, LF2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def GSplitFace(self, F: TopoDS_Shape, G: TopOpeBRepBuild_GTopo, LSclass: TopTools_ListOfShape) -> None: ...
    def GSplitFaceSFS(self, F1: TopoDS_Shape, LSclass: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    @staticmethod
    def GTakeCommonOfDiff(G: TopOpeBRepBuild_GTopo) -> bool: ...
    @staticmethod
    def GTakeCommonOfSame(G: TopOpeBRepBuild_GTopo) -> bool: ...
    def GToMerge(self, S: TopoDS_Shape) -> bool: ...
    def GToSplit(self, S: TopoDS_Shape, TB: TopAbs_State) -> bool: ...
    def GWESMakeFaces(self, FF: TopoDS_Shape, WES: TopOpeBRepBuild_WireEdgeSet, LOF: TopTools_ListOfShape) -> None: ...
    @staticmethod
    def GcheckNBOUNDS(E: TopoDS_Shape) -> bool: ...
    def GdumpEDBU(self, EB: TopOpeBRepBuild_EdgeBuilder) -> None: ...
    def GdumpEDG(self, S: TopoDS_Shape, str: Optional[None] = None) -> None: ...
    def GdumpEDGVER(self, E: TopoDS_Shape, V: TopoDS_Shape, str: Optional[None] = None) -> None: ...
    def GdumpEXP(self, E: TopOpeBRepTool_ShapeExplorer) -> None: ...
    def GdumpFABU(self, FB: TopOpeBRepBuild_FaceBuilder) -> None: ...
    def GdumpLS(self, L: TopTools_ListOfShape) -> None: ...
    @staticmethod
    def GdumpORIPARPNT(o: TopAbs_Orientation, p: float, Pnt: gp_Pnt) -> None: ...
    @staticmethod
    def GdumpPNT(P: gp_Pnt) -> None: ...
    def GdumpSAMDOM(self, L: TopTools_ListOfShape, str: Optional[None] = None) -> None: ...
    def GdumpSHA(self, S: TopoDS_Shape, str: Optional[None] = None) -> None: ...
    def GdumpSHAORI(self, S: TopoDS_Shape, str: Optional[None] = None) -> None: ...
    def GdumpSHAORIGEO(self, S: TopoDS_Shape, str: Optional[None] = None) -> None: ...
    def GdumpSHASETindex(self) -> int: ...
    def GdumpSHASETreset(self) -> None: ...
    @overload
    def GdumpSHASTA(self, iS: int, T: TopAbs_State, a: Optional[str] = "", b: Optional[str] = "") -> None: ...
    @overload
    def GdumpSHASTA(self, S: TopoDS_Shape, T: TopAbs_State, a: Optional[str] = "", b: Optional[str] = "") -> None: ...
    @overload
    def GdumpSHASTA(self, iS: int, T: TopAbs_State, SS: TopOpeBRepBuild_ShapeSet, a: Optional[str] = "", b: Optional[str] = "", c: Optional[str] = "\n") -> None: ...
    def GdumpSOBU(self, SB: TopOpeBRepBuild_SolidBuilder) -> None: ...
    @overload
    def GtraceSPS(self, iS: int) -> bool: ...
    @overload
    def GtraceSPS(self, iS: int, jS: int) -> bool: ...
    @overload
    def GtraceSPS(self, S: TopoDS_Shape) -> bool: ...
    @overload
    def GtraceSPS(self, S: TopoDS_Shape) -> Tuple[bool, int]: ...
    def InitSection(self) -> None: ...
    def IsKPart(self) -> int: ...
    def IsMerged(self, S: TopoDS_Shape, TB: TopAbs_State) -> bool: ...
    def IsShapeOf(self, S: TopoDS_Shape, I12: int) -> bool: ...
    def IsSplit(self, S: TopoDS_Shape, TB: TopAbs_State) -> bool: ...
    def KPClearMaps(self) -> None: ...
    @staticmethod
    def KPContains(S: TopoDS_Shape, L: TopTools_ListOfShape) -> bool: ...
    def KPSameDomain(self, L1: TopTools_ListOfShape, L2: TopTools_ListOfShape) -> None: ...
    @overload
    def KPclasSS(self, S1: TopoDS_Shape, exceptLS1: TopTools_ListOfShape, S2: TopoDS_Shape) -> TopAbs_State: ...
    @overload
    def KPclasSS(self, S1: TopoDS_Shape, exceptS1: TopoDS_Shape, S2: TopoDS_Shape) -> TopAbs_State: ...
    @overload
    def KPclasSS(self, S1: TopoDS_Shape, S2: TopoDS_Shape) -> TopAbs_State: ...
    def KPclassF(self, F1: TopoDS_Shape, F2: TopoDS_Shape) -> TopAbs_State: ...
    def KPclassFF(self, F1: TopoDS_Shape, F2: TopoDS_Shape, T1: TopAbs_State, T2: TopAbs_State) -> None: ...
    def KPisdisj(self) -> int: ...
    def KPisdisjanalyse(self, ST1: TopAbs_State, ST2: TopAbs_State) -> Tuple[int, int, int]: ...
    def KPisdisjsh(self, S: TopoDS_Shape) -> int: ...
    def KPisfafa(self) -> int: ...
    def KPisfafash(self, S: TopoDS_Shape) -> int: ...
    def KPiskole(self) -> int: ...
    def KPiskoleFF(self, F1: TopoDS_Shape, F2: TopoDS_Shape, T1: TopAbs_State, T2: TopAbs_State) -> bool: ...
    def KPiskoleanalyse(self, FT1: TopAbs_State, FT2: TopAbs_State, ST1: TopAbs_State, ST2: TopAbs_State) -> Tuple[int, int, int]: ...
    def KPiskolesh(self, S: TopoDS_Shape, LS: TopTools_ListOfShape, LF: TopTools_ListOfShape) -> bool: ...
    def KPiskoletge(self) -> int: ...
    def KPiskoletgeanalyse(self, Conf: TopOpeBRepDS_Config, ST1: TopAbs_State, ST2: TopAbs_State) -> int: ...
    def KPiskoletgesh(self, S: TopoDS_Shape, LS: TopTools_ListOfShape, LF: TopTools_ListOfShape) -> bool: ...
    def KPissoso(self) -> int: ...
    def KPissososh(self, S: TopoDS_Shape) -> int: ...
    @overload
    def KPlhg(self, S: TopoDS_Shape, T: TopAbs_ShapeEnum, L: TopTools_ListOfShape) -> int: ...
    @overload
    def KPlhg(self, S: TopoDS_Shape, T: TopAbs_ShapeEnum) -> int: ...
    @overload
    def KPlhsd(self, S: TopoDS_Shape, T: TopAbs_ShapeEnum, L: TopTools_ListOfShape) -> int: ...
    @overload
    def KPlhsd(self, S: TopoDS_Shape, T: TopAbs_ShapeEnum) -> int: ...
    @overload
    @staticmethod
    def KPls(S: TopoDS_Shape, T: TopAbs_ShapeEnum, L: TopTools_ListOfShape) -> int: ...
    @overload
    @staticmethod
    def KPls(S: TopoDS_Shape, T: TopAbs_ShapeEnum) -> int: ...
    def KPmakeface(self, F1: TopoDS_Shape, LF2: TopTools_ListOfShape, T1: TopAbs_State, T2: TopAbs_State, R1: bool, R2: bool) -> TopoDS_Shape: ...
    @staticmethod
    def KPreturn(KP: int) -> int: ...
    def KeepShape(self, S: TopoDS_Shape, LS: TopTools_ListOfShape, T: TopAbs_State) -> bool: ...
    def MSplit(self, s: TopAbs_State) -> TopOpeBRepDS_DataMapOfShapeListOfShapeOn1State: ...
    def MakeEdges(self, E: TopoDS_Shape, B: TopOpeBRepBuild_EdgeBuilder, L: TopTools_ListOfShape) -> None: ...
    def MakeFaces(self, F: TopoDS_Shape, B: TopOpeBRepBuild_FaceBuilder, L: TopTools_ListOfShape) -> None: ...
    def MakeShells(self, B: TopOpeBRepBuild_SolidBuilder, L: TopTools_ListOfShape) -> None: ...
    def MakeSolids(self, B: TopOpeBRepBuild_SolidBuilder, L: TopTools_ListOfShape) -> None: ...
    def MapShapes(self, S1: TopoDS_Shape, S2: TopoDS_Shape) -> None: ...
    def MergeEdges(self, L1: TopTools_ListOfShape, TB1: TopAbs_State, L2: TopTools_ListOfShape, TB2: TopAbs_State, onA: Optional[bool] = False, onB: Optional[bool] = False, onAB: Optional[bool] = False) -> None: ...
    def MergeFaces(self, S1: TopTools_ListOfShape, TB1: TopAbs_State, S2: TopTools_ListOfShape, TB2: TopAbs_State, onA: Optional[bool] = False, onB: Optional[bool] = False, onAB: Optional[bool] = False) -> None: ...
    @overload
    def MergeKPart(self) -> None: ...
    @overload
    def MergeKPart(self, TB1: TopAbs_State, TB2: TopAbs_State) -> None: ...
    def MergeKPartisdisj(self) -> None: ...
    def MergeKPartisfafa(self) -> None: ...
    def MergeKPartiskole(self) -> None: ...
    def MergeKPartiskoletge(self) -> None: ...
    def MergeKPartissoso(self) -> None: ...
    def MergeShapes(self, S1: TopoDS_Shape, TB1: TopAbs_State, S2: TopoDS_Shape, TB2: TopAbs_State) -> None: ...
    def MergeSolid(self, S: TopoDS_Shape, TB: TopAbs_State) -> None: ...
    def MergeSolids(self, S1: TopoDS_Shape, TB1: TopAbs_State, S2: TopoDS_Shape, TB2: TopAbs_State) -> None: ...
    def Merged(self, S: TopoDS_Shape, TB: TopAbs_State) -> TopTools_ListOfShape: ...
    def NewEdges(self, I: int) -> TopTools_ListOfShape: ...
    def NewFaces(self, I: int) -> TopTools_ListOfShape: ...
    def NewVertex(self, I: int) -> TopoDS_Shape: ...
    def Opec12(self) -> bool: ...
    def Opec21(self) -> bool: ...
    def Opecom(self) -> bool: ...
    def Opefus(self) -> bool: ...
    @staticmethod
    def Orient(O: TopAbs_Orientation, R: bool) -> TopAbs_Orientation: ...
    @overload
    def Perform(self, HDS: TopOpeBRepDS_HDataStructure) -> None: ...
    @overload
    def Perform(self, HDS: TopOpeBRepDS_HDataStructure, S1: TopoDS_Shape, S2: TopoDS_Shape) -> None: ...
    @staticmethod
    def PrintCur(E: TopoDS_Edge) -> None: ...
    @staticmethod
    def PrintGeo(S: TopoDS_Shape) -> None: ...
    @staticmethod
    def PrintOri(S: TopoDS_Shape) -> None: ...
    @staticmethod
    def PrintPnt(V: TopoDS_Vertex) -> None: ...
    @staticmethod
    def PrintSur(F: TopoDS_Face) -> None: ...
    def RegularizeFace(self, FF: TopoDS_Shape, newFace: TopoDS_Shape, LOF: TopTools_ListOfShape) -> None: ...
    def RegularizeFaces(self, FF: TopoDS_Shape, lnewFace: TopTools_ListOfShape, LOF: TopTools_ListOfShape) -> None: ...
    def RegularizeSolid(self, SS: TopoDS_Shape, newSolid: TopoDS_Shape, LOS: TopTools_ListOfShape) -> None: ...
    def RegularizeSolids(self, SS: TopoDS_Shape, lnewSolid: TopTools_ListOfShape, LOS: TopTools_ListOfShape) -> None: ...
    @staticmethod
    def Reverse(T1: TopAbs_State, T2: TopAbs_State) -> bool: ...
    @overload
    def Section(self, L: TopTools_ListOfShape) -> None: ...
    @overload
    def Section(self) -> TopTools_ListOfShape: ...
    def SectionCurves(self, L: TopTools_ListOfShape) -> None: ...
    def SectionEdges(self, L: TopTools_ListOfShape) -> None: ...
    def ShapePosition(self, S: TopoDS_Shape, LS: TopTools_ListOfShape) -> TopAbs_State: ...
    def ShapeRank(self, S: TopoDS_Shape) -> int: ...
    def SplitEvisoONperiodicF(self) -> None: ...
    def SplitSectionEdge(self, E: TopoDS_Shape) -> None: ...
    def SplitSectionEdges(self) -> None: ...
    def Splits(self, S: TopoDS_Shape, TB: TopAbs_State) -> TopTools_ListOfShape: ...
    @staticmethod
    def StringState(S: TopAbs_State) -> str: ...
    @staticmethod
    def TopType(S: TopoDS_Shape) -> TopAbs_ShapeEnum: ...

class TopOpeBRepBuild_BuilderON:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, PB: TopOpeBRepBuild_PBuilder, F: TopoDS_Shape, PG: TopOpeBRepBuild_PGTopo, PLSclass: TopOpeBRepTool_Plos, PWES: TopOpeBRepBuild_PWireEdgeSet) -> None: ...
    def GFillONCheckI(self, I: TopOpeBRepDS_Interference) -> bool: ...
    def GFillONParts2dWES2(self, I: TopOpeBRepDS_Interference, EspON: TopoDS_Shape) -> None: ...
    def GFillONPartsWES1(self, I: TopOpeBRepDS_Interference) -> None: ...
    def GFillONPartsWES2(self, I: TopOpeBRepDS_Interference, EspON: TopoDS_Shape) -> None: ...
    def Perform(self, PB: TopOpeBRepBuild_PBuilder, F: TopoDS_Shape, PG: TopOpeBRepBuild_PGTopo, PLSclass: TopOpeBRepTool_Plos, PWES: TopOpeBRepBuild_PWireEdgeSet) -> None: ...
    def Perform2d(self, PB: TopOpeBRepBuild_PBuilder, F: TopoDS_Shape, PG: TopOpeBRepBuild_PGTopo, PLSclass: TopOpeBRepTool_Plos, PWES: TopOpeBRepBuild_PWireEdgeSet) -> None: ...

class TopOpeBRepBuild_CorrectFace2d:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, aFace: TopoDS_Face, anAvoidMap: TopTools_IndexedMapOfOrientedShape, aMap: TopTools_IndexedDataMapOfShapeShape) -> None: ...
    @staticmethod
    def CheckList(aFace: TopoDS_Face, aHeadList: TopTools_ListOfShape) -> None: ...
    def CorrectedFace(self) -> TopoDS_Face: ...
    def ErrorStatus(self) -> int: ...
    def Face(self) -> TopoDS_Face: ...
    @staticmethod
    def GetP2dFL(aFace: TopoDS_Face, anEdge: TopoDS_Edge, P2dF: gp_Pnt2d, P2dL: gp_Pnt2d) -> None: ...
    def IsDone(self) -> bool: ...
    def MapOfTrans2dInfo(self) -> TopTools_IndexedDataMapOfShapeShape: ...
    def Perform(self) -> None: ...
    def SetMapOfTrans2dInfo(self, aMap: TopTools_IndexedDataMapOfShapeShape) -> None: ...

class TopOpeBRepBuild_FaceBuilder:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, ES: TopOpeBRepBuild_WireEdgeSet, F: TopoDS_Shape, ForceClass: Optional[bool] = False) -> None: ...
    def AddEdgeWire(self, E: TopoDS_Shape, W: TopoDS_Shape) -> int: ...
    def CorrectGclosedWire(self, mapVVref: TopTools_IndexedDataMapOfShapeShape, mapVon1Edge: TopTools_IndexedDataMapOfShapeShape) -> None: ...
    def DetectPseudoInternalEdge(self, mapE: TopTools_IndexedMapOfShape) -> None: ...
    def DetectUnclosedWire(self, mapVVsameG: TopTools_IndexedDataMapOfShapeShape, mapVon1Edge: TopTools_IndexedDataMapOfShapeShape) -> None: ...
    def Edge(self) -> TopoDS_Shape: ...
    def EdgeConnexity(self, E: TopoDS_Shape) -> int: ...
    def Face(self) -> TopoDS_Shape: ...
    def FindNextValidElement(self) -> None: ...
    def InitEdge(self) -> int: ...
    def InitFace(self) -> int: ...
    def InitFaceBuilder(self, ES: TopOpeBRepBuild_WireEdgeSet, F: TopoDS_Shape, ForceClass: bool) -> None: ...
    def InitWire(self) -> int: ...
    def IsOldWire(self) -> bool: ...
    def MoreEdge(self) -> bool: ...
    def MoreFace(self) -> bool: ...
    def MoreWire(self) -> bool: ...
    def NextEdge(self) -> None: ...
    def NextFace(self) -> None: ...
    def NextWire(self) -> None: ...
    def OldWire(self) -> TopoDS_Shape: ...

class TopOpeBRepBuild_FuseFace:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, LIF: TopTools_ListOfShape, LRF: TopTools_ListOfShape, CXM: int) -> None: ...
    def ClearEdge(self) -> None: ...
    def ClearVertex(self) -> None: ...
    def Init(self, LIF: TopTools_ListOfShape, LRF: TopTools_ListOfShape, CXM: int) -> None: ...
    def IsDone(self) -> bool: ...
    def IsModified(self) -> bool: ...
    def LExternEdge(self) -> TopTools_ListOfShape: ...
    def LExternVertex(self) -> TopTools_ListOfShape: ...
    def LFuseFace(self) -> TopTools_ListOfShape: ...
    def LInternEdge(self) -> TopTools_ListOfShape: ...
    def LInternVertex(self) -> TopTools_ListOfShape: ...
    def LModifEdge(self) -> TopTools_ListOfShape: ...
    def LModifVertex(self) -> TopTools_ListOfShape: ...
    def PerformEdge(self) -> None: ...
    def PerformFace(self) -> None: ...

class TopOpeBRepBuild_GIter:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, G: TopOpeBRepBuild_GTopo) -> None: ...
    def Current(self, s1: TopAbs_State, s2: TopAbs_State) -> None: ...
    @overload
    def Init(self) -> None: ...
    @overload
    def Init(self, G: TopOpeBRepBuild_GTopo) -> None: ...
    def More(self) -> bool: ...
    def Next(self) -> None: ...

class TopOpeBRepBuild_GTool:
    @staticmethod
    def GComDiff(s1: TopAbs_ShapeEnum, s2: TopAbs_ShapeEnum) -> TopOpeBRepBuild_GTopo: ...
    @staticmethod
    def GComSame(s1: TopAbs_ShapeEnum, s2: TopAbs_ShapeEnum) -> TopOpeBRepBuild_GTopo: ...
    @staticmethod
    def GComUnsh(s1: TopAbs_ShapeEnum, s2: TopAbs_ShapeEnum) -> TopOpeBRepBuild_GTopo: ...
    @staticmethod
    def GCutDiff(s1: TopAbs_ShapeEnum, s2: TopAbs_ShapeEnum) -> TopOpeBRepBuild_GTopo: ...
    @staticmethod
    def GCutSame(s1: TopAbs_ShapeEnum, s2: TopAbs_ShapeEnum) -> TopOpeBRepBuild_GTopo: ...
    @staticmethod
    def GCutUnsh(s1: TopAbs_ShapeEnum, s2: TopAbs_ShapeEnum) -> TopOpeBRepBuild_GTopo: ...
    @staticmethod
    def GFusDiff(s1: TopAbs_ShapeEnum, s2: TopAbs_ShapeEnum) -> TopOpeBRepBuild_GTopo: ...
    @staticmethod
    def GFusSame(s1: TopAbs_ShapeEnum, s2: TopAbs_ShapeEnum) -> TopOpeBRepBuild_GTopo: ...
    @staticmethod
    def GFusUnsh(s1: TopAbs_ShapeEnum, s2: TopAbs_ShapeEnum) -> TopOpeBRepBuild_GTopo: ...

class TopOpeBRepBuild_GTopo:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, II: bool, IN: bool, IO: bool, NI: bool, NN: bool, NO: bool, OI: bool, ON: bool, OO: bool, t1: TopAbs_ShapeEnum, t2: TopAbs_ShapeEnum, C1: TopOpeBRepDS_Config, C2: TopOpeBRepDS_Config) -> None: ...
    def ChangeConfig(self, C1: TopOpeBRepDS_Config, C2: TopOpeBRepDS_Config) -> None: ...
    def ChangeType(self, t1: TopAbs_ShapeEnum, t2: TopAbs_ShapeEnum) -> None: ...
    @overload
    def ChangeValue(self, i1: int, i2: int, b: bool) -> None: ...
    @overload
    def ChangeValue(self, s1: TopAbs_State, s2: TopAbs_State, b: bool) -> None: ...
    def Config1(self) -> TopOpeBRepDS_Config: ...
    def Config2(self) -> TopOpeBRepDS_Config: ...
    def CopyPermuted(self) -> TopOpeBRepBuild_GTopo: ...
    def GIndex(self, S: TopAbs_State) -> int: ...
    def GState(self, I: int) -> TopAbs_State: ...
    def Index(self, II: int) -> Tuple[int, int]: ...
    def IsToReverse1(self) -> bool: ...
    def IsToReverse2(self) -> bool: ...
    def Reset(self) -> None: ...
    def Reverse(self) -> bool: ...
    def Set(self, II: bool, IN: bool, IO: bool, NI: bool, NN: bool, NO: bool, OI: bool, ON: bool, OO: bool) -> None: ...
    def SetReverse(self, rev: bool) -> None: ...
    def StatesON(self, s1: TopAbs_State, s2: TopAbs_State) -> None: ...
    def Type(self, t1: TopAbs_ShapeEnum, t2: TopAbs_ShapeEnum) -> None: ...
    @overload
    def Value(self, s1: TopAbs_State, s2: TopAbs_State) -> bool: ...
    @overload
    def Value(self, I1: int, I2: int) -> bool: ...
    @overload
    def Value(self, II: int) -> bool: ...

class TopOpeBRepBuild_HBuilder(Standard_Transient):
    def __init__(self, BT: TopOpeBRepDS_BuildTool) -> None: ...
    def BuildTool(self) -> TopOpeBRepDS_BuildTool: ...
    def ChangeBuildTool(self) -> TopOpeBRepDS_BuildTool: ...
    def ChangeBuilder(self) -> TopOpeBRepBuild_Builder: ...
    def ChangeNewEdges(self, I: int) -> TopTools_ListOfShape: ...
    def Clear(self) -> None: ...
    def CurrentSection(self) -> TopoDS_Shape: ...
    def DataStructure(self) -> TopOpeBRepDS_HDataStructure: ...
    def EdgeCurveAncestors(self, E: TopoDS_Shape, F1: TopoDS_Shape, F2: TopoDS_Shape) -> Tuple[bool, int]: ...
    def EdgeSectionAncestors(self, E: TopoDS_Shape, LF1: TopTools_ListOfShape, LF2: TopTools_ListOfShape, LE1: TopTools_ListOfShape, LE2: TopTools_ListOfShape) -> bool: ...
    def GetDSCurveFromSectEdge(self, SectEdge: TopoDS_Shape) -> int: ...
    def GetDSEdgeFromSectEdge(self, E: TopoDS_Shape, rank: int) -> int: ...
    def GetDSFaceFromDSCurve(self, indexCur: int, rank: int) -> int: ...
    def GetDSFaceFromDSEdge(self, indexEdg: int, rank: int) -> TColStd_ListOfInteger: ...
    def GetDSPointFromNewVertex(self, NewVert: TopoDS_Shape) -> int: ...
    def InitExtendedSectionDS(self, k: Optional[int] = 3) -> None: ...
    def InitSection(self, k: Optional[int] = 3) -> None: ...
    def IsKPart(self) -> int: ...
    def IsMerged(self, S: TopoDS_Shape, ToBuild: TopAbs_State) -> bool: ...
    def IsSplit(self, S: TopoDS_Shape, ToBuild: TopAbs_State) -> bool: ...
    def MergeKPart(self, TB1: TopAbs_State, TB2: TopAbs_State) -> None: ...
    def MergeShapes(self, S1: TopoDS_Shape, TB1: TopAbs_State, S2: TopoDS_Shape, TB2: TopAbs_State) -> None: ...
    def MergeSolid(self, S: TopoDS_Shape, TB: TopAbs_State) -> None: ...
    def MergeSolids(self, S1: TopoDS_Shape, TB1: TopAbs_State, S2: TopoDS_Shape, TB2: TopAbs_State) -> None: ...
    def Merged(self, S: TopoDS_Shape, ToBuild: TopAbs_State) -> TopTools_ListOfShape: ...
    def MoreSection(self) -> bool: ...
    def NewEdges(self, I: int) -> TopTools_ListOfShape: ...
    def NewFaces(self, I: int) -> TopTools_ListOfShape: ...
    def NewVertex(self, I: int) -> TopoDS_Shape: ...
    def NextSection(self) -> None: ...
    @overload
    def Perform(self, HDS: TopOpeBRepDS_HDataStructure) -> None: ...
    @overload
    def Perform(self, HDS: TopOpeBRepDS_HDataStructure, S1: TopoDS_Shape, S2: TopoDS_Shape) -> None: ...
    def Section(self) -> TopTools_ListOfShape: ...
    def Splits(self, S: TopoDS_Shape, ToBuild: TopAbs_State) -> TopTools_ListOfShape: ...

class TopOpeBRepBuild_Loop(Standard_Transient):
    @overload
    def __init__(self, S: TopoDS_Shape) -> None: ...
    @overload
    def __init__(self, BI: TopOpeBRepBuild_BlockIterator) -> None: ...
    def BlockIterator(self) -> TopOpeBRepBuild_BlockIterator: ...
    def Dump(self) -> None: ...
    def IsShape(self) -> bool: ...
    def Shape(self) -> TopoDS_Shape: ...

class TopOpeBRepBuild_LoopClassifier:
    def Compare(self, L1: TopOpeBRepBuild_Loop, L2: TopOpeBRepBuild_Loop) -> TopAbs_State: ...

class TopOpeBRepBuild_LoopSet:
    def __init__(self) -> None: ...
    def ChangeListOfLoop(self) -> TopOpeBRepBuild_ListOfLoop: ...
    def InitLoop(self) -> None: ...
    def Loop(self) -> TopOpeBRepBuild_Loop: ...
    def MoreLoop(self) -> bool: ...
    def NextLoop(self) -> None: ...

class TopOpeBRepBuild_ShapeListOfShape:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, S: TopoDS_Shape) -> None: ...
    @overload
    def __init__(self, S: TopoDS_Shape, L: TopTools_ListOfShape) -> None: ...
    def ChangeList(self) -> TopTools_ListOfShape: ...
    def ChangeShape(self) -> TopoDS_Shape: ...
    def List(self) -> TopTools_ListOfShape: ...
    def Shape(self) -> TopoDS_Shape: ...

class TopOpeBRepBuild_ShapeSet:
    def __init__(self, SubShapeType: TopAbs_ShapeEnum, checkshape: Optional[bool] = True) -> None: ...
    def AddElement(self, S: TopoDS_Shape) -> None: ...
    def AddShape(self, S: TopoDS_Shape) -> None: ...
    def AddStartElement(self, S: TopoDS_Shape) -> None: ...
    def ChangeStartShapes(self) -> TopTools_ListOfShape: ...
    @overload
    def CheckShape(self, checkshape: bool) -> None: ...
    @overload
    def CheckShape(self) -> bool: ...
    @overload
    def CheckShape(self, S: TopoDS_Shape, checkgeom: Optional[bool] = False) -> bool: ...
    @overload
    def DEBName(self, N: str) -> None: ...
    @overload
    def DEBName(self) -> str: ...
    @overload
    def DEBNumber(self, I: int) -> None: ...
    @overload
    def DEBNumber(self) -> int: ...
    def DumpBB(self) -> None: ...
    def DumpSS(self) -> None: ...
    def FindNeighbours(self) -> None: ...
    def InitNeighbours(self, S: TopoDS_Shape) -> None: ...
    def InitShapes(self) -> None: ...
    def InitStartElements(self) -> None: ...
    def MakeNeighboursList(self, E: TopoDS_Shape, V: TopoDS_Shape) -> TopTools_ListOfShape: ...
    def MaxNumberSubShape(self, Shape: TopoDS_Shape) -> int: ...
    def MoreNeighbours(self) -> bool: ...
    def MoreShapes(self) -> bool: ...
    def MoreStartElements(self) -> bool: ...
    def Neighbour(self) -> TopoDS_Shape: ...
    def NextNeighbour(self) -> None: ...
    def NextShape(self) -> None: ...
    def NextStartElement(self) -> None: ...
    @overload
    def SName(self, S: TopoDS_Shape, sb: Optional[str] = "", sa: Optional[str] = "") -> str: ...
    @overload
    def SName(self, S: TopTools_ListOfShape, sb: Optional[str] = "", sa: Optional[str] = "") -> str: ...
    @overload
    def SNameori(self, S: TopoDS_Shape, sb: Optional[str] = "", sa: Optional[str] = "") -> str: ...
    @overload
    def SNameori(self, S: TopTools_ListOfShape, sb: Optional[str] = "", sa: Optional[str] = "") -> str: ...
    def Shape(self) -> TopoDS_Shape: ...
    def StartElement(self) -> TopoDS_Shape: ...
    def StartElements(self) -> TopTools_ListOfShape: ...

class TopOpeBRepBuild_ShellToSolid:
    def __init__(self) -> None: ...
    def AddShell(self, Sh: TopoDS_Shell) -> None: ...
    def Init(self) -> None: ...
    def MakeSolids(self, So: TopoDS_Solid, LSo: TopTools_ListOfShape) -> None: ...

class TopOpeBRepBuild_SolidBuilder:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, FS: TopOpeBRepBuild_ShellFaceSet, ForceClass: Optional[bool] = False) -> None: ...
    def Face(self) -> TopoDS_Shape: ...
    def InitFace(self) -> int: ...
    def InitShell(self) -> int: ...
    def InitSolid(self) -> int: ...
    def InitSolidBuilder(self, FS: TopOpeBRepBuild_ShellFaceSet, ForceClass: bool) -> None: ...
    def IsOldShell(self) -> bool: ...
    def MoreFace(self) -> bool: ...
    def MoreShell(self) -> bool: ...
    def MoreSolid(self) -> bool: ...
    def NextFace(self) -> None: ...
    def NextShell(self) -> None: ...
    def NextSolid(self) -> None: ...
    def OldShell(self) -> TopoDS_Shape: ...

class TopOpeBRepBuild_Tools:
    @staticmethod
    def CheckFaceClosed2d(theFace: TopoDS_Face) -> bool: ...
    @staticmethod
    def CorrectCurveOnSurface(aS: TopoDS_Shape, aTolMax: Optional[float] = 0.0001) -> None: ...
    @staticmethod
    def CorrectFace2d(oldFace: TopoDS_Shape, corrFace: TopoDS_Shape, aSourceShapes: TopTools_IndexedMapOfOrientedShape, aMapOfCorrect2dEdges: TopTools_IndexedDataMapOfShapeShape) -> None: ...
    @staticmethod
    def CorrectPointOnCurve(aS: TopoDS_Shape, aTolMax: Optional[float] = 0.0001) -> None: ...
    @staticmethod
    def CorrectTolerances(aS: TopoDS_Shape, aTolMax: Optional[float] = 0.0001) -> None: ...
    @staticmethod
    def FindState(aVertex: TopoDS_Shape, aState: TopAbs_State, aShapeEnum: TopAbs_ShapeEnum, aMapVertexEdges: TopTools_IndexedDataMapOfShapeListOfShape, aMapProcessedVertices: TopTools_MapOfShape, aMapVs: TopOpeBRepDS_DataMapOfShapeState) -> None: ...
    @staticmethod
    def FindState1(anEdge: TopoDS_Shape, aState: TopAbs_State, aMapEdgesFaces: TopTools_IndexedDataMapOfShapeListOfShape, aMapProcessedVertices: TopTools_MapOfShape, aMapVs: TopOpeBRepDS_DataMapOfShapeState) -> None: ...
    @staticmethod
    def FindState2(anEdge: TopoDS_Shape, aState: TopAbs_State, aMapEdgesFaces: TopTools_IndexedDataMapOfShapeListOfShape, aMapProcessedEdges: TopTools_MapOfShape, aMapVs: TopOpeBRepDS_DataMapOfShapeState) -> None: ...
    @staticmethod
    def FindStateThroughVertex(aShape: TopoDS_Shape, aShapeClassifier: TopOpeBRepTool_ShapeClassifier, aMapOfShapeWithState: TopOpeBRepDS_IndexedDataMapOfShapeWithState, anAvoidSubshMap: TopTools_MapOfShape) -> TopAbs_State: ...
    @staticmethod
    def GetAdjacentFace(aFaceObj: TopoDS_Shape, anEObj: TopoDS_Shape, anEdgeFaceMap: TopTools_IndexedDataMapOfShapeListOfShape, anAdjFaceObj: TopoDS_Shape) -> bool: ...
    @staticmethod
    def GetNormalInNearestPoint(aFace: TopoDS_Face, anEdge: TopoDS_Edge, aNormal: gp_Vec) -> None: ...
    @staticmethod
    def GetNormalToFaceOnEdge(aFObj: TopoDS_Face, anEdgeObj: TopoDS_Edge, aDirNormal: gp_Vec) -> None: ...
    @staticmethod
    def GetTangentToEdge(anEdgeObj: TopoDS_Edge, aTangent: gp_Vec) -> bool: ...
    @staticmethod
    def GetTangentToEdgeEdge(aFObj: TopoDS_Face, anEdgeObj: TopoDS_Edge, aOriEObj: TopoDS_Edge, aTangent: gp_Vec) -> bool: ...
    @staticmethod
    def IsDegEdgesTheSame(anE1: TopoDS_Shape, anE2: TopoDS_Shape) -> bool: ...
    @staticmethod
    def NormalizeFace(oldFace: TopoDS_Shape, corrFace: TopoDS_Shape) -> None: ...
    @staticmethod
    def PropagateState(aSplEdgesState: TopOpeBRepDS_DataMapOfShapeState, anEdgesToRestMap: TopTools_IndexedMapOfShape, aShapeEnum1: TopAbs_ShapeEnum, aShapeEnum2: TopAbs_ShapeEnum, aShapeClassifier: TopOpeBRepTool_ShapeClassifier, aMapOfShapeWithState: TopOpeBRepDS_IndexedDataMapOfShapeWithState, anUnkStateShapes: TopTools_MapOfShape) -> None: ...
    @staticmethod
    def PropagateStateForWires(aFacesToRestMap: TopTools_IndexedMapOfShape, aMapOfShapeWithState: TopOpeBRepDS_IndexedDataMapOfShapeWithState) -> None: ...
    @staticmethod
    def SpreadStateToChild(aShape: TopoDS_Shape, aState: TopAbs_State, aMapOfShapeWithState: TopOpeBRepDS_IndexedDataMapOfShapeWithState) -> None: ...
    @staticmethod
    def UpdateEdgeOnFace(aEdgeToUpdate: TopoDS_Edge, OldFace: TopoDS_Face, NewFace: TopoDS_Face) -> None: ...
    @staticmethod
    def UpdateEdgeOnPeriodicalFace(aEdgeToUpdate: TopoDS_Edge, OldFace: TopoDS_Face, NewFace: TopoDS_Face) -> None: ...
    @staticmethod
    def UpdatePCurves(aWire: TopoDS_Wire, fromFace: TopoDS_Face, toFace: TopoDS_Face) -> None: ...

class TopOpeBRepBuild_Tools2d:
    @staticmethod
    def DumpMapOfShapeVertexInfo(aMap: TopOpeBRepBuild_IndexedDataMapOfShapeVertexInfo) -> None: ...
    @staticmethod
    def MakeMapOfShapeVertexInfo(aWire: TopoDS_Wire, aMap: TopOpeBRepBuild_IndexedDataMapOfShapeVertexInfo) -> None: ...
    @staticmethod
    def Path(aWire: TopoDS_Wire, aResList: TopTools_ListOfShape) -> None: ...

class TopOpeBRepBuild_VertexInfo:
    def __init__(self) -> None: ...
    def AddIn(self, anE: TopoDS_Edge) -> None: ...
    def AddOut(self, anE: TopoDS_Edge) -> None: ...
    def AppendPassed(self, anE: TopoDS_Edge) -> None: ...
    def ChangeEdgesOut(self) -> TopTools_IndexedMapOfOrientedShape: ...
    def CurrentOut(self) -> TopoDS_Edge: ...
    def Dump(self) -> None: ...
    def EdgesIn(self) -> TopTools_IndexedMapOfOrientedShape: ...
    def EdgesOut(self) -> TopTools_IndexedMapOfOrientedShape: ...
    def FoundOut(self) -> int: ...
    def ListPassed(self) -> TopTools_ListOfShape: ...
    def NbCases(self) -> int: ...
    def Prepare(self, aL: TopTools_ListOfShape) -> None: ...
    def RemovePassed(self) -> None: ...
    def SetCurrentIn(self, anE: TopoDS_Edge) -> None: ...
    def SetSmart(self, aFlag: bool) -> None: ...
    def SetVertex(self, aV: TopoDS_Vertex) -> None: ...
    def Smart(self) -> bool: ...
    def Vertex(self) -> TopoDS_Vertex: ...

class TopOpeBRepBuild_WireToFace:
    def __init__(self) -> None: ...
    def AddWire(self, W: TopoDS_Wire) -> None: ...
    def Init(self) -> None: ...
    def MakeFaces(self, F: TopoDS_Face, LF: TopTools_ListOfShape) -> None: ...

class TopOpeBRepBuild_Area1dBuilder(TopOpeBRepBuild_AreaBuilder):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, LS: TopOpeBRepBuild_PaveSet, LC: TopOpeBRepBuild_PaveClassifier, ForceClass: Optional[bool] = False) -> None: ...
    def ADD_LISTOFLoop_TO_LISTOFLoop(self, LOL1: TopOpeBRepBuild_ListOfLoop, LOL2: TopOpeBRepBuild_ListOfLoop, s: Optional[None] = None, s1: Optional[None] = None, s2: Optional[None] = None) -> None: ...
    def ADD_Loop_TO_LISTOFLoop(self, L: TopOpeBRepBuild_Loop, LOL: TopOpeBRepBuild_ListOfLoop, s: Optional[None] = None) -> None: ...
    @staticmethod
    def DumpList(L: TopOpeBRepBuild_ListOfLoop) -> None: ...
    def InitAreaBuilder(self, LS: TopOpeBRepBuild_LoopSet, LC: TopOpeBRepBuild_LoopClassifier, ForceClass: Optional[bool] = False) -> None: ...
    def REM_Loop_FROM_LISTOFLoop(self, ITLOL: TopOpeBRepBuild_ListIteratorOfListOfLoop, LOL: TopOpeBRepBuild_ListOfLoop, s: Optional[None] = None) -> None: ...

class TopOpeBRepBuild_Area2dBuilder(TopOpeBRepBuild_AreaBuilder):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, LS: TopOpeBRepBuild_LoopSet, LC: TopOpeBRepBuild_LoopClassifier, ForceClass: Optional[bool] = False) -> None: ...
    def InitAreaBuilder(self, LS: TopOpeBRepBuild_LoopSet, LC: TopOpeBRepBuild_LoopClassifier, ForceClass: Optional[bool] = False) -> None: ...

class TopOpeBRepBuild_Area3dBuilder(TopOpeBRepBuild_AreaBuilder):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, LS: TopOpeBRepBuild_LoopSet, LC: TopOpeBRepBuild_LoopClassifier, ForceClass: Optional[bool] = False) -> None: ...
    def InitAreaBuilder(self, LS: TopOpeBRepBuild_LoopSet, LC: TopOpeBRepBuild_LoopClassifier, ForceClass: Optional[bool] = False) -> None: ...

class TopOpeBRepBuild_Builder1(TopOpeBRepBuild_Builder):
    def __init__(self, BT: TopOpeBRepDS_BuildTool) -> None: ...
    def Clear(self) -> None: ...
    def CorrectResult2d(self, aResult: TopoDS_Shape) -> int: ...
    def GFillEdgeNotSameDomWES(self, E1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def GFillEdgeSameDomWES(self, E1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def GFillFaceNotSameDomSFS(self, F1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    def GFillFaceNotSameDomWES(self, F1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def GFillFaceSameDomSFS(self, F1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    def GFillFaceSameDomWES(self, F1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def GFillShellSFS(self, SH1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    def GFillSolidSFS(self, SO1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, SFS: TopOpeBRepBuild_ShellFaceSet) -> None: ...
    def GFillWireNotSameDomWES(self, W1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def GFillWireSameDomWES(self, W1: TopoDS_Shape, LSO2: TopTools_ListOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def GWESMakeFaces(self, FF: TopoDS_Shape, WES: TopOpeBRepBuild_WireEdgeSet, LOF: TopTools_ListOfShape) -> None: ...
    @overload
    def MergeKPart(self) -> None: ...
    @overload
    def MergeKPart(self, TB1: TopAbs_State, TB2: TopAbs_State) -> None: ...
    @overload
    def Perform(self, HDS: TopOpeBRepDS_HDataStructure) -> None: ...
    @overload
    def Perform(self, HDS: TopOpeBRepDS_HDataStructure, S1: TopoDS_Shape, S2: TopoDS_Shape) -> None: ...
    def PerformONParts(self, F: TopoDS_Shape, SDfaces: TopTools_IndexedMapOfShape, G: TopOpeBRepBuild_GTopo, WES: TopOpeBRepBuild_WireEdgeSet) -> None: ...
    def PerformPieceIn2D(self, aPieceToPerform: TopoDS_Edge, aOriginalEdge: TopoDS_Edge, edgeFace: TopoDS_Face, toFace: TopoDS_Face, G: TopOpeBRepBuild_GTopo) -> bool: ...
    def PerformPieceOn2D(self, aPieceObj: TopoDS_Shape, aFaceObj: TopoDS_Shape, aEdgeObj: TopoDS_Shape, aListOfPieces: TopTools_ListOfShape, aListOfFaces: TopTools_ListOfShape, aListOfPiecesOut2d: TopTools_ListOfShape) -> int: ...
    def TwoPiecesON(self, aSeq: TopTools_SequenceOfShape, aListOfPieces: TopTools_ListOfShape, aListOfFaces: TopTools_ListOfShape, aListOfPiecesOut2d: TopTools_ListOfShape) -> int: ...

class TopOpeBRepBuild_CompositeClassifier(TopOpeBRepBuild_LoopClassifier):
    def Compare(self, L1: TopOpeBRepBuild_Loop, L2: TopOpeBRepBuild_Loop) -> TopAbs_State: ...
    def CompareElement(self, E: TopoDS_Shape) -> bool: ...
    def CompareElementToShape(self, E: TopoDS_Shape, B: TopoDS_Shape) -> TopAbs_State: ...
    def CompareShapes(self, B1: TopoDS_Shape, B2: TopoDS_Shape) -> TopAbs_State: ...
    def ResetElement(self, E: TopoDS_Shape) -> None: ...
    def ResetShape(self, B: TopoDS_Shape) -> None: ...
    def State(self) -> TopAbs_State: ...

class TopOpeBRepBuild_Pave(TopOpeBRepBuild_Loop):
    def __init__(self, V: TopoDS_Shape, P: float, bound: bool) -> None: ...
    def ChangeVertex(self) -> TopoDS_Shape: ...
    def Dump(self) -> None: ...
    @overload
    def HasSameDomain(self, b: bool) -> None: ...
    @overload
    def HasSameDomain(self) -> bool: ...
    def InterferenceType(self) -> TopOpeBRepDS_Kind: ...
    def IsShape(self) -> bool: ...
    @overload
    def Parameter(self) -> float: ...
    @overload
    def Parameter(self, Par: float) -> None: ...
    @overload
    def SameDomain(self, VSD: TopoDS_Shape) -> None: ...
    @overload
    def SameDomain(self) -> TopoDS_Shape: ...
    def Shape(self) -> TopoDS_Shape: ...
    def Vertex(self) -> TopoDS_Shape: ...

class TopOpeBRepBuild_PaveClassifier(TopOpeBRepBuild_LoopClassifier):
    def __init__(self, E: TopoDS_Shape) -> None: ...
    @staticmethod
    def AdjustCase(p1: float, o: TopAbs_Orientation, first: float, period: float, tol: float) -> Tuple[float, int]: ...
    def ClosedVertices(self, B: bool) -> None: ...
    def Compare(self, L1: TopOpeBRepBuild_Loop, L2: TopOpeBRepBuild_Loop) -> TopAbs_State: ...
    def SetFirstParameter(self, P: float) -> None: ...

class TopOpeBRepBuild_PaveSet(TopOpeBRepBuild_LoopSet):
    def __init__(self, E: TopoDS_Shape) -> None: ...
    def Append(self, PV: TopOpeBRepBuild_Pave) -> None: ...
    def ClosedVertices(self) -> bool: ...
    def Edge(self) -> TopoDS_Edge: ...
    def EqualParameters(self) -> float: ...
    def HasEqualParameters(self) -> bool: ...
    def InitLoop(self) -> None: ...
    def Loop(self) -> TopOpeBRepBuild_Loop: ...
    def MoreLoop(self) -> bool: ...
    def NextLoop(self) -> None: ...
    def RemovePV(self, B: bool) -> None: ...
    @staticmethod
    def SortPave(Lin: TopOpeBRepBuild_ListOfPave, Lout: TopOpeBRepBuild_ListOfPave) -> None: ...

class TopOpeBRepBuild_ShellFaceSet(TopOpeBRepBuild_ShapeSet):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, S: TopoDS_Shape, Addr: Optional[None] = None) -> None: ...
    def AddElement(self, S: TopoDS_Shape) -> None: ...
    def AddShape(self, S: TopoDS_Shape) -> None: ...
    def AddStartElement(self, S: TopoDS_Shape) -> None: ...
    def DumpSS(self) -> None: ...
    @overload
    def SName(self, S: TopoDS_Shape, sb: Optional[str] = "", sa: Optional[str] = "") -> str: ...
    @overload
    def SName(self, S: TopTools_ListOfShape, sb: Optional[str] = "", sa: Optional[str] = "") -> str: ...
    @overload
    def SNameori(self, S: TopoDS_Shape, sb: Optional[str] = "", sa: Optional[str] = "") -> str: ...
    @overload
    def SNameori(self, S: TopTools_ListOfShape, sb: Optional[str] = "", sa: Optional[str] = "") -> str: ...
    def Solid(self) -> TopoDS_Solid: ...

class TopOpeBRepBuild_WireEdgeSet(TopOpeBRepBuild_ShapeSet):
    def __init__(self, F: TopoDS_Shape, Addr: Optional[None] = None) -> None: ...
    def AddElement(self, S: TopoDS_Shape) -> None: ...
    def AddShape(self, S: TopoDS_Shape) -> None: ...
    def AddStartElement(self, S: TopoDS_Shape) -> None: ...
    def DumpSS(self) -> None: ...
    def Face(self) -> TopoDS_Face: ...
    def FindNeighbours(self) -> None: ...
    def InitNeighbours(self, E: TopoDS_Shape) -> None: ...
    @staticmethod
    def IsUVISO(E: TopoDS_Edge, F: TopoDS_Face) -> Tuple[bool, bool]: ...
    def MakeNeighboursList(self, E: TopoDS_Shape, V: TopoDS_Shape) -> TopTools_ListOfShape: ...
    @overload
    def SName(self, S: TopoDS_Shape, sb: Optional[str] = "", sa: Optional[str] = "") -> str: ...
    @overload
    def SName(self, S: TopTools_ListOfShape, sb: Optional[str] = "", sa: Optional[str] = "") -> str: ...
    @overload
    def SNameori(self, S: TopoDS_Shape, sb: Optional[str] = "", sa: Optional[str] = "") -> str: ...
    @overload
    def SNameori(self, S: TopTools_ListOfShape, sb: Optional[str] = "", sa: Optional[str] = "") -> str: ...

class TopOpeBRepBuild_EdgeBuilder(TopOpeBRepBuild_Area1dBuilder):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, LS: TopOpeBRepBuild_PaveSet, LC: TopOpeBRepBuild_PaveClassifier, ForceClass: Optional[bool] = False) -> None: ...
    def InitEdge(self) -> None: ...
    def InitEdgeBuilder(self, LS: TopOpeBRepBuild_LoopSet, LC: TopOpeBRepBuild_LoopClassifier, ForceClass: Optional[bool] = False) -> None: ...
    def InitVertex(self) -> None: ...
    def MoreEdge(self) -> bool: ...
    def MoreVertex(self) -> bool: ...
    def NextEdge(self) -> None: ...
    def NextVertex(self) -> None: ...
    def Parameter(self) -> float: ...
    def Vertex(self) -> TopoDS_Shape: ...

class TopOpeBRepBuild_FaceAreaBuilder(TopOpeBRepBuild_Area2dBuilder):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, LS: TopOpeBRepBuild_LoopSet, LC: TopOpeBRepBuild_LoopClassifier, ForceClass: Optional[bool] = False) -> None: ...
    def InitFaceAreaBuilder(self, LS: TopOpeBRepBuild_LoopSet, LC: TopOpeBRepBuild_LoopClassifier, ForceClass: Optional[bool] = False) -> None: ...

class TopOpeBRepBuild_ShellFaceClassifier(TopOpeBRepBuild_CompositeClassifier):
    def __init__(self, BB: TopOpeBRepBuild_BlockBuilder) -> None: ...
    def Clear(self) -> None: ...
    def CompareElement(self, F: TopoDS_Shape) -> bool: ...
    def CompareElementToShape(self, F: TopoDS_Shape, S: TopoDS_Shape) -> TopAbs_State: ...
    def CompareShapes(self, B1: TopoDS_Shape, B2: TopoDS_Shape) -> TopAbs_State: ...
    def ResetElement(self, F: TopoDS_Shape) -> None: ...
    def ResetShape(self, S: TopoDS_Shape) -> None: ...
    def State(self) -> TopAbs_State: ...

class TopOpeBRepBuild_SolidAreaBuilder(TopOpeBRepBuild_Area3dBuilder):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, LS: TopOpeBRepBuild_LoopSet, LC: TopOpeBRepBuild_LoopClassifier, ForceClass: Optional[bool] = False) -> None: ...
    def InitSolidAreaBuilder(self, LS: TopOpeBRepBuild_LoopSet, LC: TopOpeBRepBuild_LoopClassifier, ForceClass: Optional[bool] = False) -> None: ...

class TopOpeBRepBuild_WireEdgeClassifier(TopOpeBRepBuild_CompositeClassifier):
    def __init__(self, F: TopoDS_Shape, BB: TopOpeBRepBuild_BlockBuilder) -> None: ...
    def Compare(self, L1: TopOpeBRepBuild_Loop, L2: TopOpeBRepBuild_Loop) -> TopAbs_State: ...
    def CompareElement(self, E: TopoDS_Shape) -> bool: ...
    def CompareElementToShape(self, E: TopoDS_Shape, B: TopoDS_Shape) -> TopAbs_State: ...
    def CompareShapes(self, B1: TopoDS_Shape, B2: TopoDS_Shape) -> TopAbs_State: ...
    def LoopToShape(self, L: TopOpeBRepBuild_Loop) -> TopoDS_Shape: ...
    def ResetElement(self, E: TopoDS_Shape) -> None: ...
    def ResetShape(self, B: TopoDS_Shape) -> None: ...
    def State(self) -> TopAbs_State: ...

# harray1 classes
# harray2 classes
# hsequence classes

