/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.indexmanagement.indexstatemanagement.util.RestHandlerUtilsKt;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.ScriptType;
import org.opensearch.script.TemplateScript;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver;", "", "()V", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "indexAliasUtils", "Lorg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver$IndexAliasUtils;", "getIndexAliasUtils", "()Lorg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver$IndexAliasUtils;", "setIndexAliasUtils", "(Lorg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver$IndexAliasUtils;)V", "scriptService", "Lorg/opensearch/script/ScriptService;", "validTopContextFields", "", "", "registerServices", "", "resolve", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "fieldValue", "IndexAliasUtils", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollupFieldValueExpressionResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupFieldValueExpressionResolver.kt\norg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,80:1\n467#2,7:81\n*S KotlinDebug\n*F\n+ 1 RollupFieldValueExpressionResolver.kt\norg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver\n*L\n32#1:81,7\n*E\n"})
public final class RollupFieldValueExpressionResolver {
    @NotNull
    public static final RollupFieldValueExpressionResolver INSTANCE = new RollupFieldValueExpressionResolver();
    @NotNull
    private static final Set<String> validTopContextFields = SetsKt.setOf((Object)"source_index");
    private static ScriptService scriptService;
    private static ClusterService clusterService;
    public static IndexAliasUtils indexAliasUtils;

    private RollupFieldValueExpressionResolver() {
    }

    @NotNull
    public final IndexAliasUtils getIndexAliasUtils() {
        IndexAliasUtils indexAliasUtils = RollupFieldValueExpressionResolver.indexAliasUtils;
        if (indexAliasUtils != null) {
            return indexAliasUtils;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"indexAliasUtils");
        return null;
    }

    public final void setIndexAliasUtils(@NotNull IndexAliasUtils indexAliasUtils) {
        Intrinsics.checkNotNullParameter((Object)indexAliasUtils, (String)"<set-?>");
        RollupFieldValueExpressionResolver.indexAliasUtils = indexAliasUtils;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String resolve(@NotNull Rollup rollup2, @NotNull String fieldValue) {
        String string;
        CharSequence charSequence;
        void $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter((Object)rollup2, (String)"rollup");
        Intrinsics.checkNotNullParameter((Object)fieldValue, (String)"fieldValue");
        Script script = new Script(ScriptType.INLINE, "mustache", fieldValue, MapsKt.emptyMap());
        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
        Map<String, Object> map = OpenSearchExtensionsKt.toMap(rollup2.toXContent(xContentBuilder, (ToXContent.Params)RestHandlerUtilsKt.getXCONTENT_WITHOUT_TYPE()));
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String key = (String)entry$iv.getKey();
            boolean bl = false;
            if (!validTopContextFields.contains(key)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map contextMap = result$iv;
        ScriptService scriptService = RollupFieldValueExpressionResolver.scriptService;
        if (scriptService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scriptService");
            scriptService = null;
        }
        TemplateScript.Factory factory = (TemplateScript.Factory)scriptService.compile(script, TemplateScript.CONTEXT);
        Map map2 = script.getParams();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"script.params");
        String compiledValue = factory.newInstance(MapsKt.plus((Map)map2, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"ctx", (Object)contextMap)))).execute();
        IndexAliasUtils indexAliasUtils = this.getIndexAliasUtils();
        String string2 = compiledValue;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"compiledValue");
        if (indexAliasUtils.isAlias(string2)) {
            IndexAliasUtils indexAliasUtils2 = this.getIndexAliasUtils();
            String string3 = compiledValue;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"compiledValue");
            compiledValue = indexAliasUtils2.getWriteIndexNameForAlias(string3);
        }
        if ((charSequence = (CharSequence)compiledValue) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            string = fieldValue;
        } else {
            String string4 = compiledValue;
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"compiledValue");
        }
        return string;
    }

    public final void registerServices(@NotNull ScriptService scriptService, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        RollupFieldValueExpressionResolver.scriptService = scriptService;
        RollupFieldValueExpressionResolver.clusterService = clusterService;
        this.setIndexAliasUtils(new IndexAliasUtils(clusterService));
    }

    public final void registerServices(@NotNull ScriptService scriptService, @NotNull ClusterService clusterService, @NotNull IndexAliasUtils indexAliasUtils) {
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)indexAliasUtils, (String)"indexAliasUtils");
        RollupFieldValueExpressionResolver.scriptService = scriptService;
        RollupFieldValueExpressionResolver.clusterService = clusterService;
        this.setIndexAliasUtils(indexAliasUtils);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver$IndexAliasUtils;", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/cluster/service/ClusterService;)V", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getBackingIndicesForAlias", "", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "alias", "", "getWriteIndexNameForAlias", "hasAlias", "", "index", "isAlias", "opensearch-index-management"})
    public static class IndexAliasUtils {
        @NotNull
        private final ClusterService clusterService;

        public IndexAliasUtils(@NotNull ClusterService clusterService) {
            Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
            this.clusterService = clusterService;
        }

        @NotNull
        public final ClusterService getClusterService() {
            return this.clusterService;
        }

        public boolean hasAlias(@NotNull String index2) {
            Map aliases;
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            IndexMetadata indexMetadata2 = (IndexMetadata)this.clusterService.state().metadata().getIndices().get(index2);
            Map map = aliases = indexMetadata2 != null ? indexMetadata2.getAliases() : null;
            if (aliases != null) {
                return !aliases.isEmpty();
            }
            return false;
        }

        public boolean isAlias(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            SortedMap sortedMap = this.clusterService.state().metadata().getIndicesLookup();
            return (sortedMap != null ? (IndexAbstraction)sortedMap.get(index2) : null) instanceof IndexAbstraction.Alias;
        }

        @Nullable
        public String getWriteIndexNameForAlias(@NotNull String alias) {
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            SortedMap sortedMap = this.clusterService.state().metadata().getIndicesLookup();
            return sortedMap != null && (sortedMap = (IndexAbstraction)sortedMap.get(alias)) != null && (sortedMap = sortedMap.getWriteIndex()) != null && (sortedMap = sortedMap.getIndex()) != null ? sortedMap.getName() : null;
        }

        @Nullable
        public List<IndexMetadata> getBackingIndicesForAlias(@NotNull String alias) {
            Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
            SortedMap sortedMap = this.clusterService.state().metadata().getIndicesLookup();
            return sortedMap != null && (sortedMap = (IndexAbstraction)sortedMap.get(alias)) != null ? sortedMap.getIndices() : null;
        }
    }
}

