/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.model;

import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.transform.model.ContinuousTransformStats;
import org.opensearch.indexmanagement.transform.model.TransformStats;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0002IJB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0089\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0016\b\u0002\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t\u0018\u00010\r\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\t\u0010-\u001a\u00020\u0007H\u00c6\u0003J\u0017\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t\u0018\u00010\rH\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\u0019H\u00c6\u0003J\t\u00100\u001a\u00020\tH\u00c6\u0003J\t\u00101\u001a\u00020\tH\u00c6\u0003J\t\u00102\u001a\u00020\u0007H\u00c6\u0003J\u0017\u00103\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u00c6\u0003J\t\u00104\u001a\u00020\u0010H\u00c6\u0003J\t\u00105\u001a\u00020\u0012H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u00107\u001a\u00020\u0015H\u00c6\u0003J\u0097\u0001\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00072\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u0016\b\u0002\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t\u0018\u00010\r2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00c6\u0001J\u0013\u00109\u001a\u00020:2\b\u0010;\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010<\u001a\u00020=H\u00d6\u0001J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010?\u001a\u00020\u0007H\u00d6\u0001J\u0018\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0016R\u001f\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010%R\u001f\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\t\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001cR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010 \u00a8\u0006K"}, d2={"Lorg/opensearch/indexmanagement/transform/model/TransformMetadata;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "id", "", "seqNo", "", "primaryTerm", "transformId", "afterKey", "", "", "lastUpdatedAt", "Ljava/time/Instant;", "status", "Lorg/opensearch/indexmanagement/transform/model/TransformMetadata$Status;", "failureReason", "stats", "Lorg/opensearch/indexmanagement/transform/model/TransformStats;", "shardIDToGlobalCheckpoint", "Lorg/opensearch/core/index/shard/ShardId;", "continuousStats", "Lorg/opensearch/indexmanagement/transform/model/ContinuousTransformStats;", "(Ljava/lang/String;JJLjava/lang/String;Ljava/util/Map;Ljava/time/Instant;Lorg/opensearch/indexmanagement/transform/model/TransformMetadata$Status;Ljava/lang/String;Lorg/opensearch/indexmanagement/transform/model/TransformStats;Ljava/util/Map;Lorg/opensearch/indexmanagement/transform/model/ContinuousTransformStats;)V", "getAfterKey", "()Ljava/util/Map;", "getContinuousStats", "()Lorg/opensearch/indexmanagement/transform/model/ContinuousTransformStats;", "getFailureReason", "()Ljava/lang/String;", "getId", "getLastUpdatedAt", "()Ljava/time/Instant;", "getPrimaryTerm", "()J", "getSeqNo", "getShardIDToGlobalCheckpoint", "getStats", "()Lorg/opensearch/indexmanagement/transform/model/TransformStats;", "getStatus", "()Lorg/opensearch/indexmanagement/transform/model/TransformMetadata$Status;", "getTransformId", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "mergeStats", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "Status", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nTransformMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformMetadata.kt\norg/opensearch/indexmanagement/transform/model/TransformMetadata\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n457#2:178\n403#2:179\n1238#3,4:180\n1#4:184\n*S KotlinDebug\n*F\n+ 1 TransformMetadata.kt\norg/opensearch/indexmanagement/transform/model/TransformMetadata\n*L\n77#1:178\n77#1:179\n77#1:180,4\n*E\n"})
public final class TransformMetadata
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    @NotNull
    private final String transformId;
    @Nullable
    private final Map<String, Object> afterKey;
    @NotNull
    private final Instant lastUpdatedAt;
    @NotNull
    private final Status status;
    @Nullable
    private final String failureReason;
    @NotNull
    private final TransformStats stats;
    @Nullable
    private final Map<ShardId, Long> shardIDToGlobalCheckpoint;
    @Nullable
    private final ContinuousTransformStats continuousStats;
    @NotNull
    public static final String TRANSFORM_METADATA_TYPE = "transform_metadata";
    @NotNull
    public static final String TRANSFORM_ID_FIELD = "transform_id";
    @NotNull
    public static final String AFTER_KEY_FIELD = "after_key";
    @NotNull
    public static final String LAST_UPDATED_AT_FIELD = "last_updated_at";
    @NotNull
    public static final String STATUS_FIELD = "status";
    @NotNull
    public static final String STATS_FIELD = "stats";
    @NotNull
    public static final String SHARD_ID_TO_GLOBAL_CHECKPOINT_FIELD = "shard_id_to_global_checkpoint";
    @NotNull
    public static final String CONTINUOUS_STATS_FIELD = "continuous_stats";
    @NotNull
    public static final String FAILURE_REASON = "failure_reason";

    public TransformMetadata(@NotNull String id2, long seqNo, long primaryTerm, @NotNull String transformId, @Nullable Map<String, ? extends Object> afterKey, @NotNull Instant lastUpdatedAt, @NotNull Status status, @Nullable String failureReason, @NotNull TransformStats stats, @Nullable Map<ShardId, Long> shardIDToGlobalCheckpoint, @Nullable ContinuousTransformStats continuousStats) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)transformId, (String)"transformId");
        Intrinsics.checkNotNullParameter((Object)lastUpdatedAt, (String)"lastUpdatedAt");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)STATUS_FIELD);
        Intrinsics.checkNotNullParameter((Object)stats, (String)STATS_FIELD);
        this.id = id2;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.transformId = transformId;
        this.afterKey = afterKey;
        this.lastUpdatedAt = lastUpdatedAt;
        this.status = status;
        this.failureReason = failureReason;
        this.stats = stats;
        this.shardIDToGlobalCheckpoint = shardIDToGlobalCheckpoint;
        this.continuousStats = continuousStats;
    }

    public /* synthetic */ TransformMetadata(String string, long l, long l2, String string2, Map map, Instant instant, Status status, String string3, TransformStats transformStats, Map map2, ContinuousTransformStats continuousTransformStats, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = -2L;
        }
        if ((n & 4) != 0) {
            l2 = 0L;
        }
        if ((n & 0x10) != 0) {
            map = null;
        }
        if ((n & 0x80) != 0) {
            string3 = null;
        }
        if ((n & 0x200) != 0) {
            map2 = null;
        }
        if ((n & 0x400) != 0) {
            continuousTransformStats = null;
        }
        this(string, l, l2, string2, map, instant, status, string3, transformStats, map2, continuousTransformStats);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @NotNull
    public final String getTransformId() {
        return this.transformId;
    }

    @Nullable
    public final Map<String, Object> getAfterKey() {
        return this.afterKey;
    }

    @NotNull
    public final Instant getLastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    @Nullable
    public final String getFailureReason() {
        return this.failureReason;
    }

    @NotNull
    public final TransformStats getStats() {
        return this.stats;
    }

    @Nullable
    public final Map<ShardId, Long> getShardIDToGlobalCheckpoint() {
        return this.shardIDToGlobalCheckpoint;
    }

    @Nullable
    public final ContinuousTransformStats getContinuousStats() {
        return this.continuousStats;
    }

    public TransformMetadata(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        long l = sin.readLong();
        long l2 = sin.readLong();
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sin.readString()");
        Map map = sin.readBoolean() ? sin.readMap() : null;
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"sin.readInstant()");
        Enum enum_ = sin.readEnum(Status.class);
        Intrinsics.checkNotNullExpressionValue((Object)enum_, (String)"sin.readEnum(Status::class.java)");
        this(string, l, l2, string2, map, instant, (Status)enum_, sin.readOptionalString(), new TransformStats(sin), sin.readBoolean() ? sin.readMap(TransformMetadata::_init_$lambda$0, TransformMetadata::_init_$lambda$1) : null, sin.readBoolean() ? new ContinuousTransformStats(sin) : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(TRANSFORM_METADATA_TYPE);
        }
        builder.field(TRANSFORM_ID_FIELD, this.transformId);
        if (this.afterKey != null) {
            builder.field(AFTER_KEY_FIELD, this.afterKey);
        }
        OpenSearchExtensionsKt.optionalTimeField(builder, LAST_UPDATED_AT_FIELD, this.lastUpdatedAt);
        builder.field(STATUS_FIELD, this.status.getType());
        builder.field(FAILURE_REASON, this.failureReason);
        builder.field(STATS_FIELD, (ToXContent)this.stats);
        if (this.shardIDToGlobalCheckpoint != null) {
            Map map;
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Map<ShardId, Long> map2 = this.shardIDToGlobalCheckpoint;
            String string = SHARD_ID_TO_GLOBAL_CHECKPOINT_FIELD;
            XContentBuilder xContentBuilder = builder;
            boolean $i$f$mapKeys = false;
            void var5_7 = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string2 = ((ShardId)it.getKey()).toString();
                Map map3 = map;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map3.put(string2, entry);
            }
            map = destination$iv$iv;
            xContentBuilder.field(string, map);
        }
        if (this.continuousStats != null) {
            builder.field(CONTINUOUS_STATS_FIELD, (ToXContent)this.continuousStats);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        XContentBuilder xContentBuilder = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.endObject()");
        return xContentBuilder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        block2: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.id);
            out.writeLong(this.seqNo);
            out.writeLong(this.primaryTerm);
            out.writeString(this.transformId);
            out.writeBoolean(this.afterKey != null);
            Map<String, Object> map = this.afterKey;
            if (map != null) {
                it = map;
                boolean bl = false;
                out.writeMap(it);
            }
            out.writeInstant(this.lastUpdatedAt);
            out.writeEnum((Enum)this.status);
            out.writeOptionalString(this.failureReason);
            this.stats.writeTo(out);
            out.writeBoolean(this.shardIDToGlobalCheckpoint != null);
            Map<ShardId, Long> map2 = this.shardIDToGlobalCheckpoint;
            if (map2 != null) {
                it = map2;
                boolean bl = false;
                out.writeMap(it, TransformMetadata::writeTo$lambda$6$lambda$4, TransformMetadata::writeTo$lambda$6$lambda$5);
            }
            out.writeBoolean(this.continuousStats != null);
            ContinuousTransformStats continuousTransformStats = this.continuousStats;
            if (continuousTransformStats == null) break block2;
            it = continuousTransformStats;
            boolean bl = false;
            ((ContinuousTransformStats)it).writeTo(out);
        }
    }

    @NotNull
    public final TransformMetadata mergeStats(@NotNull TransformStats stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)STATS_FIELD);
        TransformStats transformStats = this.stats;
        long l = this.stats.getPagesProcessed() + stats.getPagesProcessed();
        long l2 = this.stats.getDocumentsIndexed() + stats.getDocumentsIndexed();
        long l3 = this.stats.getDocumentsProcessed() + stats.getDocumentsProcessed();
        long l4 = this.stats.getIndexTimeInMillis() + stats.getIndexTimeInMillis();
        long l5 = this.stats.getSearchTimeInMillis() + stats.getSearchTimeInMillis();
        return TransformMetadata.copy$default(this, null, 0L, 0L, null, null, null, null, null, transformStats.copy(l, l3, l2, l4, l5), null, null, 1791, null);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.seqNo;
    }

    public final long component3() {
        return this.primaryTerm;
    }

    @NotNull
    public final String component4() {
        return this.transformId;
    }

    @Nullable
    public final Map<String, Object> component5() {
        return this.afterKey;
    }

    @NotNull
    public final Instant component6() {
        return this.lastUpdatedAt;
    }

    @NotNull
    public final Status component7() {
        return this.status;
    }

    @Nullable
    public final String component8() {
        return this.failureReason;
    }

    @NotNull
    public final TransformStats component9() {
        return this.stats;
    }

    @Nullable
    public final Map<ShardId, Long> component10() {
        return this.shardIDToGlobalCheckpoint;
    }

    @Nullable
    public final ContinuousTransformStats component11() {
        return this.continuousStats;
    }

    @NotNull
    public final TransformMetadata copy(@NotNull String id2, long seqNo, long primaryTerm, @NotNull String transformId, @Nullable Map<String, ? extends Object> afterKey, @NotNull Instant lastUpdatedAt, @NotNull Status status, @Nullable String failureReason, @NotNull TransformStats stats, @Nullable Map<ShardId, Long> shardIDToGlobalCheckpoint, @Nullable ContinuousTransformStats continuousStats) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)transformId, (String)"transformId");
        Intrinsics.checkNotNullParameter((Object)lastUpdatedAt, (String)"lastUpdatedAt");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)STATUS_FIELD);
        Intrinsics.checkNotNullParameter((Object)stats, (String)STATS_FIELD);
        return new TransformMetadata(id2, seqNo, primaryTerm, transformId, afterKey, lastUpdatedAt, status, failureReason, stats, shardIDToGlobalCheckpoint, continuousStats);
    }

    public static /* synthetic */ TransformMetadata copy$default(TransformMetadata transformMetadata2, String string, long l, long l2, String string2, Map map, Instant instant, Status status, String string3, TransformStats transformStats, Map map2, ContinuousTransformStats continuousTransformStats, int n, Object object) {
        if ((n & 1) != 0) {
            string = transformMetadata2.id;
        }
        if ((n & 2) != 0) {
            l = transformMetadata2.seqNo;
        }
        if ((n & 4) != 0) {
            l2 = transformMetadata2.primaryTerm;
        }
        if ((n & 8) != 0) {
            string2 = transformMetadata2.transformId;
        }
        if ((n & 0x10) != 0) {
            map = transformMetadata2.afterKey;
        }
        if ((n & 0x20) != 0) {
            instant = transformMetadata2.lastUpdatedAt;
        }
        if ((n & 0x40) != 0) {
            status = transformMetadata2.status;
        }
        if ((n & 0x80) != 0) {
            string3 = transformMetadata2.failureReason;
        }
        if ((n & 0x100) != 0) {
            transformStats = transformMetadata2.stats;
        }
        if ((n & 0x200) != 0) {
            map2 = transformMetadata2.shardIDToGlobalCheckpoint;
        }
        if ((n & 0x400) != 0) {
            continuousTransformStats = transformMetadata2.continuousStats;
        }
        return transformMetadata2.copy(string, l, l2, string2, map, instant, status, string3, transformStats, map2, continuousTransformStats);
    }

    @NotNull
    public String toString() {
        return "TransformMetadata(id=" + this.id + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", transformId=" + this.transformId + ", afterKey=" + this.afterKey + ", lastUpdatedAt=" + this.lastUpdatedAt + ", status=" + this.status + ", failureReason=" + this.failureReason + ", stats=" + this.stats + ", shardIDToGlobalCheckpoint=" + this.shardIDToGlobalCheckpoint + ", continuousStats=" + this.continuousStats + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.seqNo);
        result2 = result2 * 31 + Long.hashCode(this.primaryTerm);
        result2 = result2 * 31 + this.transformId.hashCode();
        result2 = result2 * 31 + (this.afterKey == null ? 0 : ((Object)this.afterKey).hashCode());
        result2 = result2 * 31 + this.lastUpdatedAt.hashCode();
        result2 = result2 * 31 + this.status.hashCode();
        result2 = result2 * 31 + (this.failureReason == null ? 0 : this.failureReason.hashCode());
        result2 = result2 * 31 + this.stats.hashCode();
        result2 = result2 * 31 + (this.shardIDToGlobalCheckpoint == null ? 0 : ((Object)this.shardIDToGlobalCheckpoint).hashCode());
        result2 = result2 * 31 + (this.continuousStats == null ? 0 : this.continuousStats.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TransformMetadata)) {
            return false;
        }
        TransformMetadata transformMetadata2 = (TransformMetadata)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)transformMetadata2.id)) {
            return false;
        }
        if (this.seqNo != transformMetadata2.seqNo) {
            return false;
        }
        if (this.primaryTerm != transformMetadata2.primaryTerm) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.transformId, (Object)transformMetadata2.transformId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.afterKey, transformMetadata2.afterKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUpdatedAt, (Object)transformMetadata2.lastUpdatedAt)) {
            return false;
        }
        if (this.status != transformMetadata2.status) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.failureReason, (Object)transformMetadata2.failureReason)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stats, (Object)transformMetadata2.stats)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.shardIDToGlobalCheckpoint, transformMetadata2.shardIDToGlobalCheckpoint)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.continuousStats, (Object)transformMetadata2.continuousStats);
    }

    private static final ShardId _init_$lambda$0(StreamInput it) {
        return new ShardId(it);
    }

    private static final Long _init_$lambda$1(StreamInput it) {
        return it.readLong();
    }

    private static final void writeTo$lambda$6$lambda$4(StreamOutput writer, ShardId k) {
        k.writeTo(writer);
    }

    private static final void writeTo$lambda$6$lambda$5(StreamOutput writer, Long v) {
        Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
        writer.writeLong(v.longValue());
    }

    @JvmStatic
    @NotNull
    public static final TransformMetadata parse(@NotNull XContentParser xcp, @NotNull String id2, long seqNo, long primaryTerm) throws IOException {
        return Companion.parse(xcp, id2, seqNo, primaryTerm);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/opensearch/indexmanagement/transform/model/TransformMetadata$Companion;", "", "()V", "AFTER_KEY_FIELD", "", "CONTINUOUS_STATS_FIELD", "FAILURE_REASON", "LAST_UPDATED_AT_FIELD", "SHARD_ID_TO_GLOBAL_CHECKPOINT_FIELD", "STATS_FIELD", "STATUS_FIELD", "TRANSFORM_ID_FIELD", "TRANSFORM_METADATA_TYPE", "parse", "Lorg/opensearch/indexmanagement/transform/model/TransformMetadata;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "seqNo", "", "primaryTerm", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nTransformMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformMetadata.kt\norg/opensearch/indexmanagement/transform/model/TransformMetadata$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n457#2:178\n403#2:179\n1238#3,4:180\n1#4:184\n*S KotlinDebug\n*F\n+ 1 TransformMetadata.kt\norg/opensearch/indexmanagement/transform/model/TransformMetadata$Companion\n*L\n156#1:178\n156#1:179\n156#1:180,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final TransformMetadata parse(@NotNull XContentParser xcp, @NotNull String id2, long seqNo, long primaryTerm) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            String transformId = null;
            Map afterkey = null;
            Instant lastUpdatedAt = null;
            Status status = null;
            String failureReason = null;
            TransformStats stats = null;
            Map shardIDToGlobalCheckpoint = null;
            ContinuousTransformStats continuousStats = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (string == null) continue;
                int n = -1;
                switch (string.hashCode()) {
                    case 109757599: {
                        if (string.equals(TransformMetadata.STATS_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case -1856487730: {
                        if (string.equals(TransformMetadata.TRANSFORM_ID_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case 1312226176: {
                        if (string.equals(TransformMetadata.LAST_UPDATED_AT_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                    case 1019577724: {
                        if (string.equals(TransformMetadata.AFTER_KEY_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                    case -1646691805: {
                        if (string.equals(TransformMetadata.SHARD_ID_TO_GLOBAL_CHECKPOINT_FIELD)) {
                            n = 5;
                        }
                        break;
                    }
                    case 1743941273: {
                        if (string.equals(TransformMetadata.FAILURE_REASON)) {
                            n = 6;
                        }
                        break;
                    }
                    case 1234383727: {
                        if (string.equals(TransformMetadata.CONTINUOUS_STATS_FIELD)) {
                            n = 7;
                        }
                        break;
                    }
                    case -892481550: {
                        if (string.equals(TransformMetadata.STATUS_FIELD)) {
                            n = 8;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        transformId = xcp.text();
                        break;
                    }
                    case 4: {
                        afterkey = xcp.map();
                        break;
                    }
                    case 3: {
                        lastUpdatedAt = OpenSearchExtensionsKt.instant(xcp);
                        break;
                    }
                    case 8: {
                        Object object;
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                        Locale locale = Locale.ROOT;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                        String string2 = ((String)object).toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
                        status = Status.valueOf(string2);
                        break;
                    }
                    case 6: {
                        failureReason = xcp.textOrNull();
                        break;
                    }
                    case 1: {
                        stats = TransformStats.Companion.parse(xcp);
                        break;
                    }
                    case 5: {
                        void $this$mapKeysTo$iv$iv;
                        void $this$mapKeys$iv;
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.map(Companion::parse$lambda$0, Companion::parse$lambda$1), (String)"xcp.map({ HashMap<String\u2026 -> parser.longValue() })");
                        boolean $i$f$mapKeys = false;
                        void var19_25 = $this$mapKeys$iv;
                        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                        boolean $i$f$mapKeysTo = false;
                        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                        boolean $i$f$associateByTo = false;
                        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                            ShardId shardId;
                            void it$iv$iv;
                            void it;
                            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                            Map map = destination$iv$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)ShardId.fromString((String)((String)it.getKey())), (String)"fromString(it.key)");
                            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                            Map map2 = map;
                            boolean bl2 = false;
                            entry = it$iv$iv.getValue();
                            map2.put(shardId, entry);
                        }
                        shardIDToGlobalCheckpoint = destination$iv$iv;
                        break;
                    }
                    case 7: {
                        continuousStats = ContinuousTransformStats.Companion.parse(xcp);
                    }
                }
            }
            String string = id2;
            long l = seqNo;
            long l2 = primaryTerm;
            String string3 = transformId;
            if (string3 == null) {
                long l3 = l2;
                long l4 = l;
                String string4 = string;
                boolean $i$a$-requireNotNull-TransformMetadata$Companion$parse$82 = false;
                String string5 = "TransformId must not be null";
                String string6 = string4;
                long l5 = l4;
                long l6 = l3;
                String $i$a$-requireNotNull-TransformMetadata$Companion$parse$82 = string5;
                throw new IllegalArgumentException($i$a$-requireNotNull-TransformMetadata$Companion$parse$82.toString());
            }
            Map map = afterkey;
            Instant instant = lastUpdatedAt;
            if (instant == null) {
                Map map3 = map;
                String string7 = string3;
                long l7 = l2;
                long l8 = l;
                String string8 = string;
                boolean $i$a$-requireNotNull-TransformMetadata$Companion$parse$92 = false;
                String string9 = "Last updated time must not be null";
                String string10 = string8;
                long l9 = l8;
                long l10 = l7;
                String string11 = string7;
                Map map4 = map3;
                String $i$a$-requireNotNull-TransformMetadata$Companion$parse$92 = string9;
                throw new IllegalArgumentException($i$a$-requireNotNull-TransformMetadata$Companion$parse$92.toString());
            }
            Status status2 = status;
            if (status2 == null) {
                Instant instant2 = instant;
                Map map5 = map;
                String string12 = string3;
                long l11 = l2;
                long l12 = l;
                String string13 = string;
                boolean $i$a$-requireNotNull-TransformMetadata$Companion$parse$102 = false;
                String string14 = "Status must not be null";
                String string15 = string13;
                long l13 = l12;
                long l14 = l11;
                String string16 = string12;
                Map map6 = map5;
                Instant instant3 = instant2;
                String $i$a$-requireNotNull-TransformMetadata$Companion$parse$102 = string14;
                throw new IllegalArgumentException($i$a$-requireNotNull-TransformMetadata$Companion$parse$102.toString());
            }
            String string17 = failureReason;
            TransformStats transformStats = stats;
            if (transformStats == null) {
                String string18 = string17;
                Status status3 = status2;
                Instant instant4 = instant;
                Map map7 = map;
                String string19 = string3;
                long l15 = l2;
                long l16 = l;
                String string20 = string;
                boolean bl = false;
                String string21 = "Stats must not be null";
                String string22 = string20;
                long l17 = l16;
                long l18 = l15;
                String string23 = string19;
                Map map8 = map7;
                Instant instant5 = instant4;
                Status status4 = status3;
                String string24 = string18;
                String string25 = string21;
                throw new IllegalArgumentException(string25.toString());
            }
            ContinuousTransformStats continuousTransformStats = continuousStats;
            Map map9 = shardIDToGlobalCheckpoint;
            TransformStats transformStats2 = transformStats;
            String string26 = string17;
            Status status5 = status2;
            Instant instant6 = instant;
            Map map10 = map;
            String string27 = string3;
            long l19 = l2;
            long l20 = l;
            String string28 = string;
            return new TransformMetadata(string28, l20, l19, string27, map10, instant6, status5, string26, transformStats2, map9, continuousTransformStats);
        }

        public static /* synthetic */ TransformMetadata parse$default(Companion companion, XContentParser xContentParser, String string, long l, long l2, int n, Object object) throws IOException {
            if ((n & 4) != 0) {
                l = -2L;
            }
            if ((n & 8) != 0) {
                l2 = 0L;
            }
            return companion.parse(xContentParser, string, l, l2);
        }

        private static final Map parse$lambda$0() {
            return new HashMap();
        }

        private static final Long parse$lambda$1(XContentParser parser) {
            return parser.longValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/opensearch/indexmanagement/transform/model/TransformMetadata$Status;", "", "type", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getType", "()Ljava/lang/String;", "toString", "INIT", "STARTED", "STOPPED", "FINISHED", "FAILED", "opensearch-index-management"})
    public static final class Status
    extends Enum<Status> {
        @NotNull
        private final String type;
        public static final /* enum */ Status INIT = new Status("init");
        public static final /* enum */ Status STARTED = new Status("started");
        public static final /* enum */ Status STOPPED = new Status("stopped");
        public static final /* enum */ Status FINISHED = new Status("finished");
        public static final /* enum */ Status FAILED = new Status("failed");
        private static final /* synthetic */ Status[] $VALUES;

        private Status(String type) {
            this.type = type;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public String toString() {
            return this.type;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        static {
            $VALUES = statusArray = new Status[]{Status.INIT, Status.STARTED, Status.STOPPED, Status.FINISHED, Status.FAILED};
        }
    }
}

