# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _ogr
else:
    import _ogr

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


wkb25DBit = _ogr.wkb25DBit

wkb25Bit = _ogr.wkb25Bit

wkbUnknown = _ogr.wkbUnknown

wkbPoint = _ogr.wkbPoint

wkbLineString = _ogr.wkbLineString

wkbPolygon = _ogr.wkbPolygon

wkbMultiPoint = _ogr.wkbMultiPoint

wkbMultiLineString = _ogr.wkbMultiLineString

wkbMultiPolygon = _ogr.wkbMultiPolygon

wkbGeometryCollection = _ogr.wkbGeometryCollection

wkbCircularString = _ogr.wkbCircularString

wkbCompoundCurve = _ogr.wkbCompoundCurve

wkbCurvePolygon = _ogr.wkbCurvePolygon

wkbMultiCurve = _ogr.wkbMultiCurve

wkbMultiSurface = _ogr.wkbMultiSurface

wkbCurve = _ogr.wkbCurve

wkbSurface = _ogr.wkbSurface

wkbPolyhedralSurface = _ogr.wkbPolyhedralSurface

wkbTIN = _ogr.wkbTIN

wkbTriangle = _ogr.wkbTriangle

wkbNone = _ogr.wkbNone

wkbLinearRing = _ogr.wkbLinearRing

wkbCircularStringZ = _ogr.wkbCircularStringZ

wkbCompoundCurveZ = _ogr.wkbCompoundCurveZ

wkbCurvePolygonZ = _ogr.wkbCurvePolygonZ

wkbMultiCurveZ = _ogr.wkbMultiCurveZ

wkbMultiSurfaceZ = _ogr.wkbMultiSurfaceZ

wkbCurveZ = _ogr.wkbCurveZ

wkbSurfaceZ = _ogr.wkbSurfaceZ

wkbPolyhedralSurfaceZ = _ogr.wkbPolyhedralSurfaceZ

wkbTINZ = _ogr.wkbTINZ

wkbTriangleZ = _ogr.wkbTriangleZ

wkbPointM = _ogr.wkbPointM

wkbLineStringM = _ogr.wkbLineStringM

wkbPolygonM = _ogr.wkbPolygonM

wkbMultiPointM = _ogr.wkbMultiPointM

wkbMultiLineStringM = _ogr.wkbMultiLineStringM

wkbMultiPolygonM = _ogr.wkbMultiPolygonM

wkbGeometryCollectionM = _ogr.wkbGeometryCollectionM

wkbCircularStringM = _ogr.wkbCircularStringM

wkbCompoundCurveM = _ogr.wkbCompoundCurveM

wkbCurvePolygonM = _ogr.wkbCurvePolygonM

wkbMultiCurveM = _ogr.wkbMultiCurveM

wkbMultiSurfaceM = _ogr.wkbMultiSurfaceM

wkbCurveM = _ogr.wkbCurveM

wkbSurfaceM = _ogr.wkbSurfaceM

wkbPolyhedralSurfaceM = _ogr.wkbPolyhedralSurfaceM

wkbTINM = _ogr.wkbTINM

wkbTriangleM = _ogr.wkbTriangleM

wkbPointZM = _ogr.wkbPointZM

wkbLineStringZM = _ogr.wkbLineStringZM

wkbPolygonZM = _ogr.wkbPolygonZM

wkbMultiPointZM = _ogr.wkbMultiPointZM

wkbMultiLineStringZM = _ogr.wkbMultiLineStringZM

wkbMultiPolygonZM = _ogr.wkbMultiPolygonZM

wkbGeometryCollectionZM = _ogr.wkbGeometryCollectionZM

wkbCircularStringZM = _ogr.wkbCircularStringZM

wkbCompoundCurveZM = _ogr.wkbCompoundCurveZM

wkbCurvePolygonZM = _ogr.wkbCurvePolygonZM

wkbMultiCurveZM = _ogr.wkbMultiCurveZM

wkbMultiSurfaceZM = _ogr.wkbMultiSurfaceZM

wkbCurveZM = _ogr.wkbCurveZM

wkbSurfaceZM = _ogr.wkbSurfaceZM

wkbPolyhedralSurfaceZM = _ogr.wkbPolyhedralSurfaceZM

wkbTINZM = _ogr.wkbTINZM

wkbTriangleZM = _ogr.wkbTriangleZM

wkbPoint25D = _ogr.wkbPoint25D

wkbLineString25D = _ogr.wkbLineString25D

wkbPolygon25D = _ogr.wkbPolygon25D

wkbMultiPoint25D = _ogr.wkbMultiPoint25D

wkbMultiLineString25D = _ogr.wkbMultiLineString25D

wkbMultiPolygon25D = _ogr.wkbMultiPolygon25D

wkbGeometryCollection25D = _ogr.wkbGeometryCollection25D

OFTInteger = _ogr.OFTInteger

OFTIntegerList = _ogr.OFTIntegerList

OFTReal = _ogr.OFTReal

OFTRealList = _ogr.OFTRealList

OFTString = _ogr.OFTString

OFTStringList = _ogr.OFTStringList

OFTWideString = _ogr.OFTWideString

OFTWideStringList = _ogr.OFTWideStringList

OFTBinary = _ogr.OFTBinary

OFTDate = _ogr.OFTDate

OFTTime = _ogr.OFTTime

OFTDateTime = _ogr.OFTDateTime

OFTInteger64 = _ogr.OFTInteger64

OFTInteger64List = _ogr.OFTInteger64List

OFSTNone = _ogr.OFSTNone

OFSTBoolean = _ogr.OFSTBoolean

OFSTInt16 = _ogr.OFSTInt16

OFSTFloat32 = _ogr.OFSTFloat32

OFSTJSON = _ogr.OFSTJSON

OFSTUUID = _ogr.OFSTUUID

OJUndefined = _ogr.OJUndefined

OJLeft = _ogr.OJLeft

OJRight = _ogr.OJRight

OFDT_CODED = _ogr.OFDT_CODED

OFDT_RANGE = _ogr.OFDT_RANGE

OFDT_GLOB = _ogr.OFDT_GLOB

OFDSP_DEFAULT_VALUE = _ogr.OFDSP_DEFAULT_VALUE

OFDSP_DUPLICATE = _ogr.OFDSP_DUPLICATE

OFDSP_GEOMETRY_RATIO = _ogr.OFDSP_GEOMETRY_RATIO

OFDMP_DEFAULT_VALUE = _ogr.OFDMP_DEFAULT_VALUE

OFDMP_SUM = _ogr.OFDMP_SUM

OFDMP_GEOMETRY_WEIGHTED = _ogr.OFDMP_GEOMETRY_WEIGHTED

wkbXDR = _ogr.wkbXDR

wkbNDR = _ogr.wkbNDR

NullFID = _ogr.NullFID

ALTER_NAME_FLAG = _ogr.ALTER_NAME_FLAG

ALTER_TYPE_FLAG = _ogr.ALTER_TYPE_FLAG

ALTER_WIDTH_PRECISION_FLAG = _ogr.ALTER_WIDTH_PRECISION_FLAG

ALTER_NULLABLE_FLAG = _ogr.ALTER_NULLABLE_FLAG

ALTER__FLAG = _ogr.ALTER__FLAG

ALTER_DEFAULT_FLAG = _ogr.ALTER_DEFAULT_FLAG

ALTER_UNIQUE_FLAG = _ogr.ALTER_UNIQUE_FLAG

ALTER_DOMAIN_FLAG = _ogr.ALTER_DOMAIN_FLAG

ALTER_ALTERNATIVE_NAME_FLAG = _ogr.ALTER_ALTERNATIVE_NAME_FLAG

ALTER_COMMENT_FLAG = _ogr.ALTER_COMMENT_FLAG

ALTER_ALL_FLAG = _ogr.ALTER_ALL_FLAG

ALTER_GEOM_FIELD_DEFN_NAME_FLAG = _ogr.ALTER_GEOM_FIELD_DEFN_NAME_FLAG

ALTER_GEOM_FIELD_DEFN_TYPE_FLAG = _ogr.ALTER_GEOM_FIELD_DEFN_TYPE_FLAG

ALTER_GEOM_FIELD_DEFN_NULLABLE_FLAG = _ogr.ALTER_GEOM_FIELD_DEFN_NULLABLE_FLAG

ALTER_GEOM_FIELD_DEFN_SRS_FLAG = _ogr.ALTER_GEOM_FIELD_DEFN_SRS_FLAG

ALTER_GEOM_FIELD_DEFN_SRS_COORD_EPOCH_FLAG = _ogr.ALTER_GEOM_FIELD_DEFN_SRS_COORD_EPOCH_FLAG

ALTER_GEOM_FIELD_DEFN_ALL_FLAG = _ogr.ALTER_GEOM_FIELD_DEFN_ALL_FLAG

F_VAL_NULL = _ogr.F_VAL_NULL

F_VAL_GEOM_TYPE = _ogr.F_VAL_GEOM_TYPE

F_VAL_WIDTH = _ogr.F_VAL_WIDTH

F_VAL_ALLOW_NULL_WHEN_DEFAULT = _ogr.F_VAL_ALLOW_NULL_WHEN_DEFAULT

F_VAL_ALL = _ogr.F_VAL_ALL

TZFLAG_UNKNOWN = _ogr.TZFLAG_UNKNOWN

TZFLAG_LOCALTIME = _ogr.TZFLAG_LOCALTIME

TZFLAG_MIXED_TZ = _ogr.TZFLAG_MIXED_TZ

TZFLAG_UTC = _ogr.TZFLAG_UTC

GGT_COUNT_NOT_NEEDED = _ogr.GGT_COUNT_NOT_NEEDED

GGT_STOP_IF_MIXED = _ogr.GGT_STOP_IF_MIXED

GGT_GEOMCOLLECTIONZ_TINZ = _ogr.GGT_GEOMCOLLECTIONZ_TINZ

OLCRandomRead = _ogr.OLCRandomRead

OLCSequentialWrite = _ogr.OLCSequentialWrite

OLCRandomWrite = _ogr.OLCRandomWrite

OLCFastSpatialFilter = _ogr.OLCFastSpatialFilter

OLCFastFeatureCount = _ogr.OLCFastFeatureCount

OLCFastGetExtent = _ogr.OLCFastGetExtent

OLCCreateField = _ogr.OLCCreateField

OLCDeleteField = _ogr.OLCDeleteField

OLCReorderFields = _ogr.OLCReorderFields

OLCAlterFieldDefn = _ogr.OLCAlterFieldDefn

OLCAlterGeomFieldDefn = _ogr.OLCAlterGeomFieldDefn

OLCTransactions = _ogr.OLCTransactions

OLCDeleteFeature = _ogr.OLCDeleteFeature

OLCUpsertFeature = _ogr.OLCUpsertFeature

OLCUpdateFeature = _ogr.OLCUpdateFeature

OLCFastSetNextByIndex = _ogr.OLCFastSetNextByIndex

OLCStringsAsUTF8 = _ogr.OLCStringsAsUTF8

OLCIgnoreFields = _ogr.OLCIgnoreFields

OLCCreateGeomField = _ogr.OLCCreateGeomField

OLCCurveGeometries = _ogr.OLCCurveGeometries

OLCMeasuredGeometries = _ogr.OLCMeasuredGeometries

OLCZGeometries = _ogr.OLCZGeometries

OLCRename = _ogr.OLCRename

OLCFastGetArrowStream = _ogr.OLCFastGetArrowStream

ODsCCreateLayer = _ogr.ODsCCreateLayer

ODsCDeleteLayer = _ogr.ODsCDeleteLayer

ODsCCreateGeomFieldAfterCreateLayer = _ogr.ODsCCreateGeomFieldAfterCreateLayer

ODsCCurveGeometries = _ogr.ODsCCurveGeometries

ODsCTransactions = _ogr.ODsCTransactions

ODsCEmulatedTransactions = _ogr.ODsCEmulatedTransactions

ODsCMeasuredGeometries = _ogr.ODsCMeasuredGeometries

ODsCZGeometries = _ogr.ODsCZGeometries

ODsCRandomLayerRead = _ogr.ODsCRandomLayerRead

ODsCRandomLayerWrite = _ogr.ODsCRandomLayerWrite

ODsCAddFieldDomain = _ogr.ODsCAddFieldDomain

ODsCDeleteFieldDomain = _ogr.ODsCDeleteFieldDomain

ODsCUpdateFieldDomain = _ogr.ODsCUpdateFieldDomain

ODrCCreateDataSource = _ogr.ODrCCreateDataSource

ODrCDeleteDataSource = _ogr.ODrCDeleteDataSource

OLMD_FID64 = _ogr.OLMD_FID64

OGRERR_NONE = _ogr.OGRERR_NONE

OGRERR_NOT_ENOUGH_DATA = _ogr.OGRERR_NOT_ENOUGH_DATA

OGRERR_NOT_ENOUGH_MEMORY = _ogr.OGRERR_NOT_ENOUGH_MEMORY

OGRERR_UNSUPPORTED_GEOMETRY_TYPE = _ogr.OGRERR_UNSUPPORTED_GEOMETRY_TYPE

OGRERR_UNSUPPORTED_OPERATION = _ogr.OGRERR_UNSUPPORTED_OPERATION

OGRERR_CORRUPT_DATA = _ogr.OGRERR_CORRUPT_DATA

OGRERR_FAILURE = _ogr.OGRERR_FAILURE

OGRERR_UNSUPPORTED_SRS = _ogr.OGRERR_UNSUPPORTED_SRS

OGRERR_INVALID_HANDLE = _ogr.OGRERR_INVALID_HANDLE

OGRERR_NON_EXISTING_FEATURE = _ogr.OGRERR_NON_EXISTING_FEATURE


def GetUseExceptions(*args):
    r"""GetUseExceptions() -> int"""
    return _ogr.GetUseExceptions(*args)

def _GetExceptionsLocal(*args):
    r"""_GetExceptionsLocal() -> int"""
    return _ogr._GetExceptionsLocal(*args)

def _SetExceptionsLocal(*args):
    r"""_SetExceptionsLocal(int bVal)"""
    return _ogr._SetExceptionsLocal(*args)

def _UseExceptions(*args):
    r"""_UseExceptions()"""
    return _ogr._UseExceptions(*args)

def _DontUseExceptions(*args):
    r"""_DontUseExceptions()"""
    return _ogr._DontUseExceptions(*args)

def _UserHasSpecifiedIfUsingExceptions(*args):
    r"""_UserHasSpecifiedIfUsingExceptions() -> int"""
    return _ogr._UserHasSpecifiedIfUsingExceptions(*args)

class ExceptionMgr(object):
    """
    Context manager to manage Python Exception state
    for GDAL/OGR/OSR/GNM.

    Separate exception state is maintained for each
    module (gdal, ogr, etc), and this class appears independently
    in all of them. This is built in top of calls to the older
    UseExceptions()/DontUseExceptions() functions.

    Example::

        >>> print(gdal.GetUseExceptions())
        0
        >>> with gdal.ExceptionMgr():
        ...     # Exceptions are now in use
        ...     print(gdal.GetUseExceptions())
        1
        >>>
        >>> # Exception state has now been restored
        >>> print(gdal.GetUseExceptions())
        0

    """
    def __init__(self, useExceptions=True):
        """
        Save whether or not this context will be using exceptions
        """
        self.requestedUseExceptions = useExceptions

    def __enter__(self):
        """
        On context entry, save the current GDAL exception state, and
        set it to the state requested for the context

        """
        self.currentUseExceptions = _GetExceptionsLocal()
        _SetExceptionsLocal(self.requestedUseExceptions)
        if ExceptionMgr.__module__ == "osgeo.gdal":
            try:
                from . import gdal_array
            except ImportError:
                gdal_array = None
            if gdal_array:
                gdal_array._SetExceptionsLocal(self.requestedUseExceptions)

    def __exit__(self, exc_type, exc_val, exc_tb):
        """
        On exit, restore the GDAL/OGR/OSR/GNM exception state which was
        current on entry to the context
        """
        _SetExceptionsLocal(self.currentUseExceptions)
        if ExceptionMgr.__module__ == "osgeo.gdal":
            try:
                from . import gdal_array
            except ImportError:
                gdal_array = None
            if gdal_array:
                gdal_array._SetExceptionsLocal(self.currentUseExceptions)




def UseExceptions():
    """ Enable exceptions in all GDAL related modules (osgeo.gdal, osgeo.ogr, osgeo.osr, osgeo.gnm).
        Note: prior to GDAL 3.7, this only affected the calling module"""

    try:
        from . import gdal
        gdal._UseExceptions()
    except ImportError:
        pass
    try:
        from . import gdal_array
        gdal_array._UseExceptions()
    except ImportError:
        pass
    try:
        from . import ogr
        ogr._UseExceptions()
    except ImportError:
        pass
    try:
        from . import osr
        osr._UseExceptions()
    except ImportError:
        pass
    try:
        from . import gnm
        gnm._UseExceptions()
    except ImportError:
        pass

def DontUseExceptions():
    """ Disable exceptions in all GDAL related modules (osgeo.gdal, osgeo.ogr, osgeo.osr, osgeo.gnm).
        Note: prior to GDAL 3.7, this only affected the calling module"""

    try:
        from . import gdal
        gdal._DontUseExceptions()
    except ImportError:
        pass
    try:
        from . import gdal_array
        gdal_array._DontUseExceptions()
    except ImportError:
        pass
    try:
        from . import ogr
        ogr._DontUseExceptions()
    except ImportError:
        pass
    try:
        from . import osr
        osr._DontUseExceptions()
    except ImportError:
        pass
    try:
        from . import gnm
        gnm._DontUseExceptions()
    except ImportError:
        pass




hasWarnedAboutUserHasNotSpecifiedIfUsingExceptions = False

def _WarnIfUserHasNotSpecifiedIfUsingExceptions():
    from . import gdal
    if not hasattr(gdal, "hasWarnedAboutUserHasNotSpecifiedIfUsingExceptions") and not _UserHasSpecifiedIfUsingExceptions():
        gdal.hasWarnedAboutUserHasNotSpecifiedIfUsingExceptions = True
        import warnings
        warnings.warn(
            "Neither ogr.UseExceptions() nor ogr.DontUseExceptions() has been explicitly called. " +
            "In GDAL 4.0, exceptions will be enabled by default.", FutureWarning)

from . import osr
class MajorObject(object):
    r"""Proxy of C++ GDALMajorObjectShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetDescription(self, *args):
        r"""GetDescription(MajorObject self) -> char const *"""
        return _ogr.MajorObject_GetDescription(self, *args)

    def SetDescription(self, *args):
        r"""SetDescription(MajorObject self, char const * pszNewDesc)"""
        return _ogr.MajorObject_SetDescription(self, *args)

    def GetMetadataDomainList(self, *args):
        r"""GetMetadataDomainList(MajorObject self) -> char **"""
        return _ogr.MajorObject_GetMetadataDomainList(self, *args)

    def GetMetadata_Dict(self, *args):
        r"""GetMetadata_Dict(MajorObject self, char const * pszDomain="") -> char **"""
        return _ogr.MajorObject_GetMetadata_Dict(self, *args)

    def GetMetadata_List(self, *args):
        r"""GetMetadata_List(MajorObject self, char const * pszDomain="") -> char **"""
        return _ogr.MajorObject_GetMetadata_List(self, *args)

    def SetMetadata(self, *args):
        r"""
        SetMetadata(MajorObject self, char ** papszMetadata, char const * pszDomain="") -> CPLErr
        SetMetadata(MajorObject self, char * pszMetadataString, char const * pszDomain="") -> CPLErr
        """
        return _ogr.MajorObject_SetMetadata(self, *args)

    def GetMetadataItem(self, *args):
        r"""GetMetadataItem(MajorObject self, char const * pszName, char const * pszDomain="") -> char const *"""
        return _ogr.MajorObject_GetMetadataItem(self, *args)

    def SetMetadataItem(self, *args):
        r"""SetMetadataItem(MajorObject self, char const * pszName, char const * pszValue, char const * pszDomain="") -> CPLErr"""
        return _ogr.MajorObject_SetMetadataItem(self, *args)

    def GetMetadata(self, domain=''):
      if domain[:4] == 'xml:':
        return self.GetMetadata_List(domain)
      return self.GetMetadata_Dict(domain)


# Register MajorObject in _ogr:
_ogr.MajorObject_swigregister(MajorObject)

def GetGEOSVersionMajor(*args):
    r"""GetGEOSVersionMajor() -> int"""
    return _ogr.GetGEOSVersionMajor(*args)

def GetGEOSVersionMinor(*args):
    r"""GetGEOSVersionMinor() -> int"""
    return _ogr.GetGEOSVersionMinor(*args)

def GetGEOSVersionMicro(*args):
    r"""GetGEOSVersionMicro() -> int"""
    return _ogr.GetGEOSVersionMicro(*args)
class StyleTable(object):
    r"""Proxy of C++ OGRStyleTableShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(StyleTable self) -> StyleTable"""
        _ogr.StyleTable_swiginit(self, _ogr.new_StyleTable(*args))
    __swig_destroy__ = _ogr.delete_StyleTable

    def AddStyle(self, *args):
        r"""AddStyle(StyleTable self, char const * pszName, char const * pszStyleString) -> int"""
        return _ogr.StyleTable_AddStyle(self, *args)

    def LoadStyleTable(self, *args):
        r"""LoadStyleTable(StyleTable self, char const * utf8_path) -> int"""
        return _ogr.StyleTable_LoadStyleTable(self, *args)

    def SaveStyleTable(self, *args):
        r"""SaveStyleTable(StyleTable self, char const * utf8_path) -> int"""
        return _ogr.StyleTable_SaveStyleTable(self, *args)

    def Find(self, *args):
        r"""Find(StyleTable self, char const * pszName) -> char const *"""
        return _ogr.StyleTable_Find(self, *args)

    def ResetStyleStringReading(self, *args):
        r"""ResetStyleStringReading(StyleTable self)"""
        return _ogr.StyleTable_ResetStyleStringReading(self, *args)

    def GetNextStyle(self, *args):
        r"""GetNextStyle(StyleTable self) -> char const *"""
        return _ogr.StyleTable_GetNextStyle(self, *args)

    def GetLastStyleName(self, *args):
        r"""GetLastStyleName(StyleTable self) -> char const *"""
        return _ogr.StyleTable_GetLastStyleName(self, *args)

# Register StyleTable in _ogr:
_ogr.StyleTable_swigregister(StyleTable)
class Driver(MajorObject):
    r"""Proxy of C++ OGRDriverShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    name = property(_ogr.Driver_name_get, doc=r"""name : p.q(const).char""")

    def CreateDataSource(self, *args, **kwargs):
        r"""CreateDataSource(Driver self, char const * utf8_path, char ** options=None) -> DataSource"""
        return _ogr.Driver_CreateDataSource(self, *args, **kwargs)

    def CopyDataSource(self, *args, **kwargs):
        r"""CopyDataSource(Driver self, DataSource copy_ds, char const * utf8_path, char ** options=None) -> DataSource"""
        return _ogr.Driver_CopyDataSource(self, *args, **kwargs)

    def Open(self, *args, **kwargs):
        r"""Open(Driver self, char const * utf8_path, int update=0) -> DataSource"""

        _WarnIfUserHasNotSpecifiedIfUsingExceptions()


        return _ogr.Driver_Open(self, *args, **kwargs)


    def DeleteDataSource(self, *args):
        r"""DeleteDataSource(Driver self, char const * utf8_path) -> int"""
        return _ogr.Driver_DeleteDataSource(self, *args)

    def TestCapability(self, *args):
        r"""TestCapability(Driver self, char const * cap) -> bool"""
        return _ogr.Driver_TestCapability(self, *args)

    def GetName(self, *args):
        r"""GetName(Driver self) -> char const *"""
        return _ogr.Driver_GetName(self, *args)

    def Register(self, *args):
        r"""Register(Driver self)"""
        return _ogr.Driver_Register(self, *args)

    def Deregister(self, *args):
        r"""Deregister(Driver self)"""
        return _ogr.Driver_Deregister(self, *args)

# Register Driver in _ogr:
_ogr.Driver_swigregister(Driver)
class DataSource(MajorObject):
    r"""

    Python proxy of a vector :cpp:class:`GDALDataset`.

    Since GDAL 3.8, a DataSource can be used as a context manager.
    When exiting the context, the DataSource will be closed and
    features will be written to disk.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    name = property(_ogr.DataSource_name_get, doc=r"""name : p.q(const).char""")
    __swig_destroy__ = _ogr.delete_DataSource

    def Close(self, *args):
        r"""
        Close(DataSource self) -> CPLErr

        Closes opened dataset and releases allocated resources.

        This method can be used to force the dataset to close
        when one more references to the dataset are still
        reachable. If Close is never called, the dataset will
        be closed automatically during garbage collection.

        """
        val = _ogr.DataSource_Close(self, *args)

        self.thisown = 0
        self.this = None
        self._invalidate_layers()
        return val


        return val


    def GetRefCount(self, *args):
        r"""
        GetRefCount(DataSource self) -> int
        int
        OGR_DS_GetRefCount(OGRDataSourceH hDataSource) 
        """
        return _ogr.DataSource_GetRefCount(self, *args)

    def GetSummaryRefCount(self, *args):
        r"""
        GetSummaryRefCount(DataSource self) -> int
        int
        OGR_DS_GetSummaryRefCount(OGRDataSourceH hDataSource) 
        """
        return _ogr.DataSource_GetSummaryRefCount(self, *args)

    def GetLayerCount(self, *args):
        r"""
        GetLayerCount(DataSource self) -> int
        int
        OGR_DS_GetLayerCount(OGRDataSourceH hDS)

        Get the number of layers in this data source.

        Deprecated Use GDALDatasetGetLayerCount() in GDAL 2.0

        Parameters
        -----------
        hDS:
            handle to the data source from which to get the number of
            layers.

        Returns
        --------
        int:
            layer count.

        """
        return _ogr.DataSource_GetLayerCount(self, *args)

    def GetDriver(self, *args):
        r"""
        GetDriver(DataSource self) -> Driver
        OGRSFDriverH
        OGR_DS_GetDriver(OGRDataSourceH hDS)

        Returns the driver that the dataset was opened with.

        NOTE: Starting with GDAL 2.0, it is NOT safe to cast the returned
        handle to OGRSFDriver\*. If a C++ object is needed, the handle should
        be cast to GDALDriver\*.

        Deprecated Use GDALGetDatasetDriver() in GDAL 2.0

        Parameters
        -----------
        hDS:
            handle to the datasource

        Returns
        --------
        OGRSFDriverH:
            NULL if driver info is not available, or pointer to a driver owned by
            the OGRSFDriverManager.

        """
        return _ogr.DataSource_GetDriver(self, *args)

    def GetName(self, *args):
        r"""
        GetName(DataSource self) -> char const *
        const char\*
        OGR_DS_GetName(OGRDataSourceH hDS)

        Returns the name of the data source.

        This string should be sufficient to open the data source if passed to
        the same OGRSFDriver that this data source was opened with, but it
        need not be exactly the same string that was used to open the data
        source. Normally this is a filename.

        Deprecated Use GDALGetDescription() in GDAL 2.0

        Parameters
        -----------
        hDS:
            handle to the data source to get the name from.

        Returns
        --------
        str:
            pointer to an internal name string which should not be modified or
            freed by the caller.

        """
        return _ogr.DataSource_GetName(self, *args)

    def DeleteLayer(self, value) -> "OGRErr":
        """
        DeleteLayer(DataSource self, value) -> OGRErr

        Delete the indicated layer from the datasource.

        For more details: :c:func:`OGR_DS_DeleteLayer`

        Parameters
        -----------
        value: str | int
            index or name of the layer to delete.

        Returns
        -------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success, or :py:const:`osgeo.ogr.OGRERR_UNSUPPORTED_OPERATION` if deleting
            layers is not supported for this datasource.
        """

        if isinstance(value, str):
            for i in range(self.GetLayerCount()):
                lyr = self.GetLayer(i)
                if lyr.GetName() == value:
                    return _ogr.DataSource_DeleteLayer(self, i)
            raise ValueError("Layer %s not found to delete" % value)
        elif isinstance(value, int):
            return _ogr.DataSource_DeleteLayer(self, value)
        else:
            raise TypeError("Input %s is not of String or Int type" % type(value))



    def SyncToDisk(self, *args):
        r"""
        SyncToDisk(DataSource self) -> OGRErr
        OGRErr
        OGR_DS_SyncToDisk(OGRDataSourceH hDS)

        Flush pending changes to disk.

        See GDALDataset::FlushCache() 
        """
        return _ogr.DataSource_SyncToDisk(self, *args)

    def FlushCache(self, *args):
        r"""FlushCache(DataSource self)"""
        return _ogr.DataSource_FlushCache(self, *args)

    def CreateLayer(self, *args, **kwargs):
        r"""
        CreateLayer(DataSource self, char const * name, SpatialReference srs=None, OGRwkbGeometryType geom_type=wkbUnknown, char ** options=None) -> Layer
        OGRLayerH
        OGR_DS_CreateLayer(OGRDataSourceH hDS, const char \*pszName,
        OGRSpatialReferenceH hSpatialRef, OGRwkbGeometryType eType, char
        \*\*papszOptions)

        This function attempts to create a new layer on the data source with
        the indicated name, coordinate system, geometry type.

        The papszOptions argument can be used to control driver specific
        creation options. These options are normally documented in the format
        specific documentation.

        Deprecated Use GDALDatasetCreateLayer() in GDAL 2.0

        Parameters
        -----------
        hDS:
            The dataset handle.pszName:  the name for the new layer. This should ideally not match
            any existing layer on the datasource.
        hSpatialRef:
            handle to the coordinate system to use for the new
            layer, or NULL if no coordinate system is available. The driver might
            only increase the reference counter of the object to take ownership,
            and not make a full copy, so do not use OSRDestroySpatialReference(),
            but OSRRelease() instead when you are done with the object.
        eType:
            the geometry type for the layer. Use wkbUnknown if there are
            no constraints on the types geometry to be written.
        papszOptions:
            a StringList of name=value options. Options are driver
            specific, and driver information can be found at the following
            url:http://www.gdal.org/ogr_formats.html


        Returns
        --------
        OGRLayerH:
            NULL is returned on failure, or a new OGRLayer handle on success.

        """
        val = _ogr.DataSource_CreateLayer(self, *args, **kwargs)

        self._add_layer_ref(val)


        return val


    def CopyLayer(self, *args, **kwargs):
        r"""
        CopyLayer(DataSource self, Layer src_layer, char const * new_name, char ** options=None) -> Layer
        OGRLayerH
        OGR_DS_CopyLayer(OGRDataSourceH hDS, OGRLayerH hSrcLayer, const char
        \*pszNewName, char \*\*papszOptions)

        Duplicate an existing layer.

        This function creates a new layer, duplicate the field definitions of
        the source layer and then duplicate each features of the source layer.
        The papszOptions argument can be used to control driver specific
        creation options. These options are normally documented in the format
        specific documentation. The source layer may come from another
        dataset.

        Deprecated Use GDALDatasetCopyLayer() in GDAL 2.0

        Parameters
        -----------
        hDS:
            handle to the data source where to create the new layer
        hSrcLayer:
            handle to the source layer.
        pszNewName:
            the name of the layer to create.
        papszOptions:
            a StringList of name=value options. Options are driver
            specific.

        Returns
        -------
        OGRLayerH:
            a handle to the layer, or NULL if an error occurs.

        """
        val = _ogr.DataSource_CopyLayer(self, *args, **kwargs)

        self._add_layer_ref(val)


        return val


    def GetLayerByIndex(self, *args):
        r"""GetLayerByIndex(DataSource self, int index=0) -> Layer"""
        val = _ogr.DataSource_GetLayerByIndex(self, *args)

        self._add_layer_ref(val)


        return val


    def GetLayerByName(self, *args):
        r"""
        GetLayerByName(DataSource self, char const * layer_name) -> Layer
        OGRLayerH
        OGR_DS_GetLayerByName(OGRDataSourceH hDS, const char \*pszLayerName)

        Fetch a layer by name.

        The returned layer remains owned by the OGRDataSource and should not
        be deleted by the application.

        Deprecated Use GDALDatasetGetLayerByName() in GDAL 2.0

        Parameters
        -----------
        hDS:
            handle to the data source from which to get the layer.
        pszLayerName:
            Layer the layer name of the layer to fetch.


        Returns
        --------
        OGRLayerH:
            a handle to the layer, or NULL if the layer is not found or an error
            occurs.

        """
        val = _ogr.DataSource_GetLayerByName(self, *args)

        self._add_layer_ref(val)


        return val


    def TestCapability(self, *args):
        r"""
        TestCapability(DataSource self, char const * cap) -> bool
        int
        OGR_DS_TestCapability(OGRDataSourceH hDS, const char \*pszCapability)

        Test if capability is available.

        One of the following data source capability names can be passed into
        this function, and a TRUE or FALSE value will be returned indicating
        whether or not the capability is available for this object.

        ODsCCreateLayer: True if this datasource can create new layers.

        ODsCDeleteLayer: True if this datasource can delete existing layers.

        ODsCCreateGeomFieldAfterCreateLayer: True if the layers of this
        datasource support CreateGeomField() just after layer creation.

        ODsCCurveGeometries: True if this datasource supports writing curve
        geometries. (GDAL 2.0). In that case, OLCCurveGeometries must also be
        declared in layers of that dataset.

        The #define macro forms of the capability names should be used in
        preference to the strings themselves to avoid misspelling.

        Deprecated Use GDALDatasetTestCapability() in GDAL 2.0

        Parameters
        -----------
        hDS:
            handle to the data source against which to test the capability.
        pszCapability:
            the capability to test.

        Returns
        --------
        int:
            TRUE if capability available otherwise FALSE.

        """
        return _ogr.DataSource_TestCapability(self, *args)

    def ExecuteSQL(self, statement, spatialFilter=None, dialect="", keep_ref_on_ds=False):
        """ExecuteSQL(self, statement, spatialFilter: ogr.Geometry = None, dialect: Optional[str] = "", keep_ref_on_ds=False) -> ogr.Layer

        Execute a SQL statement against the dataset

        The result of a SQL query is:
          - None (or an exception if exceptions are enabled) for statements
            that are in error
          - or None for statements that have no results set,
          - or a ogr.Layer handle representing a results set from the query.

        Note that this ogr.Layer is in addition to the layers in the data store
        and must be released with ReleaseResultSet() before the data source is closed
        (destroyed).

        Starting with GDAL 3.7, this method can also be used as a context manager,
        as a convenient way of automatically releasing the returned result layer.

        For more information on the SQL dialect supported internally by OGR
        review the OGR SQL document (:ref:`ogr_sql_sqlite_dialect`)
        Some drivers (i.e. Oracle and PostGIS) pass the SQL directly through to the
        underlying RDBMS.

        The SQLITE dialect can also be used (:ref:`sql_sqlite_dialect`)

        Parameters
        ----------
        statement:
            the SQL statement to execute (e.g "SELECT * FROM layer")
        spatialFilter:
            a geometry which represents a spatial filter. Can be None
        dialect:
            allows control of the statement dialect. If set to None or empty string,
            the OGR SQL engine will be used, except for RDBMS drivers that will
            use their dedicated SQL engine, unless OGRSQL is explicitly passed as
            the dialect. The SQLITE dialect can also be used.
        keep_ref_on_ds:
            whether the returned layer should keep a (strong) reference on
            the current dataset. Cf example 2 for a use case.

        Returns
        -------
        ogr.Layer:
            a ogr.Layer containing the results of the query, that will be
            automatically released when the context manager goes out of scope.

        Examples
        --------
        1. Use as a context manager:

        >>> with ds.ExecuteSQL("SELECT * FROM layer") as lyr:
        ...     print(lyr.GetFeatureCount())

        2. Use keep_ref_on_ds=True to return an object that keeps a reference to its dataset:

        >>> def get_sql_lyr():
        ...     return gdal.OpenEx("test.shp").ExecuteSQL("SELECT * FROM test", keep_ref_on_ds=True)
        ...
        ... with get_sql_lyr() as lyr:
        ...     print(lyr.GetFeatureCount())
        """

        sql_lyr = _ogr.DataSource_ExecuteSQL(self, statement, spatialFilter, dialect)
        if sql_lyr:
            import weakref
            sql_lyr._to_release = True
            sql_lyr._dataset_weak_ref = weakref.ref(self)
            if keep_ref_on_ds:
                sql_lyr._dataset_strong_ref = self
        return sql_lyr



    def AbortSQL(self, *args):
        r"""AbortSQL(DataSource self) -> OGRErr"""
        return _ogr.DataSource_AbortSQL(self, *args)

    def ReleaseResultSet(self, sql_lyr):
        """ReleaseResultSet(self, sql_lyr: ogr.Layer)

        Release ogr.Layer returned by ExecuteSQL() (when not called as an execution manager)

        The sql_lyr object is invalidated after this call.

        Parameters
        ----------
        sql_lyr:
            ogr.Layer got with ExecuteSQL()
        """

        if sql_lyr and not hasattr(sql_lyr, "_to_release"):
            raise Exception("This layer was not returned by ExecuteSQL() and should not be released with ReleaseResultSet()")
        _ogr.DataSource_ReleaseResultSet(self, sql_lyr)
    # Invalidates the layer
        if sql_lyr:
            sql_lyr.thisown = None
            sql_lyr.this = None



    def GetStyleTable(self, *args):
        r"""
        GetStyleTable(DataSource self) -> StyleTable
        OGRStyleTableH
        OGR_DS_GetStyleTable(OGRDataSourceH hDS)

        Get style table. 
        """
        return _ogr.DataSource_GetStyleTable(self, *args)

    def SetStyleTable(self, *args):
        r"""
        SetStyleTable(DataSource self, StyleTable table)
        void
        OGR_DS_SetStyleTable(OGRDataSourceH hDS, OGRStyleTableH hStyleTable)

        Set style table. 
        """
        return _ogr.DataSource_SetStyleTable(self, *args)

    def StartTransaction(self, *args, **kwargs):
        r"""StartTransaction(DataSource self, int force=FALSE) -> OGRErr"""
        return _ogr.DataSource_StartTransaction(self, *args, **kwargs)

    def CommitTransaction(self, *args):
        r"""CommitTransaction(DataSource self) -> OGRErr"""
        return _ogr.DataSource_CommitTransaction(self, *args)

    def RollbackTransaction(self, *args):
        r"""RollbackTransaction(DataSource self) -> OGRErr"""
        return _ogr.DataSource_RollbackTransaction(self, *args)


    def Destroy(self):
      "Once called, self has effectively been destroyed.  Do not access. For backwards compatibility only"
      _ogr.delete_DataSource(self)
      self.thisown = 0
      self.this = None
      self._invalidate_layers()

    def Release(self):
      "Once called, self has effectively been destroyed.  Do not access. For backwards compatibility only"
      _ogr.delete_DataSource(self)
      self.thisown = 0
      self.this = None
      self._invalidate_layers()

    def Reference(self):
      "For backwards compatibility only."
      return self.Reference()

    def Dereference(self):
      "For backwards compatibility only."
      self.Dereference()

    def __len__(self):
        """Returns the number of layers on the datasource"""
        return self.GetLayerCount()

    def __enter__(self):
        return self

    def __exit__(self, *args):
        self.Close()

    def __del__(self):
        self._invalidate_layers()

    def __getitem__(self, value):
        """Support dictionary, list, and slice -like access to the datasource.
        ds[0] would return the first layer on the datasource.
        ds['aname'] would return the layer named "aname".
        ds[0:4] would return a list of the first four layers."""
        if isinstance(value, slice):
            output = []
            step = value.step if value.step else 1
            for i in range(value.start, value.stop, step):
                lyr = self.GetLayer(i)
                if lyr is None:
                    return output
                output.append(lyr)
            return output
        if isinstance(value, int):
            if value > len(self) - 1:
                raise IndexError
            return self.GetLayer(value)
        elif isinstance(value, str):
            return self.GetLayer(value)
        else:
            raise TypeError('Input %s is not of String or Int type' % type(value))

    def GetLayer(self, iLayer=0):
        """Return the layer given an index or a name"""

        _WarnIfUserHasNotSpecifiedIfUsingExceptions()

        if isinstance(iLayer, str):
            return self.GetLayerByName(str(iLayer))
        elif isinstance(iLayer, int):
            return self.GetLayerByIndex(iLayer)
        else:
            raise TypeError("Input %s is not of String or Int type" % type(iLayer))

    def _invalidate_layers(self, lyr = None):
        if hasattr(self, '_layer_references'):
            for lyr in self._layer_references:
                lyr.this = None


    def _add_layer_ref(self, lyr):
        if not lyr:
            return

        if not hasattr(self, '_layer_references'):
            import weakref

            self._layer_references = weakref.WeakSet()

        self._layer_references.add(lyr)


# Register DataSource in _ogr:
_ogr.DataSource_swigregister(DataSource)
class ArrowArray(object):
    r"""Proxy of C++ ArrowArray class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(ArrowArray self) -> ArrowArray"""
        _ogr.ArrowArray_swiginit(self, _ogr.new_ArrowArray(*args))
    __swig_destroy__ = _ogr.delete_ArrowArray

    def _getPtr(self, *args):
        r"""_getPtr(ArrowArray self) -> VoidPtrAsLong"""
        return _ogr.ArrowArray__getPtr(self, *args)

    def GetChildrenCount(self, *args):
        r"""GetChildrenCount(ArrowArray self) -> GIntBig"""
        return _ogr.ArrowArray_GetChildrenCount(self, *args)

    def GetLength(self, *args):
        r"""GetLength(ArrowArray self) -> GIntBig"""
        return _ogr.ArrowArray_GetLength(self, *args)

# Register ArrowArray in _ogr:
_ogr.ArrowArray_swigregister(ArrowArray)
class ArrowSchema(object):
    r"""Proxy of C++ ArrowSchema class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(ArrowSchema self) -> ArrowSchema"""
        _ogr.ArrowSchema_swiginit(self, _ogr.new_ArrowSchema(*args))
    __swig_destroy__ = _ogr.delete_ArrowSchema

    def _getPtr(self, *args):
        r"""_getPtr(ArrowSchema self) -> VoidPtrAsLong"""
        return _ogr.ArrowSchema__getPtr(self, *args)

    def GetName(self, *args):
        r"""GetName(ArrowSchema self) -> char const *"""
        return _ogr.ArrowSchema_GetName(self, *args)

    def GetChildrenCount(self, *args):
        r"""GetChildrenCount(ArrowSchema self) -> GIntBig"""
        return _ogr.ArrowSchema_GetChildrenCount(self, *args)

    def GetChild(self, *args):
        r"""GetChild(ArrowSchema self, int iChild) -> ArrowSchema"""
        return _ogr.ArrowSchema_GetChild(self, *args)

# Register ArrowSchema in _ogr:
_ogr.ArrowSchema_swigregister(ArrowSchema)
class ArrowArrayStream(object):
    r"""Proxy of C++ ArrowArrayStream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _ogr.delete_ArrowArrayStream

    def GetSchema(self, *args):
        r"""GetSchema(ArrowArrayStream self) -> ArrowSchema"""
        return _ogr.ArrowArrayStream_GetSchema(self, *args)

    def GetNextRecordBatch(self, *args):
        r"""GetNextRecordBatch(ArrowArrayStream self, char ** options=None) -> ArrowArray"""
        return _ogr.ArrowArrayStream_GetNextRecordBatch(self, *args)

# Register ArrowArrayStream in _ogr:
_ogr.ArrowArrayStream_swigregister(ArrowArrayStream)
class Layer(MajorObject):
    r"""Proxy of C++ OGRLayerShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Rename(self, *args):
        r"""Rename(Layer self, char const * new_name) -> OGRErr"""
        return _ogr.Layer_Rename(self, *args)

    def GetRefCount(self, *args):
        r"""
        GetRefCount(Layer self) -> int

        For more details: :cpp:func:`OGR_L_GetRefCount`

        """
        return _ogr.Layer_GetRefCount(self, *args)

    def SetSpatialFilter(self, *args):
        r"""
        SetSpatialFilter(Layer self, Geometry filter)
        SetSpatialFilter(Layer self, int iGeomField, Geometry filter)

        Set a new spatial filter.

        For more details:

        - :cpp:func:`OGR_L_SetSpatialFilter`
        - :cpp:func:`OGR_L_SetSpatialFilterEx`

        Parameters
        -----------
        iGeomField: int, optional
            index of the geometry field on which the spatial filter operates.
        filter: Geometry
            The geometry to use as a filtering region. None may
            be passed indicating that the current spatial filter should be
            cleared, but no new one instituted.

        """
        return _ogr.Layer_SetSpatialFilter(self, *args)

    def SetSpatialFilterRect(self, *args):
        r"""
        SetSpatialFilterRect(Layer self, double minx, double miny, double maxx, double maxy)
        SetSpatialFilterRect(Layer self, int iGeomField, double minx, double miny, double maxx, double maxy)

        Set a new rectangular spatial filter.

        For more details:

        - :cpp:func:`OGR_L_SetSpatialFilterRect`
        - :cpp:func:`OGR_L_SetSpatialFilterRectEx`

        Parameters
        -----------
        iGeomField: int, optional
            index of the geometry field on which the spatial filter operates.
        minx: float
            the minimum X coordinate for the rectangular region.
        miny: float
            the minimum Y coordinate for the rectangular region.
        maxx: float
            the maximum X coordinate for the rectangular region.
        maxy: float
            the maximum Y coordinate for the rectangular region.

        """
        return _ogr.Layer_SetSpatialFilterRect(self, *args)

    def GetSpatialFilter(self, *args):
        r"""
        GetSpatialFilter(Layer self) -> Geometry

        This function returns the current spatial filter for this layer.

        For more details: :cpp:func:`OGR_L_GetSpatialFilter`

        Returns
        --------
        Geometry:
            The spatial filter geometry.

        """
        return _ogr.Layer_GetSpatialFilter(self, *args)

    def SetAttributeFilter(self, *args):
        r"""
        SetAttributeFilter(Layer self, char * filter_string) -> OGRErr

        Set a new attribute query.

        For more details: :cpp:func:`OGR_L_SetAttributeFilter`

        Parameters
        -----------
        filter_string: str
            query in restricted SQL WHERE format, or None to clear the
            current query.

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` if successfully installed,
            or an error code if the query expression is in error,
            or some other failure occurs.

        """
        return _ogr.Layer_SetAttributeFilter(self, *args)

    def ResetReading(self, *args):
        r"""
        ResetReading(Layer self)

        Reset feature reading to start on the first feature.

        For more details: :cpp:func:`OGR_L_ResetReading`

        """
        return _ogr.Layer_ResetReading(self, *args)

    def GetName(self, *args):
        r"""
        GetName(Layer self) -> char const *

        Return the layer name.

        For more details: :cpp:func:`OGR_L_GetName`

        Returns
        --------
        str:
            The layer name

        """
        return _ogr.Layer_GetName(self, *args)

    def GetGeomType(self, *args):
        r"""
        GetGeomType(Layer self) -> OGRwkbGeometryType

        Return the layer geometry type.

        For more details: :cpp:func:`OGR_L_GetGeomType`

        Returns
        --------
        int:
            The geometry type code. The types can be found with
            'osgeo.ogr.wkb' prefix. For example :py:const:`osgeo.ogr.wkbPolygon`.

        """
        return _ogr.Layer_GetGeomType(self, *args)

    def GetGeometryColumn(self, *args):
        r"""
        GetGeometryColumn(Layer self) -> char const *

        This method returns the name of the underlying database column being
        used as the geometry column, or '' if not supported.

        For more details: :cpp:func:`OGR_L_GetGeometryColumn`

        Returns
        --------
        str:
            geometry column name.

        """
        return _ogr.Layer_GetGeometryColumn(self, *args)

    def GetFIDColumn(self, *args):
        r"""
        GetFIDColumn(Layer self) -> char const *

        This method returns the name of the underlying database column being
        used as the FID column, or '' if not supported.

        For more details: :cpp:func:`OGR_L_GetFIDColumn`

        Returns
        --------
        str:
            fid column name.

        """
        return _ogr.Layer_GetFIDColumn(self, *args)

    def GetFeature(self, *args):
        r"""
        GetFeature(Layer self, GIntBig fid) -> Feature

        Fetch a feature by its identifier.

        For more details: :cpp:func:`OGR_L_GetFeature`

        Use :py:func:`TestCapability` with (:py:const:`osgeo.ogr.OLCRandomRead`)
        to establish if this layer supports efficient random access reading via
        :py:func:`GetFeature`; However, the call should always work if the feature exists.

        Sequential reads (with :py:func:`GetNextFeature`) are generally
        considered interrupted by a :py:func:`GetFeature` call.

        Parameters
        -----------
        fid: int
            The feature id of the feature to read.

        Returns
        --------
        Feature:
            A new feature now owned by the caller, or None on failure.
            The returned feature should be deleted with :py:func:`Destroy`.

        """
        return _ogr.Layer_GetFeature(self, *args)

    def GetNextFeature(self, *args):
        r"""
        GetNextFeature(Layer self) -> Feature

        Fetch the next available feature from this layer.

        For more details: :cpp:func:`OGR_L_GetNextFeature`

        Returns
        --------
        Feature:
            A feature or None if no more features are available.

        """
        return _ogr.Layer_GetNextFeature(self, *args)

    def SetNextByIndex(self, *args):
        r"""
        SetNextByIndex(Layer self, GIntBig new_index) -> OGRErr

        Move read cursor to the nIndex'th feature in the current resultset.

        For more details: :cpp:func:`OGR_L_SetNextByIndex`

        Parameters
        -----------
        new_index: int
            The index indicating how many steps into the result set to seek.

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success or an error code.

        """
        return _ogr.Layer_SetNextByIndex(self, *args)

    def SetFeature(self, *args):
        r"""
        SetFeature(Layer self, Feature feature) -> OGRErr

        Rewrite an existing feature.

        For more details: :cpp:func:`OGR_L_SetFeature`

        To set a feature, but create it if it doesn't exist see :py:meth:`.Layer.UpsertFeature`.

        Parameters
        -----------
        feature: Feature
            The feature to write.

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` if the operation works,
            otherwise an appropriate error code
            (e.g :py:const:`osgeo.ogr.OGRERR_NON_EXISTING_FEATURE` if the
            feature does not exist).

        """
        return _ogr.Layer_SetFeature(self, *args)

    def CreateFeature(self, *args):
        r"""
        CreateFeature(Layer self, Feature feature) -> OGRErr

        Create and write a new feature within a layer.

        For more details: :cpp:func:`OGR_L_CreateFeature`

        To create a feature, but set it if it exists see :py:meth:`.Layer.UpsertFeature`.

        Parameters
        -----------
        feature: Feature
            The feature to write to disk.

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success.

        """
        return _ogr.Layer_CreateFeature(self, *args)

    def UpsertFeature(self, *args):
        r"""
        UpsertFeature(Layer self, Feature feature) -> OGRErr

        Rewrite an existing feature or create a new feature within a layer.

        For more details: :cpp:func:`OGR_L_UpsertFeature`

        Parameters
        -----------
        feature: Feature
            The feature to write to disk.

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success.

        """
        return _ogr.Layer_UpsertFeature(self, *args)

    def UpdateFeature(self, *args):
        r"""UpdateFeature(Layer self, Feature feature, int nUpdatedFieldsCount, int nUpdatedGeomFieldsCount, bool bUpdateStyleString) -> OGRErr"""
        return _ogr.Layer_UpdateFeature(self, *args)

    def DeleteFeature(self, *args):
        r"""
        DeleteFeature(Layer self, GIntBig fid) -> OGRErr

        Delete feature from layer.

        For more details: :cpp:func:`OGR_L_DeleteFeature`

        Parameters
        -----------
        fid: int
            The feature id to be deleted from the layer

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` if the operation works,
            otherwise an appropriate error code
            (e.g :py:const:`osgeo.ogr.OGRERR_NON_EXISTING_FEATURE`)
            if the feature does not exist.

        """
        return _ogr.Layer_DeleteFeature(self, *args)

    def SyncToDisk(self, *args):
        r"""
        SyncToDisk(Layer self) -> OGRErr

        Flush pending changes to disk.

        For more details: :cpp:func:`OGR_L_SyncToDisk`

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` if no error occurs
            (even if nothing is done) or an error code.

        """
        return _ogr.Layer_SyncToDisk(self, *args)

    def GetLayerDefn(self, *args):
        r"""
        GetLayerDefn(Layer self) -> FeatureDefn

        Fetch the schema information for this layer.

        For more details: :cpp:func:`OGR_L_GetLayerDefn`

        Returns
        --------
        FeatureDefn:
            The feature definition.

        """
        return _ogr.Layer_GetLayerDefn(self, *args)

    def GetFeatureCount(self, *args, **kwargs):
        r"""
        GetFeatureCount(Layer self, int force=1) -> GIntBig

        Fetch the feature count in this layer.

        For more details: :cpp:func:`OGR_L_GetFeatureCount`

        Parameters
        -----------
        force: int
            Flag indicating whether the count should be computed even if
            it is expensive.

        Returns
        --------
        int:
            Feature count, -1 if count not known.

        """
        return _ogr.Layer_GetFeatureCount(self, *args, **kwargs)

    def GetExtent(self, *args, **kwargs):
        r"""
        GetExtent(Layer self, int force=1, int can_return_null=0, int geom_field=0)

        Fetch the extent of this layer.

        For more details:

        - :cpp:func:`OGR_L_GetExtent`
        - :cpp:func:`OGR_L_GetExtentEx`

        .. warning:: Check the return order of the bounds.

        Parameters
        -----------
        force: int, default=False
            Flag indicating whether the extent should be computed even if
            it is expensive.
        can_return_null: int, default=False
            Whether None can be returned in the response.
        geom_field: int, default=0
            Ithe index of the geometry field on which to compute the extent.
            Can be iterated over using :py:func:`range` and :py:func:`GetGeomFieldCount`.

        Returns
        --------
        minx: float
        maxx: float
        miny: float
        maxy: float

        """
        return _ogr.Layer_GetExtent(self, *args, **kwargs)

    def TestCapability(self, *args):
        r"""
        TestCapability(Layer self, char const * cap) -> bool

        Test if this layer supported the named capability.

        For more details: :cpp:func:`OGR_L_TestCapability`

        Parameters
        -----------
        cap: str
            The name of the capability to test. These can
            be found in the `osgeo.ogr` namespace. For example,
            :py:const:`osgeo.ogr.OLCRandomRead`.

        Returns
        --------
        int:
            True if the layer has the requested capability, or False otherwise.
            Will return False for any unrecognized capabilities.

        """
        return _ogr.Layer_TestCapability(self, *args)

    def CreateField(self, *args, **kwargs):
        r"""
        CreateField(Layer self, FieldDefn field_def, int approx_ok=1) -> OGRErr

        Create a new field on a layer.

        For more details: :cpp:func:`OGR_L_CreateField`

        Parameters
        -----------
        field_def: FieldDefn
            The field definition to write to disk.
        approx_ok: bool, default=True
            If True, the field may be created in a slightly different
            form depending on the limitations of the format driver.

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success.

        """
        return _ogr.Layer_CreateField(self, *args, **kwargs)

    def DeleteField(self, *args):
        r"""
        DeleteField(Layer self, int iField) -> OGRErr

        Delete an existing field on a layer.

        For more details: :cpp:func:`OGR_L_DeleteField`

        Parameters
        -----------
        iField: int
            index of the field to delete.

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success.

        """
        return _ogr.Layer_DeleteField(self, *args)

    def ReorderField(self, *args):
        r"""
        ReorderField(Layer self, int iOldFieldPos, int iNewFieldPos) -> OGRErr

        Reorder an existing field on a layer.

        For more details: :cpp:func:`OGR_L_ReorderField`

        Parameters
        -----------
        iOldFieldPos: int
            previous position of the field to move. Must be in the
            range [0,GetFieldCount()-1].
        iNewFieldPos: int
            new position of the field to move. Must be in the range
            [0,GetFieldCount()-1].

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success.

        """
        return _ogr.Layer_ReorderField(self, *args)

    def ReorderFields(self, *args):
        r"""
        ReorderFields(Layer self, int nList) -> OGRErr

        Reorder all the fields of a layer.

        For more details: :cpp:func:`OGR_L_ReorderFields`

        Parameters
        -----------
        nList: list[int]
            A list of GetLayerDefn().GetFieldCount()
            elements which is a permutation of
            [0, GetLayerDefn().GetFieldCount()-1].

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success.

        """
        return _ogr.Layer_ReorderFields(self, *args)

    def AlterFieldDefn(self, *args):
        r"""
        AlterFieldDefn(Layer self, int iField, FieldDefn field_def, int nFlags) -> OGRErr

        Alter the definition of an existing field on a layer.

        For more details: :cpp:func:`OGR_L_AlterFieldDefn`

        Parameters
        -----------
        iField: int
            index of the field whose definition must be altered.
        field_def: FieldDefn
            new field definition
        nFlags: int
            Combination of
            :py:const:`osgeo.ogr.ALTER_NAME_FLAG`,
            :py:const:`osgeo.ogr.ALTER_TYPE_FLAG`,
            :py:const:`osgeo.ogr.ALTER_WIDTH_PRECISION_FLAG`,
            :py:const:`osgeo.ogr.ALTER_NULLABLE_FLAG` and
            :py:const:`osgeo.ogr.ALTER_DEFAULT_FLAG`
            to indicate which of the name and/or type and/or width and precision
            fields and/or nullability from the new field definition must be taken
            into account.

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success.

        """
        return _ogr.Layer_AlterFieldDefn(self, *args)

    def AlterGeomFieldDefn(self, *args):
        r"""AlterGeomFieldDefn(Layer self, int iGeomField, GeomFieldDefn field_def, int nFlags) -> OGRErr"""
        return _ogr.Layer_AlterGeomFieldDefn(self, *args)

    def CreateGeomField(self, *args, **kwargs):
        r"""
        CreateGeomField(Layer self, GeomFieldDefn field_def, int approx_ok=1) -> OGRErr

        Create a new geometry field on a layer.

        For more details: :cpp:func:`OGR_L_CreateGeomField`

        Parameters
        -----------
        field_def: GeomFieldDefn
            The geometry field definition to write to disk.
        approx_ok: bool, default=True
            If True, the field may be created in a slightly different
            form depending on the limitations of the format driver.

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success.

        """
        return _ogr.Layer_CreateGeomField(self, *args, **kwargs)

    def StartTransaction(self, *args):
        r"""
        StartTransaction(Layer self) -> OGRErr

        For datasources which support transactions, this creates a transaction.

        For more details: :cpp:func:`OGR_L_StartTransaction`

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success.

        """
        return _ogr.Layer_StartTransaction(self, *args)

    def CommitTransaction(self, *args):
        r"""
        CommitTransaction(Layer self) -> OGRErr

        For datasources which support transactions, this commits a transaction.

        For more details: :cpp:func:`OGR_L_CommitTransaction`

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success.

        """
        return _ogr.Layer_CommitTransaction(self, *args)

    def RollbackTransaction(self, *args):
        r"""
        RollbackTransaction(Layer self) -> OGRErr

        Roll back a datasource to its state before the start of the current transaction.

        For more details: :cpp:func:`OGR_L_RollbackTransaction`

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success.

        """
        return _ogr.Layer_RollbackTransaction(self, *args)

    def FindFieldIndex(self, *args):
        r"""
        FindFieldIndex(Layer self, char const * pszFieldName, int bExactMatch) -> int

        Find the index of field in a layer.

        For more details: :cpp:func:`OGR_L_FindFieldIndex`

        Returns
        --------
        int:
            field index, or -1 if the field doesn't exist

        """
        return _ogr.Layer_FindFieldIndex(self, *args)

    def GetSpatialRef(self, *args):
        r"""
        GetSpatialRef(Layer self) -> SpatialReference

        Fetch the spatial reference system for this layer.

        For more details: :cpp:func:`OGR_L_GetSpatialRef`

        Returns
        --------
        SpatialReference:
            spatial reference, or None if there isn't one.

        """
        return _ogr.Layer_GetSpatialRef(self, *args)

    def GetFeaturesRead(self, *args):
        r"""
        GetFeaturesRead(Layer self) -> GIntBig

        For more details: :cpp:func:`OGR_L_GetFeaturesRead`

        """
        return _ogr.Layer_GetFeaturesRead(self, *args)

    def SetIgnoredFields(self, *args):
        r"""
        SetIgnoredFields(Layer self, char const ** options) -> OGRErr

        Set which fields can be omitted when retrieving features from the
        layer.

        For more details: :cpp:func:`OGR_L_SetIgnoredFields`

        Parameters
        -----------
        options: list[str]
            A list of field names.
            If an empty list is passed, the ignored list is cleared.

        Returns
        -------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` if all field names have been resolved
            (even if the driver does not support this method)

        """
        return _ogr.Layer_SetIgnoredFields(self, *args)

    def Intersection(self, *args, **kwargs):
        r"""
        Intersection(Layer self, Layer method_layer, Layer result_layer, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> OGRErr

        Intersection of two layers.

        For more details: :cpp:func:`OGR_L_Intersection`

        Parameters
        -----------
        method_layer: Layer
            the method layer. Should not be None.
        result_layer: Layer
            the layer where the features resulting from the
            operation are inserted. Should not be None.
        options: list[str], optional
            List of options (empty list is allowed). For example ["PROMOTE_TO_MULTI=YES"].
        callback: Callable, optional
            a GDALProgressFunc() compatible callback function for
            reporting progress or None.
        callback_data:
            Argument to be passed to 'callback'. May be None.

        Returns
        -------
        int:
            An error code if there was an error or the execution was interrupted,
            :py:const:`osgeo.ogr.OGRERR_NONE` otherwise.

        """
        return _ogr.Layer_Intersection(self, *args, **kwargs)

    def Union(self, *args, **kwargs):
        r"""
        Union(Layer self, Layer method_layer, Layer result_layer, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> OGRErr

        Union of two layers.

        For more details: :cpp:func:`OGR_L_Union`

        The first geometry field is always used.

        Parameters
        -----------
        method_layer: Layer
            the method layer. Should not be None.
        result_layer: Layer
            the layer where the features resulting from the
            operation are inserted. Should not be None.
        options: list[str], optional
            List of options (empty list is allowed). For example ["PROMOTE_TO_MULTI=YES"].
        callback: Callable, optional
            a GDALProgressFunc() compatible callback function for
            reporting progress or None.
        callback_data:
            Argument to be passed to 'callback'. May be None.

        Returns
        -------
        int:
            An error code if there was an error or the execution was interrupted,
            :py:const:`osgeo.ogr.OGRERR_NONE` otherwise.

        """
        return _ogr.Layer_Union(self, *args, **kwargs)

    def SymDifference(self, *args, **kwargs):
        r"""
        SymDifference(Layer self, Layer method_layer, Layer result_layer, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> OGRErr

        Symmetrical difference of two layers.

        For more details: :cpp:func:`OGR_L_SymDifference`

        Parameters
        -----------
        method_layer: Layer
            the method layer. Should not be None.
        result_layer: Layer
            the layer where the features resulting from the
            operation are inserted. Should not be None.
        options: list[str], optional
            List of options (empty list is allowed). For example ["PROMOTE_TO_MULTI=YES"].
        callback: Callable, optional
            a GDALProgressFunc() compatible callback function for
            reporting progress or None.
        callback_data:
            Argument to be passed to 'callback'. May be None.

        Returns
        -------
        int:
            An error code if there was an error or the execution was interrupted,
            :py:const:`osgeo.ogr.OGRERR_NONE` otherwise.

        """
        return _ogr.Layer_SymDifference(self, *args, **kwargs)

    def Identity(self, *args, **kwargs):
        r"""
        Identity(Layer self, Layer method_layer, Layer result_layer, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> OGRErr

        Identify the features of this layer with the ones from the identity layer.

        For more details: :cpp:func:`OGR_L_Identity`

        Parameters
        -----------
        method_layer: Layer
            the method layer. Should not be None.
        result_layer: Layer
            the layer where the features resulting from the
            operation are inserted. Should not be None.
        options: list[str], optional
            List of options (empty list is allowed). For example ["PROMOTE_TO_MULTI=YES"].
        callback: Callable, optional
            a GDALProgressFunc() compatible callback function for
            reporting progress or None.
        callback_data:
            Argument to be passed to 'callback'. May be None.

        Returns
        -------
        int:
            An error code if there was an error or the execution was interrupted,
            :py:const:`osgeo.ogr.OGRERR_NONE` otherwise.

        """
        return _ogr.Layer_Identity(self, *args, **kwargs)

    def Update(self, *args, **kwargs):
        r"""
        Update(Layer self, Layer method_layer, Layer result_layer, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> OGRErr

        Update this layer with features from the update layer.

        For more details: :cpp:func:`OGR_L_Update`

        Parameters
        -----------
        method_layer: Layer
            the method layer. Should not be None.
        result_layer: Layer
            the layer where the features resulting from the
            operation are inserted. Should not be None.
        options: list[str], optional
            List of options (empty list is allowed). For example ["PROMOTE_TO_MULTI=YES"].
        callback: Callable, optional
            a GDALProgressFunc() compatible callback function for
            reporting progress or None.
        callback_data:
            Argument to be passed to 'callback'. May be None.

        Returns
        -------
        int:
            An error code if there was an error or the execution was interrupted,
            :py:const:`osgeo.ogr.OGRERR_NONE` otherwise.

        """
        return _ogr.Layer_Update(self, *args, **kwargs)

    def Clip(self, *args, **kwargs):
        r"""
        Clip(Layer self, Layer method_layer, Layer result_layer, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> OGRErr

        Clip off areas that are not covered by the method layer.

        For more details: :cpp:func:`OGR_L_Clip`

        Parameters
        -----------
        method_layer: Layer
            the method layer. Should not be None.
        result_layer: Layer
            the layer where the features resulting from the
            operation are inserted. Should not be None.
        options: list[str], optional
            List of options (empty list is allowed). For example ["PROMOTE_TO_MULTI=YES"].
        callback: Callable, optional
            a GDALProgressFunc() compatible callback function for
            reporting progress or None.
        callback_data:
            Argument to be passed to 'callback'. May be None.

        Returns
        -------
        int:
            An error code if there was an error or the execution was interrupted,
            :py:const:`osgeo.ogr.OGRERR_NONE` otherwise.

        """
        return _ogr.Layer_Clip(self, *args, **kwargs)

    def Erase(self, *args, **kwargs):
        r"""
        Erase(Layer self, Layer method_layer, Layer result_layer, char ** options=None, GDALProgressFunc callback=0, void * callback_data=None) -> OGRErr

        Remove areas that are covered by the method layer.

        For more details: :cpp:func:`OGR_L_Erase`

        Parameters
        -----------
        method_layer: Layer
            the method layer. Should not be None.
        result_layer: Layer
            the layer where the features resulting from the
            operation are inserted. Should not be None.
        options: list[str], optional
            List of options (empty list is allowed). For example ["PROMOTE_TO_MULTI=YES"].
        callback: Callable, optional
            a GDALProgressFunc() compatible callback function for
            reporting progress or None.
        callback_data:
            Argument to be passed to 'callback'. May be None.

        Returns
        -------
        int:
            An error code if there was an error or the execution was interrupted,
            :py:const:`osgeo.ogr.OGRERR_NONE` otherwise.

        """
        return _ogr.Layer_Erase(self, *args, **kwargs)

    def GetStyleTable(self, *args):
        r"""
        GetStyleTable(Layer self) -> StyleTable

        Get style table.

        For more details: :cpp:func:`OGR_L_GetStyleTable`

        """
        return _ogr.Layer_GetStyleTable(self, *args)

    def SetStyleTable(self, *args):
        r"""
        SetStyleTable(Layer self, StyleTable table)

        Set style table.

        For more details: :cpp:func:`OGR_L_SetStyleTable`

        """
        return _ogr.Layer_SetStyleTable(self, *args)

    def GetArrowStream(self, *args):
        r"""GetArrowStream(Layer self, char ** options=None) -> ArrowArrayStream"""
        return _ogr.Layer_GetArrowStream(self, *args)

    def IsArrowSchemaSupported(self, *args):
        r"""IsArrowSchemaSupported(Layer self, ArrowSchema schema, char ** options=None)"""
        return _ogr.Layer_IsArrowSchemaSupported(self, *args)

    def CreateFieldFromArrowSchema(self, *args):
        r"""CreateFieldFromArrowSchema(Layer self, ArrowSchema schema, char ** options=None) -> OGRErr"""
        return _ogr.Layer_CreateFieldFromArrowSchema(self, *args)

    def WriteArrowBatch(self, *args):
        r"""WriteArrowBatch(Layer self, ArrowSchema schema, ArrowArray array, char ** options=None) -> OGRErr"""
        return _ogr.Layer_WriteArrowBatch(self, *args)

    def GetGeometryTypes(self, *args, **kwargs):
        r"""
        GetGeometryTypes(Layer self, int geom_field=0, int flags=0, GDALProgressFunc callback=0, void * callback_data=None)

        Get actual geometry types found in features.

        For more details: :cpp:func:`OGR_L_GetGeometryTypes`

        Parameters
        -----------
        geom_field: int, optional
            index of the geometry field
        flags: int, optional
            0, or a combination of :py:const:`osgeo.ogr.GGT_COUNT_NOT_NEEDED`,
            :py:const:`osgeo.ogr.GGT_STOP_IF_MIXED` and
            :py:const:`osgeo.ogr.GGT_GEOMCOLLECTIONZ_TINZ`
        callback: Callable, optional
            a GDALProgressFunc() compatible callback function for
            cancellation or None.
        callback_data:
            Argument to be passed to 'callback'. May be None.

        Returns
        -------
        dict:
            A dictionary whose keys are :py:const:`osgeo.ogr.wkbXXXX` constants and
            values the corresponding number of geometries of that type in the layer.

        """
        return _ogr.Layer_GetGeometryTypes(self, *args, **kwargs)

    def GetSupportedSRSList(self, *args, **kwargs):
        r"""GetSupportedSRSList(Layer self, int geom_field=0)"""
        return _ogr.Layer_GetSupportedSRSList(self, *args, **kwargs)

    def SetActiveSRS(self, *args):
        r"""SetActiveSRS(Layer self, int geom_field, SpatialReference srs) -> OGRErr"""
        return _ogr.Layer_SetActiveSRS(self, *args)

    def Reference(self):
      "For backwards compatibility only."
      pass

    def Dereference(self):
      "For backwards compatibility only."
      pass

    def __len__(self):
        """Returns the number of features in the layer"""
        return self.GetFeatureCount()

    # To avoid __len__ being called when testing boolean value
    # which can have side effects (#4758)
    def __nonzero__(self):
        return True

    # For Python 3 compat
    __bool__ = __nonzero__

    def __getitem__(self, value):
        """Support list and slice -like access to the layer.
        layer[0] would return the first feature on the layer.
        layer[0:4] would return a list of the first four features."""
        if isinstance(value, slice):
            import sys
            output = []
            if value.stop == sys.maxsize:
    #for an unending slice, sys.maxsize is used
    #We need to stop before that or GDAL will write an
    ##error to stdout
                stop = len(self) - 1
            else:
                stop = value.stop
            for i in range(value.start, stop, value.step):
                feature = self.GetFeature(i)
                if feature:
                    output.append(feature)
                else:
                    return output
            return output
        if isinstance(value, int):
            if value > len(self) - 1:
                raise IndexError
            return self.GetFeature(value)
        else:
            raise TypeError("Input %s is not of IntType or SliceType" % type(value))

    def CreateFields(self, fields):
        """Create a list of fields on the Layer"""
        for i in fields:
            self.CreateField(i)

    def __enter__(self):
        """Method called when using Dataset.ExecuteSQL() as a context manager"""
        if hasattr(self, "_dataset_weak_ref"):
            self._dataset_strong_ref = self._dataset_weak_ref()
            assert self._dataset_strong_ref is not None
            del self._dataset_weak_ref
            return self
        raise Exception("__enter__() called in unexpected situation")

    def __exit__(self, *args):
        """Method called when using Dataset.ExecuteSQL() as a context manager"""
        if hasattr(self, "_dataset_strong_ref"):
            self._dataset_strong_ref.ReleaseResultSet(self)
            del self._dataset_strong_ref

    def __iter__(self):
        self.ResetReading()
        while True:
            feature = self.GetNextFeature()
            if not feature:
                break
            yield feature

    def schema(self):
        output = []
        defn = self.GetLayerDefn()
        for n in range(defn.GetFieldCount()):
            output.append(defn.GetFieldDefn(n))
        return output
    schema = property(schema)


    def GetArrowStreamAsPyArrow(self, options = []):
        """ Return an ArrowStream as PyArrow Schema and Array objects """

        import pyarrow as pa

        class Stream:
            def __init__(self, stream):
                self.stream = stream
                self.end_of_stream = False

            def schema(self):
                """ Return the schema as a PyArrow DataType """

                schema = self.stream.GetSchema()
                if schema is None:
                    raise Exception("cannot get schema")
                return pa.DataType._import_from_c(schema._getPtr())

            schema = property(schema)

            def __enter__(self):
                return self

            def __exit__(self, type, value, tb):
                self.end_of_stream = True
                self.stream = None

            def GetNextRecordBatch(self):
                """ Return the next RecordBatch as a PyArrow StructArray, or None at end of iteration """

                array = self.stream.GetNextRecordBatch()
                if array is None:
                    return None
                return pa.Array._import_from_c(array._getPtr(), self.schema)

            def __iter__(self):
                """ Return an iterator over record batches as a PyArrow StructArray """
                if self.end_of_stream:
                    raise Exception("Stream has already been iterated over")

                while True:
                    batch = self.GetNextRecordBatch()
                    if not batch:
                        break
                    yield batch
                self.end_of_stream = True
                self.stream = None

        stream = self.GetArrowStream(options)
        if not stream:
            raise Exception("GetArrowStream() failed")
        return Stream(stream)


    def GetArrowStreamAsNumPy(self, options = []):
        """ Return an ArrowStream as NumPy Array objects.
            A specific option to this method is USE_MASKED_ARRAYS=YES/NO (default is YES).
        """

        from osgeo import gdal_array

        class Stream:
            def __init__(self, stream, use_masked_arrays):
                self.stream = stream
                self.schema = stream.GetSchema()
                self.end_of_stream = False
                self.use_masked_arrays = use_masked_arrays

            def __enter__(self):
                return self

            def __exit__(self, type, value, tb):
                self.end_of_stream = True
                self.schema = None
                self.stream = None

            def GetNextRecordBatch(self):
                """ Return the next RecordBatch as a dictionary of Numpy arrays, or None at end of iteration """

                array = self.stream.GetNextRecordBatch()
                if array is None:
                    return None

                ret = gdal_array._RecordBatchAsNumpy(array._getPtr(),
                                                     self.schema._getPtr(),
                                                     array)
                if ret is None:
                    gdal_array._RaiseException()
                    return ret
                for key, val in ret.items():
                    if isinstance(val, dict):
                        if self.use_masked_arrays:
                            import numpy.ma as ma
                            ret[key] = ma.masked_array(val["data"], val["mask"])
                        else:
                            ret[key] = val["data"]
                return ret

            def __iter__(self):
                """ Return an iterator over record batches as a dictionary of Numpy arrays """

                if self.end_of_stream:
                    raise Exception("Stream has already been iterated over")

                try:
                    while True:
                        batch = self.GetNextRecordBatch()
                        if not batch:
                            break
                        yield batch
                finally:
                    self.end_of_stream = True
                    self.stream = None

        stream = self.GetArrowStream(options)
        if not stream:
            raise Exception("GetArrowStream() failed")

        use_masked_arrays = True
        for opt in options:
            opt = opt.upper()
            if opt.startswith('USE_MASKED_ARRAYS='):
                use_masked_arrays = opt[len('USE_MASKED_ARRAYS='):] in ('YES', 'TRUE', 'ON', '1')

        return Stream(stream, use_masked_arrays)


    def IsPyArrowSchemaSupported(self, pa_schema, options=[]):
        """Returns whether the passed pyarrow Schema is supported by the layer, as a tuple (success: bool, errorMsg: str).

           This may be used as a preliminary check before calling WritePyArrowBatch()
        """

        import pyarrow as pa
        schema = ArrowSchema()
        pa_schema._export_to_c(schema._getPtr())
        return self.IsArrowSchemaSupported(schema, options)


    def CreateFieldFromPyArrowSchema(self, pa_schema, options=[]):
        """Create a field from the passed pyarrow Schema."""

        import pyarrow as pa
        schema = ArrowSchema()
        pa_schema._export_to_c(schema._getPtr())
        return self.CreateFieldFromArrowSchema(schema, options)


    def WritePyArrow(self, pa_batch, options=[]):
        """Write the content of the passed PyArrow batch (either a pyarrow.Table, a pyarrow.RecordBatch or a pyarrow.StructArray) into the layer."""

        import pyarrow as pa

    # Is it a pyarrow.Table ?
        if hasattr(pa_batch, "to_batches"):
            for batch in pa_batch.to_batches():
                if self.WritePyArrow(batch, options=options) != OGRERR_NONE:
                    return OGRERR_FAILURE
            return OGRERR_NONE

    # Is it a pyarrow.RecordBatch ?
        if hasattr(pa_batch, "columns") and hasattr(pa_batch, "schema"):
            array = pa.StructArray.from_arrays(pa_batch.columns, names=pa_batch.schema.names)
            return self.WritePyArrow(array, options=options)

    # Assume it is a pyarrow.StructArray
        schema = ArrowSchema()
        array = ArrowArray()
        pa_batch._export_to_c(array._getPtr(), schema._getPtr())
        return self.WriteArrowBatch(schema, array, options)



# Register Layer in _ogr:
_ogr.Layer_swigregister(Layer)
class Feature(object):
    r"""Proxy of C++ OGRFeatureShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _ogr.delete_Feature

    def __init__(self, *args, **kwargs):
        r"""__init__(Feature self, FeatureDefn feature_def) -> Feature"""
        _ogr.Feature_swiginit(self, _ogr.new_Feature(*args, **kwargs))

    def GetDefnRef(self, *args):
        r"""
        GetDefnRef(Feature self) -> FeatureDefn

        OGRFeatureDefnH OGR_F_GetDefnRef(OGRFeatureH hFeat)

        Fetch feature definition.

        This function is the same as the C++ method OGRFeature::GetDefnRef().

        Parameters
        -----------
        hFeat:
            handle to the feature to get the feature definition from.

        Returns
        --------
        OGRFeatureDefnH:
            a handle to the feature definition object on which feature depends.

        """
        return _ogr.Feature_GetDefnRef(self, *args)

    def SetGeometry(self, *args):
        r"""
        SetGeometry(Feature self, Geometry geom) -> OGRErr

        OGRErr OGR_F_SetGeometry(OGRFeatureH hFeat, OGRGeometryH hGeom)

        Set feature geometry.

        This function updates the features geometry, and operate exactly as
        SetGeometryDirectly(), except that this function does not assume
        ownership of the passed geometry, but instead makes a copy of it.

        This function is the same as the C++ OGRFeature::SetGeometry().

        This method has only an effect on the in-memory feature object. If
        this object comes from a layer and the modifications must be
        serialized back to the datasource, OGR_L_SetFeature() must be used
        afterwards. Or if this is a new feature, OGR_L_CreateFeature() must be
        used afterwards.

        Parameters
        -----------
        hFeat:
            handle to the feature on which new geometry is applied to.
        hGeom:
            handle to the new geometry to apply to feature.

        Returns
        --------
        OGRErr:
            OGRERR_NONE if successful, or OGR_UNSUPPORTED_GEOMETRY_TYPE if the
            geometry type is illegal for the OGRFeatureDefn (checking not yet
            implemented).

        """
        return _ogr.Feature_SetGeometry(self, *args)

    def SetGeometryDirectly(self, geom):
        ret = _ogr.Feature_SetGeometryDirectly(self, geom)
        if ret == OGRERR_NONE:
            self._add_geom_ref(geom)
        return ret



    def GetGeometryRef(self, *args):
        r"""
        GetGeometryRef(Feature self) -> Geometry

        Return the feature geometry

        The lifetime of the returned geometry is bound to the one of its belonging
        feature.

        For more details: :cpp:func:`OGR_F_GetGeometryRef`

        The geometry() method is also available as an alias of GetGeometryRef()

        Returns
        --------
        Geometry:
            the geometry, or None.

        """
        val = _ogr.Feature_GetGeometryRef(self, *args)

        self._add_geom_ref(val)


        return val


    def SetGeomField(self, *args):
        r"""
        SetGeomField(Feature self, int iField, Geometry geom) -> OGRErr
        SetGeomField(Feature self, char const * field_name, Geometry geom) -> OGRErr
        OGRErr
        OGR_F_SetGeomField(OGRFeatureH hFeat, int iField, OGRGeometryH hGeom)

        Set feature geometry of a specified geometry field.

        This function updates the features geometry, and operate exactly as
        SetGeometryDirectly(), except that this function does not assume
        ownership of the passed geometry, but instead makes a copy of it.

        This function is the same as the C++ OGRFeature::SetGeomField().

        Parameters
        -----------
        hFeat:
            handle to the feature on which new geometry is applied to.
        iField:
            geometry field to set.
        hGeom:
            handle to the new geometry to apply to feature.

        Returns
        --------
        OGRErr:
            OGRERR_NONE if successful, or OGR_UNSUPPORTED_GEOMETRY_TYPE if the
            geometry type is illegal for the OGRFeatureDefn (checking not yet
            implemented).

        """
        return _ogr.Feature_SetGeomField(self, *args)

    def SetGeomFieldDirectly(self, field, geom):
        ret = _ogr.Feature_SetGeomFieldDirectly(self, field, geom)
        if ret == OGRERR_NONE:
            self._add_geom_ref(geom)
        return ret



    def GetGeomFieldRef(self, *args):
        r"""
        GetGeomFieldRef(Feature self, int iField) -> Geometry
        GetGeomFieldRef(Feature self, char const * field_name) -> Geometry
        OGRGeometryH
        OGR_F_GetGeomFieldRef(OGRFeatureH hFeat, int iField)

        Fetch a handle to feature geometry.

        This function is the same as the C++ method
        OGRFeature::GetGeomFieldRef().

        Parameters
        -----------
        hFeat:
            handle to the feature to get geometry from.
        iField:
            geometry field to get.

        a handle to internal feature geometry. This object should not be
        modified.

        GDAL 1.11 
        """
        val = _ogr.Feature_GetGeomFieldRef(self, *args)

        self._add_geom_ref(val)


        return val


    def Clone(self, *args):
        r"""
        Clone(Feature self) -> Feature

        OGRFeatureH OGR_F_Clone(OGRFeatureH hFeat)

        Duplicate feature.

        The newly created feature is owned by the caller, and will have its
        own reference to the OGRFeatureDefn.

        This function is the same as the C++ method OGRFeature::Clone().

        Parameters
        -----------
        hFeat:
            handle to the feature to clone.

        Returns
        --------
        OGRFeatureH:
            a handle to the new feature, exactly matching this feature.

        """
        return _ogr.Feature_Clone(self, *args)

    def Equal(self, *args):
        r"""
        Equal(Feature self, Feature feature) -> bool
        int OGR_F_Equal(OGRFeatureH hFeat,
        OGRFeatureH hOtherFeat)

        Test if two features are the same.

        Two features are considered equal if the share them (handle equality)
        same OGRFeatureDefn, have the same field values, and the same geometry
        (as tested by OGR_G_Equal()) as well as the same feature id.

        This function is the same as the C++ method OGRFeature::Equal().

        Parameters
        -----------
        hFeat:
            handle to one of the feature.
        hOtherFeat:
            handle to the other feature to test this one against.

        Returns
        --------
        int:
            TRUE if they are equal, otherwise FALSE.

        """
        return _ogr.Feature_Equal(self, *args)

    def GetFieldCount(self, *args):
        r"""
        GetFieldCount(Feature self) -> int

        int OGR_F_GetFieldCount(OGRFeatureH hFeat)

        Fetch number of fields on this feature This will always be the same as
        the field count for the OGRFeatureDefn.

        This function is the same as the C++ method
        OGRFeature::GetFieldCount().

        Parameters
        -----------
        hFeat:
            handle to the feature to get the fields count from.

        Returns
        --------
        int:
            count of fields.

        """
        return _ogr.Feature_GetFieldCount(self, *args)

    def GetFieldDefnRef(self, *args):
        r"""
        GetFieldDefnRef(Feature self, int id) -> FieldDefn
        GetFieldDefnRef(Feature self, char const * field_name) -> FieldDefn

        OGRFieldDefnH OGR_F_GetFieldDefnRef(OGRFeatureH hFeat, int i)

        Fetch definition for this field.

        This function is the same as the C++ method
        OGRFeature::GetFieldDefnRef().

        Parameters
        -----------
        hFeat:
            handle to the feature on which the field is found.
        i:
            the field to fetch, from 0 to GetFieldCount()-1.

        Returns
        --------
        OGRFieldDefnH:
            a handle to the field definition (from the OGRFeatureDefn). This is an
            internal reference, and should not be deleted or modified.

        """
        return _ogr.Feature_GetFieldDefnRef(self, *args)

    def GetGeomFieldCount(self, *args):
        r"""
        GetGeomFieldCount(Feature self) -> int

        int OGR_F_GetGeomFieldCount(OGRFeatureH hFeat)

        Fetch number of geometry fields on this feature This will always be
        the same as the geometry field count for the OGRFeatureDefn.

        This function is the same as the C++ method
        OGRFeature::GetGeomFieldCount().

        .. versionadded:: 1.11

        Parameters
        -----------
        hFeat:
            handle to the feature to get the geometry fields count from.


        Returns
        --------
        int:
            count of geometry fields.

        """
        return _ogr.Feature_GetGeomFieldCount(self, *args)

    def GetGeomFieldDefnRef(self, *args):
        r"""
        GetGeomFieldDefnRef(Feature self, int id) -> GeomFieldDefn
        GetGeomFieldDefnRef(Feature self, char const * field_name) -> GeomFieldDefn

        OGRGeomFieldDefnH OGR_F_GetGeomFieldDefnRef(OGRFeatureH hFeat, int i)

        Fetch definition for this geometry field.

        This function is the same as the C++ method
        OGRFeature::GetGeomFieldDefnRef().

        .. versionadded:: 1.11

        Parameters
        -----------
        hFeat:
            handle to the feature on which the field is found.
        i:
            the field to fetch, from 0 to GetGeomFieldCount()-1.


        Returns
        --------
        OGRGeomFieldDefnH:
            a handle to the field definition (from the OGRFeatureDefn). This is an
            internal reference, and should not be deleted or modified.

        """
        return _ogr.Feature_GetGeomFieldDefnRef(self, *args)

    def GetFieldAsString(self, *args):
        r"""
        GetFieldAsString(Feature self, int id) -> char const
        GetFieldAsString(Feature self, char const * field_name) -> char const *

        const char\* OGR_F_GetFieldAsString(OGRFeatureH hFeat, int iField)

        Fetch field value as a string.

        OFTReal and OFTInteger fields will be translated to string using
        sprintf(), but not necessarily using the established formatting rules.
        Other field types, or errors will result in a return value of zero.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsString().

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to fetch, from 0 to GetFieldCount()-1.

        Returns
        --------
        str:
            the field value. This string is internal, and should not be modified,
            or freed. Its lifetime may be very brief.

        """
        return _ogr.Feature_GetFieldAsString(self, *args)

    def GetFieldAsISO8601DateTime(self, *args):
        r"""
        GetFieldAsISO8601DateTime(Feature self, int id, char ** options=None) -> char const
        GetFieldAsISO8601DateTime(Feature self, char const * field_name, char ** options=None) -> char const *
        """
        return _ogr.Feature_GetFieldAsISO8601DateTime(self, *args)

    def GetFieldAsInteger(self, *args):
        r"""
        GetFieldAsInteger(Feature self, int id) -> int
        GetFieldAsInteger(Feature self, char const * field_name) -> int

        int OGR_F_GetFieldAsInteger(OGRFeatureH hFeat, int iField)

        Fetch field value as integer.

        OFTString features will be translated using atoi(). OFTReal fields
        will be cast to integer. Other field types, or errors will result in a
        return value of zero.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsInteger().

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to fetch, from 0 to GetFieldCount()-1.

        Returns
        --------
        int:
            the field value.

        """
        return _ogr.Feature_GetFieldAsInteger(self, *args)

    def GetFieldAsInteger64(self, *args):
        r"""
        GetFieldAsInteger64(Feature self, int id) -> GIntBig
        GetFieldAsInteger64(Feature self, char const * field_name) -> GIntBig

        GIntBig OGR_F_GetFieldAsInteger64(OGRFeatureH hFeat, int iField)

        Fetch field value as integer 64 bit.

        OFTInteger are promoted to 64 bit. OFTString features will be
        translated using CPLAtoGIntBig(). OFTReal fields will be cast to
        integer. Other field types, or errors will result in a return value of
        zero.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsInteger64().

        .. versionadded:: 2.0

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to fetch, from 0 to GetFieldCount()-1.

        Returns
        --------
        int:
            the field value.

        """
        return _ogr.Feature_GetFieldAsInteger64(self, *args)

    def GetFieldAsDouble(self, *args):
        r"""
        GetFieldAsDouble(Feature self, int id) -> double
        GetFieldAsDouble(Feature self, char const * field_name) -> double

        double OGR_F_GetFieldAsDouble(OGRFeatureH hFeat, int iField)

        Fetch field value as a double.

        OFTString features will be translated using CPLAtof(). OFTInteger
        fields will be cast to double. Other field types, or errors will
        result in a return value of zero.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsDouble().

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to fetch, from 0 to GetFieldCount()-1.

        Returns
        --------
        float:
            the field value.

        """
        return _ogr.Feature_GetFieldAsDouble(self, *args)

    def GetFieldAsDateTime(self, *args):
        r"""
        GetFieldAsDateTime(Feature self, int id)
        GetFieldAsDateTime(Feature self, char const * field_name)
        int
        OGR_F_GetFieldAsDateTime(OGRFeatureH hFeat, int iField, int \*pnYear,
        int \*pnMonth, int \*pnDay, int \*pnHour, int \*pnMinute, int \*pnSecond,
        int \*pnTZFlag)

        Fetch field value as date and time.

        Currently this method only works for OFTDate, OFTTime and OFTDateTime
        fields.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsDateTime().

        .. note:: Use OGR_F_GetFieldAsDateTimeEx() for second with millisecond accuracy.

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to fetch, from 0 to GetFieldCount()-1.
        pnYear:
            (including century)
        pnMonth:
            (1-12)
        pnDay:
            (1-31)
        pnHour:
            (0-23)
        pnMinute:
            (0-59)
        pnSecond:
            (0-59)
        pnTZFlag:
            (0=unknown, 1=localtime, 100=GMT, see data model for
        details)

        Returns
        --------
        int:
            TRUE on success or FALSE on failure.

        """
        return _ogr.Feature_GetFieldAsDateTime(self, *args)

    def GetFieldAsIntegerList(self, *args):
        r"""
        GetFieldAsIntegerList(Feature self, int id)
        GetFieldAsIntegerList(Feature self, char const * field_name)

        const int\* OGR_F_GetFieldAsIntegerList(OGRFeatureH hFeat, int iField, int
        \*pnCount)

        Fetch field value as a list of integers.

        Currently this function only works for OFTIntegerList fields.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsIntegerList().

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to fetch, from 0 to GetFieldCount()-1.
        pnCount:
            an integer to put the list count (number of integers) into.

        Returns
        --------
        list[int]:
            the field value. This list is internal, and should not be modified, or
            freed. Its lifetime may be very brief. If \*pnCount is zero on return
            the returned pointer may be NULL or non-NULL.

        """
        return _ogr.Feature_GetFieldAsIntegerList(self, *args)

    def GetFieldAsInteger64List(self, *args):
        r"""
        GetFieldAsInteger64List(Feature self, int id)
        const GIntBig\*
        OGR_F_GetFieldAsInteger64List(OGRFeatureH hFeat, int iField, int
        \*pnCount)

        Fetch field value as a list of 64 bit integers.

        Currently this function only works for OFTInteger64List fields.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsInteger64List().

        .. versionadded:: 2.0

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to fetch, from 0 to GetFieldCount()-1.
        pnCount:
            an integer to put the list count (number of integers) into.

        Returns
        --------
        list[int]:
            the field value. This list is internal, and should not be modified, or
            freed. Its lifetime may be very brief. If \*pnCount is zero on return
            the returned pointer may be NULL or non-NULL.

        """
        return _ogr.Feature_GetFieldAsInteger64List(self, *args)

    def GetFieldAsDoubleList(self, *args):
        r"""
        GetFieldAsDoubleList(Feature self, int id)
        GetFieldAsDoubleList(Feature self, char const * field_name)
        const double\*
        OGR_F_GetFieldAsDoubleList(OGRFeatureH hFeat, int iField, int
        \*pnCount)

        Fetch field value as a list of doubles.

        Currently this function only works for OFTRealList fields.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsDoubleList().

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to fetch, from 0 to GetFieldCount()-1.
        pnCount:
            an integer to put the list count (number of doubles) into.

        Returns
        --------
        list[float]:
            the field value. This list is internal, and should not be modified, or
            freed. Its lifetime may be very brief. If \*pnCount is zero on return
            the returned pointer may be NULL or non-NULL.

        """
        return _ogr.Feature_GetFieldAsDoubleList(self, *args)

    def GetFieldAsStringList(self, *args):
        r"""
        GetFieldAsStringList(Feature self, int id) -> char **
        char\*\*
        OGR_F_GetFieldAsStringList(OGRFeatureH hFeat, int iField)

        Fetch field value as a list of strings.

        Currently this method only works for OFTStringList fields.

        The returned list is terminated by a NULL pointer. The number of
        elements can also be calculated using CSLCount().

        This function is the same as the C++ method
        OGRFeature::GetFieldAsStringList().

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to fetch, from 0 to GetFieldCount()-1.

        Returns
        --------
        list[str]:
            the field value. This list is internal, and should not be modified, or
            freed. Its lifetime may be very brief.

        """
        return _ogr.Feature_GetFieldAsStringList(self, *args)

    def GetFieldAsBinary(self, *args):
        r"""
        GetFieldAsBinary(Feature self, int id) -> OGRErr
        GetFieldAsBinary(Feature self, char const * field_name) -> OGRErr
        GByte\*
        OGR_F_GetFieldAsBinary(OGRFeatureH hFeat, int iField, int \*pnBytes)

        Fetch field value as binary.

        This method only works for OFTBinary and OFTString fields.

        This function is the same as the C++ method
        OGRFeature::GetFieldAsBinary().

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to fetch, from 0 to GetFieldCount()-1.
        pnBytes:
            location to place count of bytes returned.


        Returns
        --------
        list:
            the field value. This list is internal, and should not be modified, or
            freed. Its lifetime may be very brief.

        """
        return _ogr.Feature_GetFieldAsBinary(self, *args)

    def IsFieldSet(self, *args):
        r"""
        IsFieldSet(Feature self, int id) -> bool
        IsFieldSet(Feature self, char const * field_name) -> bool

        int OGR_F_IsFieldSet(OGRFeatureH hFeat, int iField)

        Test if a field has ever been assigned a value or not.

        This function is the same as the C++ method OGRFeature::IsFieldSet().

        Parameters
        -----------
        hFeat:
            handle to the feature on which the field is.
        iField:
            the field to test.

        Returns
        --------
        int:
            TRUE if the field has been set, otherwise false.

        """
        return _ogr.Feature_IsFieldSet(self, *args)

    def IsFieldNull(self, *args):
        r"""
        IsFieldNull(Feature self, int id) -> bool
        IsFieldNull(Feature self, char const * field_name) -> bool

        int OGR_F_IsFieldNull(OGRFeatureH hFeat, int iField)

        Test if a field is null.

        This function is the same as the C++ method OGRFeature::IsFieldNull().

        .. versionadded:: 2.2

        Parameters
        -----------
        hFeat:
            handle to the feature on which the field is.
        iField:
            the field to test.

        Returns
        --------
        int:
            TRUE if the field is null, otherwise false.

        """
        return _ogr.Feature_IsFieldNull(self, *args)

    def IsFieldSetAndNotNull(self, *args):
        r"""
        IsFieldSetAndNotNull(Feature self, int id) -> bool
        IsFieldSetAndNotNull(Feature self, char const * field_name) -> bool

        int OGR_F_IsFieldSetAndNotNull(OGRFeatureH hFeat, int iField)

        Test if a field is set and not null.

        This function is the same as the C++ method
        OGRFeature::IsFieldSetAndNotNull().

        .. versionadded:: 2.2

        Parameters
        -----------
        hFeat:
            handle to the feature on which the field is.
        iField:
            the field to test.

        Returns
        --------
        int:
            TRUE if the field is set and not null, otherwise false.

        """
        return _ogr.Feature_IsFieldSetAndNotNull(self, *args)

    def GetFieldIndex(self, *args):
        r"""
        GetFieldIndex(Feature self, char const * field_name) -> int

        int OGR_F_GetFieldIndex(OGRFeatureH hFeat, const char \*pszName)

        Fetch the field index given field name.

        This is a cover for the OGRFeatureDefn::GetFieldIndex() method.

        This function is the same as the C++ method
        OGRFeature::GetFieldIndex().

        Parameters
        -----------
        hFeat:
            handle to the feature on which the field is found.
        pszName:
            the name of the field to search for.

        Returns
        --------
        int:
            the field index, or -1 if no matching field is found.

        """
        return _ogr.Feature_GetFieldIndex(self, *args)

    def GetGeomFieldIndex(self, *args):
        r"""
        GetGeomFieldIndex(Feature self, char const * field_name) -> int

        int OGR_F_GetGeomFieldIndex(OGRFeatureH hFeat, const char \*pszName)

        Fetch the geometry field index given geometry field name.

        This is a cover for the OGRFeatureDefn::GetGeomFieldIndex() method.

        This function is the same as the C++ method
        OGRFeature::GetGeomFieldIndex().

        .. versionadded:: 1.11

        Parameters
        -----------
        hFeat:
            handle to the feature on which the geometry field is found.
        pszName:
            the name of the geometry field to search for.


        Returns
        --------
        int:
            the geometry field index, or -1 if no matching geometry field is found.

        """
        return _ogr.Feature_GetGeomFieldIndex(self, *args)

    def GetFID(self, *args):
        r"""
        GetFID(Feature self) -> GIntBig
        GIntBig OGR_F_GetFID(OGRFeatureH
        hFeat)

        Get feature identifier.

        This function is the same as the C++ method OGRFeature::GetFID().
        Note: since GDAL 2.0, this method returns a GIntBig (previously a
        long)

        Parameters
        -----------
        hFeat:
            handle to the feature from which to get the feature
        identifier.

        Returns
        -------
        int:
            feature id or OGRNullFID if none has been assigned.

        """
        return _ogr.Feature_GetFID(self, *args)

    def SetFID(self, *args):
        r"""
        SetFID(Feature self, GIntBig fid) -> OGRErr
        OGRErr OGR_F_SetFID(OGRFeatureH hFeat,
        GIntBig nFID)

        Set the feature identifier.

        For specific types of features this operation may fail on illegal
        features ids. Generally it always succeeds. Feature ids should be
        greater than or equal to zero, with the exception of OGRNullFID (-1)
        indicating that the feature id is unknown.

        This function is the same as the C++ method OGRFeature::SetFID().

        Parameters
        -----------
        hFeat:
            handle to the feature to set the feature id to.
        nFID:
            the new feature identifier value to assign.

        Returns
        --------
        OGRErr:
            On success OGRERR_NONE, or on failure some other value.

        """
        return _ogr.Feature_SetFID(self, *args)

    def DumpReadable(self, *args):
        r"""
        DumpReadable(Feature self)
        void
        OGR_F_DumpReadable(OGRFeatureH hFeat, FILE \*fpOut)

        Dump this feature in a human readable form.

        This dumps the attributes, and geometry; however, it doesn't
        definition information (other than field types and names), nor does it
        report the geometry spatial reference system.

        This function is the same as the C++ method
        OGRFeature::DumpReadable().

        Parameters
        -----------
        hFeat:
            handle to the feature to dump.
        fpOut:
            the stream to write to, such as strout.

        """
        return _ogr.Feature_DumpReadable(self, *args)

    def DumpReadableAsString(self, *args):
        r"""DumpReadableAsString(Feature self, char ** options=None) -> retStringAndCPLFree *"""
        return _ogr.Feature_DumpReadableAsString(self, *args)

    def UnsetField(self, *args):
        r"""
        UnsetField(Feature self, int id)
        UnsetField(Feature self, char const * field_name)

        void OGR_F_UnsetField(OGRFeatureH hFeat, int iField)

        Clear a field, marking it as unset.

        This function is the same as the C++ method OGRFeature::UnsetField().

        Parameters
        -----------
        hFeat:
            handle to the feature on which the field is.
        iField:
            the field to unset.

        """
        return _ogr.Feature_UnsetField(self, *args)

    def SetFieldNull(self, *args):
        r"""
        SetFieldNull(Feature self, int id)
        SetFieldNull(Feature self, char const * field_name)

        void OGR_F_SetFieldNull(OGRFeatureH hFeat, int iField)

        Clear a field, marking it as null.

        This function is the same as the C++ method
        OGRFeature::SetFieldNull().

        .. versionadded:: 2.2

        Parameters
        -----------
        hFeat:
            handle to the feature on which the field is.
        iField:
            the field to set to null.

        """
        return _ogr.Feature_SetFieldNull(self, *args)

    def SetFieldInteger64(self, *args):
        r"""
        SetFieldInteger64(Feature self, int id, GIntBig value)
        void
        OGR_F_SetFieldInteger64(OGRFeatureH hFeat, int iField, GIntBig nValue)

        Set field to 64 bit integer value.

        OFTInteger, OFTInteger64 and OFTReal fields will be set directly.
        OFTString fields will be assigned a string representation of the
        value, but not necessarily taking into account formatting constraints
        on this field. Other field types may be unaffected.

        This function is the same as the C++ method OGRFeature::SetField().

        This method has only an effect on the in-memory feature object. If
        this object comes from a layer and the modifications must be
        serialized back to the datasource, OGR_L_SetFeature() must be used
        afterwards. Or if this is a new feature, OGR_L_CreateFeature() must be
        used afterwards.

        .. versionadded:: 2.0

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to fetch, from 0 to GetFieldCount()-1.
        nValue:
            the value to assign.

        """
        return _ogr.Feature_SetFieldInteger64(self, *args)

        # With several override, SWIG cannot dispatch automatically unicode strings
        # to the right implementation, so we have to do it at hand
    def SetField(self, *args) -> "OGRErr":
        """
        SetField(self, fld_index, value: str)
        SetField(self, fld_name, value: str)
        SetField(self, fld_index, value: int)
        SetField(self, fld_name, value: int)
        SetField(self, fld_index, value: float)
        SetField(self, fld_name, value: float)
        SetField(self, fld_index, year: int, month: int, day: int, hour: int, minute: int, second: int|float, tzflag: int)
        SetField(self, fld_name, year: int, month: int, day: int, hour: int, minute: int, second: int|float, tzflag: int)
        SetField(self, fld_index, value: bytes)
        SetField(self, fld_name, value: bytes)
        """

        if len(args) == 2 and args[1] is None:
            return _ogr.Feature_SetFieldNull(self, args[0])

        if len(args) == 2 and isinstance(args[1], int):
            fld_index = args[0]
            if isinstance(fld_index, str):
                fld_index = self._getfieldindex(fld_index)
            return _ogr.Feature_SetFieldInteger64(self, fld_index, args[1])

        if len(args) == 2 and isinstance(args[1], str):
            fld_index = args[0]
            if isinstance(fld_index, str):
                fld_index = self._getfieldindex(fld_index)
            return _ogr.Feature_SetFieldString(self, fld_index, args[1])

        if len(args) == 2 and isinstance(args[1], (bytes, bytearray, memoryview)):
            fld_index = args[0]
            if isinstance(fld_index, str):
                fld_index = self._getfieldindex(fld_index)
            if self.GetFieldType(fld_index) == OFTBinary:
                return self._SetFieldBinary(fld_index, args[1])

        return _ogr.Feature_SetField(self, *args)



    def SetFieldIntegerList(self, *args):
        r"""
        SetFieldIntegerList(Feature self, int id, int nList)
        void
        OGR_F_SetFieldIntegerList(OGRFeatureH hFeat, int iField, int nCount,
        const int \*panValues)

        Set field to list of integers value.

        This function currently on has an effect of OFTIntegerList,
        OFTInteger64List and OFTRealList fields.

        This function is the same as the C++ method OGRFeature::SetField().

        This method has only an effect on the in-memory feature object. If
        this object comes from a layer and the modifications must be
        serialized back to the datasource, OGR_L_SetFeature() must be used
        afterwards. Or if this is a new feature, OGR_L_CreateFeature() must be
        used afterwards.

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to set, from 0 to GetFieldCount()-1.
        nCount:
            the number of values in the list being assigned.
        panValues:
            the values to assign.

        """
        return _ogr.Feature_SetFieldIntegerList(self, *args)

    def SetFieldInteger64List(self, *args):
        r"""
        SetFieldInteger64List(Feature self, int id, int nList)
        void
        OGR_F_SetFieldInteger64List(OGRFeatureH hFeat, int iField, int nCount,
        const GIntBig \*panValues)

        Set field to list of 64 bit integers value.

        This function currently on has an effect of OFTIntegerList,
        OFTInteger64List and OFTRealList fields.

        This function is the same as the C++ method OGRFeature::SetField().

        This method has only an effect on the in-memory feature object. If
        this object comes from a layer and the modifications must be
        serialized back to the datasource, OGR_L_SetFeature() must be used
        afterwards. Or if this is a new feature, OGR_L_CreateFeature() must be
        used afterwards.

        .. versionadded:: 2.0

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to set, from 0 to GetFieldCount()-1.
        nCount:
            the number of values in the list being assigned.
        panValues:
            the values to assign.

        """
        return _ogr.Feature_SetFieldInteger64List(self, *args)

    def SetFieldDoubleList(self, *args):
        r"""
        SetFieldDoubleList(Feature self, int id, int nList)
        void
        OGR_F_SetFieldDoubleList(OGRFeatureH hFeat, int iField, int nCount,
        const double \*padfValues)

        Set field to list of doubles value.

        This function currently on has an effect of OFTIntegerList,
        OFTInteger64List, OFTRealList fields.

        This function is the same as the C++ method OGRFeature::SetField().

        This method has only an effect on the in-memory feature object. If
        this object comes from a layer and the modifications must be
        serialized back to the datasource, OGR_L_SetFeature() must be used
        afterwards. Or if this is a new feature, OGR_L_CreateFeature() must be
        used afterwards.

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to set, from 0 to GetFieldCount()-1.
        nCount:
            the number of values in the list being assigned.
        padfValues:
            the values to assign.

        """
        return _ogr.Feature_SetFieldDoubleList(self, *args)

    def SetFieldStringList(self, *args):
        r"""
        SetFieldStringList(Feature self, int id, char ** pList)
        void
        OGR_F_SetFieldStringList(OGRFeatureH hFeat, int iField, CSLConstList
        papszValues)

        Set field to list of strings value.

        This function currently on has an effect of OFTStringList fields.

        This function is the same as the C++ method OGRFeature::SetField().

        This method has only an effect on the in-memory feature object. If
        this object comes from a layer and the modifications must be
        serialized back to the datasource, OGR_L_SetFeature() must be used
        afterwards. Or if this is a new feature, OGR_L_CreateFeature() must be
        used afterwards.

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to set, from 0 to GetFieldCount()-1.
        papszValues:
            the values to assign. List of NUL-terminated string,
        ending with a NULL pointer.

        """
        return _ogr.Feature_SetFieldStringList(self, *args)

    def _SetFieldBinary(self, *args):
        r"""_SetFieldBinary(Feature self, int id, int nLen)"""
        return _ogr.Feature__SetFieldBinary(self, *args)

    def SetFieldBinaryFromHexString(self, *args):
        r"""
        SetFieldBinaryFromHexString(Feature self, int id, char const * pszValue)
        SetFieldBinaryFromHexString(Feature self, char const * field_name, char const * pszValue)
        """
        return _ogr.Feature_SetFieldBinaryFromHexString(self, *args)

    def SetFrom(self, *args, **kwargs):
        r"""
        SetFrom(Feature self, Feature other, int forgiving=1) -> OGRErr
        OGRErr OGR_F_SetFrom(OGRFeatureH
        hFeat, OGRFeatureH hOtherFeat, int bForgiving)

        Set one feature from another.

        Overwrite the contents of this feature from the geometry and
        attributes of another. The hOtherFeature does not need to have the
        same OGRFeatureDefn. Field values are copied by corresponding field
        names. Field types do not have to exactly match. OGR_F_SetField\*()
        function conversion rules will be applied as needed.

        This function is the same as the C++ method OGRFeature::SetFrom().

        Parameters
        -----------
        hFeat:
            handle to the feature to set to.
        hOtherFeat:
            handle to the feature from which geometry, and field
            values will be copied.
        bForgiving:
            TRUE if the operation should continue despite lacking
            output fields matching some of the source fields.

        Returns
        --------
        OGRErr:
            OGRERR_NONE if the operation succeeds, even if some values are not
            transferred, otherwise an error code.

        """
        return _ogr.Feature_SetFrom(self, *args, **kwargs)

    def SetFromWithMap(self, *args):
        r"""
        SetFromWithMap(Feature self, Feature other, int forgiving, int nList) -> OGRErr
        OGRErr
        OGR_F_SetFromWithMap(OGRFeatureH hFeat, OGRFeatureH hOtherFeat, int
        bForgiving, const int \*panMap)

        Set one feature from another.

        Overwrite the contents of this feature from the geometry and
        attributes of another. The hOtherFeature does not need to have the
        same OGRFeatureDefn. Field values are copied according to the provided
        indices map. Field types do not have to exactly match.
        OGR_F_SetField\*() function conversion rules will be applied as needed.
        This is more efficient than OGR_F_SetFrom() in that this doesn't
        lookup the fields by their names. Particularly useful when the field
        names don't match.

        This function is the same as the C++ method OGRFeature::SetFrom().

        Parameters
        -----------
        hFeat:
            handle to the feature to set to.
        hOtherFeat:
            handle to the feature from which geometry, and field
            values will be copied.
        panMap:
            Array of the indices of the destination feature's fields
            stored at the corresponding index of the source feature's fields. A
            value of -1 should be used to ignore the source's field. The array
            should not be NULL and be as long as the number of fields in the
            source feature.
        bForgiving:
            TRUE if the operation should continue despite lacking
            output fields matching some of the source fields.

        Returns
        --------
        OGRErr:
            OGRERR_NONE if the operation succeeds, even if some values are not
            transferred, otherwise an error code.

        """
        return _ogr.Feature_SetFromWithMap(self, *args)

    def GetStyleString(self, *args):
        r"""
        GetStyleString(Feature self) -> char const *
        const char\*
        OGR_F_GetStyleString(OGRFeatureH hFeat)

        Fetch style string for this feature.

        Set the OGR Feature Style Specification for details on the format of
        this string, and ogr_featurestyle.h for services available to parse
        it.

        This function is the same as the C++ method
        OGRFeature::GetStyleString().

        Parameters
        -----------
        hFeat:
            handle to the feature to get the style from.

        Returns
        --------
        str:
            a reference to a representation in string format, or NULL if there
            isn't one.

        """
        return _ogr.Feature_GetStyleString(self, *args)

    def SetStyleString(self, *args):
        r"""
        SetStyleString(Feature self, char const * the_string)
        void
        OGR_F_SetStyleString(OGRFeatureH hFeat, const char \*pszStyle)

        Set feature style string.

        This method operate exactly as OGR_F_SetStyleStringDirectly() except
        that it does not assume ownership of the passed string, but instead
        makes a copy of it.

        This function is the same as the C++ method
        OGRFeature::SetStyleString().

        Parameters
        -----------
        hFeat:
            handle to the feature to set style to.
        pszStyle:
            the style string to apply to this feature, cannot be NULL.

        """
        return _ogr.Feature_SetStyleString(self, *args)

    def GetFieldType(self, *args):
        r"""
        GetFieldType(Feature self, int id) -> OGRFieldType
        GetFieldType(Feature self, char const * field_name) -> OGRFieldType
        """
        return _ogr.Feature_GetFieldType(self, *args)

    def Validate(self, *args):
        r"""
        Validate(Feature self, int flags=OGR_F_VAL_ALL, int bEmitError=TRUE) -> int
        int OGR_F_Validate(OGRFeatureH
        hFeat, int nValidateFlags, int bEmitError)

        Validate that a feature meets constraints of its schema.

        The scope of test is specified with the nValidateFlags parameter.

        Regarding OGR_F_VAL_WIDTH, the test is done assuming the string width
        must be interpreted as the number of UTF-8 characters. Some drivers
        might interpret the width as the number of bytes instead. So this test
        is rather conservative (if it fails, then it will fail for all
        interpretations).

        This function is the same as the C++ method OGRFeature::Validate().

        .. versionadded:: 2.0

        Parameters
        -----------
        hFeat:
            handle to the feature to validate.
        nValidateFlags:
            OGR_F_VAL_ALL or combination of OGR_F_VAL_NULL,
            OGR_F_VAL_GEOM_TYPE, OGR_F_VAL_WIDTH and
            OGR_F_VAL_ALLOW_NULL_WHEN_DEFAULT with '|' operator
        bEmitError:
            TRUE if a CPLError() must be emitted when a check fails

        Returns
        -------
        int:
            TRUE if all enabled validation tests pass.

        """
        return _ogr.Feature_Validate(self, *args)

    def FillUnsetWithDefault(self, *args):
        r"""
        FillUnsetWithDefault(Feature self, int bNotNullableOnly=FALSE, char ** options=None)
        void
        OGR_F_FillUnsetWithDefault(OGRFeatureH hFeat, int bNotNullableOnly,
        char \*\*papszOptions)

        Fill unset fields with default values that might be defined.

        This function is the same as the C++ method
        OGRFeature::FillUnsetWithDefault().

        .. versionadded:: 2.0

        Parameters
        -----------
        hFeat:
            handle to the feature.
        bNotNullableOnly:
            if we should fill only unset fields with a not-null
            constraint.
        papszOptions:
            unused currently. Must be set to NULL.

        """
        return _ogr.Feature_FillUnsetWithDefault(self, *args)

    def GetNativeData(self, *args):
        r"""
        GetNativeData(Feature self) -> char const *
        const char\*
        OGR_F_GetNativeData(OGRFeatureH hFeat)

        Returns the native data for the feature.

        The native data is the representation in a "natural" form that comes
        from the driver that created this feature, or that is aimed at an
        output driver. The native data may be in different format, which is
        indicated by OGR_F_GetNativeMediaType().

        Note that most drivers do not support storing the native data in the
        feature object, and if they do, generally the NATIVE_DATA open option
        must be passed at dataset opening.

        The "native data" does not imply it is something more performant or
        powerful than what can be obtained with the rest of the API, but it
        may be useful in round-tripping scenarios where some characteristics
        of the underlying format are not captured otherwise by the OGR
        abstraction.

        This function is the same as the C++ method
        OGRFeature::GetNativeData().

        .. note:: See https://trac.osgeo.org/gdal/wiki/rfc60_improved_roundtripping_in_ogr

        .. versionadded:: 2.1

        Parameters
        -----------
        hFeat:
            handle to the feature.

        Returns
        -------
        str:
            a string with the native data, or NULL if there is none.

        """
        return _ogr.Feature_GetNativeData(self, *args)

    def GetNativeMediaType(self, *args):
        r"""
        GetNativeMediaType(Feature self) -> char const *
        const char\*
        OGR_F_GetNativeMediaType(OGRFeatureH hFeat)

        Returns the native media type for the feature.

        The native media type is the identifier for the format of the native
        data. It follows the IANA RFC 2045
        (seehttps://en.wikipedia.org/wiki/Media_type), e.g.
        "application/vnd.geo+json" for JSon.

        This function is the same as the C function
        OGR_F_GetNativeMediaType().

        .. note:: See https://trac.osgeo.org/gdal/wiki/rfc60_improved_roundtripping_in_ogr

        .. versionadded:: 2.1

        Parameters
        -----------
        hFeat:
            handle to the feature.


        Returns
        --------
        str:
            a string with the native media type, or NULL if there is none.

        """
        return _ogr.Feature_GetNativeMediaType(self, *args)

    def SetNativeData(self, *args):
        r"""
        SetNativeData(Feature self, char const * nativeData)
        void
        OGR_F_SetNativeData(OGRFeatureH hFeat, const char \*pszNativeData)

        Sets the native data for the feature.

        The native data is the representation in a "natural" form that comes
        from the driver that created this feature, or that is aimed at an
        output driver. The native data may be in different format, which is
        indicated by OGR_F_GetNativeMediaType().

        This function is the same as the C++ method
        OGRFeature::SetNativeData().

        .. note:: See https://trac.osgeo.org/gdal/wiki/rfc60_improved_roundtripping_in_ogr

        .. versionadded:: 2.1

        Parameters
        -----------
        hFeat:
            handle to the feature.
        pszNativeData:
            a string with the native data, or NULL if there is none.

        """
        return _ogr.Feature_SetNativeData(self, *args)

    def SetNativeMediaType(self, *args):
        r"""
        SetNativeMediaType(Feature self, char const * nativeMediaType)
        void
        OGR_F_SetNativeMediaType(OGRFeatureH hFeat, const char
        \*pszNativeMediaType)

        Sets the native media type for the feature.

        The native media type is the identifier for the format of the native
        data. It follows the IANA RFC 2045
        (seehttps://en.wikipedia.org/wiki/Media_type), e.g.
        "application/vnd.geo+json" for JSon.

        This function is the same as the C++ method
        OGRFeature::SetNativeMediaType().

        .. note:: See https://trac.osgeo.org/gdal/wiki/rfc60_improved_roundtripping_in_ogr

        .. versionadded:: 2.1


        Parameters
        -----------
        hFeat:
            handle to the feature.
        pszNativeMediaType:
            a string with the native media type, or NULL if there is none.

        """
        return _ogr.Feature_SetNativeMediaType(self, *args)

    def SetFieldString(self, *args):
        r"""
        SetFieldString(Feature self, int id, char const * value)
        void
        OGR_F_SetFieldString(OGRFeatureH hFeat, int iField, const char
        \*pszValue)

        Set field to string value.

        OFTInteger fields will be set based on an atoi() conversion of the
        string. OFTInteger64 fields will be set based on an CPLAtoGIntBig()
        conversion of the string. OFTReal fields will be set based on an
        CPLAtof() conversion of the string. Other field types may be
        unaffected.

        This function is the same as the C++ method OGRFeature::SetField().

        This method has only an effect on the in-memory feature object. If
        this object comes from a layer and the modifications must be
        serialized back to the datasource, OGR_L_SetFeature() must be used
        afterwards. Or if this is a new feature, OGR_L_CreateFeature() must be
        used afterwards.

        Parameters
        -----------
        hFeat:
            handle to the feature that owned the field.
        iField:
            the field to fetch, from 0 to GetFieldCount()-1.
        pszValue:
            the value to assign.

        """
        return _ogr.Feature_SetFieldString(self, *args)

    def Reference(self):
      pass

    def Dereference(self):
      pass

    def Destroy(self):
      "Once called, self has effectively been destroyed.  Do not access. For backwards compatibility only"
      _ogr.delete_Feature(self)
      self._invalidate_geom_refs()
      self.thisown = 0
      self.this = None

    def __cmp__(self, other):
        """Compares a feature to another for equality"""
        return self.Equal(other)

    def __copy__(self):
        return self.Clone()

    def _getfieldindex(self, fieldname):
        case_insensitive_idx = -1
        fdefn = _ogr.Feature_GetDefnRef(self)
        for i in range(fdefn.GetFieldCount()):
            name = fdefn.GetFieldDefn(i).GetName()
            if name == fieldname:
                return i
            elif case_insensitive_idx < 0 and name.lower() == fieldname.lower():
                case_insensitive_idx = i
        return case_insensitive_idx

    # This makes it possible to fetch fields in the form "feature.area".
    # This has some risk of name collisions.
    def __getattr__(self, key):
        """Returns the values of fields by the given name"""
        if key in ('this', 'thisown', '_geom_references'):
            return self.__getattribute__(key)

        idx = self._getfieldindex(key)
        if idx < 0:
            idx = self.GetGeomFieldIndex(key)
            if idx < 0:
                raise AttributeError(key)
            else:
                return self.GetGeomFieldRef(idx)
        else:
            return self.GetField(idx)

    # This makes it possible to set fields in the form "feature.area".
    # This has some risk of name collisions.
    def __setattr__(self, key, value):
        """Set the values of fields by the given name"""
        if key in ('this', 'thisown', '_geom_references'):
            super().__setattr__(key, value)
        else:
            idx = self._getfieldindex(key)
            if idx != -1:
                self._SetField2(idx, value)
            else:
                idx = self.GetGeomFieldIndex(key)
                if idx != -1:
                    self.SetGeomField(idx, value)
                else:
                    self.__dict__[key] = value

    # This makes it possible to fetch fields in the form "feature['area']".
    def __getitem__(self, key):
        """Returns the values of fields by the given name / field_index"""
        if isinstance(key, str):
            fld_index = self._getfieldindex(key)
        else:
            fld_index = key
            if key == self.GetFieldCount():
                raise IndexError
        if fld_index < 0:
            if isinstance(key, str):
                fld_index = self.GetGeomFieldIndex(key)
            if fld_index < 0:
                raise KeyError("Illegal field requested in GetField()")
            else:
                return self.GetGeomFieldRef(fld_index)
        else:
            return self.GetField(fld_index)

    # This makes it possible to set fields in the form "feature['area'] = 123".
    def __setitem__(self, key, value):
        """Returns the value of a field by field name / index"""
        if isinstance(key, str):
            fld_index = self._getfieldindex(key)
        else:
            fld_index = key
            if key == self.GetFieldCount():
                raise IndexError
        if fld_index < 0:
            if isinstance(key, str):
                fld_index = self.GetGeomFieldIndex(key)
            if fld_index < 0:
                raise KeyError("Illegal field requested in SetField()")
            else:
                return self.SetGeomField(fld_index, value)
        else:
            return self._SetField2(fld_index, value)

    def GetField(self, fld_index):
        if isinstance(fld_index, str):
            fld_index = self._getfieldindex(fld_index)
        if (fld_index < 0) or (fld_index > self.GetFieldCount()):
            raise KeyError("Illegal field requested in GetField()")
        if not (self.IsFieldSet(fld_index)) or self.IsFieldNull(fld_index):
            return None
        fld_type = self.GetFieldType(fld_index)
        if fld_type == OFTInteger:
            if self.GetFieldDefnRef(fld_index).GetSubType() == OFSTBoolean:
                return bool(self.GetFieldAsInteger(fld_index))
            return self.GetFieldAsInteger(fld_index)
        if fld_type == OFTInteger64:
            return self.GetFieldAsInteger64(fld_index)
        if fld_type == OFTReal:
            return self.GetFieldAsDouble(fld_index)
        if fld_type == OFTStringList:
            return self.GetFieldAsStringList(fld_index)
        if fld_type == OFTIntegerList:
            ret = self.GetFieldAsIntegerList(fld_index)
            if self.GetFieldDefnRef(fld_index).GetSubType() == OFSTBoolean:
                 ret = [bool(x) for x in ret]
            return ret
        if fld_type == OFTInteger64List:
            return self.GetFieldAsInteger64List(fld_index)
        if fld_type == OFTRealList:
            return self.GetFieldAsDoubleList(fld_index)
    ## if fld_type == OFTDateTime or fld_type == OFTDate or fld_type == OFTTime:
    #     return self.GetFieldAsDate(fld_index)
    # default to returning as a string.  Should we add more types?
        try:
            return self.GetFieldAsString(fld_index)
        except:
    # For Python3 on non-UTF8 strings
            return self.GetFieldAsBinary(fld_index)

    def SetFieldBinary(self, field_index_or_name, value):
        """
        SetFieldBinary(Feature self, field_index_or_name: int | str, value: bytes)

        Set field to binary data.
        This function currently only has an effect on OFTBinary fields.
        This function is the same as the C++ method OGRFeature::SetField().

        Parameters
        -----------
        field_index_or_name:
            the field to set, from 0 to GetFieldCount()-1. Or the field name
        values:
            the data to apply.
        """

        if isinstance(field_index_or_name, str):
            fld_index = self._getfieldindex(field_index_or_name)
        else:
            fld_index = field_index_or_name
        self._SetFieldBinary(fld_index, value)

    def _SetField2(self, fld_index, value):
        if isinstance(fld_index, str):
            fld_index = self._getfieldindex(fld_index)
        if (fld_index < 0) or (fld_index > self.GetFieldCount()):
            raise KeyError("Illegal field requested in _SetField2()")

        if value is None:
            self.SetFieldNull(fld_index)
            return

        if isinstance(value, list):
            if not value:
                self.SetFieldNull(fld_index)
                return
            if isinstance(value[0], type(1)) or isinstance(value[0], type(12345678901234)):
                self.SetFieldInteger64List(fld_index, value)
                return
            elif isinstance(value[0], float):
                self.SetFieldDoubleList(fld_index, value)
                return
            elif isinstance(value[0], str):
                self.SetFieldStringList(fld_index, value)
                return
            else:
                raise TypeError('Unsupported type of list in _SetField2(). Type of element is %s' % str(type(value[0])))

        if isinstance(value, (bytes, bytearray, memoryview)) and self.GetFieldType(fld_index) == OFTBinary:
            self._SetFieldBinary(fld_index, value)
            return

        try:
            self.SetField(fld_index, value)
        except:
            self.SetField(fld_index, str(value))
        return

    def keys(self):
        """Return the list of field names (of the layer definition)"""
        names = []
        for i in range(self.GetFieldCount()):
            fieldname = self.GetFieldDefnRef(i).GetName()
            names.append(fieldname)
        return names

    def items(self):
        """Return a dictionary with the field names as key, and their value in the feature"""
        keys = self.keys()
        output = {}
        for key in keys:
            output[key] = self.GetField(key)
        return output

    def geometry(self):
        """ Return the feature geometry

            The lifetime of the returned geometry is bound to the one of its belonging
            feature.

            For more details: :cpp:func:`OGR_F_GetGeometryRef`

            The GetGeometryRef() method is also available as an alias of geometry()

            Returns
            --------
            Geometry:
                the geometry, or None.
        """

        return self.GetGeometryRef()

    def __del__(self):
        self._invalidate_geom_refs()

    def __repr__(self):
        return self.DumpReadableAsString()


    def ExportToJson(self, as_object=False, options=None):
        """Exports a GeoJSON object which represents the Feature. The
           as_object parameter determines whether the returned value
           should be a Python object instead of a string. Defaults to False.
           The options parameter is passed to Geometry.ExportToJson()"""

        try:
            import simplejson
        except ImportError:
            try:
                import json as simplejson
            except ImportError:
                raise ImportError("Unable to import simplejson or json, needed for ExportToJson.")

        geom = self.GetGeometryRef()
        if geom is not None:
            if options is None:
                options = []
            geom_json_string = geom.ExportToJson(options=options)
            geom_json_object = simplejson.loads(geom_json_string)
        else:
            geom_json_object = None

        output = {'type':'Feature',
                   'geometry': geom_json_object,
                   'properties': {}
                  }

        fid = self.GetFID()
        if fid != NullFID:
            output['id'] = fid

        for key in self.keys():
            fld_defn = self.GetFieldDefnRef(self.GetFieldIndex(key))
            if fld_defn.GetType() == _ogr.OFTInteger and fld_defn.GetSubType() == _ogr.OFSTBoolean:
                output['properties'][key] = bool(self.GetField(key))
            else:
                output['properties'][key] = self.GetField(key)

        if not as_object:
            output = simplejson.dumps(output)

        return output


    def _add_geom_ref(self, geom):
        if geom is None:
            return

        if not hasattr(self, '_geom_references'):
            import weakref

            self._geom_references = weakref.WeakSet()

        self._geom_references.add(geom)


    def _invalidate_geom_refs(self):
        if hasattr(self, '_geom_references'):
            for geom in self._geom_references:
                geom.this = None



# Register Feature in _ogr:
_ogr.Feature_swigregister(Feature)
class FeatureDefn(object):
    r"""Proxy of C++ OGRFeatureDefnShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _ogr.delete_FeatureDefn

    def __init__(self, *args, **kwargs):
        r"""__init__(FeatureDefn self, char const * name_null_ok=None) -> FeatureDefn"""
        _ogr.FeatureDefn_swiginit(self, _ogr.new_FeatureDefn(*args, **kwargs))

    def GetName(self, *args):
        r"""
        GetName(FeatureDefn self) -> char const *
        const char\*
        OGR_FD_GetName(OGRFeatureDefnH hDefn)

        Get name of the OGRFeatureDefn passed as an argument.

        This function is the same as the C++ method OGRFeatureDefn::GetName().

        Parameters
        -----------
        hDefn:
            handle to the feature definition to get the name from.

        Returns
        --------
        str:
            the name. This name is internal and should not be modified, or freed.

        """
        return _ogr.FeatureDefn_GetName(self, *args)

    def GetFieldCount(self, *args):
        r"""
        GetFieldCount(FeatureDefn self) -> int
        int
        OGR_FD_GetFieldCount(OGRFeatureDefnH hDefn)

        Fetch number of fields on the passed feature definition.

        This function is the same as the C++ OGRFeatureDefn::GetFieldCount().

        Parameters
        -----------
        hDefn:
            handle to the feature definition to get the fields count from.

        Returns
        --------
        int:
            count of fields.

        """
        return _ogr.FeatureDefn_GetFieldCount(self, *args)

    def GetFieldDefn(self, *args):
        r"""
        GetFieldDefn(FeatureDefn self, int i) -> FieldDefn
        OGRFieldDefnH
        OGR_FD_GetFieldDefn(OGRFeatureDefnH hDefn, int iField)

        Fetch field definition of the passed feature definition.

        This function is the same as the C++ method
        OGRFeatureDefn::GetFieldDefn().

        Parameters
        -----------
        hDefn:
            handle to the feature definition to get the field definition from.
        iField:
            the field to fetch, between 0 and GetFieldCount()-1.

        Returns
        --------
        OGRFieldDefnH:
            a handle to an internal field definition object or NULL if invalid
            index. This object should not be modified or freed by the application.

        """
        return _ogr.FeatureDefn_GetFieldDefn(self, *args)

    def GetFieldIndex(self, *args):
        r"""
        GetFieldIndex(FeatureDefn self, char const * field_name) -> int
        int
        OGR_FD_GetFieldIndex(OGRFeatureDefnH hDefn, const char \*pszFieldName)

        Find field by name.

        The field index of the first field matching the passed field name
        (case insensitively) is returned.

        This function is the same as the C++ method
        OGRFeatureDefn::GetFieldIndex.

        Parameters
        -----------
        hDefn:
            handle to the feature definition to get field index from.
        pszFieldName:
            the field name to search for.

        Returns
        --------
        int:
            the field index, or -1 if no match found.

        """
        return _ogr.FeatureDefn_GetFieldIndex(self, *args)

    def AddFieldDefn(self, *args):
        r"""
        AddFieldDefn(FeatureDefn self, FieldDefn defn)
        void
        OGR_FD_AddFieldDefn(OGRFeatureDefnH hDefn, OGRFieldDefnH hNewField)

        Add a new field definition to the passed feature definition.

        To add a new field definition to a layer definition, do not use this
        function directly, but use OGR_L_CreateField() instead.

        This function should only be called while there are no OGRFeature
        objects in existence based on this OGRFeatureDefn. The OGRFieldDefn
        passed in is copied, and remains the responsibility of the caller.

        This function is the same as the C++ method
        OGRFeatureDefn::AddFieldDefn().

        Parameters
        -----------
        hDefn:
            handle to the feature definition to add the field definition to.
        hNewField:
            handle to the new field definition.

        """
        return _ogr.FeatureDefn_AddFieldDefn(self, *args)

    def GetGeomFieldCount(self, *args):
        r"""
        GetGeomFieldCount(FeatureDefn self) -> int
        int
        OGR_FD_GetGeomFieldCount(OGRFeatureDefnH hDefn)

        Fetch number of geometry fields on the passed feature definition.

        This function is the same as the C++
        OGRFeatureDefn::GetGeomFieldCount().

        .. versionadded:: 1.11

        Parameters
        -----------
        hDefn:
            handle to the feature definition to get the fields count from.

        Returns
        --------
        int:
            count of geometry fields.

        """
        return _ogr.FeatureDefn_GetGeomFieldCount(self, *args)

    def GetGeomFieldDefn(self, *args):
        r"""
        GetGeomFieldDefn(FeatureDefn self, int i) -> GeomFieldDefn
        OGRGeomFieldDefnH
        OGR_FD_GetGeomFieldDefn(OGRFeatureDefnH hDefn, int iGeomField)

        Fetch geometry field definition of the passed feature definition.

        This function is the same as the C++ method
        OGRFeatureDefn::GetGeomFieldDefn().

        .. versionadded:: 1.11

        Parameters
        -----------
        hDefn:
            handle to the feature definition to get the field definition from.
        iGeomField:
            the geometry field to fetch, between 0 and GetGeomFieldCount() - 1.

        Returns
        --------
        OGRGeomFieldDefnH:
            a handle to an internal field definition object or NULL if invalid
            index. This object should not be modified or freed by the application.

        """
        return _ogr.FeatureDefn_GetGeomFieldDefn(self, *args)

    def GetGeomFieldIndex(self, *args):
        r"""
        GetGeomFieldIndex(FeatureDefn self, char const * field_name) -> int
        int
        OGR_FD_GetGeomFieldIndex(OGRFeatureDefnH hDefn, const char
        \*pszGeomFieldName)

        Find geometry field by name.

        The geometry field index of the first geometry field matching the
        passed field name (case insensitively) is returned.

        This function is the same as the C++ method
        OGRFeatureDefn::GetGeomFieldIndex.

        Parameters
        -----------
        hDefn:
            handle to the feature definition to get field index from.
        pszGeomFieldName:
            the geometry field name to search for.

        Returns
        --------
        int:
            the geometry field index, or -1 if no match found.

        """
        return _ogr.FeatureDefn_GetGeomFieldIndex(self, *args)

    def AddGeomFieldDefn(self, *args):
        r"""
        AddGeomFieldDefn(FeatureDefn self, GeomFieldDefn defn)
        void
        OGR_FD_AddGeomFieldDefn(OGRFeatureDefnH hDefn, OGRGeomFieldDefnH
        hNewGeomField)

        Add a new field definition to the passed feature definition.

        To add a new field definition to a layer definition, do not use this
        function directly, but use OGR_L_CreateGeomField() instead.

        This function should only be called while there are no OGRFeature
        objects in existence based on this OGRFeatureDefn. The
        OGRGeomFieldDefn passed in is copied, and remains the responsibility
        of the caller.

        This function is the same as the C++ method
        OGRFeatureDefn::AddGeomFieldDefn().

        .. versionadded:: 1.11

        Parameters
        -----------
        hDefn:
            handle to the feature definition to add the geometry field
            definition to.
        hNewGeomField:
            handle to the new field definition.

        """
        return _ogr.FeatureDefn_AddGeomFieldDefn(self, *args)

    def DeleteGeomFieldDefn(self, *args):
        r"""
        DeleteGeomFieldDefn(FeatureDefn self, int idx) -> OGRErr
        OGRErr
        OGR_FD_DeleteGeomFieldDefn(OGRFeatureDefnH hDefn, int iGeomField)

        Delete an existing geometry field definition.

        To delete an existing geometry field definition from a layer
        definition, do not use this function directly, but use
        OGR_L_DeleteGeomField() instead ( not implemented yet).

        This method should only be called while there are no OGRFeature
        objects in existence based on this OGRFeatureDefn.

        This method is the same as the C++ method
        OGRFeatureDefn::DeleteGeomFieldDefn().

        .. versionadded:: 1.11

        Parameters
        -----------
        hDefn:
            handle to the feature definition.
        iGeomField:
            the index of the geometry field definition.

        Returns
        --------
        OGRErr:
            OGRERR_NONE in case of success.

        """
        return _ogr.FeatureDefn_DeleteGeomFieldDefn(self, *args)

    def GetGeomType(self, *args):
        r"""
        GetGeomType(FeatureDefn self) -> OGRwkbGeometryType
        OGRwkbGeometryType
        OGR_FD_GetGeomType(OGRFeatureDefnH hDefn)

        Fetch the geometry base type of the passed feature definition.

        This function is the same as the C++ method
        OGRFeatureDefn::GetGeomType().

        Starting with GDAL 1.11, this method returns
        GetGeomFieldDefn(0)->GetType().

        Parameters
        -----------
        hDefn:
            handle to the feature definition to get the geometry type from.

        Returns
        --------
        OGRwkbGeometryType:
            the base type for all geometry related to this definition.

        """
        return _ogr.FeatureDefn_GetGeomType(self, *args)

    def SetGeomType(self, *args):
        r"""
        SetGeomType(FeatureDefn self, OGRwkbGeometryType geom_type)
        void
        OGR_FD_SetGeomType(OGRFeatureDefnH hDefn, OGRwkbGeometryType eType)

        Assign the base geometry type for the passed layer (the same as the
        feature definition).

        All geometry objects using this type must be of the defined type or a
        derived type. The default upon creation is wkbUnknown which allows for
        any geometry type. The geometry type should generally not be changed
        after any OGRFeatures have been created against this definition.

        This function is the same as the C++ method
        OGRFeatureDefn::SetGeomType().

        Starting with GDAL 1.11, this method calls
        GetGeomFieldDefn(0)->SetType().

        Parameters
        -----------
        hDefn:
            handle to the layer or feature definition to set the geometry type to.
        eType:
            the new type to assign.

        """
        return _ogr.FeatureDefn_SetGeomType(self, *args)

    def GetReferenceCount(self, *args):
        r"""
        GetReferenceCount(FeatureDefn self) -> int
        int
        OGR_FD_GetReferenceCount(OGRFeatureDefnH hDefn)

        Fetch current reference count.

        This function is the same as the C++ method
        OGRFeatureDefn::GetReferenceCount().

        Parameters
        -----------
        hDefn:
            handle to the feature definition on witch OGRFeature are based on.

        Returns
        --------
        int:
            the current reference count.

        """
        return _ogr.FeatureDefn_GetReferenceCount(self, *args)

    def IsGeometryIgnored(self, *args):
        r"""
        IsGeometryIgnored(FeatureDefn self) -> int
        int
        OGR_FD_IsGeometryIgnored(OGRFeatureDefnH hDefn)

        Determine whether the geometry can be omitted when fetching features.

        This function is the same as the C++ method
        OGRFeatureDefn::IsGeometryIgnored().

        Starting with GDAL 1.11, this method returns
        GetGeomFieldDefn(0)->IsIgnored().

        Parameters
        -----------
        hDefn:
            handle to the feature definition on witch OGRFeature are based on.

        Returns
        --------
        int:
            ignore state

        """
        return _ogr.FeatureDefn_IsGeometryIgnored(self, *args)

    def SetGeometryIgnored(self, *args):
        r"""
        SetGeometryIgnored(FeatureDefn self, int bIgnored)
        void
        OGR_FD_SetGeometryIgnored(OGRFeatureDefnH hDefn, int bIgnore)

        Set whether the geometry can be omitted when fetching features.

        This function is the same as the C++ method
        OGRFeatureDefn::SetGeometryIgnored().

        Starting with GDAL 1.11, this method calls
        GetGeomFieldDefn(0)->SetIgnored().

        Parameters
        -----------
        hDefn:
            handle to the feature definition on witch OGRFeature are based on.
        bIgnore:
            ignore state

        """
        return _ogr.FeatureDefn_SetGeometryIgnored(self, *args)

    def IsStyleIgnored(self, *args):
        r"""
        IsStyleIgnored(FeatureDefn self) -> int
        int
        OGR_FD_IsStyleIgnored(OGRFeatureDefnH hDefn)

        Determine whether the style can be omitted when fetching features.

        This function is the same as the C++ method
        OGRFeatureDefn::IsStyleIgnored().

        Parameters
        -----------
        hDefn:
            handle to the feature definition on which OGRFeature are based on.

        Returns
        --------
        int:
            ignore state

        """
        return _ogr.FeatureDefn_IsStyleIgnored(self, *args)

    def SetStyleIgnored(self, *args):
        r"""
        SetStyleIgnored(FeatureDefn self, int bIgnored)
        void
        OGR_FD_SetStyleIgnored(OGRFeatureDefnH hDefn, int bIgnore)

        Set whether the style can be omitted when fetching features.

        This function is the same as the C++ method
        OGRFeatureDefn::SetStyleIgnored().

        Parameters
        -----------
        hDefn:
            handle to the feature definition on witch OGRFeature are based on.
        bIgnore:
            ignore state

        """
        return _ogr.FeatureDefn_SetStyleIgnored(self, *args)

    def IsSame(self, *args):
        r"""
        IsSame(FeatureDefn self, FeatureDefn other_defn) -> int
        int OGR_FD_IsSame(OGRFeatureDefnH
        hFDefn, OGRFeatureDefnH hOtherFDefn)

        Test if the feature definition is identical to the other one.

        .. versionadded:: 1.11

        Parameters
        -----------
        hFDefn:
            handle to the feature definition on witch OGRFeature are based on.
        hOtherFDefn:
            handle to the other feature definition to compare to.

        Returns
        --------
        int:
            TRUE if the feature definition is identical to the other one.

        """
        return _ogr.FeatureDefn_IsSame(self, *args)

    def Destroy(self):
      "Once called, self has effectively been destroyed.  Do not access. For backwards compatibility only"
      _ogr.delete_FeatureDefn(self)
      self.thisown = 0



# Register FeatureDefn in _ogr:
_ogr.FeatureDefn_swigregister(FeatureDefn)
class FieldDefn(object):
    r"""Proxy of C++ OGRFieldDefnShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _ogr.delete_FieldDefn

    def __init__(self, *args, **kwargs):
        r"""__init__(FieldDefn self, char const * name_null_ok="unnamed", OGRFieldType field_type=OFTString) -> FieldDefn"""
        _ogr.FieldDefn_swiginit(self, _ogr.new_FieldDefn(*args, **kwargs))

    def GetName(self, *args):
        r"""GetName(FieldDefn self) -> char const *"""
        return _ogr.FieldDefn_GetName(self, *args)

    def GetNameRef(self, *args):
        r"""
        GetNameRef(FieldDefn self) -> char const *
        const char\*
        OGR_Fld_GetNameRef(OGRFieldDefnH hDefn)

        Fetch name of this field.

        This function is the same as the CPP method
        OGRFieldDefn::GetNameRef().

        Parameters
        -----------
        hDefn:
            handle to the field definition.

        Returns
        --------
        str:
            the name of the field definition.

        """
        return _ogr.FieldDefn_GetNameRef(self, *args)

    def SetName(self, *args):
        r"""
        SetName(FieldDefn self, char const * name)
        void OGR_Fld_SetName(OGRFieldDefnH
        hDefn, const char \*pszName)

        Reset the name of this field.

        This function is the same as the CPP method OGRFieldDefn::SetName().

        Parameters
        -----------
        hDefn:
            handle to the field definition to apply the new name to.
        pszName:
            the new name to apply.

        """
        return _ogr.FieldDefn_SetName(self, *args)

    def GetAlternativeName(self, *args):
        r"""GetAlternativeName(FieldDefn self) -> char const *"""
        return _ogr.FieldDefn_GetAlternativeName(self, *args)

    def GetAlternativeNameRef(self, *args):
        r"""
        GetAlternativeNameRef(FieldDefn self) -> char const *
        const char\*
        OGR_Fld_GetAlternativeNameRef(OGRFieldDefnH hDefn)

        Fetch the alternative name (or "alias") for this field.

        The alternative name is an optional attribute for a field which can
        provide a more user-friendly, descriptive name of a field which is not
        subject to the usual naming constraints defined by the data provider.

        This is a metadata style attribute only: the alternative name cannot
        be used in place of the actual field name during SQL queries or other
        field name dependent API calls.

        This function is the same as the CPP method
        OGRFieldDefn::GetAlternativeNameRef().

        .. versionadded:: 3.2

        Parameters
        -----------
        hDefn:
            handle to the field definition.

        Returns
        --------
        str:
            the alternative name of the field definition.

        """
        return _ogr.FieldDefn_GetAlternativeNameRef(self, *args)

    def SetAlternativeName(self, *args):
        r"""
        SetAlternativeName(FieldDefn self, char const * alternativeName)
        void
        OGR_Fld_SetAlternativeName(OGRFieldDefnH hDefn, const char
        \*pszAlternativeName)

        Reset the alternative name (or "alias") for this field.

        The alternative name is an optional attribute for a field which can
        provide a more user-friendly, descriptive name of a field which is not
        subject to the usual naming constraints defined by the data provider.

        This is a metadata style attribute only: the alternative name cannot
        be used in place of the actual field name during SQL queries or other
        field name dependent API calls.

        This function is the same as the CPP method
        OGRFieldDefn::SetAlternativeName().

        .. versionadded:: 3.2

        Parameters
        -----------
        hDefn:
            handle to the field definition to apply the new alternative name to.
        pszAlternativeName:
            the new alternative name to apply.

        """
        return _ogr.FieldDefn_SetAlternativeName(self, *args)

    def GetType(self, *args):
        r"""
        GetType(FieldDefn self) -> OGRFieldType
        OGRFieldType
        OGR_Fld_GetType(OGRFieldDefnH hDefn)

        Fetch type of this field.

        This function is the same as the CPP method OGRFieldDefn::GetType().

        Parameters
        -----------
        hDefn:
            handle to the field definition to get type from.

        Returns
        --------
        OGRFieldType:
            field type.

        """
        return _ogr.FieldDefn_GetType(self, *args)

    def SetType(self, *args):
        r"""
        SetType(FieldDefn self, OGRFieldType type)
        void OGR_Fld_SetType(OGRFieldDefnH
        hDefn, OGRFieldType eType)

        Set the type of this field.

        This should never be done to an OGRFieldDefn that is already part of
        an OGRFeatureDefn.

        This function is the same as the CPP method OGRFieldDefn::SetType().

        Parameters
        -----------
        hDefn:
            handle to the field definition to set type to.
        eType:
            the new field type.

        """
        return _ogr.FieldDefn_SetType(self, *args)

    def GetSubType(self, *args):
        r"""
        GetSubType(FieldDefn self) -> OGRFieldSubType
        OGRFieldSubType
        OGR_Fld_GetSubType(OGRFieldDefnH hDefn)

        Fetch subtype of this field.

        This function is the same as the CPP method
        OGRFieldDefn::GetSubType().

        .. versionadded:: 2.0

        Parameters
        -----------
        hDefn:
            handle to the field definition to get subtype from.

        Returns
        --------
        OGRFieldSubType:
            field subtype.

        """
        return _ogr.FieldDefn_GetSubType(self, *args)

    def SetSubType(self, *args):
        r"""
        SetSubType(FieldDefn self, OGRFieldSubType type)
        void
        OGR_Fld_SetSubType(OGRFieldDefnH hDefn, OGRFieldSubType eSubType)

        Set the subtype of this field.

        This should never be done to an OGRFieldDefn that is already part of
        an OGRFeatureDefn.

        This function is the same as the CPP method
        OGRFieldDefn::SetSubType().

        .. versionadded:: 2.0

        Parameters
        -----------
        hDefn:
            handle to the field definition to set type to.
        eSubType:
            the new field subtype.

        """
        return _ogr.FieldDefn_SetSubType(self, *args)

    def GetJustify(self, *args):
        r"""
        GetJustify(FieldDefn self) -> OGRJustification
        OGRJustification
        OGR_Fld_GetJustify(OGRFieldDefnH hDefn)

        Get the justification for this field.

        This function is the same as the CPP method
        OGRFieldDefn::GetJustify().

        Note: no driver is know to use the concept of field justification.

        Parameters
        -----------
        hDefn:
            handle to the field definition to get justification from.

        Returns
        --------
        OGRJustification:
            the justification.

        """
        return _ogr.FieldDefn_GetJustify(self, *args)

    def SetJustify(self, *args):
        r"""
        SetJustify(FieldDefn self, OGRJustification justify)
        void
        OGR_Fld_SetJustify(OGRFieldDefnH hDefn, OGRJustification eJustify)

        Set the justification for this field.

        Note: no driver is know to use the concept of field justification.

        This function is the same as the CPP method
        OGRFieldDefn::SetJustify().

        Parameters
        -----------
        hDefn:
            handle to the field definition to set justification to.
        eJustify:
            the new justification.

        """
        return _ogr.FieldDefn_SetJustify(self, *args)

    def GetWidth(self, *args):
        r"""
        GetWidth(FieldDefn self) -> int
        int OGR_Fld_GetWidth(OGRFieldDefnH
        hDefn)

        Get the formatting width for this field.

        This function is the same as the CPP method OGRFieldDefn::GetWidth().

        Parameters
        -----------
        hDefn:
            handle to the field definition to get width from.


        Returns
        --------
        int:
            the width, zero means no specified width.

        """
        return _ogr.FieldDefn_GetWidth(self, *args)

    def SetWidth(self, *args):
        r"""
        SetWidth(FieldDefn self, int width)
        void OGR_Fld_SetWidth(OGRFieldDefnH
        hDefn, int nNewWidth)

        Set the formatting width for this field in characters.

        This function is the same as the CPP method OGRFieldDefn::SetWidth().

        Parameters
        -----------
        hDefn:
            handle to the field definition to set width to.
        nNewWidth:
            the new width.

        """
        return _ogr.FieldDefn_SetWidth(self, *args)

    def GetPrecision(self, *args):
        r"""
        GetPrecision(FieldDefn self) -> int
        int
        OGR_Fld_GetPrecision(OGRFieldDefnH hDefn)

        Get the formatting precision for this field.

        This should normally be zero for fields of types other than OFTReal.

        This function is the same as the CPP method
        OGRFieldDefn::GetPrecision().

        Parameters
        -----------
        hDefn:
            handle to the field definition to get precision from.

        Returns
        --------
        int:
            the precision.

        """
        return _ogr.FieldDefn_GetPrecision(self, *args)

    def SetPrecision(self, *args):
        r"""
        SetPrecision(FieldDefn self, int precision)
        void
        OGR_Fld_SetPrecision(OGRFieldDefnH hDefn, int nPrecision)

        Set the formatting precision for this field in characters.

        This should normally be zero for fields of types other than OFTReal.

        This function is the same as the CPP method
        OGRFieldDefn::SetPrecision().

        Parameters
        -----------
        hDefn:
            handle to the field definition to set precision to.
        nPrecision:
            the new precision.

        """
        return _ogr.FieldDefn_SetPrecision(self, *args)

    def GetTZFlag(self, *args):
        r"""GetTZFlag(FieldDefn self) -> int"""
        return _ogr.FieldDefn_GetTZFlag(self, *args)

    def SetTZFlag(self, *args):
        r"""SetTZFlag(FieldDefn self, int tzflag)"""
        return _ogr.FieldDefn_SetTZFlag(self, *args)

    def GetTypeName(self, *args):
        r"""GetTypeName(FieldDefn self) -> char const *"""
        return _ogr.FieldDefn_GetTypeName(self, *args)

    def GetFieldTypeName(self, *args):
        r"""GetFieldTypeName(FieldDefn self, OGRFieldType type) -> char const *"""
        return _ogr.FieldDefn_GetFieldTypeName(self, *args)

    def IsIgnored(self, *args):
        r"""
        IsIgnored(FieldDefn self) -> int
        int OGR_Fld_IsIgnored(OGRFieldDefnH
        hDefn)

        Return whether this field should be omitted when fetching features.

        This method is the same as the C++ method OGRFieldDefn::IsIgnored().

        Parameters
        -----------
        hDefn:
            handle to the field definition

        Returns
        --------
        int:
            ignore state

        """
        return _ogr.FieldDefn_IsIgnored(self, *args)

    def SetIgnored(self, *args):
        r"""
        SetIgnored(FieldDefn self, int bIgnored)
        void
        OGR_Fld_SetIgnored(OGRFieldDefnH hDefn, int ignore)

        Set whether this field should be omitted when fetching features.

        This method is the same as the C++ method OGRFieldDefn::SetIgnored().

        Parameters
        -----------
        hDefn:
            handle to the field definition
        ignore:
            ignore state

        """
        return _ogr.FieldDefn_SetIgnored(self, *args)

    def IsNullable(self, *args):
        r"""
        IsNullable(FieldDefn self) -> int
        int
        OGR_Fld_IsNullable(OGRFieldDefnH hDefn)

        Return whether this field can receive null values.

        By default, fields are nullable.

        Even if this method returns FALSE (i.e not-nullable field), it doesn't
        mean that OGRFeature::IsFieldSet() will necessary return TRUE, as
        fields can be temporary unset and null/not-null validation is usually
        done when OGRLayer::CreateFeature()/SetFeature() is called.

        This method is the same as the C++ method OGRFieldDefn::IsNullable().

        .. versionadded:: 2.0

        Parameters
        -----------
        hDefn:
            handle to the field definition


        Returns
        --------
        int:
            TRUE if the field is authorized to be null.

        """
        return _ogr.FieldDefn_IsNullable(self, *args)

    def SetNullable(self, *args):
        r"""
        SetNullable(FieldDefn self, int bNullable)
        void
        OGR_Fld_SetNullable(OGRFieldDefnH hDefn, int bNullableIn)

        Set whether this field can receive null values.

        By default, fields are nullable, so this method is generally called
        with FALSE to set a not-null constraint.

        Drivers that support writing not-null constraint will advertise the
        GDAL_DCAP_NOTNULL_FIELDS driver metadata item.

        This method is the same as the C++ method OGRFieldDefn::SetNullable().

        .. versionadded:: 2.0

        Parameters
        -----------
        hDefn:
            handle to the field definition
        bNullableIn:
            FALSE if the field must have a not-null constraint.

        """
        return _ogr.FieldDefn_SetNullable(self, *args)

    def IsUnique(self, *args):
        r"""
        IsUnique(FieldDefn self) -> int
        int OGR_Fld_IsUnique(OGRFieldDefnH
        hDefn)

        Return whether this field has a unique constraint.

        By default, fields have no unique constraint.

        This method is the same as the C++ method OGRFieldDefn::IsUnique().

        .. versionadded:: 3.2

        Parameters
        -----------
        hDefn:
            handle to the field definition


        Returns
        --------
        int:
            TRUE if the field has a unique constraint.

        """
        return _ogr.FieldDefn_IsUnique(self, *args)

    def SetUnique(self, *args):
        r"""
        SetUnique(FieldDefn self, int bUnique)
        void
        OGR_Fld_SetUnique(OGRFieldDefnH hDefn, int bUniqueIn)

        Set whether this field has a unique constraint.

        By default, fields have no unique constraint, so this method is
        generally called with TRUE to set a unique constraint.

        Drivers that support writing unique constraint will advertise the
        GDAL_DCAP_UNIQUE_FIELDS driver metadata item. field can receive null
        values.

        This method is the same as the C++ method OGRFieldDefn::SetUnique().

        .. versionadded:: 3.2

        Parameters
        -----------
        hDefn:
            handle to the field definition
        bUniqueIn:
            TRUE if the field must have a unique constraint.

        """
        return _ogr.FieldDefn_SetUnique(self, *args)

    def GetDefault(self, *args):
        r"""
        GetDefault(FieldDefn self) -> char const *
        const char\*
        OGR_Fld_GetDefault(OGRFieldDefnH hDefn)

        Get default field value.

        This function is the same as the C++ method
        OGRFieldDefn::GetDefault().

        .. versionadded:: 2.0

        Parameters
        -----------
        hDefn:
            handle to the field definition.

        Returns
        --------
        str:
            default field value or NULL.

        """
        return _ogr.FieldDefn_GetDefault(self, *args)

    def SetDefault(self, *args):
        r"""
        SetDefault(FieldDefn self, char const * pszValue)
        void
        OGR_Fld_SetDefault(OGRFieldDefnH hDefn, const char \*pszDefault)

        Set default field value.

        The default field value is taken into account by drivers (generally
        those with a SQL interface) that support it at field creation time.
        OGR will generally not automatically set the default field value to
        null fields by itself when calling OGRFeature::CreateFeature() /
        OGRFeature::SetFeature(), but will let the low-level layers to do the
        job. So retrieving the feature from the layer is recommended.

        The accepted values are NULL, a numeric value, a literal value
        enclosed between single quote characters (and inner single quote
        characters escaped by repetition of the single quote character),
        CURRENT_TIMESTAMP, CURRENT_TIME, CURRENT_DATE or a driver specific
        expression (that might be ignored by other drivers). For a datetime
        literal value, format should be 'YYYY/MM/DD HH:MM:SS[.sss]'
        (considered as UTC time).

        Drivers that support writing DEFAULT clauses will advertise the
        GDAL_DCAP_DEFAULT_FIELDS driver metadata item.

        This function is the same as the C++ method
        OGRFieldDefn::SetDefault().

        .. versionadded:: 2.0

        Parameters
        -----------
        hDefn:
            handle to the field definition.
        pszDefault:
            new default field value or NULL pointer.

        """
        return _ogr.FieldDefn_SetDefault(self, *args)

    def IsDefaultDriverSpecific(self, *args):
        r"""
        IsDefaultDriverSpecific(FieldDefn self) -> int
        int
        OGR_Fld_IsDefaultDriverSpecific(OGRFieldDefnH hDefn)

        Returns whether the default value is driver specific.

        Driver specific default values are those that are not NULL, a numeric
        value, a literal value enclosed between single quote characters,
        CURRENT_TIMESTAMP, CURRENT_TIME, CURRENT_DATE or datetime literal
        value.

        This function is the same as the C++ method
        OGRFieldDefn::IsDefaultDriverSpecific().

        .. versionadded:: 2.0

        Parameters
        -----------
        hDefn:
            handle to the field definition


        Returns
        --------
        int:
            TRUE if the default value is driver specific.

        """
        return _ogr.FieldDefn_IsDefaultDriverSpecific(self, *args)

    def GetDomainName(self, *args):
        r"""
        GetDomainName(FieldDefn self) -> char const *
        const char\*
        OGR_Fld_GetDomainName(OGRFieldDefnH hDefn)

        Return the name of the field domain for this field.

        By default, none (empty string) is returned.

        Field domains ( OGRFieldDomain class) are attached at the GDALDataset
        level and should be retrieved with GDALDatasetGetFieldDomain().

        This method is the same as the C++ method
        OGRFieldDefn::GetDomainName().

        .. versionadded:: 3.3

        Parameters
        -----------
        hDefn:
            handle to the field definition

        Returns
        --------
        str:
            the field domain name, or an empty string if there is none.

        """
        return _ogr.FieldDefn_GetDomainName(self, *args)

    def SetDomainName(self, *args):
        r"""
        SetDomainName(FieldDefn self, char const * name)
        void
        OGR_Fld_SetDomainName(OGRFieldDefnH hDefn, const char \*pszFieldName)

        Set the name of the field domain for this field.

        Field domains ( OGRFieldDomain) are attached at the GDALDataset level.

        This method is the same as the C++ method
        OGRFieldDefn::SetDomainName().

        .. versionadded:: 3.3

        Parameters
        -----------
        hDefn:
            handle to the field definition
        pszFieldName:
            Field domain name.

        """
        return _ogr.FieldDefn_SetDomainName(self, *args)

    def GetComment(self, *args):
        r"""GetComment(FieldDefn self) -> char const *"""
        return _ogr.FieldDefn_GetComment(self, *args)

    def SetComment(self, *args):
        r"""SetComment(FieldDefn self, char const * comment)"""
        return _ogr.FieldDefn_SetComment(self, *args)

    width = property(GetWidth, SetWidth)
    type = property(GetType, SetType)
    precision = property(GetPrecision, SetPrecision)
    name = property(GetName, SetName)
    justify = property(GetJustify, SetJustify)


    def Destroy(self):
      "Once called, self has effectively been destroyed.  Do not access. For backwards compatibility only"
      _ogr.delete_FieldDefn(self)
      self.thisown = 0


# Register FieldDefn in _ogr:
_ogr.FieldDefn_swigregister(FieldDefn)
class GeomFieldDefn(object):
    r"""Proxy of C++ OGRGeomFieldDefnShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _ogr.delete_GeomFieldDefn

    def __init__(self, *args, **kwargs):
        r"""__init__(GeomFieldDefn self, char const * name_null_ok="", OGRwkbGeometryType field_type=wkbUnknown) -> GeomFieldDefn"""
        _ogr.GeomFieldDefn_swiginit(self, _ogr.new_GeomFieldDefn(*args, **kwargs))

    def GetName(self, *args):
        r"""GetName(GeomFieldDefn self) -> char const *"""
        return _ogr.GeomFieldDefn_GetName(self, *args)

    def GetNameRef(self, *args):
        r"""GetNameRef(GeomFieldDefn self) -> char const *"""
        return _ogr.GeomFieldDefn_GetNameRef(self, *args)

    def SetName(self, *args):
        r"""SetName(GeomFieldDefn self, char const * name)"""
        return _ogr.GeomFieldDefn_SetName(self, *args)

    def GetType(self, *args):
        r"""GetType(GeomFieldDefn self) -> OGRwkbGeometryType"""
        return _ogr.GeomFieldDefn_GetType(self, *args)

    def SetType(self, *args):
        r"""SetType(GeomFieldDefn self, OGRwkbGeometryType type)"""
        return _ogr.GeomFieldDefn_SetType(self, *args)

    def GetSpatialRef(self, *args):
        r"""GetSpatialRef(GeomFieldDefn self) -> SpatialReference"""
        return _ogr.GeomFieldDefn_GetSpatialRef(self, *args)

    def SetSpatialRef(self, *args):
        r"""SetSpatialRef(GeomFieldDefn self, SpatialReference srs)"""
        return _ogr.GeomFieldDefn_SetSpatialRef(self, *args)

    def IsIgnored(self, *args):
        r"""IsIgnored(GeomFieldDefn self) -> int"""
        return _ogr.GeomFieldDefn_IsIgnored(self, *args)

    def SetIgnored(self, *args):
        r"""SetIgnored(GeomFieldDefn self, int bIgnored)"""
        return _ogr.GeomFieldDefn_SetIgnored(self, *args)

    def IsNullable(self, *args):
        r"""IsNullable(GeomFieldDefn self) -> int"""
        return _ogr.GeomFieldDefn_IsNullable(self, *args)

    def SetNullable(self, *args):
        r"""SetNullable(GeomFieldDefn self, int bNullable)"""
        return _ogr.GeomFieldDefn_SetNullable(self, *args)

    type = property(GetType, SetType)
    name = property(GetName, SetName)
    srs = property(GetSpatialRef, SetSpatialRef)


# Register GeomFieldDefn in _ogr:
_ogr.GeomFieldDefn_swigregister(GeomFieldDefn)

def CreateGeometryFromWkb(*args, **kwargs):
    r"""CreateGeometryFromWkb(size_t len, SpatialReference reference=None) -> Geometry"""
    return _ogr.CreateGeometryFromWkb(*args, **kwargs)

def CreateGeometryFromWkt(*args, **kwargs):
    r"""CreateGeometryFromWkt(char ** val, SpatialReference reference=None) -> Geometry"""
    return _ogr.CreateGeometryFromWkt(*args, **kwargs)

def CreateGeometryFromGML(*args):
    r"""CreateGeometryFromGML(char const * input_string) -> Geometry"""
    return _ogr.CreateGeometryFromGML(*args)

def CreateGeometryFromJson(*args):
    r"""CreateGeometryFromJson(char const * input_string) -> Geometry"""
    return _ogr.CreateGeometryFromJson(*args)

def CreateGeometryFromEsriJson(*args):
    r"""CreateGeometryFromEsriJson(char const * input_string) -> Geometry"""
    return _ogr.CreateGeometryFromEsriJson(*args)

def BuildPolygonFromEdges(*args, **kwargs):
    r"""BuildPolygonFromEdges(Geometry hLineCollection, int bBestEffort=0, int bAutoClose=0, double dfTolerance=0) -> Geometry"""
    return _ogr.BuildPolygonFromEdges(*args, **kwargs)

def ApproximateArcAngles(*args, **kwargs):
    r"""ApproximateArcAngles(double dfCenterX, double dfCenterY, double dfZ, double dfPrimaryRadius, double dfSecondaryAxis, double dfRotation, double dfStartAngle, double dfEndAngle, double dfMaxAngleStepSizeDegrees) -> Geometry"""
    return _ogr.ApproximateArcAngles(*args, **kwargs)

def ForceToPolygon(*args):
    r"""ForceToPolygon(Geometry geom_in) -> Geometry"""
    return _ogr.ForceToPolygon(*args)

def ForceToLineString(*args):
    r"""ForceToLineString(Geometry geom_in) -> Geometry"""
    return _ogr.ForceToLineString(*args)

def ForceToMultiPolygon(*args):
    r"""ForceToMultiPolygon(Geometry geom_in) -> Geometry"""
    return _ogr.ForceToMultiPolygon(*args)

def ForceToMultiPoint(*args):
    r"""ForceToMultiPoint(Geometry geom_in) -> Geometry"""
    return _ogr.ForceToMultiPoint(*args)

def ForceToMultiLineString(*args):
    r"""ForceToMultiLineString(Geometry geom_in) -> Geometry"""
    return _ogr.ForceToMultiLineString(*args)

def ForceTo(*args):
    r"""ForceTo(Geometry geom_in, OGRwkbGeometryType eTargetType, char ** options=None) -> Geometry"""
    return _ogr.ForceTo(*args)
class Geometry(object):
    r"""Proxy of C++ OGRGeometryShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _ogr.delete_Geometry

    def __init__(self, *args, **kwargs):
        r"""__init__(Geometry self, OGRwkbGeometryType type=wkbUnknown, char * wkt=None, int wkb=0, char * gml=None) -> Geometry"""
        _ogr.Geometry_swiginit(self, _ogr.new_Geometry(*args, **kwargs))

    def ExportToWkt(self, *args):
        r"""
        ExportToWkt(Geometry self) -> OGRErr

        Convert a geometry into well known text format.

        For more details: :cpp:func:`OGR_G_ExportToWkt`

        Returns
        --------
        str

        """
        return _ogr.Geometry_ExportToWkt(self, *args)

    def ExportToIsoWkt(self, *args):
        r"""
        ExportToIsoWkt(Geometry self) -> OGRErr

        Convert a geometry into SFSQL 1.2 / ISO SQL/MM Part 3 well known text
        format.

        For more details: :cpp:func:`OGR_G_ExportToIsoWkt`

        .. versionadded:: 2.0

        Returns
        --------
        str

        """
        return _ogr.Geometry_ExportToIsoWkt(self, *args)

    def ExportToWkb(self, *args, **kwargs):
        r"""
        ExportToWkb(Geometry self, OGRwkbByteOrder byte_order=wkbNDR) -> OGRErr

        Convert a geometry well known binary format.

        For more details: :cpp:func:`OGR_G_ExportToWkb`

        Parameters
        -----------
        byte_order: osgeo.ogr.wkbXDR | osgeo.ogr.wkbNDR, default=osgeo.ogr.wkbNDR
            One of wkbXDR or wkbNDR indicating MSB or LSB byte order respectively.

        Returns
        --------
        bytes

        """
        return _ogr.Geometry_ExportToWkb(self, *args, **kwargs)

    def ExportToIsoWkb(self, *args, **kwargs):
        r"""
        ExportToIsoWkb(Geometry self, OGRwkbByteOrder byte_order=wkbNDR) -> OGRErr

        Convert a geometry into SFSQL 1.2 / ISO SQL/MM Part 3 well known
        binary format.

        For more details: :cpp:func:`OGR_G_ExportToIsoWkb`

        .. versionadded:: 2.0

        Parameters
        -----------
        byte_order: osgeo.ogr.wkbXDR | osgeo.ogr.wkbNDR, default=osgeo.ogr.wkbNDR
            One of wkbXDR or wkbNDR indicating MSB or LSB byte order respectively.

        Returns
        --------
        bytes

        """
        return _ogr.Geometry_ExportToIsoWkb(self, *args, **kwargs)

    def ExportToGML(self, *args, **kwargs):
        r"""ExportToGML(Geometry self, char ** options=None) -> retStringAndCPLFree *"""
        return _ogr.Geometry_ExportToGML(self, *args, **kwargs)

    def ExportToKML(self, *args):
        r"""ExportToKML(Geometry self, char const * altitude_mode=None) -> retStringAndCPLFree *"""
        return _ogr.Geometry_ExportToKML(self, *args)

    def ExportToJson(self, *args, **kwargs):
        r"""ExportToJson(Geometry self, char ** options=None) -> retStringAndCPLFree *"""
        return _ogr.Geometry_ExportToJson(self, *args, **kwargs)

    def AddPoint(self, *args, **kwargs):
        r"""AddPoint(Geometry self, double x, double y, double z=0)"""
        return _ogr.Geometry_AddPoint(self, *args, **kwargs)

    def AddPointM(self, *args, **kwargs):
        r"""AddPointM(Geometry self, double x, double y, double m)"""
        return _ogr.Geometry_AddPointM(self, *args, **kwargs)

    def AddPointZM(self, *args, **kwargs):
        r"""AddPointZM(Geometry self, double x, double y, double z, double m)"""
        return _ogr.Geometry_AddPointZM(self, *args, **kwargs)

    def AddPoint_2D(self, *args):
        r"""AddPoint_2D(Geometry self, double x, double y)"""
        return _ogr.Geometry_AddPoint_2D(self, *args)

    def AddGeometryDirectly(self, *args):
        r"""AddGeometryDirectly(Geometry self, Geometry other_disown) -> OGRErr"""
        return _ogr.Geometry_AddGeometryDirectly(self, *args)

    def AddGeometry(self, *args):
        r"""AddGeometry(Geometry self, Geometry other) -> OGRErr"""
        return _ogr.Geometry_AddGeometry(self, *args)

    def RemoveGeometry(self, *args):
        r"""RemoveGeometry(Geometry self, int iSubGeom) -> OGRErr"""
        return _ogr.Geometry_RemoveGeometry(self, *args)

    def Clone(self, *args):
        r"""
        Clone(Geometry self) -> Geometry

        Make a copy of this object.

        For more details: :cpp:func:`OGR_G_Clone`

        Returns
        --------
        Geometry:
            The copy of the geometry with the same spatial reference system
            as the original.

        """
        return _ogr.Geometry_Clone(self, *args)

    def GetGeometryType(self, *args):
        r"""
        GetGeometryType(Geometry self) -> OGRwkbGeometryType

        Fetch geometry type.

        For more details: :cpp:func:`OGR_G_GetGeometryType`

        Returns
        --------
        int:
            The geometry type code. The types can be found with
            'osgeo.ogr.wkb' prefix. For example :py:const:`osgeo.ogr.wkbPolygon`.

        """
        return _ogr.Geometry_GetGeometryType(self, *args)

    def GetGeometryName(self, *args):
        r"""
        GetGeometryName(Geometry self) -> char const *

        Fetch WKT name for geometry type.

        For more details: :cpp:func:`OGR_G_GetGeometryName`

        geometry to get name from.

        Returns
        --------
        str

        """
        return _ogr.Geometry_GetGeometryName(self, *args)

    def Length(self, *args):
        r"""Length(Geometry self) -> double"""
        return _ogr.Geometry_Length(self, *args)

    def Area(self, *args):
        r"""Area(Geometry self) -> double"""
        return _ogr.Geometry_Area(self, *args)

    def IsClockwise(self, *args):
        r"""IsClockwise(Geometry self) -> bool"""
        return _ogr.Geometry_IsClockwise(self, *args)

    def GetArea(self, *args):
        r"""GetArea(Geometry self) -> double"""
        return _ogr.Geometry_GetArea(self, *args)

    def GetPointCount(self, *args):
        r"""GetPointCount(Geometry self) -> int"""
        return _ogr.Geometry_GetPointCount(self, *args)

    def GetPoints(self, *args, **kwargs):
        r"""GetPoints(Geometry self, int nCoordDimension=0)"""
        return _ogr.Geometry_GetPoints(self, *args, **kwargs)

    def GetX(self, *args, **kwargs):
        r"""GetX(Geometry self, int point=0) -> double"""
        return _ogr.Geometry_GetX(self, *args, **kwargs)

    def GetY(self, *args, **kwargs):
        r"""GetY(Geometry self, int point=0) -> double"""
        return _ogr.Geometry_GetY(self, *args, **kwargs)

    def GetZ(self, *args, **kwargs):
        r"""GetZ(Geometry self, int point=0) -> double"""
        return _ogr.Geometry_GetZ(self, *args, **kwargs)

    def GetM(self, *args, **kwargs):
        r"""GetM(Geometry self, int point=0) -> double"""
        return _ogr.Geometry_GetM(self, *args, **kwargs)

    def GetPoint(self, *args):
        r"""GetPoint(Geometry self, int iPoint=0)"""
        return _ogr.Geometry_GetPoint(self, *args)

    def GetPointZM(self, *args):
        r"""GetPointZM(Geometry self, int iPoint=0)"""
        return _ogr.Geometry_GetPointZM(self, *args)

    def GetPoint_2D(self, *args):
        r"""GetPoint_2D(Geometry self, int iPoint=0)"""
        return _ogr.Geometry_GetPoint_2D(self, *args)

    def GetGeometryCount(self, *args):
        r"""GetGeometryCount(Geometry self) -> int"""
        return _ogr.Geometry_GetGeometryCount(self, *args)

    def SetPoint(self, *args, **kwargs):
        r"""SetPoint(Geometry self, int point, double x, double y, double z=0)"""
        return _ogr.Geometry_SetPoint(self, *args, **kwargs)

    def SetPointM(self, *args, **kwargs):
        r"""SetPointM(Geometry self, int point, double x, double y, double m)"""
        return _ogr.Geometry_SetPointM(self, *args, **kwargs)

    def SetPointZM(self, *args, **kwargs):
        r"""SetPointZM(Geometry self, int point, double x, double y, double z, double m)"""
        return _ogr.Geometry_SetPointZM(self, *args, **kwargs)

    def SetPoint_2D(self, *args, **kwargs):
        r"""SetPoint_2D(Geometry self, int point, double x, double y)"""
        return _ogr.Geometry_SetPoint_2D(self, *args, **kwargs)

    def SwapXY(self, *args):
        r"""
        SwapXY(Geometry self)

        Swap x and y coordinates.

        For more details: :cpp:func:`OGR_G_SwapXY`

        .. versionadded:: 2.3.0


        """
        return _ogr.Geometry_SwapXY(self, *args)

    def GetGeometryRef(self, *args):
        r"""GetGeometryRef(Geometry self, int geom) -> Geometry"""
        return _ogr.Geometry_GetGeometryRef(self, *args)

    def Simplify(self, *args):
        r"""
        Simplify(Geometry self, double tolerance) -> Geometry

        Compute a simplified geometry.

        For more details: :cpp:func:`OGR_G_Simplify`

        Parameters
        -----------
        tolerance: float
            The distance tolerance for the simplification.

        Returns
        --------
        Geometry:
            The simplified geometry or None if an error occurs.

        """
        return _ogr.Geometry_Simplify(self, *args)

    def SimplifyPreserveTopology(self, *args):
        r"""
        SimplifyPreserveTopology(Geometry self, double tolerance) -> Geometry

        Simplify the geometry while preserving topology.

        For more details: :cpp:func:`OGR_G_SimplifyPreserveTopology`

        Parameters
        -----------
        tolerance: float
            The distance tolerance for the simplification.

        Returns
        --------
        Geometry:
            The simplified geometry or None if an error occurs.

        """
        return _ogr.Geometry_SimplifyPreserveTopology(self, *args)

    def DelaunayTriangulation(self, *args, **kwargs):
        r"""
        DelaunayTriangulation(Geometry self, double dfTolerance=0.0, int bOnlyEdges=FALSE) -> Geometry

        Return a Delaunay triangulation of the vertices of the geometry.

        For more details: :cpp:func:`OGR_G_DelaunayTriangulation`

        .. versionadded:: 2.1

        Parameters
        -----------
        dfTolerance: float
            optional snapping tolerance to use for improved robustness
        bOnlyEdges: bool
            If True, will return a MULTILINESTRING, otherwise it will
            return a GEOMETRYCOLLECTION containing triangular POLYGONs.

        Returns
        --------
        Geometry:
            The geometry resulting from the Delaunay triangulation or None if an
            error occurs.

        """
        return _ogr.Geometry_DelaunayTriangulation(self, *args, **kwargs)

    def Polygonize(self, *args):
        r"""
        Polygonize(Geometry self) -> Geometry

        Polygonizes a set of sparse edges.

        For more details: :cpp:func:`OGR_G_Polygonize`

        Returns
        --------
        Geometry:
            A new geometry or None on failure.

        """
        return _ogr.Geometry_Polygonize(self, *args)

    def Boundary(self, *args):
        r"""
        Boundary(Geometry self) -> Geometry

        Compute boundary.

        For more details: :cpp:func:`OGR_G_Boundary`

        Returns
        --------
        Geometry:
            A new geometry or None on failure.

        """
        return _ogr.Geometry_Boundary(self, *args)

    def GetBoundary(self, *args):
        r"""
        GetBoundary(Geometry self) -> Geometry

        Compute boundary (deprecated)

        For more details: :cpp:func:`OGR_G_GetBoundary`

        ..warning:: Deprecated

        See: :cpp:func:`OGR_G_Boundary`

        """
        return _ogr.Geometry_GetBoundary(self, *args)

    def ConvexHull(self, *args):
        r"""
        ConvexHull(Geometry self) -> Geometry

        Compute convex hull.

        For more details: :cpp:func:`OGR_G_ConvexHull`

        Returns
        --------
        Geometry:
            a handle to A newly allocated geometry now owned by the caller, or
            None on failure.

        """
        return _ogr.Geometry_ConvexHull(self, *args)

    def ConcaveHull(self, *args):
        r"""ConcaveHull(Geometry self, double ratio, bool allowHoles) -> Geometry"""
        return _ogr.Geometry_ConcaveHull(self, *args)

    def MakeValid(self, *args):
        r"""
        MakeValid(Geometry self, char ** options=None) -> Geometry

        Attempts to make an invalid geometry valid without losing vertices.

        For more details: :cpp:func:`OGR_G_MakeValidEx`

        .. versionadded:: 3.0
        .. versionadded:: 3.4 options

        Parameters
        -----------
        options: list[str], optional
            papszOptions to be passed in. For example: ["METHOD=STRUCTURE"].

        Returns
        --------
        Geometry:
            A newly allocated geometry now owned by the caller, or None on
            failure.

        """
        return _ogr.Geometry_MakeValid(self, *args)

    def Normalize(self, *args):
        r"""
        Normalize(Geometry self) -> Geometry

        Attempts to bring geometry into normalized/canonical form.

        For more details: :cpp:func:`OGR_G_Normalize`

        .. versionadded:: 3.3

        Returns
        --------
        Geometry:
            A newly allocated geometry now owned by the caller, or None on
            failure.

        """
        return _ogr.Geometry_Normalize(self, *args)

    def RemoveLowerDimensionSubGeoms(self, *args):
        r"""RemoveLowerDimensionSubGeoms(Geometry self) -> Geometry"""
        return _ogr.Geometry_RemoveLowerDimensionSubGeoms(self, *args)

    def Buffer(self, *args, **kwargs):
        r"""
        Buffer(Geometry self, double distance, int quadsecs=30) -> Geometry

        Compute buffer of geometry.

        For more details: :cpp:func:`OGR_G_Buffer`

        Parameters
        -----------
        distance: float
            The buffer distance to be applied. Should be expressed into
            the same unit as the coordinates of the geometry.
        quadsecs: int, default=30
            The number of segments used to approximate a 90 degree
            (quadrant) of curvature.

        Returns
        --------
        Geometry:
            The newly created geometry or None if an error occurs.

        """
        return _ogr.Geometry_Buffer(self, *args, **kwargs)

    def Intersection(self, *args):
        r"""
        Intersection(Geometry self, Geometry other) -> Geometry

        Compute intersection.

        For more details: :cpp:func:`OGR_G_Intersection`

        Parameters
        -----------
        other: Geometry
            The other geometry.

        Returns
        --------
        Geometry:
            A new geometry representing the intersection or None if there is no
            intersection or an error occurs.

        """
        return _ogr.Geometry_Intersection(self, *args)

    def Union(self, *args):
        r"""
        Union(Geometry self, Geometry other) -> Geometry

        Compute union.

        For more details: :cpp:func:`OGR_G_Union`

        Parameters
        -----------
        other: Geometry
            The other geometry.

        Returns
        --------
        Geometry:
            A new geometry representing the union or None if an error occurs.

        """
        return _ogr.Geometry_Union(self, *args)

    def UnionCascaded(self, *args):
        r"""
        UnionCascaded(Geometry self) -> Geometry

        Compute union using cascading.

        For more deails: :cpp:func:`OGR_G_UnionCascaded`

        Returns
        --------
        Geometry:
            A new geometry representing the union or None if an error occurs.

        """
        return _ogr.Geometry_UnionCascaded(self, *args)

    def Difference(self, *args):
        r"""
        Difference(Geometry self, Geometry other) -> Geometry

        Compute difference.

        For more details: :cpp:func:`OGR_G_Difference`

        Parameters
        -----------
        other: Geometry
            The other geometry.

        Returns
        --------
        Geometry:
            A new geometry representing the difference or None if the difference
            is empty or an error occurs.

        """
        return _ogr.Geometry_Difference(self, *args)

    def SymDifference(self, *args):
        r"""
        SymDifference(Geometry self, Geometry other) -> Geometry

        Compute symmetric difference.

        For more details: :cpp:func:`OGR_G_SymDifference`

        Parameters
        -----------
        other:
            the other geometry.

        Returns
        --------
        Geometry:
            A new geometry representing the symmetric difference or None if the
            difference is empty or an error occurs.

        """
        return _ogr.Geometry_SymDifference(self, *args)

    def SymmetricDifference(self, *args):
        r"""
        SymmetricDifference(Geometry self, Geometry other) -> Geometry

        Compute symmetric difference (deprecated)

        For more details: :cpp:func:`OGR_G_SymmetricDifference`

        .. warning:: Deprecated


        """
        return _ogr.Geometry_SymmetricDifference(self, *args)

    def Distance(self, *args):
        r"""
        Distance(Geometry self, Geometry other) -> double

        Compute distance between two geometries.

        For more details: :cpp:func:`OGR_G_Distance`

        Parameters
        -----------
        other: Geometry
            The other geometry to compare against.

        Returns
        --------
        float:
            The distance between the geometries or -1 if an error occurs.

        """
        return _ogr.Geometry_Distance(self, *args)

    def Distance3D(self, *args):
        r"""
        Distance3D(Geometry self, Geometry other) -> double

        Returns the 3D distance between two geometries.

        For more details: :cpp:func:`OGR_G_Distance3D`

        .. versionadded:: 2.2

        Parameters
        -----------
        other: Geometry
            The other geometry to compare against.

        Returns
        --------
        float:
            The distance between the geometries or -1 if an error occurs.

        """
        return _ogr.Geometry_Distance3D(self, *args)

    def Empty(self, *args):
        r"""
        Empty(Geometry self)

        Clear geometry information.

        For more details: :cpp:func:`OGR_G_Empty`

        """
        return _ogr.Geometry_Empty(self, *args)

    def IsEmpty(self, *args):
        r"""
        IsEmpty(Geometry self) -> bool

        Test if the geometry is empty.

        For more details: :cpp:func:`OGR_G_IsEmpty`

        Returns
        --------
        int:
            True if the geometry has no points, otherwise False.

        """
        return _ogr.Geometry_IsEmpty(self, *args)

    def IsValid(self, *args):
        r"""
        IsValid(Geometry self) -> bool

        Test if the geometry is valid.

        For more details: :cpp:func:`OGR_G_IsValid`

        Returns
        --------
        int:
            True if the geometry has no points, otherwise False.

        """
        return _ogr.Geometry_IsValid(self, *args)

    def IsSimple(self, *args):
        r"""
        IsSimple(Geometry self) -> bool

        Returns True if the geometry is simple.

        For more details: :cpp:func:`OGR_G_IsSimple`

        Returns
        --------
        int:
            True if object is simple, otherwise False.

        """
        return _ogr.Geometry_IsSimple(self, *args)

    def IsRing(self, *args):
        r"""
        IsRing(Geometry self) -> bool

        Test if the geometry is a ring.

        For more details: :cpp:func:`OGR_G_IsRing`

        Returns
        --------
        int:
            True if the geometry has no points, otherwise False.

        """
        return _ogr.Geometry_IsRing(self, *args)

    def Intersects(self, *args):
        r"""
        Intersects(Geometry self, Geometry other) -> bool

        Determines whether two geometries intersect.

        For more details: :cpp:func:`OGR_G_Intersects`

        Parameters
        -----------
        other: Geometry
            The other geometry to test against.

        Returns
        --------
        int:
            True if the geometries intersect, otherwise False.

        """
        return _ogr.Geometry_Intersects(self, *args)

    def Intersect(self, *args):
        r"""Intersect(Geometry self, Geometry other) -> bool"""
        return _ogr.Geometry_Intersect(self, *args)

    def Equals(self, *args):
        r"""
        Equals(Geometry self, Geometry other) -> bool

        Returns True if two geometries are equivalent.

        For more details: :cpp:func:`OGR_G_Equals`

        Parameters
        -----------
        other: Geometry
            The other geometry to test against.

        Returns
        --------
        int:
            True if equivalent or False otherwise.

        """
        return _ogr.Geometry_Equals(self, *args)

    def Equal(self, *args):
        r"""Equal(Geometry self, Geometry other) -> bool"""
        return _ogr.Geometry_Equal(self, *args)

    def Disjoint(self, *args):
        r"""
        Disjoint(Geometry self, Geometry other) -> bool

        Test for disjointness.

        For more details: :cpp:func:`OGR_G_Disjoint`

        Parameters
        -----------
        other: Geometry
            The other geometry to compare.

        Returns
        --------
        int:
            True if they are disjoint, otherwise False.

        """
        return _ogr.Geometry_Disjoint(self, *args)

    def Touches(self, *args):
        r"""
        Touches(Geometry self, Geometry other) -> bool

        Test for touching.

        For more details: :cpp:func:`OGR_G_Touches`

        Parameters
        -----------
        other:
            the other geometry to compare.

        Returns
        --------
        int:
            True if they are touching, otherwise False.

        """
        return _ogr.Geometry_Touches(self, *args)

    def Crosses(self, *args):
        r"""
        Crosses(Geometry self, Geometry other) -> bool

        Test for crossing.

        For more details: :cpp:func:`OGR_G_Crosses`

        Parameters
        -----------
        other: Geometry
            the other geometry to compare.

        Returns
        --------
        int:
            True if they are crossing, otherwise False.

        """
        return _ogr.Geometry_Crosses(self, *args)

    def Within(self, *args):
        r"""
        Within(Geometry self, Geometry other) -> bool

        Test for containment.

        For more details: :cpp:func:`OGR_G_Within`

        Parameters
        -----------
        other: Geometry
            the other geometry to compare.

        Returns
        --------
        int:
            True if this is within other, otherwise False.

        """
        return _ogr.Geometry_Within(self, *args)

    def Contains(self, *args):
        r"""
        Contains(Geometry self, Geometry other) -> bool

        Test for containment.

        For more details: :cpp:func:`OGR_G_Contains`

        Parameters
        -----------
        other: Geometry
            the other geometry to compare.

        Returns
        --------
        int:
            True if this contains the other geometry, otherwise False.

        """
        return _ogr.Geometry_Contains(self, *args)

    def Overlaps(self, *args):
        r"""
        Overlaps(Geometry self, Geometry other) -> bool

        Test for overlap.

        For more details: :cpp:func:`OGR_G_Overlaps`

        Parameters
        -----------
        other: Geometry
            the other geometry to compare.

        Returns
        --------
        int:
            True if they are overlapping, otherwise False.

        """
        return _ogr.Geometry_Overlaps(self, *args)

    def TransformTo(self, *args):
        r"""
        TransformTo(Geometry self, SpatialReference reference) -> OGRErr

        Transform geometry to new spatial reference system.

        For more details: :cpp:func:`OGR_G_TransformTo`

        Parameters
        -----------
        reference: SpatialReference
           The spatial reference system to apply.

        Returns
        --------
        int:
            :py:const:`osgeo.ogr.OGRERR_NONE` on success, or an error code.

        """
        return _ogr.Geometry_TransformTo(self, *args)

    def GetSpatialReference(self, *args):
        r"""
        GetSpatialReference(Geometry self) -> SpatialReference

        For more details: :cpp:func:`OGR_G_GetSpatialReference`

        Returns spatial reference system for geometry.

        Returns
        --------
        SpatialReference

        """
        return _ogr.Geometry_GetSpatialReference(self, *args)

    def AssignSpatialReference(self, *args):
        r"""
        AssignSpatialReference(Geometry self, SpatialReference reference)

        Assign spatial reference to this object.

        For more details: :cpp:func:`OGR_G_AssignSpatialReference`

        Parameters
        -----------
        reference: SpatialReference
            The new spatial reference system to apply.

        """
        return _ogr.Geometry_AssignSpatialReference(self, *args)

    def CloseRings(self, *args):
        r"""
        CloseRings(Geometry self)

        Force rings to be closed.

        For more details: :cpp:func:`OGR_G_CloseRings`

        """
        return _ogr.Geometry_CloseRings(self, *args)

    def FlattenTo2D(self, *args):
        r"""
        FlattenTo2D(Geometry self)

        Convert geometry to strictly 2D.

        For more details: :cpp:func:`OGR_G_FlattenTo2D`

        """
        return _ogr.Geometry_FlattenTo2D(self, *args)

    def Segmentize(self, *args):
        r"""
        Segmentize(Geometry self, double dfMaxLength)

        Modify the geometry such it has no segment longer then the given
        distance.

        For more details: :cpp:func:`OGR_G_Segmentize`

        Parameters
        -----------
        dfMaxLength: float
            the maximum distance between 2 points after segmentization

        """
        return _ogr.Geometry_Segmentize(self, *args)

    def GetEnvelope(self, *args):
        r"""
        GetEnvelope(Geometry self)

        Computes and returns the bounding envelope for this geometry in the
        passed psEnvelope structure.

        For more details: :cpp:func:`OGR_G_GetEnvelope`

        .. warning:: Check the return order of the bounds.

        Returns
        --------
        minx: float
        maxx: float
        miny: float
        maxy: float

        """
        return _ogr.Geometry_GetEnvelope(self, *args)

    def GetEnvelope3D(self, *args):
        r"""
        GetEnvelope3D(Geometry self)

        Computes and returns the bounding envelope (3D) for this geometry in
        the passed psEnvelope structure.

        For more details: :cpp:func:`OGR_G_GetEnvelope3D`

        .. warning:: Check the return order of the bounds.

        Returns
        --------
        minx: float
        maxx: float
        miny: float
        maxy: float
        minz: float
        maxz: float

        """
        return _ogr.Geometry_GetEnvelope3D(self, *args)

    def Centroid(self, *args):
        r"""
        Centroid(Geometry self) -> Geometry

        Compute the geometry centroid.

        For more details: :cpp:func:`OGR_G_Centroid`

        Returns
        --------
        Geometry

        """
        return _ogr.Geometry_Centroid(self, *args)

    def PointOnSurface(self, *args):
        r"""
        PointOnSurface(Geometry self) -> Geometry

        Returns a point guaranteed to lie on the surface.

        For more details: :cpp:func:`OGR_G_PointOnSurface`

        Returns
        --------
        Geometry:
            A point guaranteed to lie on the surface or None if an error occurred.

        """
        return _ogr.Geometry_PointOnSurface(self, *args)

    def WkbSize(self, *args):
        r"""
        WkbSize(Geometry self) -> size_t

        Returns size of related binary representation.

        For more details: :cpp:func:`OGR_G_WkbSize`

        Returns
        --------
        int

        """
        return _ogr.Geometry_WkbSize(self, *args)

    def GetCoordinateDimension(self, *args):
        r"""
        GetCoordinateDimension(Geometry self) -> int

        Get the dimension of the coordinates in this geometry.

        For more details: :cpp:func:`OGR_G_GetCoordinateDimension`

        .. warning:: Deprecated. Use :py:func:`CoordinateDimension`,
            :py:func:`Is3D`, or :py:func:`IsMeasured`.

        Returns
        --------
        int:
            This will return 2 or 3.

        """
        return _ogr.Geometry_GetCoordinateDimension(self, *args)

    def CoordinateDimension(self, *args):
        r"""
        CoordinateDimension(Geometry self) -> int

        Get the dimension of the coordinates in this geometry.

        For more details: :cpp:func:`OGR_G_CoordinateDimension`

        .. versionadded:: 2.1

        Returns
        --------
        int:
            This will return 2 for XY, 3 for XYZ and XYM, and 4 for XYZM data.

        """
        return _ogr.Geometry_CoordinateDimension(self, *args)

    def Is3D(self, *args):
        r"""
        Is3D(Geometry self) -> int

        See whether this geometry has Z coordinates.

        For more details: :cpp:func:`OGR_G_Is3D`

        .. versionadded:: 2.1

        Returns
        --------
        int:
            True if the geometry has Z coordinates.

        """
        return _ogr.Geometry_Is3D(self, *args)

    def IsMeasured(self, *args):
        r"""
        IsMeasured(Geometry self) -> int

        See whether this geometry is measured.

        For more details: :cpp:func:`OGR_G_IsMeasured`

        .. versionadded:: 2.1

        Returns
        --------
        int:
            True if the geometry has M coordinates.

        """
        return _ogr.Geometry_IsMeasured(self, *args)

    def SetCoordinateDimension(self, *args):
        r"""
        SetCoordinateDimension(Geometry self, int dimension)

        Set the coordinate dimension.

        For more details: :cpp:func:`OGR_G_SetCoordinateDimension`

        .. warning:: Deprecated. Use :py:func:`Set3D` or :py:func:`SetMeasured`.

        Parameters
        -----------
        dimension: int
            New coordinate dimension value, either 2 or 3.

        """
        return _ogr.Geometry_SetCoordinateDimension(self, *args)

    def Set3D(self, *args):
        r"""
        Set3D(Geometry self, int b3D)

        Add or remove the Z coordinate dimension.

        For more details: :cpp:func:`OGR_G_Set3D`

        .. versionadded:: 2.1

        Parameters
        -----------
        bIs3D: bool
            Should the geometry have a Z dimension, either True or False.

        """
        return _ogr.Geometry_Set3D(self, *args)

    def SetMeasured(self, *args):
        r"""
        SetMeasured(Geometry self, int bMeasured)

        Add or remove the M coordinate dimension.

        For more details: :cpp:func:`OGR_G_SetMeasured`

        .. versionadded:: 2.1

        Parameters
        -----------
        bIsMeasured: bool
            Should the geometry have a M dimension, either True or False.

        """
        return _ogr.Geometry_SetMeasured(self, *args)

    def GetDimension(self, *args):
        r"""
        GetDimension(Geometry self) -> int

        Get the dimension of this geometry.

        For more details: :cpp:func:`OGR_G_GetDimension`

        Returns
        --------
        int:
            0 for points, 1 for lines, and 2 for surfaces.

        """
        return _ogr.Geometry_GetDimension(self, *args)

    def HasCurveGeometry(self, *args):
        r"""HasCurveGeometry(Geometry self, int bLookForCircular=FALSE) -> int"""
        return _ogr.Geometry_HasCurveGeometry(self, *args)

    def GetLinearGeometry(self, *args, **kwargs):
        r"""GetLinearGeometry(Geometry self, double dfMaxAngleStepSizeDegrees=0.0, char ** options=None) -> Geometry"""
        return _ogr.Geometry_GetLinearGeometry(self, *args, **kwargs)

    def GetCurveGeometry(self, *args, **kwargs):
        r"""GetCurveGeometry(Geometry self, char ** options=None) -> Geometry"""
        return _ogr.Geometry_GetCurveGeometry(self, *args, **kwargs)

    def Value(self, *args):
        r"""Value(Geometry self, double dfDistance) -> Geometry"""
        return _ogr.Geometry_Value(self, *args)

    def Transform(self, *args):
        r"""
        Transform(Geometry self, CoordinateTransformation trans) -> OGRErr
        Transform(Geometry self, GeomTransformer transformer) -> Geometry

        Apply arbitrary coordinate transformation to geometry.

        For more details: :cpp:func:`OGR_G_Transform`

        Parameters
        -----------
        trans: CoordinateTransform
            The transformation to apply.

        Returns
        --------
        Geometry:
            The transformed geometry.

        """
        return _ogr.Geometry_Transform(self, *args)

    def CreatePreparedGeometry(self, *args):
        r"""CreatePreparedGeometry(Geometry self) -> PreparedGeometry"""
        return _ogr.Geometry_CreatePreparedGeometry(self, *args)

    def Destroy(self):
      self.__swig_destroy__(self)
      self.thisown = 0

    def __str__(self):
      return self.ExportToIsoWkt()

    def __copy__(self):
      return self.Clone()

    def __deepcopy__(self, memo):
      g = self.Clone()
      srs = self.GetSpatialReference()
      if srs:
          g.AssignSpatialReference(srs.Clone())
      return g

    def __reduce__(self):
      return (self.__class__, (), self.ExportToWkb())

    def __setstate__(self, state):
        result = CreateGeometryFromWkb(state)
        self.this = result.this

    def __iter__(self):
        for i in range(self.GetGeometryCount()):
            yield self.GetGeometryRef(i)



# Register Geometry in _ogr:
_ogr.Geometry_swigregister(Geometry)
class PreparedGeometry(object):
    r"""Proxy of C++ OGRPreparedGeometryShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _ogr.delete_PreparedGeometry

    def Intersects(self, *args):
        r"""Intersects(PreparedGeometry self, Geometry otherGeom) -> bool"""
        return _ogr.PreparedGeometry_Intersects(self, *args)

    def Contains(self, *args):
        r"""Contains(PreparedGeometry self, Geometry otherGeom) -> bool"""
        return _ogr.PreparedGeometry_Contains(self, *args)

# Register PreparedGeometry in _ogr:
_ogr.PreparedGeometry_swigregister(PreparedGeometry)
class GeomTransformer(object):
    r"""Proxy of C++ OGRGeomTransformerShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(GeomTransformer self, CoordinateTransformation ct, char ** options=None) -> GeomTransformer"""
        _ogr.GeomTransformer_swiginit(self, _ogr.new_GeomTransformer(*args))
    __swig_destroy__ = _ogr.delete_GeomTransformer

    def Transform(self, *args):
        r"""Transform(GeomTransformer self, Geometry src_geom) -> Geometry"""
        return _ogr.GeomTransformer_Transform(self, *args)

# Register GeomTransformer in _ogr:
_ogr.GeomTransformer_swigregister(GeomTransformer)
class FieldDomain(object):
    r"""Proxy of C++ OGRFieldDomainShadow class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _ogr.delete_FieldDomain

    def GetName(self, *args):
        r"""GetName(FieldDomain self) -> char const *"""
        return _ogr.FieldDomain_GetName(self, *args)

    def GetDescription(self, *args):
        r"""GetDescription(FieldDomain self) -> char const *"""
        return _ogr.FieldDomain_GetDescription(self, *args)

    def GetFieldType(self, *args):
        r"""GetFieldType(FieldDomain self) -> OGRFieldType"""
        return _ogr.FieldDomain_GetFieldType(self, *args)

    def GetFieldSubType(self, *args):
        r"""GetFieldSubType(FieldDomain self) -> OGRFieldSubType"""
        return _ogr.FieldDomain_GetFieldSubType(self, *args)

    def GetDomainType(self, *args):
        r"""GetDomainType(FieldDomain self) -> OGRFieldDomainType"""
        return _ogr.FieldDomain_GetDomainType(self, *args)

    def GetSplitPolicy(self, *args):
        r"""GetSplitPolicy(FieldDomain self) -> OGRFieldDomainSplitPolicy"""
        return _ogr.FieldDomain_GetSplitPolicy(self, *args)

    def SetSplitPolicy(self, *args):
        r"""SetSplitPolicy(FieldDomain self, OGRFieldDomainSplitPolicy policy)"""
        return _ogr.FieldDomain_SetSplitPolicy(self, *args)

    def GetMergePolicy(self, *args):
        r"""GetMergePolicy(FieldDomain self) -> OGRFieldDomainMergePolicy"""
        return _ogr.FieldDomain_GetMergePolicy(self, *args)

    def SetMergePolicy(self, *args):
        r"""SetMergePolicy(FieldDomain self, OGRFieldDomainMergePolicy policy)"""
        return _ogr.FieldDomain_SetMergePolicy(self, *args)

    def GetEnumeration(self, *args):
        r"""GetEnumeration(FieldDomain self) -> OGRCodedValue const *"""
        return _ogr.FieldDomain_GetEnumeration(self, *args)

    def GetMinAsDouble(self, *args):
        r"""GetMinAsDouble(FieldDomain self) -> double"""
        return _ogr.FieldDomain_GetMinAsDouble(self, *args)

    def GetMinAsString(self, *args):
        r"""GetMinAsString(FieldDomain self) -> char const *"""
        return _ogr.FieldDomain_GetMinAsString(self, *args)

    def IsMinInclusive(self, *args):
        r"""IsMinInclusive(FieldDomain self) -> bool"""
        return _ogr.FieldDomain_IsMinInclusive(self, *args)

    def GetMaxAsDouble(self, *args):
        r"""GetMaxAsDouble(FieldDomain self) -> double"""
        return _ogr.FieldDomain_GetMaxAsDouble(self, *args)

    def GetMaxAsString(self, *args):
        r"""GetMaxAsString(FieldDomain self) -> char const *"""
        return _ogr.FieldDomain_GetMaxAsString(self, *args)

    def IsMaxInclusive(self, *args):
        r"""IsMaxInclusive(FieldDomain self) -> bool"""
        return _ogr.FieldDomain_IsMaxInclusive(self, *args)

    def GetGlob(self, *args):
        r"""GetGlob(FieldDomain self) -> char const *"""
        return _ogr.FieldDomain_GetGlob(self, *args)

# Register FieldDomain in _ogr:
_ogr.FieldDomain_swigregister(FieldDomain)

def CreateCodedFieldDomain(*args):
    r"""CreateCodedFieldDomain(char const * name, char const * description, OGRFieldType type, OGRFieldSubType subtype, OGRCodedValue const * enumeration) -> FieldDomain"""
    return _ogr.CreateCodedFieldDomain(*args)

def CreateRangeFieldDomain(*args):
    r"""CreateRangeFieldDomain(char const * name, char const * description, OGRFieldType type, OGRFieldSubType subtype, double min, bool minIsInclusive, double max, double maxIsInclusive) -> FieldDomain"""
    return _ogr.CreateRangeFieldDomain(*args)

def CreateRangeFieldDomainDateTime(*args):
    r"""CreateRangeFieldDomainDateTime(char const * name, char const * description, char const * min, bool minIsInclusive, char const * max, double maxIsInclusive) -> FieldDomain"""
    return _ogr.CreateRangeFieldDomainDateTime(*args)

def CreateGlobFieldDomain(*args):
    r"""CreateGlobFieldDomain(char const * name, char const * description, OGRFieldType type, OGRFieldSubType subtype, char const * glob) -> FieldDomain"""
    return _ogr.CreateGlobFieldDomain(*args)

def GetDriverCount(*args):
    r"""GetDriverCount() -> int"""
    return _ogr.GetDriverCount(*args)

def GetOpenDSCount(*args):
    r"""GetOpenDSCount() -> int"""
    return _ogr.GetOpenDSCount(*args)

def SetGenerate_DB2_V72_BYTE_ORDER(*args):
    r"""SetGenerate_DB2_V72_BYTE_ORDER(int bGenerate_DB2_V72_BYTE_ORDER) -> OGRErr"""
    return _ogr.SetGenerate_DB2_V72_BYTE_ORDER(*args)

def RegisterAll(*args):
    r"""RegisterAll()"""
    return _ogr.RegisterAll(*args)

def GeometryTypeToName(*args):
    r"""GeometryTypeToName(OGRwkbGeometryType eType) -> char const *"""
    return _ogr.GeometryTypeToName(*args)

def GetFieldTypeName(*args):
    r"""GetFieldTypeName(OGRFieldType type) -> char const *"""
    return _ogr.GetFieldTypeName(*args)

def GetFieldSubTypeName(*args):
    r"""GetFieldSubTypeName(OGRFieldSubType type) -> char const *"""
    return _ogr.GetFieldSubTypeName(*args)

def GT_Flatten(*args):
    r"""GT_Flatten(OGRwkbGeometryType eType) -> OGRwkbGeometryType"""
    return _ogr.GT_Flatten(*args)

def GT_SetZ(*args):
    r"""GT_SetZ(OGRwkbGeometryType eType) -> OGRwkbGeometryType"""
    return _ogr.GT_SetZ(*args)

def GT_SetM(*args):
    r"""GT_SetM(OGRwkbGeometryType eType) -> OGRwkbGeometryType"""
    return _ogr.GT_SetM(*args)

def GT_SetModifier(*args):
    r"""GT_SetModifier(OGRwkbGeometryType eType, int bSetZ, int bSetM=FALSE) -> OGRwkbGeometryType"""
    return _ogr.GT_SetModifier(*args)

def GT_HasZ(*args):
    r"""GT_HasZ(OGRwkbGeometryType eType) -> int"""
    return _ogr.GT_HasZ(*args)

def GT_HasM(*args):
    r"""GT_HasM(OGRwkbGeometryType eType) -> int"""
    return _ogr.GT_HasM(*args)

def GT_IsSubClassOf(*args):
    r"""GT_IsSubClassOf(OGRwkbGeometryType eType, OGRwkbGeometryType eSuperType) -> int"""
    return _ogr.GT_IsSubClassOf(*args)

def GT_IsCurve(*args):
    r"""GT_IsCurve(OGRwkbGeometryType arg1) -> int"""
    return _ogr.GT_IsCurve(*args)

def GT_IsSurface(*args):
    r"""GT_IsSurface(OGRwkbGeometryType arg1) -> int"""
    return _ogr.GT_IsSurface(*args)

def GT_IsNonLinear(*args):
    r"""GT_IsNonLinear(OGRwkbGeometryType arg1) -> int"""
    return _ogr.GT_IsNonLinear(*args)

def GT_GetCollection(*args):
    r"""GT_GetCollection(OGRwkbGeometryType eType) -> OGRwkbGeometryType"""
    return _ogr.GT_GetCollection(*args)

def GT_GetCurve(*args):
    r"""GT_GetCurve(OGRwkbGeometryType eType) -> OGRwkbGeometryType"""
    return _ogr.GT_GetCurve(*args)

def GT_GetLinear(*args):
    r"""GT_GetLinear(OGRwkbGeometryType eType) -> OGRwkbGeometryType"""
    return _ogr.GT_GetLinear(*args)

def SetNonLinearGeometriesEnabledFlag(*args):
    r"""SetNonLinearGeometriesEnabledFlag(int bFlag)"""
    return _ogr.SetNonLinearGeometriesEnabledFlag(*args)

def GetNonLinearGeometriesEnabledFlag(*args):
    r"""GetNonLinearGeometriesEnabledFlag() -> int"""
    return _ogr.GetNonLinearGeometriesEnabledFlag(*args)

def GetOpenDS(*args):
    r"""GetOpenDS(int ds_number) -> DataSource"""
    return _ogr.GetOpenDS(*args)

def Open(*args, **kwargs):
    r"""Open(char const * utf8_path, int update=0) -> DataSource"""

    _WarnIfUserHasNotSpecifiedIfUsingExceptions()


    return _ogr.Open(*args, **kwargs)

def OpenShared(*args, **kwargs):
    r"""OpenShared(char const * utf8_path, int update=0) -> DataSource"""
    return _ogr.OpenShared(*args, **kwargs)

def GetDriverByName(*args):
    r"""GetDriverByName(char const * name) -> Driver"""
    return _ogr.GetDriverByName(*args)

def GetDriver(*args):
    r"""GetDriver(int driver_number) -> Driver"""
    return _ogr.GetDriver(*args)

def GeneralCmdLineProcessor(*args):
    r"""GeneralCmdLineProcessor(char ** papszArgv, int nOptions=0) -> char **"""
    return _ogr.GeneralCmdLineProcessor(*args)

def TermProgress_nocb(*args, **kwargs):
    r"""TermProgress_nocb(double dfProgress, char const * pszMessage=None, void * pData=None) -> int"""
    return _ogr.TermProgress_nocb(*args, **kwargs)
TermProgress = _ogr.TermProgress


