"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _configSchema = require("@osd/config-schema");

var _common = require("../../common");

var _helpers = require("./utils/helpers");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(router) {
  // Get all configs from Notifications
  router.get({
    path: _common.REPORTING_NOTIFICATIONS_DASHBOARDS_API.GET_CONFIGS,
    validate: {
      query: _configSchema.schema.object({
        from_index: _configSchema.schema.number(),
        max_items: _configSchema.schema.number(),
        query: _configSchema.schema.maybe(_configSchema.schema.string()),
        config_type: _configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()]),
        feature_list: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()])),
        is_enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
        sort_field: _configSchema.schema.string(),
        sort_order: _configSchema.schema.string(),
        config_id_list: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string()), _configSchema.schema.string()]))
      })
    }
  }, async (context, request, response) => {
    const config_type = (0, _helpers.joinRequestParams)(request.query.config_type);
    const feature_list = (0, _helpers.joinRequestParams)(request.query.feature_list);
    const config_id_list = (0, _helpers.joinRequestParams)(request.query.config_id_list);
    const query = request.query.query; // @ts-ignore

    const client = context.reporting_plugin.notificationsClient.asScoped(request);

    try {
      const resp = await client.callAsCurrentUser('notifications.getConfigs', {
        from_index: request.query.from_index,
        max_items: request.query.max_items,
        is_enabled: request.query.is_enabled,
        sort_field: request.query.sort_field,
        sort_order: request.query.sort_order,
        config_type,
        ...(feature_list && {
          feature_list
        }),
        ...(query && {
          query
        }),
        ...(config_id_list && {
          config_id_list
        })
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  }); // get event by id

  router.get({
    path: `${_common.REPORTING_NOTIFICATIONS_DASHBOARDS_API.GET_EVENT}/{eventId}`,
    validate: {
      params: _configSchema.schema.object({
        eventId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    // @ts-ignore
    const client = context.reporting_plugin.notificationsClient.asScoped(request);

    try {
      const resp = await client.callAsCurrentUser('notifications.getEventById', {
        eventId: request.params.eventId
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  }); // Send test message

  router.get({
    path: `${_common.REPORTING_NOTIFICATIONS_DASHBOARDS_API.SEND_TEST_MESSAGE}/{configId}`,
    validate: {
      params: _configSchema.schema.object({
        configId: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        feature: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    // @ts-ignore
    const client = context.reporting_plugin.notificationsClient.asScoped(request);

    try {
      const resp = await client.callAsCurrentUser('notifications.sendTestMessage', {
        configId: request.params.configId,
        feature: request.query.feature
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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