/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.ExtensibleTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.plugin.PluginInstallation;
import org.openstreetmap.josm.gui.preferences.plugin.PluginListPanel;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreferencesModel;
import org.openstreetmap.josm.gui.preferences.plugin.PluginUpdatePolicyPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.FilterField;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.plugins.ReadRemotePluginInformationTask;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public final class PluginPreference
extends ExtensibleTabPreferenceSetting {
    private PluginListPanel pnlPluginPreferences;
    private PluginPreferencesModel model;
    private JScrollPane spPluginPreferences;
    private PluginUpdatePolicyPanel pnlPluginUpdatePolicy;
    private boolean pluginPreferencesActivated;

    private PluginPreference() {
        super("plugin", I18n.tr("Plugins", new Object[0]), I18n.tr("Configure available plugins.", new Object[0]), false);
    }

    public static String buildDownloadSummary(PluginDownloadTask task) {
        Collection<PluginInformation> downloaded = task.getDownloadedPlugins();
        Collection<PluginInformation> failed = task.getFailedPlugins();
        Exception exception = task.getLastException();
        StringBuilder sb = new StringBuilder();
        if (!downloaded.isEmpty()) {
            sb.append(I18n.trn("The following plugin has been downloaded <strong>successfully</strong>:", "The following {0} plugins have been downloaded <strong>successfully</strong>:", downloaded.size(), downloaded.size()));
            sb.append("<ul>");
            for (PluginInformation pi : downloaded) {
                sb.append("<li>").append(pi.name).append(" (").append(pi.version).append(")</li>");
            }
            sb.append("</ul>");
        }
        if (!failed.isEmpty()) {
            sb.append(I18n.trn("Downloading the following plugin has <strong>failed</strong>:", "Downloading the following {0} plugins has <strong>failed</strong>:", failed.size(), failed.size()));
            sb.append("<ul>");
            for (PluginInformation pi : failed) {
                sb.append("<li>").append(pi.name).append("</li>");
            }
            sb.append("</ul>");
        }
        if (exception != null) {
            sb.append(I18n.tr("<br>Error message(untranslated): {0}", exception.getMessage()));
        }
        return sb.toString();
    }

    public static void notifyDownloadResults(Component parent, PluginDownloadTask task, boolean restartRequired) {
        Collection<PluginInformation> failed = task.getFailedPlugins();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append(PluginPreference.buildDownloadSummary(task));
        if (restartRequired) {
            sb.append(I18n.tr("Please restart JOSM to activate the downloaded plugins.", new Object[0]));
        }
        sb.append("</html>");
        GuiHelper.runInEDTAndWait(() -> HelpAwareOptionPane.showOptionDialog(parent, sb.toString(), I18n.tr("Update plugins", new Object[0]), !failed.isEmpty() ? 2 : 1, HelpUtil.ht("/Preferences/Plugins")));
    }

    private JPanel buildSearchFieldPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.add(GBC.glue(0, 0));
        ButtonGroup bg = new ButtonGroup();
        JPanel radios = new JPanel();
        this.addRadioButton(bg, radios, new JRadioButton(I18n.trc("plugins", "All"), true), PluginInstallation.ALL);
        this.addRadioButton(bg, radios, new JRadioButton(I18n.trc("plugins", "Installed")), PluginInstallation.INSTALLED);
        this.addRadioButton(bg, radios, new JRadioButton(I18n.trc("plugins", "Available")), PluginInstallation.AVAILABLE);
        pnl.add((Component)radios, GBC.eol().fill(2));
        pnl.add((Component)new FilterField().filter(expr -> {
            this.model.filterDisplayedPlugins(expr);
            this.pnlPluginPreferences.refreshView();
        }), GBC.eol().insets(0, 0, 0, 5).fill(2));
        return pnl;
    }

    private void addRadioButton(ButtonGroup bg, JPanel pnl, JRadioButton rb, PluginInstallation value) {
        bg.add(rb);
        pnl.add((Component)rb, GBC.std());
        rb.addActionListener(e -> {
            this.model.filterDisplayedPlugins(value);
            this.pnlPluginPreferences.refreshView();
        });
    }

    private static Component addButton(JPanel pnl, JButton button, String buttonName) {
        button.setName(buttonName);
        return pnl.add(button);
    }

    private JPanel buildActionPanel() {
        JPanel pnl = new JPanel(new GridLayout(1, 4));
        PluginPreference.addButton(pnl, new JButton(new DownloadAvailablePluginsAction()), "downloadListButton");
        PluginPreference.addButton(pnl, new JButton(new UpdateSelectedPluginsAction()), "updatePluginsButton");
        ExpertToggleAction.addVisibilitySwitcher(PluginPreference.addButton(pnl, new JButton(new SelectByListAction()), "loadFromListButton"));
        ExpertToggleAction.addVisibilitySwitcher(PluginPreference.addButton(pnl, new JButton(new ConfigureSitesAction()), "configureSitesButton"));
        return pnl;
    }

    private JPanel buildPluginListPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.buildSearchFieldPanel(), "North");
        this.model = new PluginPreferencesModel();
        this.pnlPluginPreferences = new PluginListPanel(this.model);
        this.spPluginPreferences = GuiHelper.embedInVerticalScrollPane(this.pnlPluginPreferences);
        this.spPluginPreferences.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                PluginPreference.this.spPluginPreferences.setBorder(UIManager.getBorder("ScrollPane.border"));
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                PluginPreference.this.spPluginPreferences.setBorder(null);
            }
        });
        pnl.add((Component)this.spPluginPreferences, "Center");
        pnl.add((Component)this.buildActionPanel(), "South");
        return pnl;
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        JTabbedPane pane = this.getTabPane();
        this.pnlPluginUpdatePolicy = new PluginUpdatePolicyPanel();
        pane.addTab(I18n.tr("Plugins", new Object[0]), this.buildPluginListPanel());
        pane.addTab(I18n.tr("Plugin update policy", new Object[0]), this.pnlPluginUpdatePolicy);
        super.addGui(gui);
        this.readLocalPluginInformation();
        this.pluginPreferencesActivated = true;
    }

    private void configureSites() {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("OK", new Object[0]), new ImageProvider("ok"), I18n.tr("Accept the new plugin sites and close the dialog", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel", new Object[0]), new ImageProvider("cancel"), I18n.tr("Close the dialog", new Object[0]), null)};
        PluginConfigurationSitesPanel pnl = new PluginConfigurationSitesPanel();
        int answer = HelpAwareOptionPane.showOptionDialog(this.pnlPluginPreferences, pnl, I18n.tr("Configure Plugin Sites", new Object[0]), 3, null, options, options[0], null);
        if (answer != 0) {
            return;
        }
        Preferences.main().setPluginSites(pnl.getUpdateSites());
    }

    public Set<PluginInformation> getPluginsScheduledForUpdateOrDownload() {
        return this.model != null ? this.model.getPluginsScheduledForUpdateOrDownload() : null;
    }

    public List<PluginInformation> getNewlyActivatedPlugins() {
        return this.model != null ? this.model.getNewlyActivatedPlugins() : null;
    }

    @Override
    public boolean ok() {
        if (!this.pluginPreferencesActivated) {
            return false;
        }
        this.pnlPluginUpdatePolicy.rememberInPreferences();
        if (this.model.isActivePluginsChanged()) {
            boolean requiresRestart;
            LinkedList<String> l = new LinkedList<String>(this.model.getSelectedPluginNames());
            Collections.sort(l);
            Config.getPref().putList("plugins", l);
            List<PluginInformation> deactivatedPlugins = this.model.getNewlyDeactivatedPlugins();
            if (!deactivatedPlugins.isEmpty() && (requiresRestart = PluginHandler.removePlugins(deactivatedPlugins))) {
                return requiresRestart;
            }
            return this.model.getNewlyActivatedPlugins().stream().anyMatch(pi -> !pi.canloadatruntime);
        }
        return false;
    }

    public void readLocalPluginInformation() {
        ReadLocalPluginInformationTask task = new ReadLocalPluginInformationTask();
        Runnable r = () -> {
            if (!task.isCanceled()) {
                SwingUtilities.invokeLater(() -> {
                    this.model.setAvailablePlugins(task.getAvailablePlugins());
                    this.pnlPluginPreferences.resetDisplayedComponents();
                    this.pnlPluginPreferences.refreshView();
                });
            }
        };
        MainApplication.worker.submit(task);
        MainApplication.worker.submit(r);
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/Plugins");
    }

    private static class PluginConfigurationSitesPanel
    extends JPanel {
        private final DefaultListModel<String> model = new DefaultListModel();

        PluginConfigurationSitesPanel() {
            super(new GridBagLayout());
            this.add((Component)new JLabel(I18n.tr("Add JOSM Plugin description URL.", new Object[0])), GBC.eol());
            for (String s : Preferences.main().getPluginSites()) {
                this.model.addElement(s);
            }
            final JList<String> list = new JList<String>(this.model);
            this.add((Component)new JScrollPane(list), GBC.std().fill());
            JPanel buttons = new JPanel(new GridBagLayout());
            buttons.add((Component)new JButton(new AbstractAction(I18n.tr("Add", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = JOptionPane.showInputDialog(GuiHelper.getFrameForComponent(this), I18n.tr("Add JOSM Plugin description URL.", new Object[0]), I18n.tr("Enter URL", new Object[0]), 3);
                    if (!Utils.isEmpty(s)) {
                        model.addElement(s);
                    }
                }
            }), GBC.eol().fill(2));
            buttons.add((Component)new JButton(new AbstractAction(I18n.tr("Edit", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (list.getSelectedValue() == null) {
                        JOptionPane.showMessageDialog(GuiHelper.getFrameForComponent(this), I18n.tr("Please select an entry.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                        return;
                    }
                    String s = (String)JOptionPane.showInputDialog(MainApplication.getMainFrame(), I18n.tr("Edit JOSM Plugin description URL.", new Object[0]), I18n.tr("JOSM Plugin description URL", new Object[0]), 3, null, null, list.getSelectedValue());
                    if (!Utils.isEmpty(s)) {
                        model.setElementAt(s, list.getSelectedIndex());
                    }
                }
            }), GBC.eol().fill(2));
            buttons.add((Component)new JButton(new AbstractAction(I18n.tr("Delete", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (list.getSelectedValue() == null) {
                        JOptionPane.showMessageDialog(GuiHelper.getFrameForComponent(this), I18n.tr("Please select an entry.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                        return;
                    }
                    model.removeElement(list.getSelectedValue());
                }
            }), GBC.eol().fill(2));
            this.add((Component)buttons, GBC.eol());
        }

        protected List<String> getUpdateSites() {
            if (this.model.getSize() == 0) {
                return Collections.emptyList();
            }
            return IntStream.range(0, this.model.getSize()).mapToObj(this.model::get).collect(Collectors.toList());
        }
    }

    class SelectByListAction
    extends AbstractAction {
        SelectByListAction() {
            this.putValue("Name", I18n.tr("Load from list...", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Load plugins from a list of plugins", new Object[0]));
            new ImageProvider("misc/statusreport").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextArea textField = new JTextArea(10, 0);
            JCheckBox deleteNotInList = new JCheckBox(I18n.tr("Disable all other plugins", new Object[0]));
            JLabel helpLabel = new JLabel("<html>" + String.join((CharSequence)"<br/>", I18n.tr("Enter a list of plugins you want to download.", new Object[0]), I18n.tr("You should add one plugin id per line, version information is ignored.", new Object[0]), I18n.tr("You can copy+paste the list of a status report here.", new Object[0])) + "</html>");
            if (0 == JOptionPane.showConfirmDialog(GuiHelper.getFrameForComponent(PluginPreference.this.getTabPane()), new Object[]{helpLabel, new JScrollPane(textField), deleteNotInList}, I18n.tr("Load plugins from list", new Object[0]), 2, -1)) {
                this.activatePlugins(textField, deleteNotInList.isSelected());
            }
        }

        private void activatePlugins(JTextArea textField, boolean deleteNotInList) {
            String[] lines = textField.getText().split("\n", -1);
            ArrayList<String> toActivate = new ArrayList<String>();
            ArrayList<String> notFound = new ArrayList<String>();
            Pattern regex = Pattern.compile("^[-+\\*\\s]*|\\s[\\d\\s]*(\\([^\\(\\)\\[\\]]*\\))?[\\d\\s]*$");
            for (String line : lines) {
                String name = regex.matcher(line).replaceAll("");
                if (name.isEmpty()) continue;
                PluginInformation plugin = PluginPreference.this.model.getPluginInformation(name);
                if (plugin == null) {
                    notFound.add(name);
                    continue;
                }
                toActivate.add(name);
            }
            if (notFound.isEmpty() || this.confirmIgnoreNotFound(notFound)) {
                this.activatePlugins(toActivate, deleteNotInList);
            }
        }

        private void activatePlugins(List<String> toActivate, boolean deleteNotInList) {
            if (deleteNotInList) {
                for (String name : PluginPreference.this.model.getSelectedPluginNames()) {
                    if (toActivate.contains(name)) continue;
                    PluginPreference.this.model.setPluginSelected(name, false);
                }
            }
            for (String name : toActivate) {
                PluginPreference.this.model.setPluginSelected(name, true);
            }
            PluginPreference.this.pnlPluginPreferences.refreshView();
        }

        private boolean confirmIgnoreNotFound(List<String> notFound) {
            String list = "<ul><li>" + String.join((CharSequence)"</li><li>", notFound) + "</li></ul>";
            String message = "<html>" + I18n.tr("The following plugins were not found. Continue anyway?", new Object[0]) + list + "</html>";
            return JOptionPane.showConfirmDialog(GuiHelper.getFrameForComponent(PluginPreference.this.getTabPane()), message) == 0;
        }
    }

    class ConfigureSitesAction
    extends AbstractAction {
        ConfigureSitesAction() {
            this.putValue("Name", I18n.tr("Configure sites...", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Configure the list of sites where plugins are downloaded from", new Object[0]));
            new ImageProvider("preference").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PluginPreference.this.configureSites();
        }
    }

    class UpdateSelectedPluginsAction
    extends AbstractAction {
        UpdateSelectedPluginsAction() {
            this.putValue("Name", I18n.tr("Update plugins", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Update the selected plugins", new Object[0]));
            new ImageProvider("dialogs", "refresh").getResource().attachImageIcon(this);
        }

        protected void alertNothingToUpdate() {
            try {
                SwingUtilities.invokeAndWait(() -> HelpAwareOptionPane.showOptionDialog(PluginPreference.this.pnlPluginPreferences, I18n.tr("All installed plugins are up to date. JOSM does not have to download newer versions.", new Object[0]), I18n.tr("Plugins up to date", new Object[0]), 1, null));
            }
            catch (InterruptedException | InvocationTargetException e) {
                Logging.error(e);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<PluginInformation> toUpdate = PluginPreference.this.model.getSelectedPlugins();
            PluginDownloadTask pluginDownloadTask = new PluginDownloadTask((Component)PluginPreference.this.pnlPluginPreferences, toUpdate, I18n.tr("Update plugins", new Object[0]));
            ReadRemotePluginInformationTask pluginInfoDownloadTask = new ReadRemotePluginInformationTask(Preferences.main().getOnlinePluginSites());
            Runnable pluginDownloadContinuation = () -> {
                if (pluginDownloadTask.isCanceled()) {
                    return;
                }
                boolean restartRequired = pluginDownloadTask.getDownloadedPlugins().stream().anyMatch(pi -> !PluginPreference.this.model.getNewlyActivatedPlugins().contains(pi) || !pi.canloadatruntime);
                PluginPreference.notifyDownloadResults(PluginPreference.this.pnlPluginPreferences, pluginDownloadTask, restartRequired);
                PluginPreference.this.model.refreshLocalPluginVersion(pluginDownloadTask.getDownloadedPlugins());
                PluginPreference.this.model.clearPendingPlugins(pluginDownloadTask.getDownloadedPlugins());
                GuiHelper.runInEDT(PluginPreference.this.pnlPluginPreferences::refreshView);
            };
            Runnable pluginInfoDownloadContinuation = () -> {
                int toUpdateSize;
                if (pluginInfoDownloadTask.isCanceled()) {
                    return;
                }
                PluginPreference.this.model.updateAvailablePlugins(pluginInfoDownloadTask.getAvailablePlugins());
                toUpdate.removeIf(pi -> !pi.isUpdateRequired());
                if (toUpdate.isEmpty()) {
                    this.alertNothingToUpdate();
                    return;
                }
                boolean refreshRequired = false;
                do {
                    toUpdateSize = toUpdate.size();
                    HashSet<PluginInformation> enabledPlugins = new HashSet<PluginInformation>(PluginHandler.getPlugins());
                    enabledPlugins.addAll(toUpdate);
                    HashSet<PluginInformation> toAdd = new HashSet<PluginInformation>();
                    for (PluginInformation pi2 : toUpdate) {
                        if (PluginHandler.checkRequiredPluginsPreconditions(null, enabledPlugins, pi2, false)) continue;
                        toAdd.addAll(pi2.getRequiredPlugins().stream().filter(plugin -> PluginHandler.getPlugin(plugin) == null).map(plugin -> PluginPreference.this.model.getPluginInformation((String)plugin)).collect(Collectors.toSet()));
                    }
                    toAdd.forEach(plugin -> PluginPreference.this.model.setPluginSelected(plugin.name, true));
                    refreshRequired |= !toAdd.isEmpty();
                    toAdd.removeIf(plugin -> !plugin.isUpdateRequired());
                    toUpdate.addAll(toAdd);
                } while (toUpdateSize != toUpdate.size());
                pluginDownloadTask.setPluginsToDownload(toUpdate);
                MainApplication.worker.submit(pluginDownloadTask);
                MainApplication.worker.submit(pluginDownloadContinuation);
                if (refreshRequired) {
                    PluginPreference.this.pnlPluginPreferences.resetDisplayedComponents();
                }
                GuiHelper.runInEDT(PluginPreference.this.pnlPluginPreferences::refreshView);
            };
            MainApplication.worker.submit(pluginInfoDownloadTask);
            MainApplication.worker.submit(pluginInfoDownloadContinuation);
        }
    }

    class DownloadAvailablePluginsAction
    extends AbstractAction {
        DownloadAvailablePluginsAction() {
            this.putValue("Name", I18n.tr("Download list", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Download the list of available plugins", new Object[0]));
            new ImageProvider("download").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection<String> pluginSites = Preferences.main().getOnlinePluginSites();
            if (pluginSites.isEmpty()) {
                return;
            }
            ReadRemotePluginInformationTask task = new ReadRemotePluginInformationTask(pluginSites);
            Runnable continuation = () -> {
                if (!task.isCanceled()) {
                    SwingUtilities.invokeLater(() -> {
                        PluginPreference.this.model.updateAvailablePlugins(task.getAvailablePlugins());
                        PluginPreference.this.pnlPluginPreferences.resetDisplayedComponents();
                        PluginPreference.this.pnlPluginPreferences.refreshView();
                        Config.getPref().putInt("pluginmanager.version", Version.getInstance().getVersion());
                    });
                }
            };
            MainApplication.worker.submit(task);
            MainApplication.worker.submit(continuation);
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new PluginPreference();
        }
    }
}

