/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprMissingValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.storage.bindingtuple.BindingTuple;
import org.opensearch.sql.storage.bindingtuple.LazyBindingTuple;

public class ExprTupleValue
extends AbstractExprValue {
    private final LinkedHashMap<String, ExprValue> valueMap;

    public static ExprTupleValue fromExprValueMap(Map<String, ExprValue> map) {
        LinkedHashMap<String, ExprValue> linkedHashMap = new LinkedHashMap<String, ExprValue>(map);
        return new ExprTupleValue(linkedHashMap);
    }

    @Override
    public Object value() {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, ExprValue> entry : this.valueMap.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue().value());
        }
        return resultMap;
    }

    @Override
    public ExprType type() {
        return ExprCoreType.STRUCT;
    }

    public String toString() {
        return this.valueMap.entrySet().stream().map(entry -> String.format("%s:%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    public BindingTuple bindingTuples() {
        return new LazyBindingTuple(() -> this);
    }

    @Override
    public Map<String, ExprValue> tupleValue() {
        return this.valueMap;
    }

    @Override
    public ExprValue keyValue(String key) {
        return this.valueMap.getOrDefault(key, ExprMissingValue.of());
    }

    @Override
    public boolean equal(ExprValue o) {
        if (!(o instanceof ExprTupleValue)) {
            return false;
        }
        ExprTupleValue other = (ExprTupleValue)o;
        Iterator<Map.Entry<String, ExprValue>> thisIterator = this.valueMap.entrySet().iterator();
        Iterator<Map.Entry<String, ExprValue>> otherIterator = other.valueMap.entrySet().iterator();
        while (thisIterator.hasNext() && otherIterator.hasNext()) {
            Map.Entry<String, ExprValue> thisEntry = thisIterator.next();
            Map.Entry<String, ExprValue> otherEntry = otherIterator.next();
            if (thisEntry.getKey().equals(otherEntry.getKey()) && thisEntry.getValue().equals(otherEntry.getValue())) continue;
            return false;
        }
        return !thisIterator.hasNext() && !otherIterator.hasNext();
    }

    @Override
    public int compare(ExprValue other) {
        return Integer.compare(this.valueMap.size(), other.tupleValue().size());
    }

    public int hashCode() {
        return Objects.hashCode(this.valueMap);
    }

    @Generated
    public ExprTupleValue(LinkedHashMap<String, ExprValue> valueMap) {
        this.valueMap = valueMap;
    }
}

