/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.TrivListDec;
import java.io.IOException;
import java.util.EmptyStackException;

public class ListItem
extends ControlSequence {
    public ListItem() {
        this("item");
    }

    public ListItem(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new ListItem(this.getName());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TrivListDec trivListDec;
        TeXObject teXObject = this.popOptArg(teXParser, teXObjectList);
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        try {
            trivListDec = laTeXParserListener.peekTrivListStack();
        }
        catch (EmptyStackException emptyStackException) {
            throw new LaTeXSyntaxException(emptyStackException, teXParser, "latex.error.lonely_item", new Object[0]);
        }
        Group group = laTeXParserListener.createGroup();
        group.add(this.setuplabel(teXParser, teXObjectList, teXObject));
        this.makelabel(teXParser, teXObjectList, trivListDec, group);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    public TeXObject setuplabel(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        if (teXObject != null) {
            return teXObject;
        }
        if (laTeXParserListener.isIfTrue(laTeXParserListener.getControlSequence("if@nmbrlist"))) {
            ControlSequence controlSequence = laTeXParserListener.getControlSequence("@listctr");
            String string = teXParser.expandToString(controlSequence, teXObjectList);
            laTeXParserListener.stepcounter(string);
        }
        return laTeXParserListener.getControlSequence("@itemlabel");
    }

    public void makelabel(TeXParser teXParser, TeXObjectList teXObjectList, TrivListDec trivListDec, TeXObject teXObject) throws IOException {
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
    }
}

