
#ifndef KSANECORE_EXPORT_H
#define KSANECORE_EXPORT_H

#ifdef KSANECORE_STATIC_DEFINE
#  define KSANECORE_EXPORT
#  define KSANECORE_NO_EXPORT
#else
#  ifndef KSANECORE_EXPORT
#    ifdef KSaneCore_EXPORTS
        /* We are building this library */
#      define KSANECORE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KSANECORE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KSANECORE_NO_EXPORT
#    define KSANECORE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KSANECORE_DECL_DEPRECATED
#  define KSANECORE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KSANECORE_DECL_DEPRECATED_EXPORT
#  define KSANECORE_DECL_DEPRECATED_EXPORT KSANECORE_EXPORT KSANECORE_DECL_DEPRECATED
#endif

#ifndef KSANECORE_DECL_DEPRECATED_NO_EXPORT
#  define KSANECORE_DECL_DEPRECATED_NO_EXPORT KSANECORE_NO_EXPORT KSANECORE_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KSANECORE_NO_DEPRECATED
#    define KSANECORE_NO_DEPRECATED
#  endif
#endif

#define KSANECORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KSANECORE_NO_DEPRECATED)
#  undef KSANECORE_DEPRECATED
#  define KSANECORE_DEPRECATED_EXPORT KSANECORE_EXPORT
#  define KSANECORE_DEPRECATED_NO_EXPORT KSANECORE_NO_EXPORT
#elif defined(KSANECORE_NO_DEPRECATED_WARNINGS)
#  define KSANECORE_DEPRECATED
#  define KSANECORE_DEPRECATED_EXPORT KSANECORE_EXPORT
#  define KSANECORE_DEPRECATED_NO_EXPORT KSANECORE_NO_EXPORT
#else
#  define KSANECORE_DEPRECATED KSANECORE_DECL_DEPRECATED
#  define KSANECORE_DEPRECATED_EXPORT KSANECORE_DECL_DEPRECATED_EXPORT
#  define KSANECORE_DEPRECATED_NO_EXPORT KSANECORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KSANECORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KSANECORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KSANECORE_NO_DEPRECATED
#  define KSANECORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x180200
#endif
#ifdef KSANECORE_NO_DEPRECATED_WARNINGS
#  define KSANECORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KSANECORE_DEPRECATED_WARNINGS_SINCE
#  ifdef KSANECORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KSANECORE_DEPRECATED_WARNINGS_SINCE KSANECORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KSANECORE_DEPRECATED_WARNINGS_SINCE 0x180200
#  endif
#endif

#ifndef KSANECORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KSANECORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KSANECORE_DEPRECATED
#  define KSANECORE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KSANECORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KSANECORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KSANECORE_EXPORT_H */
