"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityPlugin = void 0;

var _opensearch_observability_plugin = require("./adaptors/opensearch_observability_plugin");

var _ppl_plugin = require("./adaptors/ppl_plugin");

var _index = require("./routes/index");

var _observability_saved_object = require("./saved_objects/observability_saved_object");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ObservabilityPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    this.logger = initializerContext.logger.get();
  }

  setup(core) {
    this.logger.debug('Observability: Setup');
    const router = core.http.createRouter();
    const openSearchObservabilityClient = core.opensearch.legacy.createClient('opensearch_observability', {
      plugins: [_ppl_plugin.PPLPlugin, _opensearch_observability_plugin.OpenSearchObservabilityPlugin]
    }); // @ts-ignore

    core.http.registerRouteHandlerContext('observability_plugin', (context, request) => {
      return {
        logger: this.logger,
        observabilityClient: openSearchObservabilityClient
      };
    });
    const obsPanelType = {
      name: 'observability-panel',
      hidden: false,
      namespaceType: 'single',
      mappings: {
        dynamic: false,
        properties: {
          title: {
            type: 'text'
          },
          description: {
            type: 'text'
          }
        }
      },
      management: {
        importableAndExportable: true,

        getInAppUrl() {
          return {
            path: `/app/management/observability/settings`,
            uiCapabilitiesPath: 'advancedSettings.show'
          };
        },

        getTitle(obj) {
          return `Observability Settings [${obj.id}]`;
        }

      },
      migrations: {
        '3.0.0': doc => ({ ...doc,
          description: ''
        }),
        '3.0.1': doc => ({ ...doc,
          description: 'Some Description Text'
        }),
        '3.0.2': doc => ({ ...doc,
          dateCreated: parseInt(doc.dateCreated || '0', 10)
        })
      }
    };
    const integrationInstanceType = {
      name: 'integration-instance',
      hidden: false,
      namespaceType: 'single',
      mappings: {
        dynamic: false,
        properties: {
          name: {
            type: 'text'
          },
          templateName: {
            type: 'text'
          },
          dataSource: {
            type: 'text'
          },
          creationDate: {
            type: 'date'
          },
          assets: {
            type: 'nested'
          }
        }
      }
    };
    core.savedObjects.registerType(obsPanelType);
    core.savedObjects.registerType(integrationInstanceType); // Register server side APIs

    (0, _index.setupRoutes)({
      router,
      client: openSearchObservabilityClient
    });
    core.savedObjects.registerType(_observability_saved_object.visualizationSavedObject);
    core.capabilities.registerProvider(() => ({
      observability: {
        show: true
      }
    }));
    return {};
  }

  start(core) {
    this.logger.debug('Observability: Started');
    return {};
  }

  stop() {}

}

exports.ObservabilityPlugin = ObservabilityPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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