/* traversable.c generated by valac 0.56.3, the Vala compiler
 * generated from traversable.vala, do not modify */

/* traversable.vala
 *
 * Copyright (C) 2011-2012  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include "gee.h"
#include <glib-object.h>
#include <glib.h>

#define GEE_TYPE_STREAM_ITERATOR (gee_stream_iterator_get_type ())
#define GEE_STREAM_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_STREAM_ITERATOR, GeeStreamIterator))
#define GEE_STREAM_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_STREAM_ITERATOR, GeeStreamIteratorClass))
#define GEE_IS_STREAM_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_STREAM_ITERATOR))
#define GEE_IS_STREAM_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_STREAM_ITERATOR))
#define GEE_STREAM_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_STREAM_ITERATOR, GeeStreamIteratorClass))

typedef struct _GeeStreamIterator GeeStreamIterator;
typedef struct _GeeStreamIteratorClass GeeStreamIteratorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
#define _gee_lazy_unref0(var) ((var == NULL) ? NULL : (var = (gee_lazy_unref (var), NULL)))
typedef struct _Block17Data Block17Data;
typedef struct _Block18Data Block18Data;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
typedef struct _Block22Data Block22Data;
typedef struct _Block23Data Block23Data;
typedef struct _Block24Data Block24Data;

#define GEE_TEE_ITERATOR_TYPE_NODE (gee_tee_iterator_node_get_type ())
#define GEE_TEE_ITERATOR_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TEE_ITERATOR_TYPE_NODE, GeeTeeIteratorNode))
#define GEE_TEE_ITERATOR_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TEE_ITERATOR_TYPE_NODE, GeeTeeIteratorNodeClass))
#define GEE_TEE_ITERATOR_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TEE_ITERATOR_TYPE_NODE))
#define GEE_TEE_ITERATOR_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TEE_ITERATOR_TYPE_NODE))
#define GEE_TEE_ITERATOR_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TEE_ITERATOR_TYPE_NODE, GeeTeeIteratorNodeClass))

typedef struct _GeeTeeIteratorNode GeeTeeIteratorNode;
typedef struct _GeeTeeIteratorNodeClass GeeTeeIteratorNodeClass;

#define GEE_TYPE_TEE_ITERATOR (gee_tee_iterator_get_type ())
#define GEE_TEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEE_ITERATOR, GeeTeeIterator))
#define GEE_TEE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEE_ITERATOR, GeeTeeIteratorClass))
#define GEE_IS_TEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEE_ITERATOR))
#define GEE_IS_TEE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEE_ITERATOR))
#define GEE_TEE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEE_ITERATOR, GeeTeeIteratorClass))

typedef struct _GeeTeeIterator GeeTeeIterator;
typedef struct _GeeTeeIteratorClass GeeTeeIteratorClass;
#define _gee_tee_iterator_node_unref0(var) ((var == NULL) ? NULL : (var = (gee_tee_iterator_node_unref (var), NULL)))
typedef struct _Block25Data Block25Data;
typedef struct _Block26Data Block26Data;
typedef struct _Block27Data Block27Data;
typedef struct _Block28Data Block28Data;
typedef struct _Block29Data Block29Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Block15Data {
	int _ref_count_;
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeFoldFunc f;
	gpointer f_target;
	gpointer seed;
};

struct _Block16Data {
	int _ref_count_;
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeMapFunc f;
	gpointer f_target;
};

struct _Block17Data {
	int _ref_count_;
	Block16Data * _data16_;
	GeeLazy* item;
};

struct _Block18Data {
	int _ref_count_;
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gboolean seed_emitted;
	GeeFoldFunc f;
	gpointer f_target;
	gpointer seed;
};

struct _Block19Data {
	int _ref_count_;
	Block18Data * _data18_;
	GeeLazy* item;
};

struct _Block20Data {
	int _ref_count_;
	GeeTraversable* self;
	GeePredicate pred;
	gpointer pred_target;
	GDestroyNotify pred_target_destroy_notify;
};

struct _Block21Data {
	int _ref_count_;
	GeeTraversable* self;
	gint offset;
	gint length;
};

struct _Block22Data {
	int _ref_count_;
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeIterator* current;
	GeeFlatMapFunc f;
	gpointer f_target;
	GDestroyNotify f_target_destroy_notify;
};

struct _Block23Data {
	int _ref_count_;
	Block22Data * _data22_;
};

struct _Block24Data {
	int _ref_count_;
	GeeTraversable* self;
	GeeIterator* _self_;
};

struct _Block25Data {
	int _ref_count_;
	GeeTraversable* self;
	gpointer _result_;
	GeePredicate pred;
	gpointer pred_target;
	GDestroyNotify pred_target_destroy_notify;
};

struct _Block26Data {
	int _ref_count_;
	GeeTraversable* self;
	gboolean _result_;
	GeePredicate pred;
	gpointer pred_target;
	GDestroyNotify pred_target_destroy_notify;
};

struct _Block27Data {
	int _ref_count_;
	GeeTraversable* self;
	gpointer max_value;
	GCompareDataFunc compare;
	gpointer compare_target;
	GDestroyNotify compare_target_destroy_notify;
};

struct _Block28Data {
	int _ref_count_;
	GeeTraversable* self;
	gpointer min_value;
	GCompareDataFunc compare;
	gpointer compare_target;
	GDestroyNotify compare_target_destroy_notify;
};

struct _Block29Data {
	int _ref_count_;
	GeeTraversable* self;
	GeeArrayList* _result_;
};

static GeeIterator* gee_traversable_real_stream (GeeTraversable* self,
                                          GType a_type,
                                          GBoxedCopyFunc a_dup_func,
                                          GDestroyNotify a_destroy_func,
                                          GeeStreamFunc f,
                                          gpointer f_target,
                                          GDestroyNotify f_target_destroy_notify);
 G_GNUC_INTERNAL GeeStreamIterator* gee_stream_iterator_new (GType a_type,
                                            GBoxedCopyFunc a_dup_func,
                                            GDestroyNotify a_destroy_func,
                                            GType g_type,
                                            GBoxedCopyFunc g_dup_func,
                                            GDestroyNotify g_destroy_func,
                                            GeeIterator* outer,
                                            GeeStreamFunc func,
                                            gpointer func_target,
                                            GDestroyNotify func_target_destroy_notify);
 G_GNUC_INTERNAL GeeStreamIterator* gee_stream_iterator_construct (GType object_type,
                                                  GType a_type,
                                                  GBoxedCopyFunc a_dup_func,
                                                  GDestroyNotify a_destroy_func,
                                                  GType g_type,
                                                  GBoxedCopyFunc g_dup_func,
                                                  GDestroyNotify g_destroy_func,
                                                  GeeIterator* outer,
                                                  GeeStreamFunc func,
                                                  gpointer func_target,
                                                  GDestroyNotify func_target_destroy_notify);
 G_GNUC_INTERNAL GType gee_stream_iterator_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gpointer gee_traversable_real_fold (GeeTraversable* self,
                                    GType a_type,
                                    GBoxedCopyFunc a_dup_func,
                                    GDestroyNotify a_destroy_func,
                                    GeeFoldFunc f,
                                    gpointer f_target,
                                    gpointer seed);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static gboolean __lambda11_ (Block15Data* _data15_,
                      gpointer item);
static gboolean ___lambda11__gee_forall_func (gpointer g,
                                       gpointer self);
static GeeIterator* gee_traversable_real_map (GeeTraversable* self,
                                       GType a_type,
                                       GBoxedCopyFunc a_dup_func,
                                       GDestroyNotify a_destroy_func,
                                       GeeMapFunc f,
                                       gpointer f_target);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static GeeTraversableStream __lambda12_ (Block16Data* _data16_,
                                  GeeTraversableStream state,
                                  GeeLazy* item,
                                  GeeLazy** val);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static gpointer ___lambda13_ (Block17Data* _data17_);
static gpointer ____lambda13__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda12__gee_stream_func (GeeTraversableStream state,
                                                   GeeLazy* g,
                                                   GeeLazy** lazy,
                                                   gpointer self);
static GeeIterator* gee_traversable_real_scan (GeeTraversable* self,
                                        GType a_type,
                                        GBoxedCopyFunc a_dup_func,
                                        GDestroyNotify a_destroy_func,
                                        GeeFoldFunc f,
                                        gpointer f_target,
                                        gpointer seed);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static GeeTraversableStream __lambda14_ (Block18Data* _data18_,
                                  GeeTraversableStream state,
                                  GeeLazy* item,
                                  GeeLazy** val);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static gpointer ___lambda15_ (Block19Data* _data19_);
static gpointer ____lambda15__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda14__gee_stream_func (GeeTraversableStream state,
                                                   GeeLazy* g,
                                                   GeeLazy** lazy,
                                                   gpointer self);
static GeeIterator* gee_traversable_real_filter (GeeTraversable* self,
                                          GeePredicate pred,
                                          gpointer pred_target,
                                          GDestroyNotify pred_target_destroy_notify);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static GeeTraversableStream __lambda16_ (Block20Data* _data20_,
                                  GeeTraversableStream state,
                                  GeeLazy* item,
                                  GeeLazy** val);
static GeeTraversableStream ___lambda16__gee_stream_func (GeeTraversableStream state,
                                                   GeeLazy* g,
                                                   GeeLazy** lazy,
                                                   gpointer self);
static GeeIterator* gee_traversable_real_chop (GeeTraversable* self,
                                        gint offset,
                                        gint length);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static GeeTraversableStream __lambda17_ (Block21Data* _data21_,
                                  GeeTraversableStream state,
                                  GeeLazy* item,
                                  GeeLazy** val);
static GeeTraversableStream ___lambda17__gee_stream_func (GeeTraversableStream state,
                                                   GeeLazy* g,
                                                   GeeLazy** lazy,
                                                   gpointer self);
static GeeIterator* gee_traversable_real_flat_map (GeeTraversable* self,
                                            GType a_type,
                                            GBoxedCopyFunc a_dup_func,
                                            GDestroyNotify a_destroy_func,
                                            GeeFlatMapFunc f,
                                            gpointer f_target,
                                            GDestroyNotify f_target_destroy_notify);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
static GeeTraversableStream __lambda18_ (Block22Data* _data22_,
                                  GeeTraversableStream state,
                                  GeeLazy* item,
                                  GeeLazy** val);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static gpointer ____lambda19_ (Block23Data* _data23_);
static gpointer _____lambda19__gee_lazy_func (gpointer self);
static gpointer ____lambda20_ (Block23Data* _data23_);
static gpointer _____lambda20__gee_lazy_func (gpointer self);
static gpointer ____lambda21_ (Block23Data* _data23_);
static gpointer _____lambda21__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda18__gee_stream_func (GeeTraversableStream state,
                                                   GeeLazy* g,
                                                   GeeLazy** lazy,
                                                   gpointer self);
static GeeIterator** gee_traversable_real_tee (GeeTraversable* self,
                                        guint forks,
                                        gint* result_length1);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static gpointer ______lambda22_ (Block24Data* _data24_);
static gpointer _______lambda22__gee_lazy_func (gpointer self);
 G_GNUC_INTERNAL gpointer gee_tee_iterator_node_ref (gpointer instance);
 G_GNUC_INTERNAL void gee_tee_iterator_node_unref (gpointer instance);
 G_GNUC_INTERNAL GParamSpec* gee_tee_iterator_param_spec_node (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
 G_GNUC_INTERNAL void gee_tee_iterator_value_set_node (GValue* value,
                                      gpointer v_object) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL void gee_tee_iterator_value_take_node (GValue* value,
                                       gpointer v_object);
 G_GNUC_INTERNAL gpointer gee_tee_iterator_value_get_node (const GValue* value) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GType gee_tee_iterator_node_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GeeLazy* gee_tee_iterator_create_nodes (GType g_type,
                                        GBoxedCopyFunc g_dup_func,
                                        GDestroyNotify g_destroy_func,
                                        GeeIterator* iterator,
                                        GeeLazy* dependent);
 G_GNUC_INTERNAL GeeTeeIteratorNode* gee_tee_iterator_node_new (GType g_type,
                                               GBoxedCopyFunc g_dup_func,
                                               GDestroyNotify g_destroy_func,
                                               GeeLazy* data,
                                               GeeLazy* next);
 G_GNUC_INTERNAL GeeTeeIteratorNode* gee_tee_iterator_node_construct (GType object_type,
                                                     GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     GeeLazy* data,
                                                     GeeLazy* next);
 G_GNUC_INTERNAL GeeTeeIterator* gee_tee_iterator_new (GType g_type,
                                      GBoxedCopyFunc g_dup_func,
                                      GDestroyNotify g_destroy_func,
                                      GeeTeeIteratorNode* head,
                                      gboolean valid);
 G_GNUC_INTERNAL GeeTeeIterator* gee_tee_iterator_construct (GType object_type,
                                            GType g_type,
                                            GBoxedCopyFunc g_dup_func,
                                            GDestroyNotify g_destroy_func,
                                            GeeTeeIteratorNode* head,
                                            gboolean valid);
 G_GNUC_INTERNAL GType gee_tee_iterator_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gpointer gee_traversable_real_first_match (GeeTraversable* self,
                                           GeePredicate pred,
                                           gpointer pred_target,
                                           GDestroyNotify pred_target_destroy_notify);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static gboolean __lambda25_ (Block25Data* _data25_,
                      gpointer item);
static gboolean ___lambda25__gee_forall_func (gpointer g,
                                       gpointer self);
static gboolean gee_traversable_real_any_match (GeeTraversable* self,
                                         GeePredicate pred,
                                         gpointer pred_target,
                                         GDestroyNotify pred_target_destroy_notify);
static gboolean gee_traversable_real_all_match (GeeTraversable* self,
                                         GeePredicate pred,
                                         gpointer pred_target,
                                         GDestroyNotify pred_target_destroy_notify);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static gboolean __lambda26_ (Block26Data* _data26_,
                      gpointer item);
static gboolean ___lambda26__gee_forall_func (gpointer g,
                                       gpointer self);
static gpointer gee_traversable_real_max (GeeTraversable* self,
                                   GCompareDataFunc compare,
                                   gpointer compare_target,
                                   GDestroyNotify compare_target_destroy_notify);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static gboolean __lambda27_ (Block27Data* _data27_,
                      gpointer item);
static gboolean ___lambda27__gee_forall_func (gpointer g,
                                       gpointer self);
static gpointer gee_traversable_real_min (GeeTraversable* self,
                                   GCompareDataFunc compare,
                                   gpointer compare_target,
                                   GDestroyNotify compare_target_destroy_notify);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static gboolean __lambda28_ (Block28Data* _data28_,
                      gpointer item);
static gboolean ___lambda28__gee_forall_func (gpointer g,
                                       gpointer self);
static GeeIterator* gee_traversable_real_order_by (GeeTraversable* self,
                                            GCompareDataFunc compare,
                                            gpointer compare_target,
                                            GDestroyNotify compare_target_destroy_notify);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static gboolean __lambda48_ (Block29Data* _data29_,
                      gpointer item);
static gboolean ___lambda48__gee_forall_func (gpointer g,
                                       gpointer self);
static GType gee_traversable_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static GType
gee_traversable_stream_get_type_once (void)
{
	static const GEnumValue values[] = {{GEE_TRAVERSABLE_STREAM_YIELD, "GEE_TRAVERSABLE_STREAM_YIELD", "yield"}, {GEE_TRAVERSABLE_STREAM_CONTINUE, "GEE_TRAVERSABLE_STREAM_CONTINUE", "continue"}, {GEE_TRAVERSABLE_STREAM_END, "GEE_TRAVERSABLE_STREAM_END", "end"}, {GEE_TRAVERSABLE_STREAM_WAIT, "GEE_TRAVERSABLE_STREAM_WAIT", "wait"}, {0, NULL, NULL}};
	GType gee_traversable_stream_type_id;
	gee_traversable_stream_type_id = g_enum_register_static ("GeeTraversableStream", values);
	return gee_traversable_stream_type_id;
}

GType
gee_traversable_stream_get_type (void)
{
	static volatile gsize gee_traversable_stream_type_id__once = 0;
	if (g_once_init_enter (&gee_traversable_stream_type_id__once)) {
		GType gee_traversable_stream_type_id;
		gee_traversable_stream_type_id = gee_traversable_stream_get_type_once ();
		g_once_init_leave (&gee_traversable_stream_type_id__once, gee_traversable_stream_type_id);
	}
	return gee_traversable_stream_type_id__once;
}

/**
 * Apply function to each element returned by iterator until last element
 * or function return ''false''.
 *
 * ''{@link Iterator} implementation:'' Operation moves the iterator
 * to last element in iteration or the first element that returned ''false''.
 * If iterator points at some element it will be included in iteration.
 *
 * @param f function applied to every element of the collection
 *
 * @return ''false'' if the argument returned ''false'' at last invocation and
 *         ''true'' otherwise.
 */
gboolean
gee_traversable_foreach (GeeTraversable* self,
                         GeeForallFunc f,
                         gpointer f_target)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->foreach) {
		return _iface_->foreach (self, f, f_target);
	}
	return FALSE;
}

/**
 * Stream function is an abstract function allowing writing many
 * operations.
 *
 * The stream function accepts three parameter:
 *
 *   1. state. It is usually the last returned value from function but
 *      it may be {@link Stream.END} when {@link Stream.CONTINUE} was
 *      returned and there was no more elements.
 *   1. input. It is valid only if first argument is
 *      {@link Stream.CONTINUE}
 *   1. output. It is valid only if result is Stream.YIELD
 *
 * It may return one of 3 results:
 *
 *   1. {@link Stream.YIELD}. It means that value was yielded and can
 *      be passed to outgoing iterator.
 *   1. {@link Stream.CONTINUE}. It means that the function needs to be
 *      called with next element or with {@link Stream.END} if it is
 *      end of stream). If the state element was Stream.END during the
 *      current iteration function ''must not'' return {@link Stream.CONTINUE}.
 *   1. {@link Stream.WAIT}. Simply denotes that iterator should skip an element.
 *      Usually the function is called once again with {@link Stream.WAIT} as
 *      state however it do affect the initial validity of iterator.
 *   1. {@link Stream.END}. It means that the last argument was yielded.
 *
 * If the function yields the value immediately then the returning iterator
 * is {@link Iterator.valid} and points to this value as well as in case when the
 * parent iterator is {@link Iterator.valid} and function yields
 * after consuming 1 input. In other case returned iterator is invalid including
 * when the first value returned is {@link Stream.WAIT}.
 *
 * Note: In {@link Iterator} implementation: if iterator is
 *    {@link Iterator.valid} the current value should be fed
 *    immediately to function if during initial call function returns
 *    {@link Stream.CONTINUE}. The parent iterator cannot be used before
 *    the functions return {@link Stream.END} afterwards it points on the
 *    last element consumed.
 *
 * @param f function generating stream
 * @return iterator containing values yielded by stream
 */
static GeeIterator*
gee_traversable_real_stream (GeeTraversable* self,
                             GType a_type,
                             GBoxedCopyFunc a_dup_func,
                             GDestroyNotify a_destroy_func,
                             GeeStreamFunc f,
                             gpointer f_target,
                             GDestroyNotify f_target_destroy_notify)
{
	GeeIterator* _self_ = NULL;
	GeeIterable* iself = NULL;
	GeeIterator* _tmp0_;
	GeeIterator* result;
	_self_ = GEE_IS_ITERATOR (self) ? ((GeeIterator*) self) : NULL;
	_tmp0_ = _self_;
	if (_tmp0_ != NULL) {
		GeeIterator* _tmp1_;
		GeeStreamFunc _tmp2_;
		gpointer _tmp2__target;
		GDestroyNotify _tmp2__target_destroy_notify;
		GeeStreamIterator* _tmp3_;
		_tmp1_ = _self_;
		_tmp2_ = f;
		_tmp2__target = f_target;
		_tmp2__target_destroy_notify = f_target_destroy_notify;
		f = NULL;
		f_target = NULL;
		f_target_destroy_notify = NULL;
		_tmp3_ = gee_stream_iterator_new (a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), (GDestroyNotify) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), _tmp1_, _tmp2_, _tmp2__target, _tmp2__target_destroy_notify);
		result = (GeeIterator*) _tmp3_;
		(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
		f = NULL;
		f_target = NULL;
		f_target_destroy_notify = NULL;
		return result;
	} else {
		GeeIterable* _tmp4_;
		iself = GEE_IS_ITERABLE (self) ? ((GeeIterable*) self) : NULL;
		_tmp4_ = iself;
		if (_tmp4_ != NULL) {
			GeeIterable* _tmp5_;
			GeeIterator* _tmp6_;
			GeeIterator* _tmp7_;
			GeeStreamFunc _tmp8_;
			gpointer _tmp8__target;
			GDestroyNotify _tmp8__target_destroy_notify;
			GeeIterator* _tmp9_;
			GeeIterator* _tmp10_;
			_tmp5_ = iself;
			_tmp6_ = gee_iterable_iterator (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = f;
			_tmp8__target = f_target;
			_tmp8__target_destroy_notify = f_target_destroy_notify;
			f = NULL;
			f_target = NULL;
			f_target_destroy_notify = NULL;
			_tmp9_ = gee_traversable_stream ((GeeTraversable*) _tmp7_, a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, _tmp8_, _tmp8__target, _tmp8__target_destroy_notify);
			_tmp10_ = _tmp9_;
			_g_object_unref0 (_tmp7_);
			result = _tmp10_;
			(f_target_destroy_notify == NULL) ? NULL : (f_target_destroy_notify (f_target), NULL);
			f = NULL;
			f_target = NULL;
			f_target_destroy_notify = NULL;
			return result;
		} else {
			g_assert_not_reached ();
		}
	}
}

GeeIterator*
gee_traversable_stream (GeeTraversable* self,
                        GType a_type,
                        GBoxedCopyFunc a_dup_func,
                        GDestroyNotify a_destroy_func,
                        GeeStreamFunc f,
                        gpointer f_target,
                        GDestroyNotify f_target_destroy_notify)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->stream) {
		return _iface_->stream (self, a_type, a_dup_func, a_destroy_func, f, f_target, f_target_destroy_notify);
	}
	return NULL;
}

/**
 * Standard aggregation function.
 *
 * It takes a function, seed and first element, returns the new seed and
 * progress to next element when the operation repeats.
 *
 * Note: Default implementation uses {@link foreach}.
 *
 * Note: In {@link Iterator} implementation operation moves the
 *    iterator to last element in iteration. If iterator is
 *    {@link Iterator.valid} the current element will be considered
 *    as well.
 *
 */
static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		GeeTraversable* self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data15_->self;
		a_type = _data15_->a_type;
		a_dup_func = _data15_->a_dup_func;
		a_destroy_func = _data15_->a_destroy_func;
		((_data15_->seed == NULL) || (a_destroy_func == NULL)) ? NULL : (_data15_->seed = (a_destroy_func (_data15_->seed), NULL));
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static gboolean
__lambda11_ (Block15Data* _data15_,
             gpointer item)
{
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer _tmp0_;
	gpointer _tmp1_;
	gpointer _tmp2_;
	gboolean result;
	self = _data15_->self;
	a_type = _data15_->a_type;
	a_dup_func = _data15_->a_dup_func;
	a_destroy_func = _data15_->a_destroy_func;
	_tmp0_ = item;
	item = NULL;
	_tmp1_ = _data15_->seed;
	_data15_->seed = NULL;
	_tmp2_ = _data15_->f (_tmp0_, _tmp1_, _data15_->f_target);
	((_data15_->seed == NULL) || (a_destroy_func == NULL)) ? NULL : (_data15_->seed = (a_destroy_func (_data15_->seed), NULL));
	_data15_->seed = _tmp2_;
	result = TRUE;
	((item == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
	return result;
}

static gboolean
___lambda11__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda11_ (self, g);
	return result;
}

static gpointer
gee_traversable_real_fold (GeeTraversable* self,
                           GType a_type,
                           GBoxedCopyFunc a_dup_func,
                           GDestroyNotify a_destroy_func,
                           GeeFoldFunc f,
                           gpointer f_target,
                           gpointer seed)
{
	Block15Data* _data15_;
	gpointer _tmp0_;
	gpointer result;
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_data15_->a_type = a_type;
	_data15_->a_dup_func = a_dup_func;
	_data15_->a_destroy_func = a_destroy_func;
	_data15_->f = f;
	_data15_->f_target = f_target;
	((_data15_->seed == NULL) || (a_destroy_func == NULL)) ? NULL : (_data15_->seed = (a_destroy_func (_data15_->seed), NULL));
	_data15_->seed = seed;
	gee_traversable_foreach (self, ___lambda11__gee_forall_func, _data15_);
	_tmp0_ = _data15_->seed;
	_data15_->seed = NULL;
	result = _tmp0_;
	block15_data_unref (_data15_);
	_data15_ = NULL;
	return result;
}

gpointer
gee_traversable_fold (GeeTraversable* self,
                      GType a_type,
                      GBoxedCopyFunc a_dup_func,
                      GDestroyNotify a_destroy_func,
                      GeeFoldFunc f,
                      gpointer f_target,
                      gpointer seed)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->fold) {
		return _iface_->fold (self, a_type, a_dup_func, a_destroy_func, f, f_target, seed);
	}
	return NULL;
}

/**
 * Produces an iterator pointing at elements generated by function passed.
 *
 * Iterator is lazy evaluated but value is force-evaluated when
 * iterator moves to next element. ({@link Iterator.next})
 *
 * Note: Default implementation uses {@link stream}.
 *
 * Note: In {@link Iterator} implementation if the parent iterator is
 *    {@link Iterator.valid} so is the returned one. Using the parent
 *    iterator is not allowed before the inner iterator {@link Iterator.next}
 *    return false and then it points on its last element.
 *    The resulting iterator is {@link Iterator.valid} if the parent
 *    iterator is.
 *
 * @param f Mapping function
 * @return Iterator listing mapped value
 */
static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		GeeTraversable* self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data16_->self;
		a_type = _data16_->a_type;
		a_dup_func = _data16_->a_dup_func;
		a_destroy_func = _data16_->a_destroy_func;
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		GeeTraversable* self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data17_->_data16_->self;
		a_type = _data17_->_data16_->a_type;
		a_dup_func = _data17_->_data16_->a_dup_func;
		a_destroy_func = _data17_->_data16_->a_destroy_func;
		_gee_lazy_unref0 (_data17_->item);
		block16_data_unref (_data17_->_data16_);
		_data17_->_data16_ = NULL;
		g_slice_free (Block17Data, _data17_);
	}
}

static gpointer
___lambda13_ (Block17Data* _data17_)
{
	Block16Data* _data16_;
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer tmp = NULL;
	gpointer _tmp0_;
	gpointer _tmp1_;
	gpointer _tmp2_;
	gpointer result;
	_data16_ = _data17_->_data16_;
	self = _data16_->self;
	a_type = _data16_->a_type;
	a_dup_func = _data16_->a_dup_func;
	a_destroy_func = _data16_->a_destroy_func;
	_tmp0_ = gee_lazy_get (_data17_->item);
	tmp = _tmp0_;
	_gee_lazy_unref0 (_data17_->item);
	_data17_->item = NULL;
	_tmp1_ = tmp;
	tmp = NULL;
	_tmp2_ = _data16_->f (_tmp1_, _data16_->f_target);
	result = _tmp2_;
	((tmp == NULL) || (a_destroy_func == NULL)) ? NULL : (tmp = (a_destroy_func (tmp), NULL));
	return result;
}

static gpointer
____lambda13__gee_lazy_func (gpointer self)
{
	gpointer result;
	result = ___lambda13_ (self);
	return result;
}

static GeeTraversableStream
__lambda12_ (Block16Data* _data16_,
             GeeTraversableStream state,
             GeeLazy* item,
             GeeLazy** val)
{
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* _vala_val = NULL;
	Block17Data* _data17_;
	GeeTraversableStream result;
	self = _data16_->self;
	a_type = _data16_->a_type;
	a_dup_func = _data16_->a_dup_func;
	a_destroy_func = _data16_->a_destroy_func;
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->_data16_ = block16_data_ref (_data16_);
	_gee_lazy_unref0 (_data17_->item);
	_data17_->item = item;
	switch (state) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
			block17_data_unref (_data17_);
			_data17_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			GeeLazy* _tmp0_;
			_tmp0_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, ____lambda13__gee_lazy_func, block17_data_ref (_data17_), block17_data_unref);
			_gee_lazy_unref0 (_vala_val);
			_vala_val = _tmp0_;
			result = GEE_TRAVERSABLE_STREAM_YIELD;
			block17_data_unref (_data17_);
			_data17_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			block17_data_unref (_data17_);
			_data17_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GeeTraversableStream
___lambda12__gee_stream_func (GeeTraversableStream state,
                              GeeLazy* g,
                              GeeLazy** lazy,
                              gpointer self)
{
	GeeTraversableStream result;
	result = __lambda12_ (self, state, g, lazy);
	return result;
}

static GeeIterator*
gee_traversable_real_map (GeeTraversable* self,
                          GType a_type,
                          GBoxedCopyFunc a_dup_func,
                          GDestroyNotify a_destroy_func,
                          GeeMapFunc f,
                          gpointer f_target)
{
	Block16Data* _data16_;
	GeeIterator* _tmp0_;
	GeeIterator* result;
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_data16_->self = g_object_ref (self);
	_data16_->a_type = a_type;
	_data16_->a_dup_func = a_dup_func;
	_data16_->a_destroy_func = a_destroy_func;
	_data16_->f = f;
	_data16_->f_target = f_target;
	_tmp0_ = gee_traversable_stream (self, a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, ___lambda12__gee_stream_func, block16_data_ref (_data16_), block16_data_unref);
	result = _tmp0_;
	block16_data_unref (_data16_);
	_data16_ = NULL;
	return result;
}

GeeIterator*
gee_traversable_map (GeeTraversable* self,
                     GType a_type,
                     GBoxedCopyFunc a_dup_func,
                     GDestroyNotify a_destroy_func,
                     GeeMapFunc f,
                     gpointer f_target)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->map) {
		return _iface_->map (self, a_type, a_dup_func, a_destroy_func, f, f_target);
	}
	return NULL;
}

/**
 * Creates a new iterator that is initially pointing to seed. Then
 * subsequent values are obtained after applying the function to previous
 * value and the subsequent items.
 *
 * The resulting iterator is always valid and it contains the seed value.
 *
 * Note: Default implementation uses {@link stream}.
 *
 * Note: When the method is called on {@link Iterator}, using the parent
 *    iterator is not allowed before the inner iterator
 *    {@link Iterator.next} returns false and then it points to its last
 *    element. The resulting iterator is {@link Iterator.valid}.
 *
 * @param f Folding function
 * @param seed original seed value
 * @return Iterator containing values of subsequent values of seed
 */
static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		GeeTraversable* self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data18_->self;
		a_type = _data18_->a_type;
		a_dup_func = _data18_->a_dup_func;
		a_destroy_func = _data18_->a_destroy_func;
		((_data18_->seed == NULL) || (a_destroy_func == NULL)) ? NULL : (_data18_->seed = (a_destroy_func (_data18_->seed), NULL));
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		GeeTraversable* self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data19_->_data18_->self;
		a_type = _data19_->_data18_->a_type;
		a_dup_func = _data19_->_data18_->a_dup_func;
		a_destroy_func = _data19_->_data18_->a_destroy_func;
		_gee_lazy_unref0 (_data19_->item);
		block18_data_unref (_data19_->_data18_);
		_data19_->_data18_ = NULL;
		g_slice_free (Block19Data, _data19_);
	}
}

static gpointer
___lambda15_ (Block19Data* _data19_)
{
	Block18Data* _data18_;
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer tmp = NULL;
	gpointer _tmp0_;
	gpointer _tmp1_;
	gpointer _tmp2_;
	gpointer _tmp3_;
	gpointer _tmp4_;
	gpointer result;
	_data18_ = _data19_->_data18_;
	self = _data18_->self;
	a_type = _data18_->a_type;
	a_dup_func = _data18_->a_dup_func;
	a_destroy_func = _data18_->a_destroy_func;
	_tmp0_ = gee_lazy_get (_data19_->item);
	tmp = _tmp0_;
	_gee_lazy_unref0 (_data19_->item);
	_data19_->item = NULL;
	_tmp1_ = tmp;
	tmp = NULL;
	_tmp2_ = _data18_->seed;
	_data18_->seed = NULL;
	_tmp3_ = _data18_->f (_tmp1_, _tmp2_, _data18_->f_target);
	((_data18_->seed == NULL) || (a_destroy_func == NULL)) ? NULL : (_data18_->seed = (a_destroy_func (_data18_->seed), NULL));
	_data18_->seed = _tmp3_;
	_tmp4_ = ((_data18_->seed != NULL) && (a_dup_func != NULL)) ? a_dup_func ((gpointer) _data18_->seed) : ((gpointer) _data18_->seed);
	result = _tmp4_;
	((tmp == NULL) || (a_destroy_func == NULL)) ? NULL : (tmp = (a_destroy_func (tmp), NULL));
	return result;
}

static gpointer
____lambda15__gee_lazy_func (gpointer self)
{
	gpointer result;
	result = ___lambda15_ (self);
	return result;
}

static GeeTraversableStream
__lambda14_ (Block18Data* _data18_,
             GeeTraversableStream state,
             GeeLazy* item,
             GeeLazy** val)
{
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* _vala_val = NULL;
	Block19Data* _data19_;
	GeeTraversableStream result;
	self = _data18_->self;
	a_type = _data18_->a_type;
	a_dup_func = _data18_->a_dup_func;
	a_destroy_func = _data18_->a_destroy_func;
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->_data18_ = block18_data_ref (_data18_);
	_gee_lazy_unref0 (_data19_->item);
	_data19_->item = item;
	switch (state) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			if (_data18_->seed_emitted) {
				_gee_lazy_unref0 (_vala_val);
				_vala_val = NULL;
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				block19_data_unref (_data19_);
				_data19_ = NULL;
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				GeeLazy* _tmp0_;
				_tmp0_ = gee_lazy_new_from_value (a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, _data18_->seed);
				_gee_lazy_unref0 (_vala_val);
				_vala_val = _tmp0_;
				_data18_->seed_emitted = TRUE;
				result = GEE_TRAVERSABLE_STREAM_YIELD;
				block19_data_unref (_data19_);
				_data19_ = NULL;
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			}
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			GeeLazy* _tmp1_;
			_tmp1_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, ____lambda15__gee_lazy_func, block19_data_ref (_data19_), block19_data_unref);
			_gee_lazy_unref0 (_vala_val);
			_vala_val = _tmp1_;
			result = GEE_TRAVERSABLE_STREAM_YIELD;
			block19_data_unref (_data19_);
			_data19_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			block19_data_unref (_data19_);
			_data19_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GeeTraversableStream
___lambda14__gee_stream_func (GeeTraversableStream state,
                              GeeLazy* g,
                              GeeLazy** lazy,
                              gpointer self)
{
	GeeTraversableStream result;
	result = __lambda14_ (self, state, g, lazy);
	return result;
}

static GeeIterator*
gee_traversable_real_scan (GeeTraversable* self,
                           GType a_type,
                           GBoxedCopyFunc a_dup_func,
                           GDestroyNotify a_destroy_func,
                           GeeFoldFunc f,
                           gpointer f_target,
                           gpointer seed)
{
	Block18Data* _data18_;
	GeeIterator* _tmp0_;
	GeeIterator* result;
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_data18_->a_type = a_type;
	_data18_->a_dup_func = a_dup_func;
	_data18_->a_destroy_func = a_destroy_func;
	_data18_->f = f;
	_data18_->f_target = f_target;
	((_data18_->seed == NULL) || (a_destroy_func == NULL)) ? NULL : (_data18_->seed = (a_destroy_func (_data18_->seed), NULL));
	_data18_->seed = seed;
	_data18_->seed_emitted = FALSE;
	_tmp0_ = gee_traversable_stream (self, a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, ___lambda14__gee_stream_func, block18_data_ref (_data18_), block18_data_unref);
	result = _tmp0_;
	block18_data_unref (_data18_);
	_data18_ = NULL;
	return result;
}

GeeIterator*
gee_traversable_scan (GeeTraversable* self,
                      GType a_type,
                      GBoxedCopyFunc a_dup_func,
                      GDestroyNotify a_destroy_func,
                      GeeFoldFunc f,
                      gpointer f_target,
                      gpointer seed)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->scan) {
		return _iface_->scan (self, a_type, a_dup_func, a_destroy_func, f, f_target, seed);
	}
	return NULL;
}

/**
 * Creates a new iterator that contains only values that fulfills the
 * predicate.
 *
 * Note: When the method is called on {@link Iterator} using the parent
 *    iterator is not allowed before the inner iterator
 *    {@link Iterator.next} return false and then it points on its last
 *    element. The resulting iterator is {@link Iterator.valid} if parent
 *    iterator is {@link Iterator.valid} and value it is pointing at
 *    fulfills the predicate.
 *
 * @param pred predicate to check should the value be retained
 * @return Iterator containing values of subsequent values of seed
 */
static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		GeeTraversable* self;
		self = _data20_->self;
		(_data20_->pred_target_destroy_notify == NULL) ? NULL : (_data20_->pred_target_destroy_notify (_data20_->pred_target), NULL);
		_data20_->pred = NULL;
		_data20_->pred_target = NULL;
		_data20_->pred_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static gpointer
_gee_lazy_ref0 (gpointer self)
{
	return self ? gee_lazy_ref (self) : NULL;
}

static GeeTraversableStream
__lambda16_ (Block20Data* _data20_,
             GeeTraversableStream state,
             GeeLazy* item,
             GeeLazy** val)
{
	GeeTraversable* self;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result;
	self = _data20_->self;
	switch (state) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
			_gee_lazy_unref0 (item);
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			gpointer g = NULL;
			gpointer _tmp0_;
			gconstpointer _tmp1_;
			_tmp0_ = gee_lazy_get (item);
			g = _tmp0_;
			_tmp1_ = g;
			if (_data20_->pred (_tmp1_, _data20_->pred_target)) {
				GeeLazy* _tmp2_;
				_tmp2_ = _gee_lazy_ref0 (item);
				_gee_lazy_unref0 (_vala_val);
				_vala_val = _tmp2_;
				result = GEE_TRAVERSABLE_STREAM_YIELD;
				((g == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (g = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (g), NULL));
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				_gee_lazy_unref0 (_vala_val);
				_vala_val = NULL;
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				((g == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (g = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (g), NULL));
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			}
			((g == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (g = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (g), NULL));
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			_gee_lazy_unref0 (item);
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GeeTraversableStream
___lambda16__gee_stream_func (GeeTraversableStream state,
                              GeeLazy* g,
                              GeeLazy** lazy,
                              gpointer self)
{
	GeeTraversableStream result;
	result = __lambda16_ (self, state, g, lazy);
	return result;
}

static GeeIterator*
gee_traversable_real_filter (GeeTraversable* self,
                             GeePredicate pred,
                             gpointer pred_target,
                             GDestroyNotify pred_target_destroy_notify)
{
	Block20Data* _data20_;
	GeeIterator* _tmp0_;
	GeeIterator* result;
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	(_data20_->pred_target_destroy_notify == NULL) ? NULL : (_data20_->pred_target_destroy_notify (_data20_->pred_target), NULL);
	_data20_->pred = NULL;
	_data20_->pred_target = NULL;
	_data20_->pred_target_destroy_notify = NULL;
	_data20_->pred = pred;
	_data20_->pred_target = pred_target;
	_data20_->pred_target_destroy_notify = pred_target_destroy_notify;
	_tmp0_ = gee_traversable_stream (self, GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), (GDestroyNotify) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), ___lambda16__gee_stream_func, block20_data_ref (_data20_), block20_data_unref);
	result = _tmp0_;
	block20_data_unref (_data20_);
	_data20_ = NULL;
	return result;
}

GeeIterator*
gee_traversable_filter (GeeTraversable* self,
                        GeePredicate pred,
                        gpointer pred_target,
                        GDestroyNotify pred_target_destroy_notify)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->filter) {
		return _iface_->filter (self, pred, pred_target, pred_target_destroy_notify);
	}
	return NULL;
}

/**
 * Creates a new iterator which contains elements from iterable. The
 * first argument states the offset i.e. number of elements the iterator
 * skips by default.
 *
 * Note: In {@link Iterator} implementation resulting iterator is
 *    {@link Iterator.valid} when parent iterator is
 *    {@link Iterator.valid} and the offset is 0. Using the parent
 *    iterator is not allowed before the inner iterator
 *    {@link Iterator.next} return false and then it points on its last
 *    element.
 *
 * @param offset the offset to first element the iterator is pointing to
 * @param length maximum number of elements iterator may return. Negative
 *        value means that the number is unbounded
 */
static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		GeeTraversable* self;
		self = _data21_->self;
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static GeeTraversableStream
__lambda17_ (Block21Data* _data21_,
             GeeTraversableStream state,
             GeeLazy* item,
             GeeLazy** val)
{
	GeeTraversable* self;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result;
	self = _data21_->self;
	switch (state) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			if (_data21_->offset > 0) {
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				if (_data21_->length > 0) {
					GeeTraversableStream _tmp0_ = 0;
					if (_data21_->length != 0) {
						_tmp0_ = GEE_TRAVERSABLE_STREAM_CONTINUE;
					} else {
						_tmp0_ = GEE_TRAVERSABLE_STREAM_END;
					}
					result = _tmp0_;
					_gee_lazy_unref0 (item);
					if (val) {
						*val = _vala_val;
					} else {
						_gee_lazy_unref0 (_vala_val);
					}
					return result;
				} else {
					if (_data21_->length == 0) {
						result = GEE_TRAVERSABLE_STREAM_END;
						_gee_lazy_unref0 (item);
						if (val) {
							*val = _vala_val;
						} else {
							_gee_lazy_unref0 (_vala_val);
						}
						return result;
					} else {
						result = GEE_TRAVERSABLE_STREAM_CONTINUE;
						_gee_lazy_unref0 (item);
						if (val) {
							*val = _vala_val;
						} else {
							_gee_lazy_unref0 (_vala_val);
						}
						return result;
					}
				}
			}
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			if (_data21_->offset == 0) {
				GeeLazy* _tmp1_;
				gint _tmp2_;
				_tmp1_ = _gee_lazy_ref0 (item);
				_gee_lazy_unref0 (_vala_val);
				_vala_val = _tmp1_;
				_tmp2_ = _data21_->length;
				_data21_->length = _tmp2_ - 1;
				result = GEE_TRAVERSABLE_STREAM_YIELD;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				gint _tmp3_;
				_gee_lazy_unref0 (_vala_val);
				_vala_val = NULL;
				_tmp3_ = _data21_->offset;
				_data21_->offset = _tmp3_ - 1;
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			}
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			_gee_lazy_unref0 (item);
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GeeTraversableStream
___lambda17__gee_stream_func (GeeTraversableStream state,
                              GeeLazy* g,
                              GeeLazy** lazy,
                              gpointer self)
{
	GeeTraversableStream result;
	result = __lambda17_ (self, state, g, lazy);
	return result;
}

static GeeIterator*
gee_traversable_real_chop (GeeTraversable* self,
                           gint offset,
                           gint length)
{
	Block21Data* _data21_;
	GeeIterator* _tmp0_;
	GeeIterator* result;
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_data21_->offset = offset;
	_data21_->length = length;
	_vala_assert (_data21_->offset >= 0, "offset >= 0");
	_tmp0_ = gee_traversable_stream (self, GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), (GDestroyNotify) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), ___lambda17__gee_stream_func, block21_data_ref (_data21_), block21_data_unref);
	result = _tmp0_;
	block21_data_unref (_data21_);
	_data21_ = NULL;
	return result;
}

GeeIterator*
gee_traversable_chop (GeeTraversable* self,
                      gint offset,
                      gint length)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->chop) {
		return _iface_->chop (self, offset, length);
	}
	return NULL;
}

/**
 * A fused concatenate and map. The function is applied to each element
 * of iteration and the resulting values are concatenated.
 *
 * The iterator is lazy evaluated but value is force-evaluated when
 * iterator is moved to next value.
 *
 * Note: Default implementation uses {@link stream}.
 *
 * Note: In {@link Iterator} implementation if the parent iterator is
 *    {@link Iterator.valid} and function returns a valid iterator the
 *    resulting iterator is also valid. Using the parent iterator is not
 *    allowed before the inner iterator {@link Iterator.next}
 *    return false and then it points on its last element.
 *
 * @since 0.11.1
 * @param f mapping function
 * @return Iterator over returned values
 */
static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		GeeTraversable* self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data22_->self;
		a_type = _data22_->a_type;
		a_dup_func = _data22_->a_dup_func;
		a_destroy_func = _data22_->a_destroy_func;
		_g_object_unref0 (_data22_->current);
		(_data22_->f_target_destroy_notify == NULL) ? NULL : (_data22_->f_target_destroy_notify (_data22_->f_target), NULL);
		_data22_->f = NULL;
		_data22_->f_target = NULL;
		_data22_->f_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		GeeTraversable* self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
		self = _data23_->_data22_->self;
		a_type = _data23_->_data22_->a_type;
		a_dup_func = _data23_->_data22_->a_dup_func;
		a_destroy_func = _data23_->_data22_->a_destroy_func;
		block22_data_unref (_data23_->_data22_);
		_data23_->_data22_ = NULL;
		g_slice_free (Block23Data, _data23_);
	}
}

static gpointer
____lambda19_ (Block23Data* _data23_)
{
	Block22Data* _data22_;
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer _tmp0_;
	gpointer result;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	a_type = _data22_->a_type;
	a_dup_func = _data22_->a_dup_func;
	a_destroy_func = _data22_->a_destroy_func;
	_tmp0_ = gee_iterator_get (_data22_->current);
	result = _tmp0_;
	return result;
}

static gpointer
_____lambda19__gee_lazy_func (gpointer self)
{
	gpointer result;
	result = ____lambda19_ (self);
	return result;
}

static gpointer
____lambda20_ (Block23Data* _data23_)
{
	Block22Data* _data22_;
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer _tmp0_;
	gpointer result;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	a_type = _data22_->a_type;
	a_dup_func = _data22_->a_dup_func;
	a_destroy_func = _data22_->a_destroy_func;
	_tmp0_ = gee_iterator_get (_data22_->current);
	result = _tmp0_;
	return result;
}

static gpointer
_____lambda20__gee_lazy_func (gpointer self)
{
	gpointer result;
	result = ____lambda20_ (self);
	return result;
}

static gpointer
____lambda21_ (Block23Data* _data23_)
{
	Block22Data* _data22_;
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer _tmp0_;
	gpointer result;
	_data22_ = _data23_->_data22_;
	self = _data22_->self;
	a_type = _data22_->a_type;
	a_dup_func = _data22_->a_dup_func;
	a_destroy_func = _data22_->a_destroy_func;
	_tmp0_ = gee_iterator_get (_data22_->current);
	result = _tmp0_;
	return result;
}

static gpointer
_____lambda21__gee_lazy_func (gpointer self)
{
	gpointer result;
	result = ____lambda21_ (self);
	return result;
}

static GeeTraversableStream
__lambda18_ (Block22Data* _data22_,
             GeeTraversableStream state,
             GeeLazy* item,
             GeeLazy** val)
{
	GeeTraversable* self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* _vala_val = NULL;
	Block23Data* _data23_;
	GeeTraversableStream result;
	self = _data22_->self;
	a_type = _data22_->a_type;
	a_dup_func = _data22_->a_dup_func;
	a_destroy_func = _data22_->a_destroy_func;
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_data23_->_data22_ = block22_data_ref (_data22_);
	switch (state) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			gboolean _tmp0_ = FALSE;
			if (_data22_->current == NULL) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = !gee_iterator_next (_data22_->current);
			}
			if (_tmp0_) {
				_gee_lazy_unref0 (_vala_val);
				_vala_val = NULL;
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				block23_data_unref (_data23_);
				_data23_ = NULL;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				GeeLazy* _tmp1_;
				_tmp1_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, _____lambda19__gee_lazy_func, block23_data_ref (_data23_), block23_data_unref);
				_gee_lazy_unref0 (_vala_val);
				_vala_val = _tmp1_;
				result = GEE_TRAVERSABLE_STREAM_YIELD;
				block23_data_unref (_data23_);
				_data23_ = NULL;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			}
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			gpointer _tmp2_;
			GeeIterator* _tmp3_;
			gboolean _tmp4_;
			gboolean _tmp5_;
			_tmp2_ = gee_lazy_get (item);
			_tmp3_ = _data22_->f (_tmp2_, _data22_->f_target);
			_g_object_unref0 (_data22_->current);
			_data22_->current = _tmp3_;
			_tmp4_ = gee_iterator_get_valid (_data22_->current);
			_tmp5_ = _tmp4_;
			if (_tmp5_) {
				GeeLazy* _tmp6_;
				_tmp6_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, _____lambda20__gee_lazy_func, block23_data_ref (_data23_), block23_data_unref);
				_gee_lazy_unref0 (_vala_val);
				_vala_val = _tmp6_;
				result = GEE_TRAVERSABLE_STREAM_YIELD;
				block23_data_unref (_data23_);
				_data23_ = NULL;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				_gee_lazy_unref0 (_vala_val);
				_vala_val = NULL;
				result = GEE_TRAVERSABLE_STREAM_WAIT;
				block23_data_unref (_data23_);
				_data23_ = NULL;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			}
		}
		case GEE_TRAVERSABLE_STREAM_WAIT:
		{
			if (gee_iterator_next (_data22_->current)) {
				GeeLazy* _tmp7_;
				_tmp7_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, _____lambda21__gee_lazy_func, block23_data_ref (_data23_), block23_data_unref);
				_gee_lazy_unref0 (_vala_val);
				_vala_val = _tmp7_;
				result = GEE_TRAVERSABLE_STREAM_YIELD;
				block23_data_unref (_data23_);
				_data23_ = NULL;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				_gee_lazy_unref0 (_vala_val);
				_vala_val = NULL;
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				block23_data_unref (_data23_);
				_data23_ = NULL;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			}
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			block23_data_unref (_data23_);
			_data23_ = NULL;
			_gee_lazy_unref0 (item);
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GeeTraversableStream
___lambda18__gee_stream_func (GeeTraversableStream state,
                              GeeLazy* g,
                              GeeLazy** lazy,
                              gpointer self)
{
	GeeTraversableStream result;
	result = __lambda18_ (self, state, g, lazy);
	return result;
}

static GeeIterator*
gee_traversable_real_flat_map (GeeTraversable* self,
                               GType a_type,
                               GBoxedCopyFunc a_dup_func,
                               GDestroyNotify a_destroy_func,
                               GeeFlatMapFunc f,
                               gpointer f_target,
                               GDestroyNotify f_target_destroy_notify)
{
	Block22Data* _data22_;
	GeeIterator* _tmp0_;
	GeeIterator* result;
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_data22_->a_type = a_type;
	_data22_->a_dup_func = a_dup_func;
	_data22_->a_destroy_func = a_destroy_func;
	(_data22_->f_target_destroy_notify == NULL) ? NULL : (_data22_->f_target_destroy_notify (_data22_->f_target), NULL);
	_data22_->f = NULL;
	_data22_->f_target = NULL;
	_data22_->f_target_destroy_notify = NULL;
	_data22_->f = f;
	_data22_->f_target = f_target;
	_data22_->f_target_destroy_notify = f_target_destroy_notify;
	_data22_->current = NULL;
	_tmp0_ = gee_traversable_stream (self, a_type, (GBoxedCopyFunc) a_dup_func, (GDestroyNotify) a_destroy_func, ___lambda18__gee_stream_func, block22_data_ref (_data22_), block22_data_unref);
	result = _tmp0_;
	block22_data_unref (_data22_);
	_data22_ = NULL;
	return result;
}

GeeIterator*
gee_traversable_flat_map (GeeTraversable* self,
                          GType a_type,
                          GBoxedCopyFunc a_dup_func,
                          GDestroyNotify a_destroy_func,
                          GeeFlatMapFunc f,
                          gpointer f_target,
                          GDestroyNotify f_target_destroy_notify)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->flat_map) {
		return _iface_->flat_map (self, a_type, a_dup_func, a_destroy_func, f, f_target, f_target_destroy_notify);
	}
	return NULL;
}

/**
 * Splits the traversable into multiple ones, caching the result if needed.
 *
 * Note: In {@link Iterator} implementation using the parent iterator is
 *   not allowed. However if any of the forked iterators {@link Iterator.next}
 *   return false then it is treated as if the parent iterator
 *   {@link Iterator.next} returned false.
 *
 * Note: The returned arrey might contain parent iterator if it is allowed
 *   by implementation. For example the iteration over collection does
 *   not need to generate and cache the results.
 *   In such case it is recommended to return the value as the first element
 *   of the array. This allows the consumer to check just the first element
 *   if it can perform optimizations for such case. However it //must// not
 *   depend on the order (that's for optimization only).
 *
 * Note: The resulting iterators does not need to be thread safe.
 *
 * @param forks Number of iterators in array
 * @return An array with created iterators
 * @since 0.11.5
 */
static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		GeeTraversable* self;
		self = _data24_->self;
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
______lambda22_ (Block24Data* _data24_)
{
	GeeTraversable* self;
	GeeIterator* _tmp0_;
	gpointer _tmp1_;
	gpointer result;
	self = _data24_->self;
	_tmp0_ = _data24_->_self_;
	_tmp1_ = gee_iterator_get (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_______lambda22__gee_lazy_func (gpointer self)
{
	gpointer result;
	result = ______lambda22_ (self);
	return result;
}

static GeeIterator**
gee_traversable_real_tee (GeeTraversable* self,
                          guint forks,
                          gint* result_length1)
{
	Block24Data* _data24_;
	GeeIterable* iself = NULL;
	GeeIterator* _tmp0_;
	GeeIterator** result;
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_data24_->_self_ = GEE_IS_ITERATOR (self) ? ((GeeIterator*) self) : NULL;
	_tmp0_ = _data24_->_self_;
	if (_tmp0_ != NULL) {
		if (forks == ((guint) 0)) {
			GeeIterator** _tmp1_;
			GeeIterator** _tmp2_;
			gint _tmp2__length1;
			_tmp1_ = g_new0 (GeeIterator*, 0 + 1);
			_tmp2_ = _tmp1_;
			_tmp2__length1 = 0;
			if (result_length1) {
				*result_length1 = _tmp2__length1;
			}
			result = _tmp2_;
			block24_data_unref (_data24_);
			_data24_ = NULL;
			return result;
		} else {
			if (forks == ((guint) 1)) {
				GeeIterator* _tmp3_;
				GeeIterator* _tmp4_;
				GeeIterator** _tmp5_;
				GeeIterator** _tmp6_;
				gint _tmp6__length1;
				_tmp3_ = _data24_->_self_;
				_tmp4_ = _g_object_ref0 (_tmp3_);
				_tmp5_ = g_new0 (GeeIterator*, 1 + 1);
				_tmp5_[0] = _tmp4_;
				_tmp6_ = _tmp5_;
				_tmp6__length1 = 1;
				if (result_length1) {
					*result_length1 = _tmp6__length1;
				}
				result = _tmp6_;
				block24_data_unref (_data24_);
				_data24_ = NULL;
				return result;
			} else {
				GeeIterator** _result_ = NULL;
				GeeIterator** _tmp7_;
				gint _result__length1;
				gint __result__size_;
				GeeLazy* data = NULL;
				gboolean is_valid = FALSE;
				GeeIterator* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				GeeTeeIteratorNode* head = NULL;
				GeeLazy* _tmp13_;
				GeeLazy* _tmp14_;
				GeeIterator* _tmp15_;
				GeeLazy* _tmp16_;
				GeeLazy* _tmp17_;
				GeeTeeIteratorNode* _tmp18_;
				GeeIterator** _tmp24_;
				gint _tmp24__length1;
				_tmp7_ = g_new0 (GeeIterator*, forks + 1);
				_result_ = _tmp7_;
				_result__length1 = forks;
				__result__size_ = _result__length1;
				_tmp8_ = _data24_->_self_;
				_tmp9_ = gee_iterator_get_valid (_tmp8_);
				_tmp10_ = _tmp9_;
				is_valid = _tmp10_;
				if (is_valid) {
					GeeLazy* _tmp11_;
					_tmp11_ = gee_lazy_new (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), (GDestroyNotify) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), _______lambda22__gee_lazy_func, block24_data_ref (_data24_), block24_data_unref);
					_gee_lazy_unref0 (data);
					data = _tmp11_;
				} else {
					GeeLazy* _tmp12_;
					_tmp12_ = gee_lazy_new_from_value (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), (GDestroyNotify) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), NULL);
					_gee_lazy_unref0 (data);
					data = _tmp12_;
				}
				_tmp13_ = data;
				_tmp14_ = _gee_lazy_ref0 (_tmp13_);
				_tmp15_ = _data24_->_self_;
				_tmp16_ = data;
				_tmp17_ = gee_tee_iterator_create_nodes (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), (GDestroyNotify) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), _tmp15_, _tmp16_);
				_tmp18_ = gee_tee_iterator_node_new (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), (GDestroyNotify) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), _tmp14_, _tmp17_);
				head = _tmp18_;
				{
					guint i = 0U;
					i = (guint) 0;
					{
						gboolean _tmp19_ = FALSE;
						_tmp19_ = TRUE;
						while (TRUE) {
							GeeIterator** _tmp21_;
							gint _tmp21__length1;
							GeeTeeIteratorNode* _tmp22_;
							GeeTeeIterator* _tmp23_;
							if (!_tmp19_) {
								guint _tmp20_;
								_tmp20_ = i;
								i = _tmp20_ + 1;
							}
							_tmp19_ = FALSE;
							if (!(i < forks)) {
								break;
							}
							_tmp21_ = _result_;
							_tmp21__length1 = _result__length1;
							_tmp22_ = head;
							_tmp23_ = gee_tee_iterator_new (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), (GDestroyNotify) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), _tmp22_, is_valid);
							_g_object_unref0 (_tmp21_[i]);
							_tmp21_[i] = (GeeIterator*) _tmp23_;
						}
					}
				}
				_tmp24_ = _result_;
				_tmp24__length1 = _result__length1;
				if (result_length1) {
					*result_length1 = _tmp24__length1;
				}
				result = _tmp24_;
				_gee_tee_iterator_node_unref0 (head);
				_gee_lazy_unref0 (data);
				block24_data_unref (_data24_);
				_data24_ = NULL;
				return result;
			}
		}
	} else {
		GeeIterable* _tmp25_;
		iself = GEE_IS_ITERABLE (self) ? ((GeeIterable*) self) : NULL;
		_tmp25_ = iself;
		if (_tmp25_ != NULL) {
			GeeIterator** _result_ = NULL;
			GeeIterator** _tmp26_;
			gint _result__length1;
			gint __result__size_;
			GeeIterator** _tmp32_;
			gint _tmp32__length1;
			_tmp26_ = g_new0 (GeeIterator*, forks + 1);
			_result_ = _tmp26_;
			_result__length1 = forks;
			__result__size_ = _result__length1;
			{
				guint i = 0U;
				i = (guint) 0;
				{
					gboolean _tmp27_ = FALSE;
					_tmp27_ = TRUE;
					while (TRUE) {
						GeeIterator** _tmp29_;
						gint _tmp29__length1;
						GeeIterable* _tmp30_;
						GeeIterator* _tmp31_;
						if (!_tmp27_) {
							guint _tmp28_;
							_tmp28_ = i;
							i = _tmp28_ + 1;
						}
						_tmp27_ = FALSE;
						if (!(i < forks)) {
							break;
						}
						_tmp29_ = _result_;
						_tmp29__length1 = _result__length1;
						_tmp30_ = iself;
						_tmp31_ = gee_iterable_iterator (_tmp30_);
						_g_object_unref0 (_tmp29_[i]);
						_tmp29_[i] = _tmp31_;
					}
				}
			}
			_tmp32_ = _result_;
			_tmp32__length1 = _result__length1;
			if (result_length1) {
				*result_length1 = _tmp32__length1;
			}
			result = _tmp32_;
			block24_data_unref (_data24_);
			_data24_ = NULL;
			return result;
		} else {
			g_assert_not_reached ();
		}
	}
}

GeeIterator**
gee_traversable_tee (GeeTraversable* self,
                     guint forks,
                     gint* result_length1)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->tee) {
		return _iface_->tee (self, forks, result_length1);
	}
	return NULL;
}

/**
 * Returns the first element that matches a given condition
 *
 * @param pred Predicate to be called to check for matches
 * @return The first element that matches or null
 * @since 0.19.91
 */
static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		GeeTraversable* self;
		self = _data25_->self;
		((_data25_->_result_ == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (_data25_->_result_ = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (_data25_->_result_), NULL));
		(_data25_->pred_target_destroy_notify == NULL) ? NULL : (_data25_->pred_target_destroy_notify (_data25_->pred_target), NULL);
		_data25_->pred = NULL;
		_data25_->pred_target = NULL;
		_data25_->pred_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static gboolean
__lambda25_ (Block25Data* _data25_,
             gpointer item)
{
	GeeTraversable* self;
	gboolean result;
	self = _data25_->self;
	if (_data25_->pred (item, _data25_->pred_target)) {
		gpointer _tmp0_;
		_tmp0_ = ((item != NULL) && (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self) != NULL)) ? GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self) ((gpointer) item) : ((gpointer) item);
		((_data25_->_result_ == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (_data25_->_result_ = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (_data25_->_result_), NULL));
		_data25_->_result_ = _tmp0_;
		result = FALSE;
		((item == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
		return result;
	}
	result = TRUE;
	((item == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
	return result;
}

static gboolean
___lambda25__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda25_ (self, g);
	return result;
}

static gpointer
gee_traversable_real_first_match (GeeTraversable* self,
                                  GeePredicate pred,
                                  gpointer pred_target,
                                  GDestroyNotify pred_target_destroy_notify)
{
	Block25Data* _data25_;
	gpointer _tmp0_;
	gpointer result;
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	(_data25_->pred_target_destroy_notify == NULL) ? NULL : (_data25_->pred_target_destroy_notify (_data25_->pred_target), NULL);
	_data25_->pred = NULL;
	_data25_->pred_target = NULL;
	_data25_->pred_target_destroy_notify = NULL;
	_data25_->pred = pred;
	_data25_->pred_target = pred_target;
	_data25_->pred_target_destroy_notify = pred_target_destroy_notify;
	_data25_->_result_ = NULL;
	gee_traversable_foreach (self, ___lambda25__gee_forall_func, _data25_);
	_tmp0_ = _data25_->_result_;
	_data25_->_result_ = NULL;
	result = _tmp0_;
	block25_data_unref (_data25_);
	_data25_ = NULL;
	return result;
}

gpointer
gee_traversable_first_match (GeeTraversable* self,
                             GeePredicate pred,
                             gpointer pred_target,
                             GDestroyNotify pred_target_destroy_notify)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->first_match) {
		return _iface_->first_match (self, pred, pred_target, pred_target_destroy_notify);
	}
	return NULL;
}

/**
 * Returns whether any element matches the given predicate.
 *
 * This is similar to @first_match, with the difference that it
 * just returns whether there is a match or not, not the value
 * of the match.
 *
 * @param pred Predicate to be called to check for matches
 * @return Whether there was a match or not
 * @since 0.19.91
 */
static gboolean
gee_traversable_real_any_match (GeeTraversable* self,
                                GeePredicate pred,
                                gpointer pred_target,
                                GDestroyNotify pred_target_destroy_notify)
{
	GeePredicate _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	gpointer _tmp1_;
	gpointer _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	_tmp0_ = pred;
	_tmp0__target = pred_target;
	_tmp0__target_destroy_notify = pred_target_destroy_notify;
	pred = NULL;
	pred_target = NULL;
	pred_target_destroy_notify = NULL;
	_tmp1_ = gee_traversable_first_match (self, _tmp0_, _tmp0__target, _tmp0__target_destroy_notify);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	((_tmp2_ == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (_tmp2_ = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (_tmp2_), NULL));
	result = _tmp3_;
	(pred_target_destroy_notify == NULL) ? NULL : (pred_target_destroy_notify (pred_target), NULL);
	pred = NULL;
	pred_target = NULL;
	pred_target_destroy_notify = NULL;
	return result;
}

gboolean
gee_traversable_any_match (GeeTraversable* self,
                           GeePredicate pred,
                           gpointer pred_target,
                           GDestroyNotify pred_target_destroy_notify)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->any_match) {
		return _iface_->any_match (self, pred, pred_target, pred_target_destroy_notify);
	}
	return FALSE;
}

/**
 * Checks whether all elements match the given predicate.
 *
 * @param pred Predicate to be called to check for matches
 * @return Whether all elements match or not
 * @since 0.19.91
 */
static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		GeeTraversable* self;
		self = _data26_->self;
		(_data26_->pred_target_destroy_notify == NULL) ? NULL : (_data26_->pred_target_destroy_notify (_data26_->pred_target), NULL);
		_data26_->pred = NULL;
		_data26_->pred_target = NULL;
		_data26_->pred_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static gboolean
__lambda26_ (Block26Data* _data26_,
             gpointer item)
{
	GeeTraversable* self;
	gboolean result;
	self = _data26_->self;
	if (!_data26_->pred (item, _data26_->pred_target)) {
		_data26_->_result_ = FALSE;
		result = FALSE;
		((item == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
		return result;
	}
	result = TRUE;
	((item == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
	return result;
}

static gboolean
___lambda26__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda26_ (self, g);
	return result;
}

static gboolean
gee_traversable_real_all_match (GeeTraversable* self,
                                GeePredicate pred,
                                gpointer pred_target,
                                GDestroyNotify pred_target_destroy_notify)
{
	Block26Data* _data26_;
	gboolean result;
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	(_data26_->pred_target_destroy_notify == NULL) ? NULL : (_data26_->pred_target_destroy_notify (_data26_->pred_target), NULL);
	_data26_->pred = NULL;
	_data26_->pred_target = NULL;
	_data26_->pred_target_destroy_notify = NULL;
	_data26_->pred = pred;
	_data26_->pred_target = pred_target;
	_data26_->pred_target_destroy_notify = pred_target_destroy_notify;
	_data26_->_result_ = TRUE;
	gee_traversable_foreach (self, ___lambda26__gee_forall_func, _data26_);
	result = _data26_->_result_;
	block26_data_unref (_data26_);
	_data26_ = NULL;
	return result;
}

gboolean
gee_traversable_all_match (GeeTraversable* self,
                           GeePredicate pred,
                           gpointer pred_target,
                           GDestroyNotify pred_target_destroy_notify)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->all_match) {
		return _iface_->all_match (self, pred, pred_target, pred_target_destroy_notify);
	}
	return FALSE;
}

/**
 * Returns the item in the sequence that contains the max value
 * based on the given compare function.
 *
 * @param compare Function to be called for comparisons
 * @return The item containing the max value.
 * @since 0.19.91
 */
static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
	g_atomic_int_inc (&_data27_->_ref_count_);
	return _data27_;
}

static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
		GeeTraversable* self;
		self = _data27_->self;
		((_data27_->max_value == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (_data27_->max_value = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (_data27_->max_value), NULL));
		(_data27_->compare_target_destroy_notify == NULL) ? NULL : (_data27_->compare_target_destroy_notify (_data27_->compare_target), NULL);
		_data27_->compare = NULL;
		_data27_->compare_target = NULL;
		_data27_->compare_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block27Data, _data27_);
	}
}

static gboolean
__lambda27_ (Block27Data* _data27_,
             gpointer item)
{
	GeeTraversable* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data27_->self;
	if (_data27_->max_value == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _data27_->compare (_data27_->max_value, item, _data27_->compare_target) > 0;
	}
	if (_tmp0_) {
		gpointer _tmp1_;
		_tmp1_ = ((item != NULL) && (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self) != NULL)) ? GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self) ((gpointer) item) : ((gpointer) item);
		((_data27_->max_value == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (_data27_->max_value = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (_data27_->max_value), NULL));
		_data27_->max_value = _tmp1_;
	}
	result = TRUE;
	((item == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
	return result;
}

static gboolean
___lambda27__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda27_ (self, g);
	return result;
}

static gpointer
gee_traversable_real_max (GeeTraversable* self,
                          GCompareDataFunc compare,
                          gpointer compare_target,
                          GDestroyNotify compare_target_destroy_notify)
{
	Block27Data* _data27_;
	gpointer _tmp0_;
	gpointer result;
	_data27_ = g_slice_new0 (Block27Data);
	_data27_->_ref_count_ = 1;
	_data27_->self = g_object_ref (self);
	(_data27_->compare_target_destroy_notify == NULL) ? NULL : (_data27_->compare_target_destroy_notify (_data27_->compare_target), NULL);
	_data27_->compare = NULL;
	_data27_->compare_target = NULL;
	_data27_->compare_target_destroy_notify = NULL;
	_data27_->compare = compare;
	_data27_->compare_target = compare_target;
	_data27_->compare_target_destroy_notify = compare_target_destroy_notify;
	_data27_->max_value = NULL;
	gee_traversable_foreach (self, ___lambda27__gee_forall_func, _data27_);
	_tmp0_ = ((_data27_->max_value != NULL) && (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self) != NULL)) ? GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self) ((gpointer) _data27_->max_value) : ((gpointer) _data27_->max_value);
	result = _tmp0_;
	block27_data_unref (_data27_);
	_data27_ = NULL;
	return result;
}

gpointer
gee_traversable_max (GeeTraversable* self,
                     GCompareDataFunc compare,
                     gpointer compare_target,
                     GDestroyNotify compare_target_destroy_notify)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->max) {
		return _iface_->max (self, compare, compare_target, compare_target_destroy_notify);
	}
	return NULL;
}

/**
 * Returns the item in the sequence that contains the min value
 * based on the given compare function.
 *
 * @param compare Function to be called for comparisons
 * @return The item containing the min value.
 * @since 0.19.91
 */
static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		GeeTraversable* self;
		self = _data28_->self;
		((_data28_->min_value == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (_data28_->min_value = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (_data28_->min_value), NULL));
		(_data28_->compare_target_destroy_notify == NULL) ? NULL : (_data28_->compare_target_destroy_notify (_data28_->compare_target), NULL);
		_data28_->compare = NULL;
		_data28_->compare_target = NULL;
		_data28_->compare_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}

static gboolean
__lambda28_ (Block28Data* _data28_,
             gpointer item)
{
	GeeTraversable* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data28_->self;
	if (_data28_->min_value == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _data28_->compare (_data28_->min_value, item, _data28_->compare_target) < 0;
	}
	if (_tmp0_) {
		gpointer _tmp1_;
		_tmp1_ = ((item != NULL) && (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self) != NULL)) ? GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self) ((gpointer) item) : ((gpointer) item);
		((_data28_->min_value == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (_data28_->min_value = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (_data28_->min_value), NULL));
		_data28_->min_value = _tmp1_;
	}
	result = TRUE;
	((item == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
	return result;
}

static gboolean
___lambda28__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda28_ (self, g);
	return result;
}

static gpointer
gee_traversable_real_min (GeeTraversable* self,
                          GCompareDataFunc compare,
                          gpointer compare_target,
                          GDestroyNotify compare_target_destroy_notify)
{
	Block28Data* _data28_;
	gpointer _tmp0_;
	gpointer result;
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	(_data28_->compare_target_destroy_notify == NULL) ? NULL : (_data28_->compare_target_destroy_notify (_data28_->compare_target), NULL);
	_data28_->compare = NULL;
	_data28_->compare_target = NULL;
	_data28_->compare_target_destroy_notify = NULL;
	_data28_->compare = compare;
	_data28_->compare_target = compare_target;
	_data28_->compare_target_destroy_notify = compare_target_destroy_notify;
	_data28_->min_value = NULL;
	gee_traversable_foreach (self, ___lambda28__gee_forall_func, _data28_);
	_tmp0_ = ((_data28_->min_value != NULL) && (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self) != NULL)) ? GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self) ((gpointer) _data28_->min_value) : ((gpointer) _data28_->min_value);
	result = _tmp0_;
	block28_data_unref (_data28_);
	_data28_ = NULL;
	return result;
}

gpointer
gee_traversable_min (GeeTraversable* self,
                     GCompareDataFunc compare,
                     gpointer compare_target,
                     GDestroyNotify compare_target_destroy_notify)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->min) {
		return _iface_->min (self, compare, compare_target, compare_target_destroy_notify);
	}
	return NULL;
}

/**
 * Returns a new iterator containing the elements in the source
 * ordered as specified by the comparison function.
 *
 * @param compare Comparison function
 * @return A new iterator with the source elements sorted.
 * @since 0.19.91
 */
static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		GeeTraversable* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->_result_);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static gboolean
__lambda48_ (Block29Data* _data29_,
             gpointer item)
{
	GeeTraversable* self;
	gboolean result;
	self = _data29_->self;
	result = gee_abstract_collection_add ((GeeAbstractCollection*) _data29_->_result_, item);
	((item == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
	return result;
}

static gboolean
___lambda48__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda48_ (self, g);
	return result;
}

static GeeIterator*
gee_traversable_real_order_by (GeeTraversable* self,
                               GCompareDataFunc compare,
                               gpointer compare_target,
                               GDestroyNotify compare_target_destroy_notify)
{
	Block29Data* _data29_;
	GeeArrayList* _tmp0_;
	GCompareDataFunc _tmp1_;
	gpointer _tmp1__target;
	GDestroyNotify _tmp1__target_destroy_notify;
	GeeIterator* _tmp2_;
	GeeIterator* result;
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = gee_array_list_new (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), (GDestroyNotify) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), NULL, NULL, NULL);
	_data29_->_result_ = _tmp0_;
	gee_traversable_foreach (self, ___lambda48__gee_forall_func, _data29_);
	_tmp1_ = compare;
	_tmp1__target = compare_target;
	_tmp1__target_destroy_notify = compare_target_destroy_notify;
	compare = NULL;
	compare_target = NULL;
	compare_target_destroy_notify = NULL;
	gee_list_sort ((GeeList*) _data29_->_result_, _tmp1_, _tmp1__target, _tmp1__target_destroy_notify);
	_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data29_->_result_);
	result = _tmp2_;
	block29_data_unref (_data29_);
	_data29_ = NULL;
	(compare_target_destroy_notify == NULL) ? NULL : (compare_target_destroy_notify (compare_target), NULL);
	compare = NULL;
	compare_target = NULL;
	compare_target_destroy_notify = NULL;
	return result;
}

GeeIterator*
gee_traversable_order_by (GeeTraversable* self,
                          GCompareDataFunc compare,
                          gpointer compare_target,
                          GDestroyNotify compare_target_destroy_notify)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->order_by) {
		return _iface_->order_by (self, compare, compare_target, compare_target_destroy_notify);
	}
	return NULL;
}

GType
gee_traversable_get_element_type (GeeTraversable* self)
{
	GeeTraversableIface* _iface_;
	g_return_val_if_fail (self != NULL, 0UL);
	_iface_ = GEE_TRAVERSABLE_GET_INTERFACE (self);
	if (_iface_->get_element_type) {
		return _iface_->get_element_type (self);
	}
	return 0UL;
}

static GType
gee_traversable_real_get_element_type (GeeTraversable* base)
{
	GType result;
	GeeTraversable* self;
	self = base;
	result = GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self);
	return result;
}

static void
gee_traversable_default_init (GeeTraversableIface * iface,
                              gpointer iface_data)
{
	iface->stream = gee_traversable_real_stream;
	iface->fold = gee_traversable_real_fold;
	iface->map = gee_traversable_real_map;
	iface->scan = gee_traversable_real_scan;
	iface->filter = gee_traversable_real_filter;
	iface->chop = gee_traversable_real_chop;
	iface->flat_map = gee_traversable_real_flat_map;
	iface->tee = gee_traversable_real_tee;
	iface->first_match = gee_traversable_real_first_match;
	iface->any_match = gee_traversable_real_any_match;
	iface->all_match = gee_traversable_real_all_match;
	iface->max = gee_traversable_real_max;
	iface->min = gee_traversable_real_min;
	iface->order_by = gee_traversable_real_order_by;
	iface->get_element_type = gee_traversable_real_get_element_type;
}

/**
 * It's a common interface for {@link Iterator} and {@link Iterable}. It
 * provides a fast, high level functions.
 *
 * ''{@link Iterator} implementation:'' Please note that most of the functions
 * affect the state of the iterator by moving it forward.
 * Even if the iterator is {@link BidirIterator} it ''must not''
 * rewind the state.
 *
 * ''{@link Iterable} implementation:'' validy ({@link Iterator.valid})
 * of returned iterator is the same as for invalid
 * iterator. In other words the following code is semantically equivalent:
 *
 * {{{
 *     var x = iterable.function (args);
 *     var x = iterable.iterator ().function(args);
 * }}}
 *
 * @since 0.7.0
 */
static GType
gee_traversable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeTraversableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_traversable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gee_traversable_type_id;
	gee_traversable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeTraversable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gee_traversable_type_id, G_TYPE_OBJECT);
	return gee_traversable_type_id;
}

GType
gee_traversable_get_type (void)
{
	static volatile gsize gee_traversable_type_id__once = 0;
	if (g_once_init_enter (&gee_traversable_type_id__once)) {
		GType gee_traversable_type_id;
		gee_traversable_type_id = gee_traversable_get_type_once ();
		g_once_init_leave (&gee_traversable_type_id__once, gee_traversable_type_id);
	}
	return gee_traversable_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

