/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.AbstractWMSTileSource;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryPatterns;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.tools.Utils;

public class TemplatedWMSTileSource
extends AbstractWMSTileSource
implements TemplatedTileSource {
    private static final NumberFormat LATLON_FORMAT = new DecimalFormat("###0.0000000", new DecimalFormatSymbols(Locale.US));
    private final Set<String> serverProjections;
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private final String date;
    private final boolean belowWMS130;

    public TemplatedWMSTileSource(ImageryInfo info, Projection tileProjection) {
        super(info, tileProjection);
        this.serverProjections = new TreeSet<String>(info.getServerProjections());
        this.headers.putAll(info.getCustomHttpHeaders());
        this.date = info.getDate();
        this.baseUrl = ImageryPatterns.handleApiKeyTemplate(info.getId(), ImageryPatterns.handleHeaderTemplate(this.baseUrl, this.headers));
        this.initProjection();
        this.belowWMS130 = !this.baseUrl.toLowerCase(Locale.US).contains("crs=");
    }

    @Override
    public int getDefaultTileSize() {
        return WMSLayer.PROP_IMAGE_SIZE.get();
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        String myProjCode = this.getServerCRS();
        EastNorth nw = this.getTileEastNorth(tilex, tiley, zoom);
        EastNorth se = this.getTileEastNorth(tilex + 1, tiley + 1, zoom);
        double w = nw.getX();
        double n = nw.getY();
        double s = se.getY();
        double e = se.getX();
        if ("EPSG:4326".equals(myProjCode) && !this.serverProjections.contains(myProjCode) && this.serverProjections.contains("CRS:84")) {
            myProjCode = "CRS:84";
        }
        StringBuffer url = new StringBuffer(this.baseUrl.length());
        Matcher matcher = ImageryPatterns.PATTERN_PARAM.matcher(this.baseUrl);
        while (matcher.find()) {
            String replacement;
            switch (matcher.group(1)) {
                case "proj": {
                    replacement = myProjCode;
                    break;
                }
                case "wkid": {
                    replacement = myProjCode.startsWith("EPSG:") ? myProjCode.substring(5) : myProjCode;
                    break;
                }
                case "bbox": {
                    replacement = this.getBbox(zoom, tilex, tiley, !this.belowWMS130 && this.getTileProjection().switchXY());
                    break;
                }
                case "w": {
                    replacement = LATLON_FORMAT.format(w);
                    break;
                }
                case "s": {
                    replacement = LATLON_FORMAT.format(s);
                    break;
                }
                case "e": {
                    replacement = LATLON_FORMAT.format(e);
                    break;
                }
                case "n": {
                    replacement = LATLON_FORMAT.format(n);
                    break;
                }
                case "width": 
                case "height": {
                    replacement = String.valueOf(this.getTileSize());
                    break;
                }
                case "time": {
                    replacement = Utils.encodeUrl(this.date);
                    break;
                }
                default: {
                    replacement = '{' + matcher.group(1) + '}';
                }
            }
            matcher.appendReplacement(url, replacement);
        }
        matcher.appendTail(url);
        return url.toString().replace(" ", "%20");
    }

    @Override
    public String getTileId(int zoom, int tilex, int tiley) {
        return this.getTileUrl(zoom, tilex, tiley);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static void checkUrl(String url) {
        ImageryPatterns.checkWmsUrlPatterns(url);
    }
}

