# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
This is a wrapper for The CD Input and Control library (libcdio) which
encapsulates CD-ROM reading and control. Python programs wishing to be
oblivious of the OS- and device-dependent properties of a CD-ROM can
use this library.
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _pycdio
else:
    import _pycdio

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class imaxdiv_t(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    quot = property(_pycdio.imaxdiv_t_quot_get, _pycdio.imaxdiv_t_quot_set)
    rem = property(_pycdio.imaxdiv_t_rem_get, _pycdio.imaxdiv_t_rem_set)

    def __init__(self):
        r"""
        get_num_tracks(p_cdio)->int

        Return the number of tracks on the CD. 
        On error pycdio.INVALID_TRACK is returned.
        """
        _pycdio.imaxdiv_t_swiginit(self, _pycdio.new_imaxdiv_t())
    __swig_destroy__ = _pycdio.delete_imaxdiv_t

# Register imaxdiv_t in _pycdio:
_pycdio.imaxdiv_t_swigregister(imaxdiv_t)

def imaxabs(n):
    return _pycdio.imaxabs(n)

def imaxdiv(numer, denom):
    return _pycdio.imaxdiv(numer, denom)

def wcstoimax(nptr, endptr, base):
    return _pycdio.wcstoimax(nptr, endptr, base)

def wcstoumax(nptr, endptr, base):
    return _pycdio.wcstoumax(nptr, endptr, base)

def strtoimax(nptr, endptr, base):
    return _pycdio.strtoimax(nptr, endptr, base)

def strtoumax(nptr, endptr, base):
    return _pycdio.strtoumax(nptr, endptr, base)
VERSION_NUM = _pycdio.VERSION_NUM
INVALID_LBA = _pycdio.INVALID_LBA
INVALID_LSN = _pycdio.INVALID_LSN
CD_FRAMESIZE = _pycdio.CD_FRAMESIZE
CD_FRAMESIZE_RAW = _pycdio.CD_FRAMESIZE_RAW
ISO_BLOCKSIZE = _pycdio.ISO_BLOCKSIZE
M2F2_SECTOR_SIZE = _pycdio.M2F2_SECTOR_SIZE
M2RAW_SECTOR_SIZE = _pycdio.M2RAW_SECTOR_SIZE

def audio_pause(p_cdio):
    r"""
    audio_pause(cdio)->status

    Pause playing CD through analog output.
    """
    return _pycdio.audio_pause(p_cdio)

def audio_play_lsn(p_cdio, start_lsn, end_lsn):
    r"""
    auto_play_lsn(cdio, start_lsn, end_lsn)->status

    Playing CD through analog output at the given lsn to the ending lsn
    """
    return _pycdio.audio_play_lsn(p_cdio, start_lsn, end_lsn)

def audio_resume(p_cdio):
    r"""
    audio_resume(cdio)->status
    Resume playing an audio CD.
    """
    return _pycdio.audio_resume(p_cdio)

def audio_set_volume_levels(p_cdio, vol1, vol2, arg4, arg5):
    r"""
    audio_resume(cdio)->status
    Resume playing an audio CD.
    """
    return _pycdio.audio_set_volume_levels(p_cdio, vol1, vol2, arg4, arg5)

def audio_stop(p_cdio):
    r"""
    audio_stop(cdio)->status
    Stop playing an audio CD.
    """
    return _pycdio.audio_stop(p_cdio)
READ_MODE_AUDIO = _pycdio.READ_MODE_AUDIO
r"""return audio volume levels array"""
READ_MODE_M1F1 = _pycdio.READ_MODE_M1F1
r"""return audio volume levels array"""
READ_MODE_M1F2 = _pycdio.READ_MODE_M1F2
r"""return audio volume levels array"""
READ_MODE_M2F1 = _pycdio.READ_MODE_M2F1
r"""return audio volume levels array"""
READ_MODE_M2F2 = _pycdio.READ_MODE_M2F2
r"""return audio volume levels array"""

def lseek(*args):
    r"""
    lseek(cdio, offset, whence)->int
    Reposition read offset
    Similar to (if not the same as) libc's fseek()

    cdio is object to get adjested, offset is amount to seek and 
    whence is like corresponding parameter in libc's lseek, e.g. 
    it should be SEEK_SET or SEEK_END.

    the offset is returned or -1 on error.
    """
    return _pycdio.lseek(*args)

def read_cd(p_cdio, p_buf):
    r"""
    read_cd(cdio, size)->[size, data]

    Reads into buf the next size bytes.
    Similar to (if not the same as) libc's read()

    The number of reads read is returned. -1 is returned on error.
    """
    return _pycdio.read_cd(p_cdio, p_buf)

def read_sectors(p_cdio, p_buf, i_lsn, read_mode):
    r"""
    read_sectors(bytes, lsn, read_mode)->[size, data]
    Reads a number of sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.

    If read_mode is pycdio.MODE_AUDIO, the return buffer size will be
    truncated to multiple of pycdio.CDIO_FRAMESIZE_RAW i_blocks bytes.

    If read_mode is pycdio.MODE_DATA, buffer will be truncated to a
    multiple of pycdio.ISO_BLOCKSIZE, pycdio.M1RAW_SECTOR_SIZE or
    pycdio.M2F2_SECTOR_SIZE bytes depending on what mode the data is in.
    If read_mode is pycdio.CDIO_MODE_M2F1, buffer will be truncated to a 
    multiple of pycdio.M2RAW_SECTOR_SIZE bytes.

    If read_mode is CDIO_MODE_M2F2, the return buffer size will be
    truncated to a multiple of pycdio.CD_FRAMESIZE bytes.

    If size <= 0 an error has occurred.
    """
    return _pycdio.read_sectors(p_cdio, p_buf, i_lsn, read_mode)

def read_data_bytes(p_cdio, p_buf, i_lsn, i_blocksize):
    r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
    return _pycdio.read_data_bytes(p_cdio, p_buf, i_lsn, i_blocksize)
TRACK_FORMAT_AUDIO = _pycdio.TRACK_FORMAT_AUDIO
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
TRACK_FORMAT_CDI = _pycdio.TRACK_FORMAT_CDI
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
TRACK_FORMAT_XA = _pycdio.TRACK_FORMAT_XA
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
TRACK_FORMAT_DATA = _pycdio.TRACK_FORMAT_DATA
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
TRACK_FORMAT_PSX = _pycdio.TRACK_FORMAT_PSX
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
CDIO_TRACK_FLAG_FALSE = _pycdio.CDIO_TRACK_FLAG_FALSE
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
CDIO_TRACK_FLAG_TRUE = _pycdio.CDIO_TRACK_FLAG_TRUE
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
CDIO_TRACK_FLAG_ERROR = _pycdio.CDIO_TRACK_FLAG_ERROR
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
CDIO_TRACK_FLAG_UNKNOWN = _pycdio.CDIO_TRACK_FLAG_UNKNOWN
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
CDIO_CDROM_LBA = _pycdio.CDIO_CDROM_LBA
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
CDIO_CDROM_MSF = _pycdio.CDIO_CDROM_MSF
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
CDIO_CDROM_DATA_TRACK = _pycdio.CDIO_CDROM_DATA_TRACK
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
CDIO_CDROM_CDI_TRACK = _pycdio.CDIO_CDROM_CDI_TRACK
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
CDIO_CDROM_XA_TRACK = _pycdio.CDIO_CDROM_XA_TRACK
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
AUDIO = _pycdio.AUDIO
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
MODE1 = _pycdio.MODE1
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
MODE1_RAW = _pycdio.MODE1_RAW
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
MODE2 = _pycdio.MODE2
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
MODE2_FORM1 = _pycdio.MODE2_FORM1
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
MODE2_FORM2 = _pycdio.MODE2_FORM2
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
MODE2_FORM_MIX = _pycdio.MODE2_FORM_MIX
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
MODE2_RAW = _pycdio.MODE2_RAW
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
INVALID_TRACK = _pycdio.INVALID_TRACK
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """
CDROM_LEADOUT_TRACK = _pycdio.CDROM_LEADOUT_TRACK
r"""
    read_data_bytes(lsn, bytes)

    Reads a number of data sectors (AKA blocks).

    lsn is sector to read, bytes is the number of bytes.
    If you don't know whether you have a Mode 1/2, 
    Form 1/ Form 2/Formless sector best to reserve space for the maximum
    which is pycdio.M2RAW_SECTOR_SIZE.

    If size <= 0 an error has occurred.
    """

def get_first_track_num(p_cdio):
    r"""
    get_first_track_num(p_cdio) -> int
    Get the number of the first track.

    return the track number or pycdio.INVALID_TRACK if there was
    a problem.
    """
    return _pycdio.get_first_track_num(p_cdio)

def get_last_track_num(p_cdio):
    r"""
    get_last_track_num
    Return the last track number.
    pycdio.INVALID_TRACK is if there was a problem.
    """
    return _pycdio.get_last_track_num(p_cdio)

def get_track(p_cdio, lsn):
    r"""
    cdio_get_track(lsn)->int

        Find the track which contains lsn.
        pycdio.INVALID_TRACK is returned if the lsn outside of the CD or
        if there was some error.

        If the lsn is before the pregap of the first track, 0 is returned.
        Otherwise we return the track that spans the lsn.
    """
    return _pycdio.get_track(p_cdio, lsn)

def get_track_channels(p_cdio, i_track):
    r"""
    get_track_channels(cdio, track)->int

    Return number of channels in track: 2 or 4; -2 if implemented or -1
    for error.  Not meaningful if track is not an audio track.
    """
    return _pycdio.get_track_channels(p_cdio, i_track)

def get_track_copy_permit(p_cdio, i_track):
    r"""
    get_copy_permit(cdio, track)->int

    Return copy protection status on a track. Is this meaningful
    not an audio track?

    """
    return _pycdio.get_track_copy_permit(p_cdio, i_track)

def get_track_format(p_cdio, i_track):
    r"""
    get_track_format(cdio, track)->format

    Get the format (audio, mode2, mode1) of track. 
    """
    return _pycdio.get_track_format(p_cdio, i_track)

def is_track_green(p_cdio, i_track):
    r"""
    is_track_green(cdio, track) -> bool

    Return True if we have XA data (green, mode2 form1) or
    XA data (green, mode2 form2). That is track begins:
     sync - header - subheader
    12     4      -  8

    FIXME: there's gotta be a better design for this and get_track_format?
    """
    return _pycdio.is_track_green(p_cdio, i_track)

def get_track_last_lsn(p_cdio, i_track):
    r"""
    cdio_get_track_last_lsn(cdio, track)->lsn

    Return the ending LSN for track number
    track in cdio.  CDIO_INVALID_LSN is returned on error.
    """
    return _pycdio.get_track_last_lsn(p_cdio, i_track)

def get_track_isrc(p_cdio, i_track):
    r"""
    cdio_get_track_isrc(cdio, track)->string

    Return the International Standard Recording Code (ISRC)
    for track number i_track in p_cdio. Track numbers start at 1.
    """
    return _pycdio.get_track_isrc(p_cdio, i_track)

def get_track_lba(p_cdio, i_track):
    r"""
    cdio_get_track_lba
        Get the starting LBA for track number
        i_track in p_cdio.  Track numbers usually start at something
        greater than 0, usually 1.

        The 'leadout' track is specified either by
        using i_track CDIO_CDROM_LEADOUT_TRACK or the total tracks+1.

        @param p_cdio object to get information from
        @param i_track  the track number we want the LSN for
        @return the starting LBA or CDIO_INVALID_LBA on error.
    """
    return _pycdio.get_track_lba(p_cdio, i_track)

def get_track_lsn(p_cdio, i_track):
    r"""
    cdio_get_track_lsn (cdio, track)->int

    Return the starting LSN for track number.
    Track numbers usually start at something greater than 0, usually 1.

    The 'leadout' track is specified either by
    using i_track pycdio.CDROM_LEADOUT_TRACK or the total tracks+1.

    pycdio.INVALID_LSN is returned on error.
    """
    return _pycdio.get_track_lsn(p_cdio, i_track)

def get_track_msf(p_cdio, i_track):
    r"""
    get_track_msf(cdio,track)->string

      Return the starting MSF (minutes/secs/frames) for track number
      track.  Track numbers usually start at something
      greater than 0, usually 1.

      The 'leadout' track is specified either by
      using i_track CDIO_CDROM_LEADOUT_TRACK or the total tracks+1.

    @return string mm:ss:ff if all good, or string 'error' on error.
    """
    return _pycdio.get_track_msf(p_cdio, i_track)

def get_track_preemphasis(p_cdio, i_track):
    r"""
    cdio_get_track_preemphasis(cdio, track)

    Get linear preemphasis status on an audio track.
    This is not meaningful if not an audio track?
    """
    return _pycdio.get_track_preemphasis(p_cdio, i_track)

def get_track_sec_count(p_cdio, i_track):
    r"""
    get_track_sec_count(cdio, track)->int

    Get the number of sectors between this track an the next.  This
    includes any pregap sectors before the start of the next track.
    Track numbers usually start at something
    greater than 0, usually 1.

    0 is returned if there is an error.
    """
    return _pycdio.get_track_sec_count(p_cdio, i_track)
CDTEXT_ARRANGER = _pycdio.CDTEXT_ARRANGER

CDTEXT_COMPOSER = _pycdio.CDTEXT_COMPOSER

CDTEXT_DISCID = _pycdio.CDTEXT_DISCID

CDTEXT_ISRC = _pycdio.CDTEXT_ISRC

CDTEXT_MESSAGE = _pycdio.CDTEXT_MESSAGE

CDTEXT_PERFORMER = _pycdio.CDTEXT_PERFORMER

CDTEXT_FIELD_TITLE = _pycdio.CDTEXT_FIELD_TITLE

CDTEXT_FIELD_SONGWRITER = _pycdio.CDTEXT_FIELD_SONGWRITER

CDTEXT_FIELD_UPC_EAN = _pycdio.CDTEXT_FIELD_UPC_EAN

CDTEXT_GENRE = _pycdio.CDTEXT_GENRE

CDTEXT_FIELD_INVALID = _pycdio.CDTEXT_FIELD_INVALID

CDTEXT_GENRE_UNUSED = _pycdio.CDTEXT_GENRE_UNUSED

CDTEXT_GENRE_UNDEFINED = _pycdio.CDTEXT_GENRE_UNDEFINED

CDTEXT_GENRE_ADULT_CONTEMP = _pycdio.CDTEXT_GENRE_ADULT_CONTEMP

CDTEXT_GENRE_ALT_ROCK = _pycdio.CDTEXT_GENRE_ALT_ROCK

CDTEXT_GENRE_CHILDRENS = _pycdio.CDTEXT_GENRE_CHILDRENS

CDTEXT_GENRE_CLASSIC = _pycdio.CDTEXT_GENRE_CLASSIC

CDTEXT_GENRE_CHRIST_CONTEMP = _pycdio.CDTEXT_GENRE_CHRIST_CONTEMP

CDTEXT_GENRE_COUNTRY = _pycdio.CDTEXT_GENRE_COUNTRY

CDTEXT_GENRE_DANCE = _pycdio.CDTEXT_GENRE_DANCE

CDTEXT_GENRE_EASY_LISTENING = _pycdio.CDTEXT_GENRE_EASY_LISTENING

CDTEXT_GENRE_EROTIC = _pycdio.CDTEXT_GENRE_EROTIC

CDTEXT_GENRE_FOLK = _pycdio.CDTEXT_GENRE_FOLK

CDTEXT_GENRE_GOSPEL = _pycdio.CDTEXT_GENRE_GOSPEL

CDTEXT_GENRE_HIPHOP = _pycdio.CDTEXT_GENRE_HIPHOP

CDTEXT_GENRE_JAZZ = _pycdio.CDTEXT_GENRE_JAZZ

CDTEXT_GENRE_LATIN = _pycdio.CDTEXT_GENRE_LATIN

CDTEXT_GENRE_MUSICAL = _pycdio.CDTEXT_GENRE_MUSICAL

CDTEXT_GENRE_NEWAGE = _pycdio.CDTEXT_GENRE_NEWAGE

CDTEXT_GENRE_OPERA = _pycdio.CDTEXT_GENRE_OPERA

CDTEXT_GENRE_OPERETTA = _pycdio.CDTEXT_GENRE_OPERETTA

CDTEXT_GENRE_POP = _pycdio.CDTEXT_GENRE_POP

CDTEXT_GENRE_RAP = _pycdio.CDTEXT_GENRE_RAP

CDTEXT_GENRE_REGGAE = _pycdio.CDTEXT_GENRE_REGGAE

CDTEXT_GENRE_ROCK = _pycdio.CDTEXT_GENRE_ROCK

CDTEXT_GENRE_RYTHMANDBLUES = _pycdio.CDTEXT_GENRE_RYTHMANDBLUES

CDTEXT_GENRE_SOUNDEFFECTS = _pycdio.CDTEXT_GENRE_SOUNDEFFECTS

CDTEXT_GENRE_SOUNDTRACK = _pycdio.CDTEXT_GENRE_SOUNDTRACK

CDTEXT_GENRE_SPOKEN_WORD = _pycdio.CDTEXT_GENRE_SPOKEN_WORD

CDTEXT_GENRE_WORLD_MUSIC = _pycdio.CDTEXT_GENRE_WORLD_MUSIC

CDTEXT_LANGUAGE_UNKNOWN = _pycdio.CDTEXT_LANGUAGE_UNKNOWN

CDTEXT_LANGUAGE_ALBANIAN = _pycdio.CDTEXT_LANGUAGE_ALBANIAN

CDTEXT_LANGUAGE_BRETON = _pycdio.CDTEXT_LANGUAGE_BRETON

CDTEXT_LANGUAGE_CATALAN = _pycdio.CDTEXT_LANGUAGE_CATALAN

CDTEXT_LANGUAGE_CROATIAN = _pycdio.CDTEXT_LANGUAGE_CROATIAN

CDTEXT_LANGUAGE_WELSH = _pycdio.CDTEXT_LANGUAGE_WELSH

CDTEXT_LANGUAGE_CZECH = _pycdio.CDTEXT_LANGUAGE_CZECH

CDTEXT_LANGUAGE_DANISH = _pycdio.CDTEXT_LANGUAGE_DANISH

CDTEXT_LANGUAGE_GERMAN = _pycdio.CDTEXT_LANGUAGE_GERMAN

CDTEXT_LANGUAGE_ENGLISH = _pycdio.CDTEXT_LANGUAGE_ENGLISH

CDTEXT_LANGUAGE_SPANISH = _pycdio.CDTEXT_LANGUAGE_SPANISH

CDTEXT_LANGUAGE_ESPERANTO = _pycdio.CDTEXT_LANGUAGE_ESPERANTO

CDTEXT_LANGUAGE_ESTONIAN = _pycdio.CDTEXT_LANGUAGE_ESTONIAN

CDTEXT_LANGUAGE_BASQUE = _pycdio.CDTEXT_LANGUAGE_BASQUE

CDTEXT_LANGUAGE_FAROESE = _pycdio.CDTEXT_LANGUAGE_FAROESE

CDTEXT_LANGUAGE_FRENCH = _pycdio.CDTEXT_LANGUAGE_FRENCH

CDTEXT_LANGUAGE_FRISIAN = _pycdio.CDTEXT_LANGUAGE_FRISIAN

CDTEXT_LANGUAGE_IRISH = _pycdio.CDTEXT_LANGUAGE_IRISH

CDTEXT_LANGUAGE_GAELIC = _pycdio.CDTEXT_LANGUAGE_GAELIC

CDTEXT_LANGUAGE_GALICIAN = _pycdio.CDTEXT_LANGUAGE_GALICIAN

CDTEXT_LANGUAGE_ICELANDIC = _pycdio.CDTEXT_LANGUAGE_ICELANDIC

CDTEXT_LANGUAGE_ITALIAN = _pycdio.CDTEXT_LANGUAGE_ITALIAN

CDTEXT_LANGUAGE_LAPPISH = _pycdio.CDTEXT_LANGUAGE_LAPPISH

CDTEXT_LANGUAGE_LATIN = _pycdio.CDTEXT_LANGUAGE_LATIN

CDTEXT_LANGUAGE_LATVIAN = _pycdio.CDTEXT_LANGUAGE_LATVIAN

CDTEXT_LANGUAGE_LUXEMBOURGIAN = _pycdio.CDTEXT_LANGUAGE_LUXEMBOURGIAN

CDTEXT_LANGUAGE_LITHUANIAN = _pycdio.CDTEXT_LANGUAGE_LITHUANIAN

CDTEXT_LANGUAGE_HUNGARIAN = _pycdio.CDTEXT_LANGUAGE_HUNGARIAN

CDTEXT_LANGUAGE_MALTESE = _pycdio.CDTEXT_LANGUAGE_MALTESE

CDTEXT_LANGUAGE_DUTCH = _pycdio.CDTEXT_LANGUAGE_DUTCH

CDTEXT_LANGUAGE_NORWEGIAN = _pycdio.CDTEXT_LANGUAGE_NORWEGIAN

CDTEXT_LANGUAGE_OCCITAN = _pycdio.CDTEXT_LANGUAGE_OCCITAN

CDTEXT_LANGUAGE_POLISH = _pycdio.CDTEXT_LANGUAGE_POLISH

CDTEXT_LANGUAGE_PORTUGUESE = _pycdio.CDTEXT_LANGUAGE_PORTUGUESE

CDTEXT_LANGUAGE_ROMANIAN = _pycdio.CDTEXT_LANGUAGE_ROMANIAN

CDTEXT_LANGUAGE_ROMANSH = _pycdio.CDTEXT_LANGUAGE_ROMANSH

CDTEXT_LANGUAGE_SERBIAN = _pycdio.CDTEXT_LANGUAGE_SERBIAN

CDTEXT_LANGUAGE_SLOVAK = _pycdio.CDTEXT_LANGUAGE_SLOVAK

CDTEXT_LANGUAGE_SLOVENIAN = _pycdio.CDTEXT_LANGUAGE_SLOVENIAN

CDTEXT_LANGUAGE_FINNISH = _pycdio.CDTEXT_LANGUAGE_FINNISH

CDTEXT_LANGUAGE_SWEDISH = _pycdio.CDTEXT_LANGUAGE_SWEDISH

CDTEXT_LANGUAGE_TURKISH = _pycdio.CDTEXT_LANGUAGE_TURKISH

CDTEXT_LANGUAGE_FLEMISH = _pycdio.CDTEXT_LANGUAGE_FLEMISH

CDTEXT_LANGUAGE_WALLON = _pycdio.CDTEXT_LANGUAGE_WALLON

CDTEXT_LANGUAGE_ZULU = _pycdio.CDTEXT_LANGUAGE_ZULU

CDTEXT_LANGUAGE_VIETNAMESE = _pycdio.CDTEXT_LANGUAGE_VIETNAMESE

CDTEXT_LANGUAGE_UZBEK = _pycdio.CDTEXT_LANGUAGE_UZBEK

CDTEXT_LANGUAGE_URDU = _pycdio.CDTEXT_LANGUAGE_URDU

CDTEXT_LANGUAGE_UKRAINIAN = _pycdio.CDTEXT_LANGUAGE_UKRAINIAN

CDTEXT_LANGUAGE_THAI = _pycdio.CDTEXT_LANGUAGE_THAI

CDTEXT_LANGUAGE_TELUGU = _pycdio.CDTEXT_LANGUAGE_TELUGU

CDTEXT_LANGUAGE_TATAR = _pycdio.CDTEXT_LANGUAGE_TATAR

CDTEXT_LANGUAGE_TAMIL = _pycdio.CDTEXT_LANGUAGE_TAMIL

CDTEXT_LANGUAGE_TADZHIK = _pycdio.CDTEXT_LANGUAGE_TADZHIK

CDTEXT_LANGUAGE_SWAHILI = _pycdio.CDTEXT_LANGUAGE_SWAHILI

CDTEXT_LANGUAGE_SRANANTONGO = _pycdio.CDTEXT_LANGUAGE_SRANANTONGO

CDTEXT_LANGUAGE_SOMALI = _pycdio.CDTEXT_LANGUAGE_SOMALI

CDTEXT_LANGUAGE_SINHALESE = _pycdio.CDTEXT_LANGUAGE_SINHALESE

CDTEXT_LANGUAGE_SHONA = _pycdio.CDTEXT_LANGUAGE_SHONA

CDTEXT_LANGUAGE_SERBO_CROAT = _pycdio.CDTEXT_LANGUAGE_SERBO_CROAT

CDTEXT_LANGUAGE_RUTHENIAN = _pycdio.CDTEXT_LANGUAGE_RUTHENIAN

CDTEXT_LANGUAGE_RUSSIAN = _pycdio.CDTEXT_LANGUAGE_RUSSIAN

CDTEXT_LANGUAGE_QUECHUA = _pycdio.CDTEXT_LANGUAGE_QUECHUA

CDTEXT_LANGUAGE_PUSHTU = _pycdio.CDTEXT_LANGUAGE_PUSHTU

CDTEXT_LANGUAGE_PUNJABI = _pycdio.CDTEXT_LANGUAGE_PUNJABI

CDTEXT_LANGUAGE_PERSIAN = _pycdio.CDTEXT_LANGUAGE_PERSIAN

CDTEXT_LANGUAGE_PAPAMIENTO = _pycdio.CDTEXT_LANGUAGE_PAPAMIENTO

CDTEXT_LANGUAGE_ORIYA = _pycdio.CDTEXT_LANGUAGE_ORIYA

CDTEXT_LANGUAGE_NEPALI = _pycdio.CDTEXT_LANGUAGE_NEPALI

CDTEXT_LANGUAGE_NDEBELE = _pycdio.CDTEXT_LANGUAGE_NDEBELE

CDTEXT_LANGUAGE_MARATHI = _pycdio.CDTEXT_LANGUAGE_MARATHI

CDTEXT_LANGUAGE_MOLDAVIAN = _pycdio.CDTEXT_LANGUAGE_MOLDAVIAN

CDTEXT_LANGUAGE_MALAYSIAN = _pycdio.CDTEXT_LANGUAGE_MALAYSIAN

CDTEXT_LANGUAGE_MALAGASAY = _pycdio.CDTEXT_LANGUAGE_MALAGASAY

CDTEXT_LANGUAGE_MACEDONIAN = _pycdio.CDTEXT_LANGUAGE_MACEDONIAN

CDTEXT_LANGUAGE_LAOTIAN = _pycdio.CDTEXT_LANGUAGE_LAOTIAN

CDTEXT_LANGUAGE_KOREAN = _pycdio.CDTEXT_LANGUAGE_KOREAN

CDTEXT_LANGUAGE_KHMER = _pycdio.CDTEXT_LANGUAGE_KHMER

CDTEXT_LANGUAGE_KAZAKH = _pycdio.CDTEXT_LANGUAGE_KAZAKH

CDTEXT_LANGUAGE_KANNADA = _pycdio.CDTEXT_LANGUAGE_KANNADA

CDTEXT_LANGUAGE_JAPANESE = _pycdio.CDTEXT_LANGUAGE_JAPANESE

CDTEXT_LANGUAGE_INDONESIAN = _pycdio.CDTEXT_LANGUAGE_INDONESIAN

CDTEXT_LANGUAGE_HINDI = _pycdio.CDTEXT_LANGUAGE_HINDI

CDTEXT_LANGUAGE_HEBREW = _pycdio.CDTEXT_LANGUAGE_HEBREW

CDTEXT_LANGUAGE_HAUSA = _pycdio.CDTEXT_LANGUAGE_HAUSA

CDTEXT_LANGUAGE_GURANI = _pycdio.CDTEXT_LANGUAGE_GURANI

CDTEXT_LANGUAGE_GUJURATI = _pycdio.CDTEXT_LANGUAGE_GUJURATI

CDTEXT_LANGUAGE_GREEK = _pycdio.CDTEXT_LANGUAGE_GREEK

CDTEXT_LANGUAGE_GEORGIAN = _pycdio.CDTEXT_LANGUAGE_GEORGIAN

CDTEXT_LANGUAGE_FULANI = _pycdio.CDTEXT_LANGUAGE_FULANI

CDTEXT_LANGUAGE_DARI = _pycdio.CDTEXT_LANGUAGE_DARI

CDTEXT_LANGUAGE_CHURASH = _pycdio.CDTEXT_LANGUAGE_CHURASH

CDTEXT_LANGUAGE_CHINESE = _pycdio.CDTEXT_LANGUAGE_CHINESE

CDTEXT_LANGUAGE_BURMESE = _pycdio.CDTEXT_LANGUAGE_BURMESE

CDTEXT_LANGUAGE_BULGARIAN = _pycdio.CDTEXT_LANGUAGE_BULGARIAN

CDTEXT_LANGUAGE_BENGALI = _pycdio.CDTEXT_LANGUAGE_BENGALI

CDTEXT_LANGUAGE_BIELORUSSIAN = _pycdio.CDTEXT_LANGUAGE_BIELORUSSIAN

CDTEXT_LANGUAGE_BAMBORA = _pycdio.CDTEXT_LANGUAGE_BAMBORA

CDTEXT_LANGUAGE_AZERBAIJANI = _pycdio.CDTEXT_LANGUAGE_AZERBAIJANI

CDTEXT_LANGUAGE_ASSAMESE = _pycdio.CDTEXT_LANGUAGE_ASSAMESE

CDTEXT_LANGUAGE_ARMENIAN = _pycdio.CDTEXT_LANGUAGE_ARMENIAN

CDTEXT_LANGUAGE_ARABIC = _pycdio.CDTEXT_LANGUAGE_ARABIC

CDTEXT_LANGUAGE_AMHARIC = _pycdio.CDTEXT_LANGUAGE_AMHARIC

CDTEXT_LANGUAGE_INVALID = _pycdio.CDTEXT_LANGUAGE_INVALID

CDTEXT_LANGUAGE_BLOCK_UNUSED = _pycdio.CDTEXT_LANGUAGE_BLOCK_UNUSED

MIN_CDTEXT_FIELD = _pycdio.MIN_CDTEXT_FIELD

MAX_CDTEXT_FIELDS = _pycdio.MAX_CDTEXT_FIELDS


def cdtext_field2str(i):
    r"""cdtext_field2str(cdtext_field_t i) -> char const *"""
    return _pycdio.cdtext_field2str(i)

def cdtext_lang2str(i):
    r"""cdtext_lang2str(cdtext_lang_t i) -> char const *"""
    return _pycdio.cdtext_lang2str(i)

def cdtext_genre2str(i):
    r"""cdtext_genre2str(cdtext_genre_t i) -> char const *"""
    return _pycdio.cdtext_genre2str(i)

def cdtext_init():
    r"""cdtext_init() -> cdtext_t *"""
    return _pycdio.cdtext_init()

def cdtext_destroy(p_cdtext):
    r"""cdtext_destroy(cdtext_t * p_cdtext)"""
    return _pycdio.cdtext_destroy(p_cdtext)

def cdtext_get(p_cdtext, key, track):
    r"""cdtext_get(cdtext_t const * p_cdtext, cdtext_field_t key, track_t track) -> char *"""
    return _pycdio.cdtext_get(p_cdtext, key, track)

def cdtext_get_const(p_cdtext, key, track):
    r"""cdtext_get_const(cdtext_t const * p_cdtext, cdtext_field_t key, track_t track) -> char const *"""
    return _pycdio.cdtext_get_const(p_cdtext, key, track)

def cdtext_get_language(p_cdtext):
    r"""cdtext_get_language(cdtext_t const * p_cdtext) -> cdtext_lang_t"""
    return _pycdio.cdtext_get_language(p_cdtext)

def cdtext_select_language(p_cdtext, lang):
    r"""cdtext_select_language(cdtext_t * p_cdtext, cdtext_lang_t lang) -> bool"""
    return _pycdio.cdtext_select_language(p_cdtext, lang)

def cdtext_list_languages(p_cdtext):
    r"""cdtext_list_languages(cdtext_t const * p_cdtext) -> cdtext_lang_t *"""
    return _pycdio.cdtext_list_languages(p_cdtext)

def cdtext_list_languages_v2(p_cdtext):
    r"""cdtext_list_languages_v2(cdtext_t const * p_cdtext) -> cdtext_lang_t *"""
    return _pycdio.cdtext_list_languages_v2(p_cdtext)

def cdtext_set(p_cdtext, key, value, track, charset):
    r"""cdtext_set(cdtext_t * p_cdtext, cdtext_field_t key, uint8_t const * value, track_t track, char const * charset)"""
    return _pycdio.cdtext_set(p_cdtext, key, value, track, charset)

def get_cdtext(p_cdio):
    r"""get_cdtext(CdIo_t * p_cdio) -> cdtext_t *"""
    return _pycdio.get_cdtext(p_cdio)
DRIVE_CAP_ERROR = _pycdio.DRIVE_CAP_ERROR

DRIVE_CAP_UNKNOWN = _pycdio.DRIVE_CAP_UNKNOWN

DRIVE_CAP_MISC_CLOSE_TRAY = _pycdio.DRIVE_CAP_MISC_CLOSE_TRAY

DRIVE_CAP_MISC_EJECT = _pycdio.DRIVE_CAP_MISC_EJECT

DRIVE_CAP_MISC_LOCK = _pycdio.DRIVE_CAP_MISC_LOCK

DRIVE_CAP_MISC_SELECT_SPEED = _pycdio.DRIVE_CAP_MISC_SELECT_SPEED

DRIVE_CAP_MISC_SELECT_DISC = _pycdio.DRIVE_CAP_MISC_SELECT_DISC

DRIVE_CAP_MISC_MULTI_SESSION = _pycdio.DRIVE_CAP_MISC_MULTI_SESSION

DRIVE_CAP_MISC_MEDIA_CHANGED = _pycdio.DRIVE_CAP_MISC_MEDIA_CHANGED

DRIVE_CAP_MISC_RESET = _pycdio.DRIVE_CAP_MISC_RESET

DRIVE_CAP_MISC_FILE = _pycdio.DRIVE_CAP_MISC_FILE

DRIVE_CAP_READ_AUDIO = _pycdio.DRIVE_CAP_READ_AUDIO

DRIVE_CAP_READ_CD_DA = _pycdio.DRIVE_CAP_READ_CD_DA

DRIVE_CAP_READ_CD_G = _pycdio.DRIVE_CAP_READ_CD_G

DRIVE_CAP_READ_CD_R = _pycdio.DRIVE_CAP_READ_CD_R

DRIVE_CAP_READ_CD_RW = _pycdio.DRIVE_CAP_READ_CD_RW

DRIVE_CAP_READ_DVD_R = _pycdio.DRIVE_CAP_READ_DVD_R

DRIVE_CAP_READ_DVD_PR = _pycdio.DRIVE_CAP_READ_DVD_PR

DRIVE_CAP_READ_DVD_RAM = _pycdio.DRIVE_CAP_READ_DVD_RAM

DRIVE_CAP_READ_DVD_ROM = _pycdio.DRIVE_CAP_READ_DVD_ROM

DRIVE_CAP_READ_DVD_RW = _pycdio.DRIVE_CAP_READ_DVD_RW

DRIVE_CAP_READ_DVD_RPW = _pycdio.DRIVE_CAP_READ_DVD_RPW

DRIVE_CAP_READ_C2_ERRS = _pycdio.DRIVE_CAP_READ_C2_ERRS

DRIVE_CAP_READ_MODE2_FORM1 = _pycdio.DRIVE_CAP_READ_MODE2_FORM1

DRIVE_CAP_READ_MODE2_FORM2 = _pycdio.DRIVE_CAP_READ_MODE2_FORM2

DRIVE_CAP_READ_MCN = _pycdio.DRIVE_CAP_READ_MCN

DRIVE_CAP_READ_ISRC = _pycdio.DRIVE_CAP_READ_ISRC

DRIVE_CAP_WRITE_CD_R = _pycdio.DRIVE_CAP_WRITE_CD_R

DRIVE_CAP_WRITE_CD_RW = _pycdio.DRIVE_CAP_WRITE_CD_RW

DRIVE_CAP_WRITE_DVD_R = _pycdio.DRIVE_CAP_WRITE_DVD_R

DRIVE_CAP_WRITE_DVD_PR = _pycdio.DRIVE_CAP_WRITE_DVD_PR

DRIVE_CAP_WRITE_DVD_RAM = _pycdio.DRIVE_CAP_WRITE_DVD_RAM

DRIVE_CAP_WRITE_DVD_RW = _pycdio.DRIVE_CAP_WRITE_DVD_RW

DRIVE_CAP_WRITE_DVD_RPW = _pycdio.DRIVE_CAP_WRITE_DVD_RPW

DRIVE_CAP_WRITE_MT_RAINIER = _pycdio.DRIVE_CAP_WRITE_MT_RAINIER

DRIVE_CAP_WRITE_BURN_PROOF = _pycdio.DRIVE_CAP_WRITE_BURN_PROOF

DRIVE_CAP_WRITE_CD = _pycdio.DRIVE_CAP_WRITE_CD

DRIVE_CAP_WRITE_DVD = _pycdio.DRIVE_CAP_WRITE_DVD

DRIVE_CAP_WRITE = _pycdio.DRIVE_CAP_WRITE

MMC_HW_VENDOR_LEN = _pycdio.MMC_HW_VENDOR_LEN

MMC_HW_MODEL_LEN = _pycdio.MMC_HW_MODEL_LEN

MMC_HW_REVISION_LEN = _pycdio.MMC_HW_REVISION_LEN

SRC_IS_DISK_IMAGE_MASK = _pycdio.SRC_IS_DISK_IMAGE_MASK

SRC_IS_DEVICE_MASK = _pycdio.SRC_IS_DEVICE_MASK

SRC_IS_SCSI_MASK = _pycdio.SRC_IS_SCSI_MASK

SRC_IS_NATIVE_MASK = _pycdio.SRC_IS_NATIVE_MASK

DRIVER_UNKNOWN = _pycdio.DRIVER_UNKNOWN

DRIVER_AIX = _pycdio.DRIVER_AIX

DRIVER_FREEBSD = _pycdio.DRIVER_FREEBSD

DRIVER_LINUX = _pycdio.DRIVER_LINUX

DRIVER_SOLARIS = _pycdio.DRIVER_SOLARIS

DRIVER_OSX = _pycdio.DRIVER_OSX

DRIVER_NETBSD = _pycdio.DRIVER_NETBSD

DRIVER_WIN32 = _pycdio.DRIVER_WIN32

DRIVER_CDRDAO = _pycdio.DRIVER_CDRDAO

DRIVER_BINCUE = _pycdio.DRIVER_BINCUE

DRIVER_NRG = _pycdio.DRIVER_NRG

DRIVER_DEVICE = _pycdio.DRIVER_DEVICE

DRIVER_OP_SUCCESS = _pycdio.DRIVER_OP_SUCCESS

DRIVER_OP_ERROR = _pycdio.DRIVER_OP_ERROR

DRIVER_OP_UNSUPPORTED = _pycdio.DRIVER_OP_UNSUPPORTED

DRIVER_OP_UNINIT = _pycdio.DRIVER_OP_UNINIT

DRIVER_OP_NOT_PERMITTED = _pycdio.DRIVER_OP_NOT_PERMITTED

DRIVER_OP_BAD_PARAMETER = _pycdio.DRIVER_OP_BAD_PARAMETER

DRIVER_OP_BAD_POINTER = _pycdio.DRIVER_OP_BAD_POINTER

DRIVER_OP_NO_DRIVER = _pycdio.DRIVER_OP_NO_DRIVER

FS_AUDIO = _pycdio.FS_AUDIO

FS_HIGH_SIERRA = _pycdio.FS_HIGH_SIERRA

FS_ISO_9660 = _pycdio.FS_ISO_9660

FS_INTERACTIVE = _pycdio.FS_INTERACTIVE

FS_HFS = _pycdio.FS_HFS

FS_UFS = _pycdio.FS_UFS

FS_EXT2 = _pycdio.FS_EXT2

FS_ISO_HFS = _pycdio.FS_ISO_HFS

FS_ISO_9660_INTERACTIVE = _pycdio.FS_ISO_9660_INTERACTIVE

FS_3DO = _pycdio.FS_3DO

FS_XISO = _pycdio.FS_XISO

FS_UDFX = _pycdio.FS_UDFX

FS_UDF = _pycdio.FS_UDF

FS_ISO_UDF = _pycdio.FS_ISO_UDF

FS_ANAL_XA = _pycdio.FS_ANAL_XA

FS_ANAL_MULTISESSION = _pycdio.FS_ANAL_MULTISESSION

FS_ANAL_PHOTO_CD = _pycdio.FS_ANAL_PHOTO_CD

FS_ANAL_HIDDEN_TRACK = _pycdio.FS_ANAL_HIDDEN_TRACK

FS_ANAL_CDTV = _pycdio.FS_ANAL_CDTV

FS_ANAL_BOOTABLE = _pycdio.FS_ANAL_BOOTABLE

FS_ANAL_VIDEOCD = _pycdio.FS_ANAL_VIDEOCD

FS_ANAL_ROCKRIDGE = _pycdio.FS_ANAL_ROCKRIDGE

FS_ANAL_JOLIET = _pycdio.FS_ANAL_JOLIET

FS_ANAL_SVCD = _pycdio.FS_ANAL_SVCD

FS_ANAL_CVD = _pycdio.FS_ANAL_CVD

FS_ANAL_XISO = _pycdio.FS_ANAL_XISO

FS_MATCH_ALL = _pycdio.FS_MATCH_ALL

FS_UNKNOWN = _pycdio.FS_UNKNOWN


def close_tray(*args):
    r"""
    close_tray(drive=None, driver_id=None) -> [status, driver_id]

    close media tray in CD drive if there is a routine to do so.
    The driver id is returned. An exception is thrown on error.
    """
    return _pycdio.close_tray(*args)

def close(p_cdio):
    r"""
    destroy(p_cdio)
    Free resources associated with p_cdio.  Call this when done using
    using CD reading/control operations for the current device.

    """
    return _pycdio.close(p_cdio)

def eject_media(p_cdio):
    r"""
    eject_media(cdio)->return_code

    Eject media in CD drive if there is a routine to do so.

    """
    return _pycdio.eject_media(p_cdio)

def eject_media_drive(psz_drive=None):
    r"""
    eject_media_drive(drive=None)->return_code
    Eject media in CD drive if there is a routine to do so.

    psz_drive: the name of the device to be acted upon.
    The operation status is returned.
    """
    return _pycdio.eject_media_drive(psz_drive)

def get_arg(p_cdio, key):
    r"""
    get_arg(p_cdio, key)->string

    Get the value associatied with key.
    """
    return _pycdio.get_arg(p_cdio, key)

def get_device(p_cdio=None):
    r"""
    get_device(cdio)->str

    Get the CD device associated with cdio.
    If cdio is NULL (we haven't initialized a specific device driver),
    then find a suitable one and return the default device for that.

    In some situations of drivers or OS's we can't find a CD device if
    there is no media in it and it is possible for this routine to return
    None even though there may be a hardware CD-ROM.
    """
    return _pycdio.get_device(p_cdio)

def get_default_device_driver(p_driver_id):
    r"""
    get_default_device_driver(driver_id=None)->[device, driver]
    Return a string containing the default CD device if none is specified.
    if p_driver_id is DRIVER_UNKNOWN or DRIVER_DEVICE then find a suitable
    one set the default device for that.

    None is returned as the device if we couldn't get a default device.
    """
    return _pycdio.get_default_device_driver(p_driver_id)

def get_devices(driver_id):
    r"""
    get_devices(driver_id)->[device1, device2, ...]

    Get an list of device names.
    """
    return _pycdio.get_devices(driver_id)

def get_devices_ret(driver_id):
    r"""
    get_devices_ret(driver_id)->[device1, device2, ... driver_id]

    Like get_devices, but return the p_driver_id which may be different
    from the passed-in driver_id if it was pycdio.DRIVER_DEVICE or
    pycdio.DRIVER_UNKNOWN. The return driver_id may be useful because
    often one wants to get a drive name and then *open* it
    afterwards. Giving the driver back facilitates this, and speeds things
    up for libcdio as well.
    """
    return _pycdio.get_devices_ret(driver_id)

def get_devices_with_cap(capabilities, b_any):
    r"""
    get_devices_with_cap(capabilities, any)->[device1, device2...]
    Get an array of device names in search_devices that have at least
    the capabilities listed by the capabities parameter.

    If any is False then every capability listed in the
    extended portion of capabilities (i.e. not the basic filesystem)
    must be satisified. If any is True, then if any of the
    capabilities matches, we call that a success.

    To find a CD-drive of any type, use the mask pycdio.CDIO_FS_MATCH_ALL.

    The array of device names is returned or NULL if we couldn't get a
    default device.  It is also possible to return a non NULL but after
    dereferencing the the value is NULL. This also means nothing was
    found.
    """
    return _pycdio.get_devices_with_cap(capabilities, b_any)

def get_devices_with_cap_ret(capabilities, b_any):
    r"""
    Like cdio_get_devices_with_cap but we return the driver we found
    as well. This is because often one wants to search for kind of drive
    and then *open* it afterwards. Giving the driver back facilitates this,
      and speeds things up for libcdio as well.
    """
    return _pycdio.get_devices_with_cap_ret(capabilities, b_any)

def get_drive_cap(*args):
    r"""
    get_drive_cap()->(read_cap, write_cap, misc_cap)

    Get drive capabilities of device.

    In some situations of drivers or OS's we can't find a CD device if
    there is no media in it. In this situation capabilities will show up as
    empty even though there is a hardware CD-ROM.get_drive_cap_dev()->(read_cap, write_cap, misc_cap)

    Get drive capabilities of device.

    In some situations of drivers or OS's we can't find a CD device if
    there is no media in it. In this situation capabilities will show up as
    empty even though there is a hardware CD-ROM.
    """
    return _pycdio.get_drive_cap(*args)

def get_driver_name(p_cdio):
    r"""
    get_driver_name(cdio)-> string

    return a string containing the name of the driver in use.

    An IOError exception is raised on error.

    """
    return _pycdio.get_driver_name(p_cdio)

def get_driver_id(p_cdio):
    r"""
    get_driver_id(cdio)-> int

    Return the driver id of the driver in use.
    if cdio has not been initialized or is None,
    return pycdio.DRIVER_UNKNOWN.
    """
    return _pycdio.get_driver_id(p_cdio)

def get_last_session(p_cdio):
    r"""
    get_last_session(p_cdio) -> int
    Get the LSN of the first track of the last session of on the CD.
    An exception is thrown on error.
    """
    return _pycdio.get_last_session(p_cdio)

def have_driver(driver_id):
    r"""
    have_driver(driver_id) -> int

    Return 1 if we have driver driver_id, 0 if not and -1
    if driver id is out of range.
    """
    return _pycdio.have_driver(driver_id)

def have_ATAPI(p_cdio):
    r"""
    have_ATAPI(CdIo_t *p_cdio)->bool
    return True if CD-ROM understand ATAPI commands.
    """
    return _pycdio.have_ATAPI(p_cdio)

def is_binfile(bin_name):
    r"""
    is_binfile(binfile_name)->cue_name

    Determine if binfile_name is the BIN file part of a CDRWIN CD disk
    image.

    Return the corresponding CUE file if bin_name is a BIN file or
    None if not a BIN file.
    """
    return _pycdio.is_binfile(bin_name)

def is_cuefile(cue_name):
    r"""
    is_cuefile(cuefile_name)->bin_name

    Determine if cuefile_name is the CUE file part of a CDRWIN CD disk
    image.

    Return the corresponding BIN file if bin_name is a CUE file or
    None if not a CUE file.
    """
    return _pycdio.is_cuefile(cue_name)

def is_device(*args):
    r"""
    is_cuefile(cuefile_name)->bin_name

    Determine if cuefile_name is the CUE file part of a CDRWIN CD disk
    image.

    Return the corresponding BIN file if bin_name is a CUE file or
    None if not a CUE file.
    """
    return _pycdio.is_device(*args)

def is_nrg(nrg_name):
    r"""
    is_nrg(cue_name)->bool

    Determine if nrg_name is a Nero CD disc image
    """
    return _pycdio.is_nrg(nrg_name)

def is_tocfile(tocfile_name):
    r"""
    is_tocfile(tocfile_name)->bool

    Determine if tocfile_name is a cdrdao CD disc image
    """
    return _pycdio.is_tocfile(tocfile_name)

def get_media_changed(p_cdio):
    r"""
    get_media_changed(cdio) -> int

    Find out if media has changed since the last call.
    Return 1 if media has changed since last call, 0 if not. Error
    return codes are the same as driver_return_code_t
    """
    return _pycdio.get_media_changed(p_cdio)

def get_hwinfo(p_cdio):
    r"""
    get_hwinfo(p_cdio)->[drc, vendor, model, release]
    Get the CD-ROM hardware info via a SCSI MMC INQUIRY command.
    """
    return _pycdio.get_hwinfo(p_cdio)

def set_blocksize(p_cdio, i_blocksize):
    r"""
    set_blocksize(cdio, blocksize)->return_status

    Set the blocksize for subsequent reads.
    """
    return _pycdio.set_blocksize(p_cdio, i_blocksize)

def set_speed(p_cdio, i_speed):
    r"""
    cdio_set_speed(cdio, speed)->return_status
    Set the drive speed.
    """
    return _pycdio.set_speed(p_cdio, i_speed)

def open_cd(*args):
    r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
    return _pycdio.open_cd(*args)

def set_python_errstring(drc):
    r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
    return _pycdio.set_python_errstring(drc)
DISC_MODE_CD_DA = _pycdio.DISC_MODE_CD_DA
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_CD_DATA = _pycdio.DISC_MODE_CD_DATA
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_CD_XA = _pycdio.DISC_MODE_CD_XA
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_CD_MIXED = _pycdio.DISC_MODE_CD_MIXED
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_DVD_ROM = _pycdio.DISC_MODE_DVD_ROM
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_DVD_RAM = _pycdio.DISC_MODE_DVD_RAM
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_DVD_R = _pycdio.DISC_MODE_DVD_R
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_DVD_RW = _pycdio.DISC_MODE_DVD_RW
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_DVD_PR = _pycdio.DISC_MODE_DVD_PR
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_DVD_PRW = _pycdio.DISC_MODE_DVD_PRW
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_DVD_OTHER = _pycdio.DISC_MODE_DVD_OTHER
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_NO_INFO = _pycdio.DISC_MODE_NO_INFO
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_ERROR = _pycdio.DISC_MODE_ERROR
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """
DISC_MODE_CD_I = _pycdio.DISC_MODE_CD_I
r"""
    open_cd(source=NULL, driver_id=None, access_mode=None)

    Sets up to read from place specified by source, driver_id and
    access mode. This should be called before using any other routine
    except those that act on a CD-ROM drive by name.

    If None is given as the source, we'll use the default driver device.
    If None is given as the driver_id, we'll find a suitable device driver.

    Return the a pointer than can be used in subsequent operations or
    None on error or no device.
    """

def get_disc_last_lsn(p_cdio):
    r"""
    get_disc_last_lsn(cdio)->lsn
    Get the LSN of the end of the CD.

    pycdio.INVALID_LSN is returned on error.
    """
    return _pycdio.get_disc_last_lsn(p_cdio)

def get_disc_mode(p_cdio):
    r"""
    get_disc_mode(p_cdio) -> str

    Get disc mode - the kind of CD (CD-DA, CD-ROM mode 1, CD-MIXED, ...)
    that we've got. The notion of 'CD' is extended a little to include
    DVD's.
    """
    return _pycdio.get_disc_mode(p_cdio)

def get_joliet_level(p_cdio):
    r"""
    get_joliet_level(cdio)->int

    Return the Joliet level recognized for cdio.
    This only makes sense for something that has an ISO-9660
    filesystem.
    """
    return _pycdio.get_joliet_level(p_cdio)

def get_mcn(p_cdio):
    r"""
    get_mcn(cdio) -> str

    Get the media catalog number (MCN) from the CD.
    """
    return _pycdio.get_mcn(p_cdio)

def get_num_tracks(p_cdio):
    r"""
    get_num_tracks(p_cdio)->int

    Return the number of tracks on the CD. 
    On error pycdio.INVALID_TRACK is returned.
    """
    return _pycdio.get_num_tracks(p_cdio)
INCLUDE_CLASS = _pycdio.INCLUDE_CLASS
r"""
    get_num_tracks(p_cdio)->int

    Return the number of tracks on the CD. 
    On error pycdio.INVALID_TRACK is returned.
    """

cvar = _pycdio.cvar

