// Generated by gmmproc 2.76.0 -- DO NOT MODIFY!
#ifndef _GTKMM_STRINGFILTER_H
#define _GTKMM_STRINGFILTER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2020 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/filter.h>
#include <gtkmm/expression.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API StringFilter_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** Filtering by strings.
 *
 * %Gtk::StringFilter determines whether to include items by looking
 * at strings and comparing them to a fixed search term. The strings
 * are obtained from the items by evaluating a Gtk::Expression.
 *
 * %Gtk::StringFilter has several different modes of comparison - it
 * can match the whole string, just a prefix, or any substring.
 *
 * @ingroup ListView
 * @newin{3,98}
 */

class GTKMM_API StringFilter : public Filter
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = StringFilter;
  using CppClassType = StringFilter_Class;
  using BaseObjectType = GtkStringFilter;
  using BaseClassType = GtkStringFilterClass;

  // noncopyable
  StringFilter(const StringFilter&) = delete;
  StringFilter& operator=(const StringFilter&) = delete;

private:  friend class StringFilter_Class;
  static CppClassType stringfilter_class_;

protected:
  explicit StringFilter(const Glib::ConstructParams& construct_params);
  explicit StringFilter(GtkStringFilter* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  StringFilter(StringFilter&& src) noexcept;
  StringFilter& operator=(StringFilter&& src) noexcept;

  ~StringFilter() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkStringFilter*       gobj()       { return reinterpret_cast<GtkStringFilter*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkStringFilter* gobj() const { return reinterpret_cast<GtkStringFilter*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkStringFilter* gobj_copy();

private:

        
protected:
    explicit StringFilter(const Glib::RefPtr<Expression<Glib::ustring>>& expression);


public:
  /** @addtogroup gtkmmEnums gtkmm Enums and Flags */

  /** 
   *  @var MatchMode EXACT
   * The search string and
   * text must match exactly.
   * 
   *  @var MatchMode SUBSTRING
   * The search string
   * must be contained as a substring inside the text.
   * 
   *  @var MatchMode PREFIX
   * The text must begin
   * with the search string.
   * 
   *  @enum MatchMode
   * 
   * Specifies how search strings are matched inside text.
   *
   * @ingroup gtkmmEnums
   */
  enum class MatchMode
  {
    EXACT,
    SUBSTRING,
    PREFIX
  };


  static Glib::RefPtr<StringFilter> create(const Glib::RefPtr<Expression<Glib::ustring>>& expression);


  /** Gets the search term.
   * 
   * @return The search term.
   */
  Glib::ustring get_search() const;
  
  /** Sets the string to search for.
   * 
   * @param search The string to search for
   * or <tt>nullptr</tt> to clear the search.
   */
  void set_search(const Glib::ustring& search);
  
  /** Gets the expression that the string filter uses to
   * obtain strings from items.
   * 
   * @return A `Gtk::Expression`.
   */
  Glib::RefPtr<Expression<Glib::ustring>> get_expression();
  
  /** Gets the expression that the string filter uses to
   * obtain strings from items.
   * 
   * @return A `Gtk::Expression`.
   */
  Glib::RefPtr<const Expression<Glib::ustring>> get_expression() const;
  
  /** Sets the expression that the string filter uses to
   * obtain strings from items.
   * 
   * The expression must have a value type of G_TYPE_STRING.
   * 
   * @param expression A `Gtk::Expression`.
   */
  void set_expression(const Glib::RefPtr<Expression<Glib::ustring>>& expression);
  
  /** Returns whether the filter ignores case differences.
   * 
   * @return <tt>true</tt> if the filter ignores case.
   */
  bool get_ignore_case() const;
  
  /** Sets whether the filter ignores case differences.
   * 
   * @param ignore_case <tt>true</tt> to ignore case.
   */
  void set_ignore_case(bool ignore_case =  true);
  
  /** Returns the match mode that the filter is using.
   * 
   * @return The match mode of the filter.
   */
  MatchMode get_match_mode() const;
  
  /** Sets the match mode for the filter.
   * 
   * @param mode The new match mode.
   */
  void set_match_mode(MatchMode mode);

  /** The expression to evaluate on item to get a string to compare with.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Expression<Glib::ustring>> > property_expression() ;

/** The expression to evaluate on item to get a string to compare with.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Expression<Glib::ustring>> > property_expression() const;

  /** If matching is case sensitive.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_ignore_case() ;

/** If matching is case sensitive.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_ignore_case() const;

  /** If exact matches are necessary or if substrings are allowed.
   *
   * Default value: Gtk::StringFilter::MatchMode::SUBSTRING
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< MatchMode > property_match_mode() ;

/** If exact matches are necessary or if substrings are allowed.
   *
   * Default value: Gtk::StringFilter::MatchMode::SUBSTRING
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< MatchMode > property_match_mode() const;

  /** The search term.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_search() ;

/** The search term.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_search() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GTKMM_API Value<Gtk::StringFilter::MatchMode> : public Glib::Value_Enum<Gtk::StringFilter::MatchMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::StringFilter
   */
  GTKMM_API
  Glib::RefPtr<Gtk::StringFilter> wrap(GtkStringFilter* object, bool take_copy = false);
}


#endif /* _GTKMM_STRINGFILTER_H */

