/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings.convertors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import javax.swing.JComponent;
import org.netbeans.modules.settings.Env;
import org.netbeans.modules.settings.ScheduledRequest;
import org.netbeans.modules.settings.convertors.ModuleInfoManager;
import org.netbeans.modules.settings.convertors.SerialDataNode;
import org.netbeans.modules.settings.convertors.XMLSettingsSupport;
import org.netbeans.spi.settings.Convertor;
import org.netbeans.spi.settings.Saver;
import org.openide.cookies.InstanceCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.InstanceDataObject;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

public final class SerialDataConvertor
extends FileChangeAdapter
implements PropertyChangeListener,
FileSystem.AtomicAction {
    static final String EA_NAME = "name";
    final Object READWRITE_LOCK = new Object();
    private final InstanceContent lkpContent;
    private final Lookup lookup;
    private final DataObject dobj;
    private final FileObject provider;
    private final NodeConvertor node;
    private SettingsInstance instance;
    private SaveSupport saver;
    private String moduleCodeBase = null;
    private boolean miUnInitialized = true;
    private boolean moduleMissing;
    private ScheduledRequest request;

    public SerialDataConvertor(DataObject dataObject, FileObject fileObject) {
        this.dobj = dataObject;
        this.provider = fileObject;
        this.lkpContent = new InstanceContent();
        FileObject fileObject2 = dataObject.getPrimaryFile();
        fileObject2.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject2));
        SettingsInstance settingsInstance = this.createInstance(null);
        if (this.isModuleEnabled(settingsInstance) && settingsInstance.instanceName().length() > 0) {
            this.instance = settingsInstance;
            this.lkpContent.add((Object)this.instance);
        }
        this.lkpContent.add((Object)this);
        this.node = new NodeConvertor();
        this.lkpContent.add((Object)this, (InstanceContent.Convertor)this.node);
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.lkpContent);
    }

    public void write(Writer writer, Object object) throws IOException {
        XMLSettingsSupport.storeToXML10(object, writer, Modules.getDefault().ownerOf(object.getClass()));
    }

    void handleUnfiredChange() {
        this.saver.propertyChange(null);
    }

    DataObject getDataObject() {
        return this.dobj;
    }

    FileObject getProvider() {
        return this.provider;
    }

    public final Lookup getLookup() {
        return this.lookup;
    }

    private SettingsInstance createInstance(Object object) {
        return new SettingsInstance(object);
    }

    private SaveSupport createSaveSupport(Object object) {
        return new SaveSupport(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachToInstance(Object object) {
        SaveSupport saveSupport = null;
        SerialDataConvertor serialDataConvertor = this;
        synchronized (serialDataConvertor) {
            if (this.saver != null) {
                this.saver.removePropertyChangeListener(this);
                saveSupport = this.saver;
            }
        }
        if (saveSupport != null) {
            saveSupport.flush();
        }
        serialDataConvertor = this;
        synchronized (serialDataConvertor) {
            this.saver = this.createSaveSupport(object);
            this.saver.addPropertyChangeListener(this);
        }
    }

    private void provideSaveCookie() {
        if (this.saver.isChanged()) {
            this.lkpContent.add((Object)this.saver);
        } else {
            this.lkpContent.remove((Object)this.saver);
        }
    }

    private void instanceCookieChanged(Object object) {
        if (XMLSettingsSupport.err.isLoggable(Level.FINE)) {
            XMLSettingsSupport.err.fine("instanceCookieChanged: " + this.dobj);
        }
        if (this.saver != null) {
            if (XMLSettingsSupport.err.isLoggable(Level.FINE)) {
                XMLSettingsSupport.err.fine("canceling saver: " + this.dobj);
            }
            this.saver.removePropertyChangeListener(this);
            this.getScheduledRequest().cancel();
            this.saver = null;
        }
        SettingsInstance settingsInstance = this.createInstance(object);
        boolean bl = false;
        if (this.instance != null && this.instance.getCachedInstance() != null && SerialDataConvertor.isSystemOption(this.instance.getCachedInstance())) {
            bl = true;
        }
        if (XMLSettingsSupport.err.isLoggable(Level.FINE)) {
            XMLSettingsSupport.err.fine("need recreate: " + bl + " for " + this.dobj);
        }
        if (this.isModuleEnabled(settingsInstance) && settingsInstance.instanceName().length() > 0) {
            this.instance = settingsInstance;
            this.lkpContent.set(Arrays.asList(this, settingsInstance), null);
            if (XMLSettingsSupport.err.isLoggable(Level.FINE)) {
                XMLSettingsSupport.err.fine("module enabled: " + this.dobj);
            }
        } else {
            this.lkpContent.set(Collections.singleton(this), null);
            this.instance = null;
            if (XMLSettingsSupport.err.isLoggable(Level.FINE)) {
                XMLSettingsSupport.err.fine("module disabled: " + this.dobj + "  or instanceName is empty: " + settingsInstance.instanceName());
            }
        }
        this.lkpContent.add((Object)this, (InstanceContent.Convertor)this.node);
        if (this.isModuleEnabled(settingsInstance) && bl) {
            if (XMLSettingsSupport.err.isLoggable(Level.FINE)) {
                XMLSettingsSupport.err.fine("recreating: " + this.dobj);
            }
            try {
                if (this.instance != null) {
                    this.instance.instanceCreate();
                }
            }
            catch (Exception exception) {
                XMLSettingsSupport.err.log(Level.WARNING, null, exception);
            }
        }
        if (XMLSettingsSupport.err.isLoggable(Level.FINE)) {
            XMLSettingsSupport.err.fine("done: " + this.dobj);
        }
    }

    private static boolean isSystemOption(Object object) {
        boolean bl = false;
        if (object != null && object instanceof SharedClassObject) {
            for (Class<?> clazz = object.getClass(); !bl && clazz != null; clazz = clazz.getSuperclass()) {
                bl = "org.openide.options.SystemOption".equals(clazz.getName());
            }
        }
        return bl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string == "savecookie") {
            this.provideSaveCookie();
        } else if (string == "fileChanged") {
            this.miUnInitialized = true;
            if (this.moduleCodeBase != null) {
                ModuleInfo moduleInfo = ModuleInfoManager.getDefault().getModule(this.moduleCodeBase);
                ModuleInfoManager.getDefault().unregisterPropertyChangeListener(this, moduleInfo);
            }
            this.instanceCookieChanged(null);
        } else if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
            this.instanceCookieChanged(null);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        if (this.saver != null && fileEvent.firedFrom((FileSystem.AtomicAction)this.saver)) {
            return;
        }
        this.propertyChange(new PropertyChangeEvent(this, "fileChanged", null, null));
    }

    public void fileDeleted(FileEvent fileEvent) {
        if (this.saver != null && fileEvent.firedFrom((FileSystem.AtomicAction)this.saver)) {
            return;
        }
        if (this.saver != null) {
            this.saver.removePropertyChangeListener(this);
            this.getScheduledRequest().cancel();
            this.saver = null;
        }
    }

    private boolean isModuleEnabled(SettingsInstance settingsInstance) {
        ModuleInfo moduleInfo = null;
        if (this.miUnInitialized) {
            this.moduleCodeBase = this.getModuleCodeNameBase(settingsInstance);
            this.miUnInitialized = false;
            if (this.moduleCodeBase != null) {
                moduleInfo = ModuleInfoManager.getDefault().getModule(this.moduleCodeBase);
                boolean bl = this.moduleMissing = moduleInfo == null;
                if (moduleInfo != null) {
                    ModuleInfoManager.getDefault().registerPropertyChangeListener(this, moduleInfo);
                } else {
                    XMLSettingsSupport.err.warning("Warning: unknown module code base: " + this.moduleCodeBase + " in " + this.getDataObject().getPrimaryFile());
                }
            } else {
                this.moduleMissing = false;
            }
        } else {
            moduleInfo = ModuleInfoManager.getDefault().getModule(this.moduleCodeBase);
        }
        return !this.moduleMissing && (moduleInfo == null || moduleInfo.isEnabled());
    }

    private String getModuleCodeNameBase(SettingsInstance settingsInstance) {
        try {
            String string = settingsInstance.getSettings(true).getCodeNameBase();
            return string;
        }
        catch (IOException iOException) {
            XMLSettingsSupport.err.log(Level.WARNING, null, iOException);
            return null;
        }
    }

    static void inform(Throwable throwable) {
        XMLSettingsSupport.err.log(Level.WARNING, null, throwable);
    }

    public void run() throws IOException {
        if (this.saver != null) {
            this.saver.writeDown();
        }
    }

    private synchronized ScheduledRequest getScheduledRequest() {
        if (this.request == null) {
            this.request = new ScheduledRequest(this.getDataObject().getPrimaryFile(), this);
        }
        return this.request;
    }

    private static final class NodeConvertor
    implements InstanceContent.Convertor<SerialDataConvertor, Node> {
        NodeConvertor() {
        }

        public Node convert(SerialDataConvertor serialDataConvertor) {
            return new SerialDataNode(serialDataConvertor);
        }

        public Class<Node> type(SerialDataConvertor serialDataConvertor) {
            return Node.class;
        }

        public String id(SerialDataConvertor serialDataConvertor) {
            return serialDataConvertor.toString();
        }

        public String displayName(SerialDataConvertor serialDataConvertor) {
            return serialDataConvertor.toString();
        }
    }

    public static final class Provider
    implements Environment.Provider {
        private final FileObject providerFO;

        public static Environment.Provider create(FileObject fileObject) {
            return new Provider(fileObject);
        }

        private Provider(FileObject fileObject) {
            this.providerFO = fileObject;
        }

        public Lookup getEnvironment(DataObject dataObject) {
            if (!(dataObject instanceof InstanceDataObject)) {
                return Lookup.EMPTY;
            }
            return new SerialDataConvertor(dataObject, this.providerFO).getLookup();
        }
    }

    private final class SaveSupport
    implements FileSystem.AtomicAction,
    SaveCookie,
    PropertyChangeListener,
    Saver {
        public static final String PROP_SAVE = "savecookie";
        public static final String PROP_FILE_CHANGED = "fileChanged";
        private PropertyChangeSupport changeSupport;
        private int propertyChangeListenerCount = 0;
        private boolean isChanged = false;
        private final FileObject file;
        private final WeakReference<Object> instance;
        private Boolean knownToBeTemplate = null;
        private boolean isWriting = false;
        private Convertor convertor;
        private ByteArrayOutputStream buf;

        public SaveSupport(Object object) {
            this.instance = new WeakReference<Object>(object);
            this.file = SerialDataConvertor.this.getDataObject().getPrimaryFile();
        }

        public final boolean isChanged() {
            return this.isChanged;
        }

        private boolean acceptSave() {
            Object t = this.instance.get();
            return t != null && t instanceof Serializable && !(t instanceof TopComponent);
        }

        private boolean ignoreChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.isChanged || this.isWriting || !SerialDataConvertor.this.getDataObject().isValid()) {
                return true;
            }
            if (propertyChangeEvent != null && Boolean.FALSE.equals(propertyChangeEvent.getPropagationId())) {
                return true;
            }
            if (this.knownToBeTemplate == null) {
                this.knownToBeTemplate = SerialDataConvertor.this.getDataObject().isTemplate() ? Boolean.TRUE : Boolean.FALSE;
            }
            return this.knownToBeTemplate;
        }

        private Convertor getConvertor() {
            return this.convertor;
        }

        private Convertor initConvertor() {
            Object t = this.instance.get();
            if (t == null) {
                throw new IllegalStateException("setting object cannot be null: " + SerialDataConvertor.this.getDataObject());
            }
            try {
                FileObject fileObject = Env.findProvider(t.getClass());
                if (fileObject != null) {
                    Object object;
                    FileObject fileObject2 = Env.findEntityRegistration(fileObject);
                    if (fileObject2 == null) {
                        fileObject2 = fileObject;
                    }
                    if ((object = fileObject2.getAttribute("hint.originalPublicID")) == null || !(object instanceof String)) {
                        throw new IOException("missing or invalid attribute: hint.originalPublicID, provider: " + fileObject2);
                    }
                    if ("-//NetBeans//DTD Session settings 1.0//EN".equals(object)) {
                        this.convertor = null;
                        return this.convertor;
                    }
                    object = fileObject.getAttribute("settings.convertor");
                    if (object == null || !(object instanceof Convertor)) {
                        throw new IOException("cannot create convertor: " + object + ", provider: " + fileObject);
                    }
                    this.convertor = (Convertor)object;
                    return this.convertor;
                }
            }
            catch (IOException iOException) {
                SerialDataConvertor.inform(iOException);
            }
            return this.convertor;
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.changeSupport == null || this.propertyChangeListenerCount <= 0) {
                Convertor convertor;
                Object t = this.instance.get();
                if (t == null) {
                    return;
                }
                if (this.changeSupport == null) {
                    this.changeSupport = new PropertyChangeSupport(this);
                    this.propertyChangeListenerCount = 0;
                }
                if ((convertor = this.initConvertor()) != null) {
                    convertor.registerSaver(t, this);
                } else {
                    this.registerPropertyChangeListener(t);
                }
            }
            ++this.propertyChangeListenerCount;
            this.changeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.changeSupport == null) {
                return;
            }
            --this.propertyChangeListenerCount;
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
            if (this.propertyChangeListenerCount == 0) {
                Object t = this.instance.get();
                if (t == null) {
                    return;
                }
                Convertor convertor = this.getConvertor();
                if (convertor != null) {
                    convertor.unregisterSaver(t, this);
                } else {
                    this.unregisterPropertyChangeListener(t);
                }
            }
        }

        private void registerPropertyChangeListener(Object object) {
            if (object instanceof SharedClassObject) {
                ((SharedClassObject)object).addPropertyChangeListener((PropertyChangeListener)this);
            } else if (object instanceof JComponent) {
                ((JComponent)object).addPropertyChangeListener(this);
            } else {
                try {
                    Method method = object.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                    method.invoke(object, this);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (XMLSettingsSupport.err.isLoggable(Level.FINE)) {
                        XMLSettingsSupport.err.warning("NoSuchMethodException: " + object.getClass().getName() + ".addPropertyChangeListener");
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    XMLSettingsSupport.err.warning("Instance: " + object);
                    XMLSettingsSupport.err.log(Level.WARNING, null, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    XMLSettingsSupport.err.log(Level.WARNING, null, invocationTargetException.getTargetException());
                }
            }
        }

        private void unregisterPropertyChangeListener(Object object) {
            try {
                Method method = object.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
                method.invoke(object, this);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (XMLSettingsSupport.err.isLoggable(Level.FINE)) {
                    XMLSettingsSupport.err.log(Level.FINE, "NoSuchMethodException: " + object.getClass().getName() + ".removePropertyChangeListener");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                XMLSettingsSupport.err.log(Level.WARNING, "Instance: " + object);
                XMLSettingsSupport.err.log(Level.WARNING, null, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                XMLSettingsSupport.err.log(Level.WARNING, null, invocationTargetException.getTargetException());
            }
        }

        private void firePropertyChange(String string) {
            if (this.changeSupport != null) {
                this.changeSupport.firePropertyChange(string, null, null);
            }
        }

        public void flush() {
            SerialDataConvertor.this.getScheduledRequest().forceToFinish();
        }

        @Override
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.ignoreChange(propertyChangeEvent)) {
                return;
            }
            this.isChanged = true;
            this.firePropertyChange(PROP_SAVE);
            if (this.acceptSave()) {
                SerialDataConvertor.this.getScheduledRequest().schedule(this.instance.get());
            }
        }

        @Override
        public void markDirty() {
            if (this.ignoreChange(null)) {
                return;
            }
            this.isChanged = true;
            this.firePropertyChange(PROP_SAVE);
        }

        @Override
        public void requestSave() throws IOException {
            if (this.ignoreChange(null)) {
                return;
            }
            this.isChanged = true;
            this.firePropertyChange(PROP_SAVE);
            SerialDataConvertor.this.getScheduledRequest().schedule(this.instance.get());
        }

        public void run() throws IOException {
            if (!SerialDataConvertor.this.getDataObject().isValid()) {
                if (XMLSettingsSupport.err.isLoggable(Level.FINE)) {
                    XMLSettingsSupport.err.fine("invalid data object cannot be used for storing " + SerialDataConvertor.this.getDataObject());
                }
                return;
            }
            try {
                this.try2run();
            }
            catch (IOException iOException) {
                if (SerialDataConvertor.this.getDataObject().isValid()) {
                    throw iOException;
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void try2run() throws IOException {
            Object object = SerialDataConvertor.this.READWRITE_LOCK;
            synchronized (object) {
                FileLock fileLock;
                if (XMLSettingsSupport.err.isLoggable(Level.FINER)) {
                    XMLSettingsSupport.err.finer("saving " + SerialDataConvertor.this.getDataObject());
                }
                if ((fileLock = SerialDataConvertor.this.getScheduledRequest().getFileLock()) == null) {
                    return;
                }
                OutputStream outputStream = this.file.getOutputStream(fileLock);
                try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 1024);){
                    this.buf.writeTo(bufferedOutputStream);
                    if (XMLSettingsSupport.err.isLoggable(Level.FINER)) {
                        XMLSettingsSupport.err.finer("saved " + SerialDataConvertor.this.dobj);
                    }
                }
            }
        }

        public void save() throws IOException {
            if (!this.isChanged) {
                return;
            }
            SerialDataConvertor.this.getScheduledRequest().runAndWait();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeDown() throws IOException {
            Object t = this.instance.get();
            if (t == null) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);
            try {
                this.isWriting = true;
                Convertor convertor = this.getConvertor();
                if (convertor != null) {
                    convertor.write(outputStreamWriter, t);
                } else {
                    SerialDataConvertor.this.write(outputStreamWriter, t);
                }
            }
            finally {
                ((Writer)outputStreamWriter).close();
                this.isWriting = false;
            }
            this.isChanged = false;
            this.buf = byteArrayOutputStream;
            this.file.getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
            this.buf = null;
            if (!this.isChanged) {
                this.firePropertyChange(PROP_SAVE);
            }
        }
    }

    private final class SettingsInstance
    implements InstanceCookie.Of {
        private SoftReference<Object> inst;
        private XMLSettingsSupport.SettingsRecognizer settings = null;

        public SettingsInstance(Object object) {
            this.setCachedInstance(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XMLSettingsSupport.SettingsRecognizer getSettings(boolean bl) throws IOException {
            SettingsInstance settingsInstance = this;
            synchronized (settingsInstance) {
                if (this.settings == null) {
                    Object object = SerialDataConvertor.this.READWRITE_LOCK;
                    synchronized (object) {
                        this.settings = new XMLSettingsSupport.SettingsRecognizer(bl, SerialDataConvertor.this.getDataObject().getPrimaryFile());
                        this.settings.parse();
                    }
                    return this.settings;
                }
                if (!bl && !this.settings.isAllRead()) {
                    this.settings.setAllRead(false);
                    this.settings.parse();
                }
                return this.settings;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object instanceCreate() throws IOException, ClassNotFoundException {
            Object object;
            SettingsInstance settingsInstance = this;
            synchronized (settingsInstance) {
                object = this.getCachedInstance();
                if (object != null) {
                    if (XMLSettingsSupport.err.isLoggable(Level.FINE)) {
                        XMLSettingsSupport.err.fine("Cached instance1: " + object);
                    }
                    return object;
                }
            }
            XMLSettingsSupport.SettingsRecognizer settingsRecognizer = this.getSettings(false);
            object = settingsRecognizer.instanceCreate();
            settingsInstance = this;
            synchronized (settingsInstance) {
                Object object2 = this.getCachedInstance();
                if (object2 != null) {
                    if (XMLSettingsSupport.err.isLoggable(Level.FINER)) {
                        XMLSettingsSupport.err.finer("Cached instance2: " + object2);
                    }
                    return object2;
                }
                this.setCachedInstance(object);
            }
            if (XMLSettingsSupport.err.isLoggable(Level.FINER)) {
                XMLSettingsSupport.err.finer("Attached to instance: " + object);
            }
            SerialDataConvertor.this.attachToInstance(object);
            return object;
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            Object object = this.getCachedInstance();
            if (object != null) {
                return object.getClass();
            }
            XMLSettingsSupport.SettingsRecognizer settingsRecognizer = this.getSettings(false);
            return settingsRecognizer.instanceClass();
        }

        public boolean instanceOf(Class<?> clazz) {
            try {
                if (SerialDataConvertor.this.moduleCodeBase != null && ModuleInfoManager.getDefault().isReloaded(SerialDataConvertor.this.moduleCodeBase) && clazz.getClassLoader() != ClassLoader.getSystemClassLoader() && clazz.getClassLoader() != null) {
                    ModuleInfo moduleInfo = ModuleInfoManager.getDefault().getModule(SerialDataConvertor.this.moduleCodeBase);
                    if (moduleInfo == null || !moduleInfo.isEnabled()) {
                        return false;
                    }
                    Class clazz2 = this.instanceClass();
                    return clazz.isAssignableFrom(clazz2);
                }
                Object object = this.getCachedInstance();
                if (object != null) {
                    return clazz.isInstance(object);
                }
                return this.getSettings(true).getInstanceOf().contains(clazz.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                XMLSettingsSupport.err.log(Level.WARNING, SerialDataConvertor.this.getDataObject().getPrimaryFile().toString());
                SerialDataConvertor.inform(classNotFoundException);
            }
            catch (IOException iOException) {
                XMLSettingsSupport.err.log(Level.WARNING, SerialDataConvertor.this.getDataObject().getPrimaryFile().toString());
                SerialDataConvertor.inform(iOException);
            }
            return false;
        }

        public String instanceName() {
            Object object = this.getCachedInstance();
            if (object != null) {
                return object.getClass().getName();
            }
            try {
                return this.getSettings(true).instanceName();
            }
            catch (IOException iOException) {
                XMLSettingsSupport.err.warning(SerialDataConvertor.this.getDataObject().getPrimaryFile().toString());
                SerialDataConvertor.inform(iOException);
                return "";
            }
        }

        private Object getCachedInstance() {
            return this.inst.get();
        }

        private void setCachedInstance(Object object) {
            this.inst = new SoftReference<Object>(object);
            this.settings = null;
        }

        public void setInstance(Object object, boolean bl) throws IOException {
            SerialDataConvertor.this.instanceCookieChanged(object);
            if (object != null) {
                SerialDataConvertor.this.attachToInstance(object);
                if (bl) {
                    SerialDataConvertor.this.getScheduledRequest().runAndWait();
                }
            }
        }
    }
}

