"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiBottomBar = exports.POSITIONS = exports.paddingSizeToClassNameMap = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _services = require("../../services");

var _accessibility = require("../accessibility");

var _i18n = require("../i18n");

var _resize_observer = require("../observer/resize_observer");

var _portal = require("../portal");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * compatible open source license.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * GitHub history for details.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */ /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * under the License.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          */

// Exported for testing
var paddingSizeToClassNameMap = {
  none: null,
  s: 'euiBottomBar--paddingSmall',
  m: 'euiBottomBar--paddingMedium',
  l: 'euiBottomBar--paddingLarge'
};
exports.paddingSizeToClassNameMap = paddingSizeToClassNameMap;
var POSITIONS = ['static', 'fixed', 'sticky'];
exports.POSITIONS = POSITIONS;
var EuiBottomBar = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _ref$position = _ref.position,
      position = _ref$position === void 0 ? 'fixed' : _ref$position,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'm' : _ref$paddingSize,
      _ref$affordForDisplac = _ref.affordForDisplacement,
      affordForDisplacement = _ref$affordForDisplac === void 0 ? true : _ref$affordForDisplac,
      children = _ref.children,
      className = _ref.className,
      bodyClassName = _ref.bodyClassName,
      landmarkHeading = _ref.landmarkHeading,
      _ref$usePortal = _ref.usePortal,
      usePortal = _ref$usePortal === void 0 ? true : _ref$usePortal,
      left = _ref.left,
      right = _ref.right,
      bottom = _ref.bottom,
      top = _ref.top,
      style = _ref.style,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["position", "paddingSize", "affordForDisplacement", "children", "className", "bodyClassName", "landmarkHeading", "usePortal", "left", "right", "bottom", "top", "style"]);
  // Force some props if `fixed` position, but not if the user has supplied these
  affordForDisplacement = position !== 'fixed' ? false : affordForDisplacement;
  usePortal = position !== 'fixed' ? false : usePortal;

  var _useState = (0, _react.useState)(null),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      resizeRef = _useState2[0],
      setResizeRef = _useState2[1];

  var setRef = (0, _services.useCombinedRefs)([setResizeRef, ref]); // TODO: Allow this hooke to be conditional

  var dimensions = (0, _resize_observer.useResizeObserver)(resizeRef);
  (0, _react.useEffect)(function () {
    if (affordForDisplacement && usePortal) {
      document.body.style.paddingBottom = "".concat(dimensions.height, "px");
    }

    if (bodyClassName) {
      document.body.classList.add(bodyClassName);
    }

    return function () {
      if (affordForDisplacement && usePortal) {
        document.body.style.paddingBottom = '';
      }

      if (bodyClassName) {
        document.body.classList.remove(bodyClassName);
      }
    };
  }, [affordForDisplacement, usePortal, dimensions, bodyClassName]);
  var classes = (0, _classnames.default)('euiBottomBar', "euiBottomBar--".concat(position), paddingSizeToClassNameMap[paddingSize], className);

  var newStyle = _objectSpread({
    left: left,
    right: right,
    bottom: bottom,
    top: top
  }, style);

  var bar = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
    token: "euiBottomBar.screenReaderHeading",
    default: "Page level controls"
  }, function (screenReaderHeading) {
    return (
      /*#__PURE__*/
      // Though it would be better to use aria-labelledby than aria-label and not repeat the same string twice
      // A bug in voiceover won't list some landmarks in the rotor without an aria-label
      _react.default.createElement("section", (0, _extends2.default)({
        "aria-label": landmarkHeading ? landmarkHeading : screenReaderHeading,
        className: classes,
        ref: setRef,
        style: newStyle
      }, rest), /*#__PURE__*/_react.default.createElement(_accessibility.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h2", null, landmarkHeading ? landmarkHeading : screenReaderHeading)), children)
    );
  }), /*#__PURE__*/_react.default.createElement(_accessibility.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
    "aria-live": "assertive"
  }, landmarkHeading ? /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
    token: "euiBottomBar.customScreenReaderAnnouncement",
    default: "There is a new region landmark called {landmarkHeading} with page level controls at the end of the document.",
    values: {
      landmarkHeading: landmarkHeading
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
    token: "euiBottomBar.screenReaderAnnouncement",
    default: "There is a new region landmark with page level controls at the end of the document."
  }))));

  return usePortal ? /*#__PURE__*/_react.default.createElement(_portal.EuiPortal, null, bar) : bar;
});
exports.EuiBottomBar = EuiBottomBar;
EuiBottomBar.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * How to position the bottom bar against its parent.
       */
  position: _propTypes.default.oneOfType([_propTypes.default.oneOf(["fixed"]), _propTypes.default.oneOf(["static", "sticky"]).isRequired]),

  /**
       * Whether to wrap in an EuiPortal which appends the component to the body element.
       * Only works if `position` is `fixed`.
       */
  usePortal: _propTypes.default.bool,

  /**
       * Whether the component should apply padding on the document body element to afford for its own displacement height.
       * Only works if `usePortal` is true and `position` is `fixed`.
       */
  affordForDisplacement: _propTypes.default.bool,

  /**
       * Padding applied to the bar. Default is 'm'.
       */
  paddingSize: _propTypes.default.oneOf(["none", "s", "m", "l"]),

  /**
       * Optional class applied to the body element on mount.
       */
  bodyClassName: _propTypes.default.string,

  /**
       * Customize the screen reader heading that helps users find this control. Default is 'Page level controls'.
       */
  landmarkHeading: _propTypes.default.string,

  /**
       * Starting vertical position when `fixed` position.
       * Offset from the top of the window when `sticky` position.
       * Has no affect on `static` positions.
       */
  top: _propTypes.default.any,

  /**
       * Ending horizontal position when `fixed` position.
       * Has no affect on `static` or `sticky` positions.
       */
  right: _propTypes.default.any,

  /**
       * Starting vertical position when `fixed` position.
       * Offset from the bottom of the window when `sticky` position.
       * Has no affect on `static` positions.
       */
  bottom: _propTypes.default.any,

  /**
       * Starting horizontal position when `fixed` position.
       * Has no affect on `static` or `sticky` positions.
       */
  left: _propTypes.default.any
};
EuiBottomBar.displayName = 'EuiBottomBar';