"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BasicAuthentication = void 0;
var _routes = require("./routes");
var _authentication_type = require("../authentication_type");
var _common = require("../../../../common");
var _next_url = require("../../../utils/next_url");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
class BasicAuthentication extends _authentication_type.AuthenticationType {
  constructor(config, sessionStorageFactory, router, esClient, coreSetup, logger) {
    super(config, sessionStorageFactory, router, esClient, coreSetup, logger);
    _defineProperty(this, "type", _common.AuthType.BASIC);
  }
  async init() {
    const routes = new _routes.BasicAuthRoutes(this.router, this.config, this.sessionStorageFactory, this.securityClient, this.coreSetup);
    routes.setupRoutes();
  }

  // override functions inherited from AuthenticationType
  requestIncludesAuthInfo(request) {
    return request.headers[_common.AUTH_HEADER_NAME] ? true : false;
  }
  async getAdditionalAuthHeader(request) {
    return {};
  }
  getCookie(request, authInfo) {
    if (this.config.auth.anonymous_auth_enabled && authInfo.user_name === _common.OPENDISTRO_SECURITY_ANONYMOUS) {
      return {
        username: authInfo.user_name,
        authType: this.type,
        expiryTime: Date.now() + this.config.session.ttl,
        isAnonymousAuth: true
      };
    }
    return {
      username: authInfo.user_name,
      credentials: {
        authHeaderValue: request.headers[_common.AUTH_HEADER_NAME]
      },
      authType: this.type,
      expiryTime: Date.now() + this.config.session.ttl
    };
  }
  async isValidCookie(cookie) {
    var _cookie$credentials;
    return cookie.authType === this.type && cookie.expiryTime && (cookie.username && ((_cookie$credentials = cookie.credentials) === null || _cookie$credentials === void 0 ? void 0 : _cookie$credentials.authHeaderValue) || this.config.auth.anonymous_auth_enabled && cookie.isAnonymousAuth);
  }
  handleUnauthedRequest(request, response, toolkit) {
    if (this.isPageRequest(request)) {
      const nextUrlParam = (0, _next_url.composeNextUrlQueryParam)(request, this.coreSetup.http.basePath.serverBasePath);
      if (this.config.auth.anonymous_auth_enabled) {
        const redirectLocation = `${this.coreSetup.http.basePath.serverBasePath}${_common.ANONYMOUS_AUTH_LOGIN}?${nextUrlParam}`;
        return response.redirected({
          headers: {
            location: `${redirectLocation}`
          }
        });
      } else {
        const redirectLocation = `${this.coreSetup.http.basePath.serverBasePath}${_common.LOGIN_PAGE_URI}?${nextUrlParam}`;
        return response.redirected({
          headers: {
            location: `${redirectLocation}`
          }
        });
      }
    } else {
      return response.unauthorized({
        body: `Authentication required`
      });
    }
  }
  buildAuthHeaderFromCookie(cookie) {
    var _cookie$credentials2;
    if (this.config.auth.anonymous_auth_enabled && cookie.isAnonymousAuth) {
      return {};
    }
    const headers = {};
    Object.assign(headers, {
      authorization: (_cookie$credentials2 = cookie.credentials) === null || _cookie$credentials2 === void 0 ? void 0 : _cookie$credentials2.authHeaderValue
    });
    return headers;
  }
}
exports.BasicAuthentication = BasicAuthentication;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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