
#ifndef KSANE_EXPORT_H
#define KSANE_EXPORT_H

#ifdef KSANE_STATIC_DEFINE
#  define KSANE_EXPORT
#  define KSANE_NO_EXPORT
#else
#  ifndef KSANE_EXPORT
#    ifdef KSaneWidgets_EXPORTS
        /* We are building this library */
#      define KSANE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KSANE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KSANE_NO_EXPORT
#    define KSANE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KSANE_DECL_DEPRECATED
#  define KSANE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KSANE_DECL_DEPRECATED_EXPORT
#  define KSANE_DECL_DEPRECATED_EXPORT KSANE_EXPORT KSANE_DECL_DEPRECATED
#endif

#ifndef KSANE_DECL_DEPRECATED_NO_EXPORT
#  define KSANE_DECL_DEPRECATED_NO_EXPORT KSANE_NO_EXPORT KSANE_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KSANE_NO_DEPRECATED
#    define KSANE_NO_DEPRECATED
#  endif
#endif

#define KSANE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KSANE_NO_DEPRECATED)
#  undef KSANE_DEPRECATED
#  define KSANE_DEPRECATED_EXPORT KSANE_EXPORT
#  define KSANE_DEPRECATED_NO_EXPORT KSANE_NO_EXPORT
#elif defined(KSANE_NO_DEPRECATED_WARNINGS)
#  define KSANE_DEPRECATED
#  define KSANE_DEPRECATED_EXPORT KSANE_EXPORT
#  define KSANE_DEPRECATED_NO_EXPORT KSANE_NO_EXPORT
#else
#  define KSANE_DEPRECATED KSANE_DECL_DEPRECATED
#  define KSANE_DEPRECATED_EXPORT KSANE_DECL_DEPRECATED_EXPORT
#  define KSANE_DEPRECATED_NO_EXPORT KSANE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KSANE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KSANE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KSANE_NO_DEPRECATED
#  define KSANE_DISABLE_DEPRECATED_BEFORE_AND_AT 0x180200
#endif
#ifdef KSANE_NO_DEPRECATED_WARNINGS
#  define KSANE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KSANE_DEPRECATED_WARNINGS_SINCE
#  ifdef KSANE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KSANE_DEPRECATED_WARNINGS_SINCE KSANE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KSANE_DEPRECATED_WARNINGS_SINCE 0x180200
#  endif
#endif

#ifndef KSANE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KSANE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KSANE_DEPRECATED
#  define KSANE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KSANE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KSANE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KSANE_EXPORT_H */
