/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import org.freeplane.view.swing.map.ContentPaneLayout;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.PaintingMode;

class ContentPane
extends JComponent {
    private static LayoutManager layoutManager = new ContentPaneLayout();
    private static final long serialVersionUID = 1L;

    ContentPane() {
        this.setLayout(layoutManager);
    }

    @Override
    public final void paint(Graphics g) {
        NodeView parent = (NodeView)this.getParent();
        PaintingMode paintingMode = parent.getMap().getPaintingMode();
        if (paintingMode.equals((Object)PaintingMode.CLOUDS)) {
            return;
        }
        boolean selected = parent.isSelected();
        if (paintingMode.equals((Object)PaintingMode.SELECTED_NODES) == selected) {
            super.paint(g);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        if (super.contains(x, y)) {
            return true;
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component comp = this.getComponent(i);
            if (!comp.isVisible() || !comp.contains(x - comp.getX(), y - comp.getY())) continue;
            return true;
        }
        return false;
    }
}

