/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.core.domain.properties.HasName;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.codeexplorer.graph.GraphCycleFinder;
import org.freeplane.plugin.codeexplorer.graph.GraphNodeSort;
import org.freeplane.plugin.codeexplorer.map.ClassNode;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.DistinctTargetDependencyFilter;
import org.freeplane.plugin.codeexplorer.map.SubgroupComparator;

class ClassesNode
extends CodeNode {
    static final String NODE_ID_SUFFIX = ".package";
    private final JavaPackage javaPackage;
    static final String UI_CHILD_PACKAGE_ICON_NAME = "code_classes";
    static final String UI_SAME_PACKAGE_ICON_NAME = "code_same_package_classes";
    private final boolean samePackage;

    public ClassesNode(JavaPackage javaPackage, CodeMap map, String name, boolean samePackage, int subprojectIndex) {
        super(map, subprojectIndex);
        this.javaPackage = javaPackage;
        this.samePackage = samePackage;
        this.setIdWithIndex(javaPackage.getName() + NODE_ID_SUFFIX);
        long classCount = this.getClasses().filter(jc -> ClassesNode.isNamed(jc)).count();
        this.setText(name + ClassesNode.formatClassCount(classCount));
        this.initializeChildNodes();
    }

    @Override
    Set<? extends JavaAnnotation<? extends HasName>> getAnnotations() {
        return this.javaPackage.getAnnotations();
    }

    private Stream<JavaClass> getClasses() {
        return this.javaPackage.getClasses().stream().filter(this::belongsToSameSubproject);
    }

    @Override
    HasName getCodeElement() {
        return this.javaPackage;
    }

    private void initializeChildNodes() {
        List children = super.getChildrenInternal();
        List classes = this.getClasses().collect(Collectors.toList());
        if (!classes.isEmpty()) {
            ClassNode node;
            GraphNodeSort<Object> nodeSort = new GraphNodeSort<Object>();
            for (JavaClass javaClass : classes) {
                JavaClass edgeStart = ClassesNode.findEnclosingNamedClass(javaClass);
                nodeSort.addNode(edgeStart);
                DistinctTargetDependencyFilter filter = new DistinctTargetDependencyFilter();
                Map<JavaClass, Long> dependencies = javaClass.getDirectDependenciesFromSelf().stream().filter(dep -> this.goesOutsideEnclosingOriginClass(edgeStart, (Dependency)dep)).map(filter::knownDependency).filter(CodeNode::classesBelongToTheSamePackage).filter(dep -> this.belongsToSameSubproject(dep.getTargetClass())).collect(Collectors.groupingBy(CodeNode::getTargetNodeClass, Collectors.counting()));
                dependencies.entrySet().stream().forEach(e -> nodeSort.addEdge(edgeStart, (JavaClass)e.getKey(), ((Long)e.getValue()).longValue()));
            }
            HashMap<JavaClass, ClassNode> nodes = new HashMap<JavaClass, ClassNode>();
            List orderedClasses = nodeSort.sortNodes(SubgroupComparator.comparingByName(HasName::getName));
            for (int subgroupIndex = 0; subgroupIndex < orderedClasses.size(); ++subgroupIndex) {
                for (JavaClass childClass : orderedClasses.get(subgroupIndex)) {
                    node = new ClassNode(childClass, this.getMap(), this.subprojectIndex);
                    nodes.put(childClass, node);
                    children.add(node);
                    node.setParent(this);
                }
            }
            for (JavaClass javaClass : classes) {
                JavaClass enclosingClass = ClassesNode.findEnclosingNamedClass(javaClass);
                node = (ClassNode)((Object)nodes.get(enclosingClass));
                node.registerInnerClass(javaClass);
            }
        }
    }

    private boolean goesOutsideEnclosingOriginClass(JavaClass edgeStart, Dependency dependency) {
        return ClassesNode.hasValidTopLevelClasses(dependency) && !ClassesNode.getTargetNodeClass(dependency).equals(edgeStart);
    }

    public String toString() {
        return this.getText();
    }

    @Override
    Stream<Dependency> getOutgoingDependencies() {
        return this.getClasses().flatMap(c -> c.getDirectDependenciesFromSelf().stream()).filter(dependency -> ClassesNode.hasValidTopLevelClass(dependency.getTargetClass())).filter(dep -> !dep.getTargetClass().getPackage().equals(dep.getOriginClass().getPackage()) || this.subprojectIndexOf(dep.getTargetClass()) != this.subprojectIndex);
    }

    @Override
    Stream<Dependency> getIncomingDependencies() {
        return this.getClasses().flatMap(c -> c.getDirectDependenciesToSelf().stream()).filter(dependency -> ClassesNode.hasValidTopLevelClass(dependency.getOriginClass())).filter(dep -> !dep.getTargetClass().getPackage().equals(dep.getOriginClass().getPackage()) || this.subprojectIndexOf(dep.getOriginClass()) != this.subprojectIndex);
    }

    @Override
    String getUIIconName() {
        return this.samePackage ? UI_SAME_PACKAGE_ICON_NAME : UI_CHILD_PACKAGE_ICON_NAME;
    }

    @Override
    Set<CodeNode> findCyclicDependencies() {
        GraphCycleFinder<ClassesNode> cycleFinder = new GraphCycleFinder<ClassesNode>();
        cycleFinder.addNode(this);
        cycleFinder.stopSearchHere();
        cycleFinder.exploreGraph(Collections.singleton(this), this::connectedTargetNodesInTheSameScope, this::connectedOriginNodesInTheSameScope);
        Set cycles = cycleFinder.findSimpleCycles();
        HashMap<JavaPackage, Set> origins = new HashMap<JavaPackage, Set>();
        HashMap<JavaPackage, Set> targets = new HashMap<JavaPackage, Set>();
        for (Map.Entry edge : cycles) {
            JavaPackage origin = ((ClassesNode)((Object)edge.getKey())).javaPackage;
            JavaPackage target = ((ClassesNode)((Object)edge.getValue())).javaPackage;
            origins.computeIfAbsent(target, x -> new HashSet()).add(origin);
            targets.computeIfAbsent(origin, x -> new HashSet()).add(target);
        }
        return cycles.stream().map(Map.Entry::getKey).flatMap(packageNode -> Stream.concat(packageNode.getOutgoingDependenciesWithKnownTargets().map(Dependency::getTargetClass).filter(targetClass -> ((Set)targets.get(packageNode.javaPackage)).contains(targetClass.getPackage())), packageNode.getIncomingDependenciesWithKnownOrigins().map(Dependency::getOriginClass).filter(originClass -> ((Set)origins.get(packageNode.javaPackage)).contains(originClass.getPackage())))).map(CodeNode::findEnclosingNamedClass).map(JavaClass::getName).map(this::idWithSubprojectIndex).map(arg_0 -> ((CodeMap)this.getMap()).getNodeForID(arg_0)).map(ClassNode.class::cast).collect(Collectors.toSet());
    }

    private Stream<ClassesNode> connectedOriginNodesInTheSameScope(CodeNode node) {
        Stream<JavaClass> originClasses = node.getIncomingDependenciesWithKnownOrigins().map(Dependency::getOriginClass);
        return this.nodesContainedInSubproject(originClasses);
    }

    private Stream<ClassesNode> connectedTargetNodesInTheSameScope(CodeNode node) {
        Stream<JavaClass> targetClasses = node.getOutgoingDependenciesWithKnownTargets().map(Dependency::getTargetClass);
        return this.nodesContainedInSubproject(targetClasses);
    }

    private Stream<ClassesNode> nodesContainedInSubproject(Stream<JavaClass> classes) {
        return classes.filter(this::belongsToSameSubproject).map(CodeNode::findEnclosingNamedClass).map(JavaClass::getName).map(this::idWithSubprojectIndex).map(arg_0 -> ((CodeMap)this.getMap()).getNodeForID(arg_0)).map(NodeModel::getParentNode).map(ClassesNode.class::cast);
    }

    static {
        IconStoreFactory.INSTANCE.createStateIcon(UI_CHILD_PACKAGE_ICON_NAME, "code/childPackage.svg");
        IconStoreFactory.INSTANCE.createStateIcon(UI_SAME_PACKAGE_ICON_NAME, "code/samePackage.svg");
    }
}

