/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.api.JmolRendererInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.Text;
import org.jmol.render.FontLineShapeRenderer;
import org.jmol.render.TextRenderer;
import org.jmol.shape.Labels;
import org.jmol.util.Font;
import org.jmol.util.Point3fi;
import org.jmol.viewer.JC;

public class LabelsRenderer
extends FontLineShapeRenderer {
    final int[] minZ = new int[1];
    protected int ascent;
    protected int descent;
    protected float sppm;
    protected float[] xy = new float[3];
    private P3i screen = new P3i();
    int fidPrevious;
    protected P3 pTemp = new P3();
    protected short bgcolix;
    protected short labelColix;
    private int fid;
    private Atom atom;
    protected Point3fi atomPt;
    private int doPointer;
    private int offset;
    protected int textAlign;
    private int pointer;
    protected int zSlab = Integer.MIN_VALUE;
    private int zBox;
    private float[] boxXY;
    private float scalePixelsPerMicron;
    protected int mode;

    @Override
    protected boolean render() {
        this.fidPrevious = 0;
        Labels labels = (Labels)this.shape;
        String[] labelStrings = labels.strings;
        int[] fids = labels.fids;
        int[] offsets = labels.offsets;
        if (labelStrings == null) {
            return false;
        }
        Atom[] atoms = this.ms.at;
        short backgroundColixContrast = this.vwr.cm.colixBackgroundContrast;
        int backgroundColor = this.vwr.getBackgroundArgb();
        this.sppm = this.vwr.getScalePixelsPerAngstrom(true);
        this.scalePixelsPerMicron = this.vwr.getBoolean(603979845) ? this.sppm * 10000.0f : 0.0f;
        this.imageFontScaling = this.vwr.imageFontScaling;
        int iGroup = -1;
        this.minZ[0] = Integer.MAX_VALUE;
        boolean isAntialiased = this.g3d.isAntialiased();
        int i = labelStrings.length;
        while (--i >= 0) {
            String label;
            this.atom = atoms[i];
            this.atomPt = this.atom;
            if (!this.isVisibleForMe(this.atom) || (label = labelStrings[i]) == null || label.length() == 0 || labels.mads != null && labels.mads[i] < 0) continue;
            this.labelColix = labels.getColix2(i, this.atom, false);
            this.bgcolix = labels.getColix2(i, this.atom, true);
            if (this.bgcolix == 0 && this.vwr.gdata.getColorArgbOrGray(this.labelColix) == backgroundColor) {
                this.labelColix = backgroundColixContrast;
            }
            this.fid = fids == null || i >= fids.length || fids[i] == 0 ? labels.zeroFontId : fids[i];
            this.offset = offsets == null || i >= offsets.length ? 0 : offsets[i];
            boolean labelsFront = (this.offset & 0x20) != 0;
            boolean labelsGroup = (this.offset & 0x10) != 0;
            this.textAlign = JC.getAlignment(this.offset);
            this.pointer = JC.getPointer(this.offset);
            this.doPointer = this.pointer & 1;
            int isAbsolute = this.offset & 0x40;
            this.mode = this.doPointer | isAbsolute | (isAntialiased ? 4 : 0);
            this.zSlab = this.atom.sZ - this.atom.sD / 2 - 3;
            if (this.zSlab < 1) {
                this.zSlab = 1;
            }
            this.zBox = this.zSlab;
            if (labelsGroup) {
                Group group = this.atom.group;
                int ig = group.groupIndex;
                if (ig != iGroup) {
                    group.getMinZ(atoms, this.minZ);
                    iGroup = ig;
                }
                this.zBox = this.minZ[0];
            } else if (labelsFront) {
                this.zBox = 1;
            }
            if (this.zBox < 1) {
                this.zBox = 1;
            }
            Text text = labels.getLabel(i);
            float[] fArray = this.boxXY = !this.isExport || this.vwr.creatingImage ? labels.getBox(i) : new float[5];
            if (this.boxXY == null) {
                this.boxXY = new float[5];
                labels.putBox(i, this.boxXY);
            }
            if ((text = this.renderLabelOrMeasure(text, label)) != null) {
                labels.putLabel(i, text);
            }
            if (isAntialiased) {
                this.boxXY[0] = this.boxXY[0] / 2.0f;
                this.boxXY[1] = this.boxXY[1] / 2.0f;
            }
            this.boxXY[4] = this.zBox;
        }
        return false;
    }

    protected Text renderLabelOrMeasure(Text text, String label) {
        short pointerColix;
        boolean newText = false;
        short s = pointerColix = (this.pointer & 2) != 0 && this.bgcolix != 0 ? this.bgcolix : this.labelColix;
        if (text != null) {
            if (text.font == null) {
                text.setFontFromFid(this.fid);
            }
            text.atomX = this.atomPt.sX;
            text.atomY = this.atomPt.sY;
            text.atomZ = this.zSlab;
            if (text.pymolOffset == null) {
                text.setXYZs(this.atomPt.sX, this.atomPt.sY, this.zBox, this.zSlab);
                text.colix = this.labelColix;
                text.bgcolix = this.bgcolix;
            } else {
                text.getPymolScreenOffset(this.atomPt, this.screen, this.zSlab, this.pTemp, this.sppm);
            }
        } else {
            boolean isSimple;
            boolean isLeft;
            boolean bl = isLeft = this.textAlign == 4 || this.textAlign == 0;
            if (this.fid != this.fidPrevious || this.ascent == 0) {
                this.vwr.gdata.setFont(Font.getFont3D(this.fid));
                this.fidPrevious = this.fid;
                this.font3d = this.vwr.gdata.getFont3DCurrent();
                if (isLeft) {
                    this.ascent = this.font3d.getAscent();
                    this.descent = this.font3d.getDescent();
                }
            }
            boolean bl2 = isSimple = isLeft && this.imageFontScaling == 1.0f && this.scalePixelsPerMicron == 0.0f && label.indexOf("|") < 0 && label.indexOf("\n") < 0 && label.indexOf("<su") < 0 && label.indexOf("<co") < 0;
            if (isSimple) {
                this.boxXY[0] = this.atomPt.sX;
                this.boxXY[1] = this.atomPt.sY;
                TextRenderer.renderSimpleLabel(this.g3d, this.font3d, label, this.labelColix, this.bgcolix, this.boxXY, this.zBox, this.zSlab, JC.getXOffset(this.offset), JC.getYOffset(this.offset), this.ascent, this.descent, pointerColix, this.doPointer == 0 ? 0 : this.vwr.getInt(553648147), this.mode);
                return null;
            }
            text = Text.newLabel(this.vwr, this.font3d, label, this.labelColix, this.bgcolix, this.textAlign, 0.0f);
            text.atomX = this.atomPt.sX;
            text.atomY = this.atomPt.sY;
            text.atomZ = this.zSlab;
            text.setXYZs(this.atomPt.sX, this.atomPt.sY, this.zBox, this.zSlab);
            newText = true;
        }
        if (text.pymolOffset == null) {
            if (text.font == null) {
                text.setFontFromFid(this.font3d.fid);
            }
            text.setOffset(this.offset);
            if (this.textAlign != 0) {
                text.setAlignment(this.textAlign);
            }
        }
        text.pointer = this.pointer;
        TextRenderer.render(null, (Text)text, (JmolRendererInterface)this.g3d, (float)this.scalePixelsPerMicron, (float)this.imageFontScaling, (float[])this.boxXY, (float[])this.xy, null, (short)pointerColix, (int)(this.doPointer == 0 ? 0 : this.vwr.getInt(553648147)), (int)this.mode);
        return newText ? text : null;
    }
}

