/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.modelset.Text;
import org.jmol.shape.TextShape;
import org.jmol.util.C;
import org.jmol.util.Font;

public class Echo
extends TextShape {
    private static final String FONTFACE = "Serif";
    private static final int FONTSIZE = 20;
    private static final short COLOR = 10;
    public Text scaleObject;

    @Override
    public void initShape() {
        this.setProperty("target", "top", null);
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if ("thisID" == propertyName) {
            if (value == null) {
                this.currentObject = null;
                this.thisID = null;
                return;
            }
            String target = (String)value;
            if (target == "%SCALE") {
                this.currentObject = this.scaleObject;
                this.thisID = target;
            } else {
                this.currentObject = (Text)this.objects.get(target);
                if (this.currentObject == null && PT.isWild(target)) {
                    this.thisID = target.toUpperCase();
                }
            }
            return;
        }
        if ("%SCALE" == propertyName) {
            this.currentObject = this.scaleObject = (Text)value;
            this.thisID = "%SCALE";
            return;
        }
        if (("color" == propertyName || "font" == propertyName) && this.scaleObject != null && this.currentObject == this.scaleObject) {
            Font f = this.currentFont;
            Object c = this.currentColor;
            this.setPropTS(propertyName, value, bs);
            this.currentFont = f;
            this.currentColor = c;
            return;
        }
        if ("off" == propertyName && this.currentObject == this.scaleObject) {
            this.scaleObject = null;
            this.currentObject = null;
            return;
        }
        if ("text" == propertyName && ((String)value).startsWith("%SCALE")) {
            this.thisID = "%SCALE";
            this.setPropTS("text", value, null);
            this.scaleObject = this.currentObject;
            if (this.scaleObject != null && this.objects.get(this.scaleObject.target) == this.scaleObject) {
                this.setPropTS("delete", this.scaleObject, null);
            }
            this.currentObject = this.scaleObject;
            return;
        }
        if ("target" == propertyName) {
            String target;
            if ("%SCALE".equals(value)) {
                this.currentObject = this.scaleObject;
                this.thisID = "%SCALE";
                if (this.currentObject != null) {
                    return;
                }
            }
            if ((target = ((String)value).intern().toLowerCase()) != "none" && target != "all") {
                Text text;
                this.isAll = false;
                Text text2 = text = this.thisID == "%SCALE" ? this.scaleObject : (Text)this.objects.get(target);
                if (text == null) {
                    int valign = 3;
                    int halign = 4;
                    if ("top" == target) {
                        valign = 0;
                        halign = 8;
                    } else if ("middle" == target) {
                        valign = 2;
                        halign = 8;
                    } else if ("bottom" == target) {
                        valign = 1;
                    } else if ("error" == target) {
                        valign = 0;
                    }
                    text = Text.newEcho(this.vwr, this.vwr.gdata.getFont3DFS(FONTFACE, 20.0f), target, (short)10, valign, halign, 0.0f);
                    text.adjustForWindow = true;
                    if (this.thisID == "%SCALE") {
                        this.scaleObject = text;
                    } else {
                        this.objects.put(target, text);
                        if (target.startsWith("_!_")) {
                            text.thisModelOnly = true;
                        }
                    }
                    if (this.currentFont != null) {
                        text.setFont(this.currentFont, true);
                    }
                    if (this.currentColor != null) {
                        text.colix = C.getColixO(this.currentColor);
                    }
                    if (this.currentBgColor != null) {
                        text.bgcolix = C.getColixO(this.currentBgColor);
                    }
                    if (this.currentTranslucentLevel != 0.0f) {
                        text.setTranslucent(this.currentTranslucentLevel, false);
                    }
                    if (this.currentBgTranslucentLevel != 0.0f) {
                        text.setTranslucent(this.currentBgTranslucentLevel, true);
                    }
                }
                this.currentObject = text;
                if (this.thisID != "%SCALE") {
                    this.thisID = null;
                }
                return;
            }
        }
        if ("scalereference" == propertyName) {
            if (this.currentObject != null) {
                float val = ((Float)value).floatValue();
                this.currentObject.setScalePixelsPerMicron(val == 0.0f ? 0.0f : 10000.0f / val);
            }
            return;
        }
        if ("point" == propertyName) {
            if (this.currentObject != null) {
                Iterator t = this.currentObject;
                ((Text)((Object)t)).pointerPt = value == null ? null : (P3)value;
                ((Text)((Object)t)).pointer = value == null ? 0 : 1;
            }
            return;
        }
        if ("xyz" == propertyName && this.currentObject != null) {
            if (this.vwr.getBoolean(603979845)) {
                this.currentObject.setScalePixelsPerMicron(this.vwr.getScalePixelsPerAngstrom(false) * 10000.0f);
            }
            this.currentObject.setXYZ((P3)value, true);
        }
        if ("scale" == propertyName) {
            if (this.currentObject != null) {
                this.currentObject.setScale(((Float)value).floatValue());
            } else if (this.isAll) {
                for (Text t : this.objects.values()) {
                    t.setScale(((Float)value).floatValue());
                }
            }
            return;
        }
        if ("image" == propertyName) {
            if (this.currentObject != null) {
                this.currentObject.setImage(value);
            } else if (this.isAll) {
                for (Text t : this.objects.values()) {
                    t.setImage(value);
                }
            }
            return;
        }
        if ("hidden" == propertyName) {
            boolean isHidden = (Boolean)value;
            if (this.currentObject != null) {
                this.currentObject.hidden = isHidden;
            } else if (this.isAll || this.thisID != null) {
                for (Text t : this.objects.values()) {
                    if (!this.isAll && !PT.isMatch(t.target.toUpperCase(), this.thisID, true, true)) continue;
                    t.hidden = isHidden;
                }
            }
            return;
        }
        if ("script" == propertyName) {
            if (this.currentObject != null) {
                this.currentObject.setScript((String)value);
            }
            return;
        }
        if ("xpos" == propertyName) {
            if (this.currentObject != null) {
                this.currentObject.setXYZ(null, true);
                this.currentObject.setMovableX((Integer)value);
            }
            return;
        }
        if ("ypos" == propertyName) {
            if (this.currentObject != null) {
                this.currentObject.setXYZ(null, true);
                this.currentObject.setMovableY((Integer)value);
            }
            return;
        }
        if ("%xpos" == propertyName) {
            if (this.currentObject != null) {
                this.currentObject.setXYZ(null, true);
                this.currentObject.setMovableXPercent((Integer)value);
            }
            return;
        }
        if ("%ypos" == propertyName) {
            if (this.currentObject != null) {
                this.currentObject.setXYZ(null, true);
                this.currentObject.setMovableYPercent((Integer)value);
            }
            return;
        }
        if ("%zpos" == propertyName) {
            if (this.currentObject != null) {
                this.currentObject.setXYZ(null, true);
                this.currentObject.setMovableZPercent((Integer)value);
            }
            return;
        }
        if ("xypos" == propertyName) {
            if (this.currentObject != null) {
                P3 pt = (P3)value;
                this.currentObject.setXYZ(null, true);
                if (pt.z == Float.MAX_VALUE) {
                    this.currentObject.setMovableX((int)pt.x);
                    this.currentObject.setMovableY((int)pt.y);
                } else {
                    this.currentObject.setMovableXPercent((int)pt.x);
                    this.currentObject.setMovableYPercent((int)pt.y);
                }
            }
            return;
        }
        if ("offset" == propertyName) {
            if (this.currentObject != null) {
                this.currentObject.pymolOffset = (float[])value;
            }
            return;
        }
        if ("align" == propertyName && this.currentObject != null) {
            this.currentObject.pymolOffset = null;
        }
        this.setPropTS(propertyName, value, null);
    }

    @Override
    public boolean getPropertyData(String property, Object[] data) {
        if ("currentTarget" == property) {
            return this.currentObject != null && (data[0] = this.currentObject.target) != null;
        }
        if (property == "%SCALE") {
            data[0] = this.scaleObject;
            return data[0] != null;
        }
        if (property == "checkID") {
            String key = ((String)data[0]).toUpperCase();
            boolean isWild = PT.isWild(key);
            for (Text t : this.objects.values()) {
                String id = t.target;
                if (!id.equalsIgnoreCase(key) && (!isWild || !PT.isMatch(id.toUpperCase(), key, true, true))) continue;
                data[1] = id;
                return true;
            }
            return false;
        }
        return this.getPropShape(property, data);
    }

    @Override
    public Object getShapeDetail() {
        Hashtable lst = new Hashtable();
        for (Map.Entry e : this.objects.entrySet()) {
            Object o;
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            Text t = (Text)e.getValue();
            String name = (String)e.getKey();
            info.put("boxXY", t.boxXY);
            if (t.xyz != null) {
                info.put("xyz", t.xyz);
            }
            if ((o = t.image) == null) {
                info.put("text", t.text == null ? "" : t.text);
            } else {
                info.put("imageFile", t.text);
                info.put("imageWidth", this.vwr.apiPlatform.getImageWidth(o));
                info.put("imageHeight", this.vwr.apiPlatform.getImageHeight(o));
            }
            lst.put(name, info);
        }
        Lst lst2 = new Lst();
        lst2.addLast(lst);
        return lst2;
    }
}

