
#ifndef KGLOBALACCELD_EXPORT_H
#define KGLOBALACCELD_EXPORT_H

#ifdef KGLOBALACCELD_STATIC_DEFINE
#  define KGLOBALACCELD_EXPORT
#  define KGLOBALACCELD_NO_EXPORT
#else
#  ifndef KGLOBALACCELD_EXPORT
#    ifdef KGlobalAccelD_EXPORTS
        /* We are building this library */
#      define KGLOBALACCELD_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KGLOBALACCELD_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KGLOBALACCELD_NO_EXPORT
#    define KGLOBALACCELD_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KGLOBALACCELD_DECL_DEPRECATED
#  define KGLOBALACCELD_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KGLOBALACCELD_DECL_DEPRECATED_EXPORT
#  define KGLOBALACCELD_DECL_DEPRECATED_EXPORT KGLOBALACCELD_EXPORT KGLOBALACCELD_DECL_DEPRECATED
#endif

#ifndef KGLOBALACCELD_DECL_DEPRECATED_NO_EXPORT
#  define KGLOBALACCELD_DECL_DEPRECATED_NO_EXPORT KGLOBALACCELD_NO_EXPORT KGLOBALACCELD_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KGLOBALACCELD_NO_DEPRECATED
#    define KGLOBALACCELD_NO_DEPRECATED
#  endif
#endif
#include <kglobalaccel_version.h>

#define KGLOBALACCELD_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KGLOBALACCELD_NO_DEPRECATED)
#  undef KGLOBALACCELD_DEPRECATED
#  define KGLOBALACCELD_DEPRECATED_EXPORT KGLOBALACCELD_EXPORT
#  define KGLOBALACCELD_DEPRECATED_NO_EXPORT KGLOBALACCELD_NO_EXPORT
#elif defined(KGLOBALACCELD_NO_DEPRECATED_WARNINGS)
#  define KGLOBALACCELD_DEPRECATED
#  define KGLOBALACCELD_DEPRECATED_EXPORT KGLOBALACCELD_EXPORT
#  define KGLOBALACCELD_DEPRECATED_NO_EXPORT KGLOBALACCELD_NO_EXPORT
#else
#  define KGLOBALACCELD_DEPRECATED KGLOBALACCELD_DECL_DEPRECATED
#  define KGLOBALACCELD_DEPRECATED_EXPORT KGLOBALACCELD_DECL_DEPRECATED_EXPORT
#  define KGLOBALACCELD_DEPRECATED_NO_EXPORT KGLOBALACCELD_DECL_DEPRECATED_NO_EXPORT
#endif

/* Build was done with the API removed deprecated before: 5.99.0 */
#define KGLOBALACCELD_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0x56300

#ifdef KGLOBALACCELD_DISABLE_DEPRECATED_BEFORE_AND_AT
#  if KGLOBALACCELD_DISABLE_DEPRECATED_BEFORE_AND_AT < KGLOBALACCELD_EXCLUDE_DEPRECATED_BEFORE_AND_AT
#    undef KGLOBALACCELD_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KGLOBALACCELD_DISABLE_DEPRECATED_BEFORE_AND_AT KGLOBALACCELD_EXCLUDE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif

#define KGLOBALACCELD_BUILD_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KGLOBALACCELD_EXCLUDE_DEPRECATED_BEFORE_AND_AT)

#ifdef KGLOBALACCELD_NO_DEPRECATED
#  define KGLOBALACCELD_DISABLE_DEPRECATED_BEFORE_AND_AT KGLOBALACCEL_VERSION
#endif
#ifdef KGLOBALACCELD_NO_DEPRECATED_WARNINGS
#  define KGLOBALACCELD_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KGLOBALACCELD_DEPRECATED_WARNINGS_SINCE
#  ifdef KGLOBALACCELD_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KGLOBALACCELD_DEPRECATED_WARNINGS_SINCE KGLOBALACCELD_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KGLOBALACCELD_DEPRECATED_WARNINGS_SINCE KGLOBALACCEL_VERSION
#  endif
#endif

#ifndef KGLOBALACCELD_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KGLOBALACCELD_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56300
#endif

#ifdef KGLOBALACCELD_DEPRECATED
#  define KGLOBALACCELD_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KGLOBALACCELD_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KGLOBALACCELD_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KGLOBALACCELD_DEPRECATED_WARNINGS_SINCE >= 0x40300
#  define KGLOBALACCELD_DEPRECATED_VERSION_4_3(text) KGLOBALACCELD_DECL_DEPRECATED_TEXT(text)
#else
#  define KGLOBALACCELD_DEPRECATED_VERSION_4_3(text)
#endif

#if KGLOBALACCELD_DEPRECATED_WARNINGS_SINCE >= 0x55a00
#  define KGLOBALACCELD_DEPRECATED_VERSION_5_90(text) KGLOBALACCELD_DECL_DEPRECATED_TEXT(text)
#else
#  define KGLOBALACCELD_DEPRECATED_VERSION_5_90(text)
#endif
#define KGLOBALACCELD_DEPRECATED_VERSION_4(minor, text)      KGLOBALACCELD_DEPRECATED_VERSION_4_##minor(text)
#define KGLOBALACCELD_DEPRECATED_VERSION_5(minor, text)      KGLOBALACCELD_DEPRECATED_VERSION_5_##minor(text)
#define KGLOBALACCELD_DEPRECATED_VERSION(major, minor, text) KGLOBALACCELD_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KGLOBALACCELD_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KGLOBALACCELD_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KGLOBALACCELD_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KGLOBALACCELD_DEPRECATED_VERSION(major, minor, text)
#  define KGLOBALACCELD_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KGLOBALACCELD_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KGLOBALACCELD_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KGLOBALACCELD_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KGLOBALACCELD_EXPORT_H */
