/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.ForeachStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;

public class RecoveredStatement
extends RecoveredElement {
    public Statement statement;
    RecoveredBlock nestedBlock;

    public RecoveredStatement(Statement statement, RecoveredElement recoveredElement, int n) {
        super(recoveredElement, n);
        this.statement = statement;
    }

    @Override
    public ASTNode parseTree() {
        return this.statement;
    }

    @Override
    public int sourceEnd() {
        return this.statement.sourceEnd;
    }

    @Override
    public String toString(int n) {
        return this.tabString(n) + "Recovered statement:\n" + this.statement.print(n + 1, new StringBuffer(10));
    }

    public Statement updatedStatement(int n, Set<TypeDeclaration> set) {
        if (this.nestedBlock != null) {
            this.nestedBlock.updatedStatement(n, set);
        }
        return this.statement;
    }

    @Override
    public void updateParseTree() {
        this.updatedStatement(0, new HashSet<TypeDeclaration>());
    }

    @Override
    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.statement.sourceEnd == 0) {
            this.statement.sourceEnd = n2;
        }
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n, n2);
            return this.parent.updateOnClosingBrace(n, n2);
        }
        return this;
    }

    @Override
    public RecoveredElement add(Block block, int n) {
        if (this.statement instanceof ForeachStatement) {
            ForeachStatement foreachStatement = (ForeachStatement)this.statement;
            this.resetPendingModifiers();
            if (foreachStatement.sourceEnd != 0 && foreachStatement.action != null && block.sourceStart > foreachStatement.sourceEnd) {
                return this.parent.add(block, n);
            }
            foreachStatement.action = block;
            RecoveredBlock recoveredBlock = new RecoveredBlock(block, (RecoveredElement)this, n);
            if (this.parser().statementRecoveryActivated) {
                this.addBlockStatement(recoveredBlock);
            }
            this.nestedBlock = recoveredBlock;
            if (block.sourceEnd == 0) {
                return recoveredBlock;
            }
            return this;
        }
        return super.add(block, n);
    }

    @Override
    public RecoveredElement add(Statement statement, int n) {
        if (this.statement instanceof ForeachStatement) {
            ForeachStatement foreachStatement = (ForeachStatement)this.statement;
            if (foreachStatement.action == null) {
                foreachStatement.action = statement;
                return this;
            }
        }
        return super.add(statement, n);
    }
}

