/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.util;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.apt.util.JrtFileSystem;

public class ModuleLocationHandler {
    Map<JavaFileManager.Location, LocationContainer> containers = new HashMap<JavaFileManager.Location, LocationContainer>();

    ModuleLocationHandler() {
    }

    public void newSystemLocation(JavaFileManager.Location location, JrtFileSystem jrtFileSystem) throws IOException {
        SystemLocationContainer systemLocationContainer = new SystemLocationContainer(StandardLocation.SYSTEM_MODULES, jrtFileSystem);
        this.containers.put(location, systemLocationContainer);
    }

    public LocationWrapper getLocation(JavaFileManager.Location location, String string) {
        LocationContainer locationContainer;
        if (location instanceof LocationWrapper) {
            location = ((LocationWrapper)location).loc;
        }
        if ((locationContainer = this.containers.get(location)) != null) {
            return locationContainer.get(string);
        }
        return null;
    }

    public JavaFileManager.Location getLocation(JavaFileManager.Location location, Path path) {
        LocationContainer locationContainer = this.containers.get(location);
        if (locationContainer != null) {
            return locationContainer.get(path);
        }
        return null;
    }

    public LocationContainer getLocation(JavaFileManager.Location location) {
        return this.containers.get(location);
    }

    public void setLocation(JavaFileManager.Location location, Iterable<? extends Path> iterable) {
        LocationContainer locationContainer = this.containers.get(location);
        if (locationContainer == null) {
            locationContainer = new LocationContainer(location);
            this.containers.put(location, locationContainer);
        }
        locationContainer.setPaths(iterable);
    }

    public void setLocation(JavaFileManager.Location location, String string, Iterable<? extends Path> iterable) {
        LocationWrapper locationWrapper = null;
        LocationContainer locationContainer = this.containers.get(location);
        if (locationContainer != null) {
            locationWrapper = locationContainer.get(string);
        } else {
            locationContainer = new LocationContainer(location);
            this.containers.put(location, locationContainer);
        }
        if (locationWrapper == null) {
            if (string.equals("")) {
                locationWrapper = new LocationWrapper(location, location.isOutputLocation(), iterable);
            } else {
                locationWrapper = new ModuleLocationWrapper(location, string, location.isOutputLocation(), iterable);
                for (Path path : iterable) {
                    locationContainer.put(path, locationWrapper);
                }
            }
        } else {
            locationWrapper.setPaths(iterable);
        }
        locationContainer.put(string, locationWrapper);
    }

    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) {
        LocationContainer locationContainer = this.containers.get(location);
        if (locationContainer == null) {
            return Collections.emptyList();
        }
        HashSet<LocationWrapper> hashSet = new HashSet<LocationWrapper>(locationContainer.locationNames.values());
        List<Set<JavaFileManager.Location>> list = Collections.singletonList(hashSet);
        return list;
    }

    public void close() {
        Collection<LocationContainer> collection = this.containers.values();
        for (LocationContainer locationContainer : collection) {
            locationContainer.clear();
        }
    }

    class ModuleLocationWrapper
    extends LocationWrapper {
        String modName;

        public ModuleLocationWrapper(JavaFileManager.Location location, String string, boolean bl, Iterable<? extends Path> iterable) {
            super(location, bl, iterable);
            this.modName = string;
        }

        @Override
        public String getName() {
            return this.loc.getName() + "[" + this.modName + "]";
        }

        @Override
        public boolean isOutputLocation() {
            return this.output;
        }

        @Override
        Iterable<? extends Path> getPaths() {
            return this.paths;
        }

        @Override
        public String toString() {
            return this.loc.toString() + "[" + this.modName + "]";
        }
    }

    class LocationWrapper
    implements JavaFileManager.Location {
        JavaFileManager.Location loc;
        boolean output;
        List<? extends Path> paths;

        LocationWrapper() {
        }

        public LocationWrapper(JavaFileManager.Location location, boolean bl, Iterable<? extends Path> iterable) {
            this.loc = location;
            this.output = bl;
            this.setPaths(iterable);
        }

        @Override
        public String getName() {
            return this.loc.getName();
        }

        @Override
        public boolean isOutputLocation() {
            return this.output;
        }

        Iterable<? extends Path> getPaths() {
            return this.paths;
        }

        void setPaths(Iterable<? extends Path> iterable) {
            if (iterable == null) {
                this.paths = null;
            } else {
                ArrayList<Path> arrayList = new ArrayList<Path>();
                for (Path path : iterable) {
                    arrayList.add(path);
                }
                this.paths = Collections.unmodifiableList(arrayList);
            }
        }

        public String toString() {
            return this.loc.toString() + "[]";
        }
    }

    class SystemLocationContainer
    extends LocationContainer {
        public SystemLocationContainer(JavaFileManager.Location location, JrtFileSystem jrtFileSystem) throws IOException {
            super(location);
            jrtFileSystem.initialize();
            HashMap<String, Path> hashMap = jrtFileSystem.modulePathMap;
            Set<String> set = hashMap.keySet();
            for (String string : set) {
                Path path = jrtFileSystem.file.toPath();
                ModuleLocationWrapper moduleLocationWrapper = new ModuleLocationWrapper(location, string, false, Collections.singletonList(path));
                this.locationNames.put(string, moduleLocationWrapper);
                this.locationPaths.put(path, moduleLocationWrapper);
            }
        }
    }

    class LocationContainer
    extends LocationWrapper {
        Map<String, LocationWrapper> locationNames;
        Map<Path, LocationWrapper> locationPaths;

        LocationContainer(JavaFileManager.Location location) {
            this.loc = location;
            this.locationNames = new HashMap<String, LocationWrapper>();
            this.locationPaths = new HashMap<Path, LocationWrapper>();
        }

        LocationWrapper get(String string) {
            return this.locationNames.get(string);
        }

        void put(String string, LocationWrapper locationWrapper) {
            this.locationNames.put(string, locationWrapper);
            this.paths = null;
        }

        void put(Path path, LocationWrapper locationWrapper) {
            this.locationPaths.put(path, locationWrapper);
            this.paths = null;
        }

        JavaFileManager.Location get(Path path) {
            return this.locationPaths.get(path);
        }

        @Override
        void setPaths(Iterable<? extends Path> iterable) {
            super.setPaths(iterable);
            this.clear();
        }

        @Override
        Iterable<? extends Path> getPaths() {
            if (this.paths != null) {
                return this.paths;
            }
            return this.locationPaths.keySet();
        }

        public void clear() {
            this.locationNames.clear();
            this.locationPaths.clear();
        }
    }
}

