/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class ProvidesStatement
extends ModuleStatement {
    public TypeReference serviceInterface;
    public TypeReference[] implementations;

    public boolean resolve(BlockScope blockScope) {
        ModuleDeclaration moduleDeclaration = blockScope.referenceCompilationUnit().moduleDeclaration;
        SourceModuleBinding sourceModuleBinding = moduleDeclaration.binding;
        TypeBinding typeBinding = this.serviceInterface.resolveType(blockScope);
        boolean bl = false;
        if (typeBinding == null || !typeBinding.isValidBinding()) {
            return false;
        }
        if (!(typeBinding.isClass() || typeBinding.isInterface() || typeBinding.isAnnotationType())) {
            blockScope.problemReporter().invalidServiceRef(8389924, this.serviceInterface);
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.serviceInterface.resolvedType;
        HashSet<ReferenceBinding> hashSet = new HashSet<ReferenceBinding>();
        for (int i = 0; i < this.implementations.length; ++i) {
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.implementations[i].resolveType(blockScope);
            if (referenceBinding2 == null || !referenceBinding2.isValidBinding() || !referenceBinding2.canBeSeenBy(blockScope)) {
                bl = true;
                continue;
            }
            if (!hashSet.add(referenceBinding2)) {
                blockScope.problemReporter().duplicateTypeReference(8389912, this.implementations[i]);
                continue;
            }
            int n = 0;
            ModuleBinding moduleBinding = referenceBinding2.module();
            if (moduleBinding != sourceModuleBinding) {
                n = 16778526;
            } else if (!referenceBinding2.isClass() && !referenceBinding2.isInterface()) {
                n = 8389925;
            } else if (referenceBinding2.isNestedType() && !referenceBinding2.isStatic()) {
                n = 16778525;
            } else {
                Binding binding;
                MethodBinding methodBinding = referenceBinding2.getExactMethod(TypeConstants.PROVIDER, Binding.NO_PARAMETERS, blockScope.compilationUnitScope());
                if (!(methodBinding == null || methodBinding.isValidBinding() && methodBinding.isPublic() && methodBinding.isStatic())) {
                    methodBinding = null;
                }
                TypeBinding typeBinding2 = referenceBinding2;
                if (methodBinding != null) {
                    typeBinding2 = methodBinding.returnType;
                    if (typeBinding2 instanceof ReferenceBinding && !typeBinding2.canBeSeenBy(blockScope)) {
                        binding = (ReferenceBinding)typeBinding2;
                        blockScope.problemReporter().invalidType(this.implementations[i], new ProblemReferenceBinding(((ReferenceBinding)binding).compoundName, (ReferenceBinding)binding, 2));
                        bl = true;
                    }
                } else if (referenceBinding2.isAbstract()) {
                    n = 16778522;
                } else {
                    binding = referenceBinding2.getExactConstructor(Binding.NO_PARAMETERS);
                    if (binding == null || !binding.isValidBinding()) {
                        n = 16778523;
                    } else if (!((MethodBinding)binding).isPublic()) {
                        n = 16778524;
                    }
                }
                if (typeBinding2.findSuperTypeOriginatingFrom(referenceBinding) == null) {
                    blockScope.problemReporter().typeMismatchError(typeBinding2, referenceBinding, this.implementations[i], null);
                    bl = true;
                }
            }
            if (n == 0) continue;
            blockScope.problemReporter().invalidServiceRef(n, this.implementations[i]);
            bl = true;
        }
        return bl;
    }

    public List<TypeBinding> getResolvedImplementations() {
        ArrayList<TypeBinding> arrayList = new ArrayList<TypeBinding>();
        if (this.implementations != null) {
            for (TypeReference typeReference : this.implementations) {
                TypeBinding typeBinding = typeReference.resolvedType;
                if (typeBinding == null) continue;
                arrayList.add(typeBinding);
            }
        }
        return arrayList;
    }

    @Override
    public StringBuffer print(int n, StringBuffer stringBuffer) {
        ProvidesStatement.printIndent(n, stringBuffer);
        stringBuffer.append("provides ");
        this.serviceInterface.print(0, stringBuffer);
        stringBuffer.append(" with ");
        for (int i = 0; i < this.implementations.length; ++i) {
            this.implementations[i].print(0, stringBuffer);
            if (i >= this.implementations.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(";");
        return stringBuffer;
    }
}

