/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.opensearch.neuralsearch.query.HybridQueryWeight;

public final class HybridQuery
extends Query
implements Iterable<Query> {
    private final List<Query> subQueries;

    public HybridQuery(Collection<Query> subQueries) {
        Objects.requireNonNull(subQueries, "collection of queries must not be null");
        if (subQueries.isEmpty()) {
            throw new IllegalArgumentException("collection of queries must not be empty");
        }
        this.subQueries = new ArrayList<Query>(subQueries);
    }

    @Override
    public Iterator<Query> iterator() {
        return this.getSubQueries().iterator();
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        Iterator<Query> it = this.subQueries.iterator();
        int i = 0;
        while (it.hasNext()) {
            Query subquery = it.next();
            if (subquery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subquery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subquery.toString(field));
            }
            if (i != this.subQueries.size() - 1) {
                buffer.append(" | ");
            }
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.subQueries.isEmpty()) {
            return new MatchNoDocsQuery("empty HybridQuery");
        }
        boolean actuallyRewritten = false;
        ArrayList<Query> rewrittenSubQueries = new ArrayList<Query>();
        for (Query subQuery : this.subQueries) {
            Query rewrittenSub = subQuery.rewrite(reader);
            actuallyRewritten |= rewrittenSub != subQuery;
            rewrittenSubQueries.add(rewrittenSub);
        }
        if (actuallyRewritten) {
            return new HybridQuery(rewrittenSubQueries);
        }
        return super.rewrite(reader);
    }

    public void visit(QueryVisitor queryVisitor) {
        QueryVisitor v = queryVisitor.getSubVisitor(BooleanClause.Occur.SHOULD, (Query)this);
        for (Query q : this.subQueries) {
            q.visit(v);
        }
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((HybridQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(HybridQuery other) {
        return Objects.equals(this.subQueries, other.subQueries);
    }

    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + Objects.hashCode(this.subQueries);
        return h;
    }

    public Collection<Query> getSubQueries() {
        return Collections.unmodifiableCollection(this.subQueries);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new HybridQueryWeight(this, searcher, scoreMode, boost);
    }
}

