/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import net.sf.sdedit.ui.components.AutoCompletion;

public class AutoCompletionComboboxEditor
implements ComboBoxEditor,
AutoCompletion.SuggestionProvider {
    private JComboBox box;
    private JTextField textField;

    public AutoCompletionComboboxEditor(JComboBox box) {
        this.box = box;
        this.textField = new JTextField();
        new AutoCompletion(this.textField, this, new char[0]);
    }

    private String[] getStrings() {
        int n = this.box.getModel().getSize();
        String[] strings = new String[n];
        for (int i = 0; i < n; ++i) {
            strings[i] = this.box.getModel().getElementAt(i).toString();
        }
        return strings;
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.textField.addActionListener(l);
    }

    @Override
    public Component getEditorComponent() {
        return this.textField;
    }

    @Override
    public Object getItem() {
        return this.textField.getText();
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.textField.removeActionListener(l);
    }

    @Override
    public void selectAll() {
        this.textField.selectAll();
    }

    @Override
    public void setItem(Object anObject) {
        this.textField.setText(anObject == null ? "" : anObject.toString());
    }

    @Override
    public List<String> getSuggestions(String prefix) {
        String regexp = "^" + prefix.replaceAll("\\*", ".*") + ".*$";
        Pattern pattern = Pattern.compile(regexp, 2);
        LinkedList<String> suggestions = new LinkedList<String>();
        for (String str : this.getStrings()) {
            if (!pattern.matcher(str).matches()) continue;
            suggestions.add(str);
        }
        return suggestions;
    }
}

