/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tim.prune.FunctionLibrary;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.config.TimezoneHelper;
import tim.prune.data.AltitudeRange;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.Selection;
import tim.prune.data.SourceInfo;
import tim.prune.data.SpeedCalculator;
import tim.prune.data.SpeedValue;
import tim.prune.data.TrackInfo;
import tim.prune.data.Unit;
import tim.prune.data.UnitSet;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.AudioListener;
import tim.prune.gui.CoordDisplay;
import tim.prune.gui.DisplayUtils;
import tim.prune.gui.FunctionLauncher;
import tim.prune.gui.GenericDisplay;
import tim.prune.gui.IconManager;
import tim.prune.gui.PhotoThumbnail;

public class DetailsDisplay
extends GenericDisplay {
    private JLabel _indexLabel = null;
    private JLabel _latLabel = null;
    private JLabel _longLabel = null;
    private JLabel _altLabel = null;
    private JLabel _ptDateLabel = null;
    private JLabel _ptTimeLabel = null;
    private JLabel _descLabel = null;
    private JLabel _speedLabel = null;
    private JLabel _vSpeedLabel = null;
    private JLabel _nameLabel = null;
    private JLabel _typeLabel = null;
    private JLabel _filenameLabel = null;
    private JLabel _rangeLabel = null;
    private JLabel _distanceLabel = null;
    private JLabel _durationLabel = null;
    private JLabel _altRangeLabel = null;
    private JLabel _updownLabel = null;
    private JLabel _aveSpeedLabel = null;
    private JPanel _photoDetailsPanel = null;
    private JLabel _photoLabel = null;
    private JLabel _photoPathLabel = null;
    private PhotoThumbnail _photoThumbnail = null;
    private JLabel _photoTimestampLabel = null;
    private JLabel _photoConnectedLabel = null;
    private JLabel _photoBearingLabel = null;
    private JPanel _rotationButtons = null;
    private JPanel _audioDetailsPanel = null;
    private JLabel _audioLabel = null;
    private JLabel _audioPathLabel = null;
    private JLabel _audioConnectedLabel = null;
    private JLabel _audioTimestampLabel = null;
    private JLabel _audioLengthLabel = null;
    private JProgressBar _audioProgress = null;
    private JPanel _playAudioPanel = null;
    private JComboBox<String> _coordFormatDropdown = null;
    private JComboBox<String> _distUnitsDropdown = null;
    private TimeZone _timezone = null;
    private static final String LABEL_POINT_SELECTED = String.valueOf(I18nManager.getText("details.index.selected")) + ": ";
    private static final String LABEL_POINT_LATITUDE = String.valueOf(I18nManager.getText("fieldname.latitude")) + ": ";
    private static final String LABEL_POINT_LONGITUDE = String.valueOf(I18nManager.getText("fieldname.longitude")) + ": ";
    private static final String LABEL_POINT_ALTITUDE = String.valueOf(I18nManager.getText("fieldname.altitude")) + ": ";
    private static final String LABEL_POINT_DATE = String.valueOf(I18nManager.getText("fieldname.date")) + ": ";
    private static final String LABEL_POINT_TIME = String.valueOf(I18nManager.getText("fieldname.timestamp")) + ": ";
    private static final String LABEL_POINT_WAYPOINTNAME = String.valueOf(I18nManager.getText("fieldname.waypointname")) + ": ";
    private static final String LABEL_POINT_WAYPOINTTYPE = String.valueOf(I18nManager.getText("fieldname.waypointtype")) + ": ";
    private static final String LABEL_POINT_DESCRIPTION = String.valueOf(I18nManager.getText("fieldname.description")) + ": ";
    private static final String LABEL_POINT_SPEED = String.valueOf(I18nManager.getText("fieldname.speed")) + ": ";
    private static final String LABEL_POINT_VERTSPEED = String.valueOf(I18nManager.getText("fieldname.verticalspeed")) + ": ";
    private static final String LABEL_POINT_FILENAME = String.valueOf(I18nManager.getText("details.track.file")) + ": ";
    private static final String LABEL_RANGE_SELECTED = String.valueOf(I18nManager.getText("details.range.selected")) + ": ";
    private static final String LABEL_RANGE_DURATION = String.valueOf(I18nManager.getText("fieldname.duration")) + ": ";
    private static final String LABEL_RANGE_DISTANCE = String.valueOf(I18nManager.getText("fieldname.distance")) + ": ";
    private static final String LABEL_RANGE_ALTITUDE = String.valueOf(I18nManager.getText("fieldname.altitude")) + ": ";
    private static final String LABEL_RANGE_CLIMB = String.valueOf(I18nManager.getText("details.range.climb")) + ": ";
    private static final String LABEL_RANGE_DESCENT = ", " + I18nManager.getText("details.range.descent") + ": ";
    private static final String LABEL_AUDIO_FILE = String.valueOf(I18nManager.getText("details.audio.file")) + ": ";
    private static final String LABEL_FULL_PATH = String.valueOf(I18nManager.getText("details.media.fullpath")) + ": ";

    public DetailsDisplay(TrackInfo trackInfo) {
        super(trackInfo);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        Font font = new JLabel().getFont();
        font = font.deriveFont(1, font.getSize2D() + 2.0f);
        JPanel jPanel2 = DetailsDisplay.makeDetailsPanel("details.pointdetails", font);
        this._indexLabel = new JLabel(I18nManager.getText("details.nopointselection"));
        jPanel2.add(this._indexLabel);
        this._latLabel = new JLabel("");
        jPanel2.add(this._latLabel);
        this._longLabel = new JLabel("");
        jPanel2.add(this._longLabel);
        this._altLabel = new JLabel("");
        jPanel2.add(this._altLabel);
        this._ptDateLabel = new JLabel("");
        this._ptDateLabel.setMinimumSize(new Dimension(120, 10));
        jPanel2.add(this._ptDateLabel);
        this._ptTimeLabel = new JLabel("");
        this._ptTimeLabel.setMinimumSize(new Dimension(120, 10));
        jPanel2.add(this._ptTimeLabel);
        this._descLabel = new JLabel("");
        jPanel2.add(this._descLabel);
        this._speedLabel = new JLabel("");
        jPanel2.add(this._speedLabel);
        this._vSpeedLabel = new JLabel("");
        jPanel2.add(this._vSpeedLabel);
        this._nameLabel = new JLabel("");
        jPanel2.add(this._nameLabel);
        this._typeLabel = new JLabel("");
        jPanel2.add(this._typeLabel);
        this._filenameLabel = new JLabel("");
        jPanel2.add(this._filenameLabel);
        jPanel2.setAlignmentX(0.0f);
        JPanel jPanel3 = DetailsDisplay.makeDetailsPanel("details.rangedetails", font);
        this._rangeLabel = new JLabel(I18nManager.getText("details.norangeselection"));
        jPanel3.add(this._rangeLabel);
        this._distanceLabel = new JLabel("");
        jPanel3.add(this._distanceLabel);
        this._durationLabel = new JLabel("");
        jPanel3.add(this._durationLabel);
        this._aveSpeedLabel = new JLabel("");
        jPanel3.add(this._aveSpeedLabel);
        this._altRangeLabel = new JLabel("");
        jPanel3.add(this._altRangeLabel);
        this._updownLabel = new JLabel("");
        jPanel3.add(this._updownLabel);
        jPanel3.setAlignmentX(0.0f);
        this._photoDetailsPanel = DetailsDisplay.makeDetailsPanel("details.photodetails", font);
        this._photoLabel = new JLabel(I18nManager.getText("details.nophoto"));
        this._photoDetailsPanel.add(this._photoLabel);
        this._photoPathLabel = new JLabel("");
        this._photoDetailsPanel.add(this._photoPathLabel);
        this._photoTimestampLabel = new JLabel("");
        this._photoTimestampLabel.setMinimumSize(new Dimension(120, 10));
        this._photoDetailsPanel.add(this._photoTimestampLabel);
        this._photoConnectedLabel = new JLabel("");
        this._photoDetailsPanel.add(this._photoConnectedLabel);
        this._photoBearingLabel = new JLabel("");
        this._photoDetailsPanel.add(this._photoBearingLabel);
        this._photoThumbnail = new PhotoThumbnail();
        this._photoThumbnail.setVisible(false);
        this._photoThumbnail.setPreferredSize(new Dimension(100, 100));
        this._photoDetailsPanel.add(this._photoThumbnail);
        JButton jButton = DetailsDisplay.makeRotateButton("controls/rotate-left", FunctionLibrary.FUNCTION_ROTATE_PHOTO_LEFT);
        JButton jButton2 = DetailsDisplay.makeRotateButton("controls/rotate-right", FunctionLibrary.FUNCTION_ROTATE_PHOTO_RIGHT);
        JButton jButton3 = DetailsDisplay.makeRotateButton("controls/show-image", FunctionLibrary.FUNCTION_PHOTO_POPUP);
        this._rotationButtons = new JPanel();
        this._rotationButtons.add(jButton);
        this._rotationButtons.add(jButton2);
        this._rotationButtons.add(Box.createHorizontalStrut(10));
        this._rotationButtons.add(jButton3);
        this._rotationButtons.setAlignmentX(0.0f);
        this._rotationButtons.setVisible(false);
        this._photoDetailsPanel.add(this._rotationButtons);
        this._photoDetailsPanel.setVisible(false);
        this._audioDetailsPanel = DetailsDisplay.makeDetailsPanel("details.audiodetails", font);
        this._audioLabel = new JLabel(I18nManager.getText("details.noaudio"));
        this._audioDetailsPanel.add(this._audioLabel);
        this._audioPathLabel = new JLabel("");
        this._audioDetailsPanel.add(this._audioPathLabel);
        this._audioTimestampLabel = new JLabel("");
        this._audioTimestampLabel.setMinimumSize(new Dimension(120, 10));
        this._audioDetailsPanel.add(this._audioTimestampLabel);
        this._audioLengthLabel = new JLabel("");
        this._audioDetailsPanel.add(this._audioLengthLabel);
        this._audioConnectedLabel = new JLabel("");
        this._audioDetailsPanel.add(this._audioConnectedLabel);
        this._audioProgress = new JProgressBar(0, 100);
        this._audioProgress.setString(I18nManager.getText("details.audio.playing"));
        this._audioProgress.setStringPainted(true);
        this._audioProgress.setVisible(false);
        this._audioDetailsPanel.add(this._audioProgress);
        this._playAudioPanel = new JPanel();
        this._playAudioPanel.setLayout(new FlowLayout(2));
        JButton jButton4 = DetailsDisplay.makeRotateButton("controls/play", FunctionLibrary.FUNCTION_PLAY_AUDIO);
        jButton4.addActionListener(new AudioListener(this._audioProgress));
        this._playAudioPanel.add(jButton4);
        JButton jButton5 = DetailsDisplay.makeRotateButton("controls/stop", FunctionLibrary.FUNCTION_STOP_AUDIO);
        this._playAudioPanel.add(jButton5);
        this._playAudioPanel.setAlignmentX(0.0f);
        this._playAudioPanel.setVisible(false);
        this._audioDetailsPanel.add(this._playAudioPanel);
        this._audioDetailsPanel.setVisible(false);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this._photoDetailsPanel);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this._audioDetailsPanel);
        jPanel.add(Box.createVerticalStrut(5));
        this.add((Component)jPanel, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("details.coordformat")) + ": ");
        jLabel.setAlignmentX(0.0f);
        jPanel4.add(jLabel);
        String[] stringArray = new String[]{I18nManager.getText("units.original"), I18nManager.getText("units.degminsec"), I18nManager.getText("units.degmin"), I18nManager.getText("units.deg")};
        this._coordFormatDropdown = new JComboBox<String>(stringArray);
        this._coordFormatDropdown.addActionListener(actionEvent -> this.dataUpdated(32));
        jPanel4.add(this._coordFormatDropdown);
        this._coordFormatDropdown.setAlignmentX(0.0f);
        JLabel jLabel2 = new JLabel(String.valueOf(I18nManager.getText("details.distanceunits")) + ": ");
        jLabel2.setAlignmentX(0.0f);
        jPanel4.add(jLabel2);
        this._distUnitsDropdown = new JComboBox();
        UnitSet unitSet = Config.getUnitSet();
        int n = 0;
        while (n < UnitSetLibrary.getNumUnitSets()) {
            this._distUnitsDropdown.addItem(I18nManager.getText(UnitSetLibrary.getUnitSet(n).getDistanceUnit().getNameKey()));
            if (UnitSetLibrary.getUnitSet(n) == unitSet) {
                this._distUnitsDropdown.setSelectedIndex(n);
            }
            ++n;
        }
        this._distUnitsDropdown.addActionListener(actionEvent -> {
            Config.selectUnitSet(this._distUnitsDropdown.getSelectedIndex());
            UpdateMessageBroker.informSubscribers(32);
        });
        jPanel4.add(this._distUnitsDropdown);
        this._distUnitsDropdown.setAlignmentX(0.0f);
        this.add((Component)jPanel4, "South");
    }

    @Override
    public void dataUpdated(int n) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DataPoint dataPoint = this._trackInfo.getCurrentPoint();
        Selection selection = this._trackInfo.getSelection();
        if ((n | 1) > 0) {
            selection.markInvalid();
        }
        int n2 = selection.getCurrentPointIndex();
        this._speedLabel.setText("");
        UnitSet unitSet = UnitSetLibrary.getUnitSet(this._distUnitsDropdown.getSelectedIndex());
        String string2 = I18nManager.getText(unitSet.getDistanceUnit().getShortnameKey());
        String string3 = I18nManager.getText(unitSet.getSpeedUnit().getShortnameKey());
        if (this._timezone == null || (n | 0x20) > 0) {
            this._timezone = TimezoneHelper.getSelectedTimezone();
        }
        if ((n | 0x20) > 0) {
            Config.setConfigString("prune.coorddisplay", "" + this.getSelectedCoordFormat());
        }
        if (this._track == null || dataPoint == null) {
            this._indexLabel.setText(I18nManager.getText("details.nopointselection"));
            this._latLabel.setText("");
            this._longLabel.setText("");
            this._altLabel.setText("");
            this._ptDateLabel.setText("");
            this._ptTimeLabel.setText("");
            this._descLabel.setText("");
            this._nameLabel.setText("");
            this._typeLabel.setText("");
            this._speedLabel.setText("");
            this._vSpeedLabel.setText("");
            this._filenameLabel.setText("");
        } else {
            SourceInfo sourceInfo;
            this._indexLabel.setText(String.valueOf(LABEL_POINT_SELECTED) + (n2 + 1) + " " + I18nManager.getText("details.index.of") + " " + this._track.getNumPoints());
            this._latLabel.setText(String.valueOf(LABEL_POINT_LATITUDE) + CoordDisplay.makeCoordinateLabel(dataPoint.getLatitude(), this.getSelectedCoordFormat()));
            this._longLabel.setText(String.valueOf(LABEL_POINT_LONGITUDE) + CoordDisplay.makeCoordinateLabel(dataPoint.getLongitude(), this.getSelectedCoordFormat()));
            object4 = Config.getUnitSet().getAltitudeUnit();
            this._altLabel.setText(dataPoint.hasAltitude() ? String.valueOf(LABEL_POINT_ALTITUDE) + dataPoint.getAltitude().getValue((Unit)object4) + " " + I18nManager.getText(((Unit)object4).getShortnameKey()) : "");
            if (dataPoint.hasTimestamp()) {
                this._ptDateLabel.setText(String.valueOf(LABEL_POINT_DATE) + dataPoint.getTimestamp().getDateText(this._timezone));
                this._ptTimeLabel.setText(String.valueOf(LABEL_POINT_TIME) + dataPoint.getTimestamp().getTimeText(this._timezone));
            } else {
                this._ptDateLabel.setText("");
                this._ptTimeLabel.setText("");
            }
            object3 = dataPoint.getFieldValue(Field.DESCRIPTION);
            if (object3 == null || ((String)object3).equals("") || dataPoint.hasMedia()) {
                this._descLabel.setText("");
                this._descLabel.setToolTipText("");
            } else {
                if (((String)object3).length() < 5) {
                    this._descLabel.setText(String.valueOf(LABEL_POINT_DESCRIPTION) + (String)object3);
                } else {
                    this._descLabel.setText(DetailsDisplay.shortenString((String)object3));
                }
                this._descLabel.setToolTipText((String)object3);
            }
            object2 = new SpeedValue();
            SpeedCalculator.calculateSpeed(this._track, n2, (SpeedValue)object2);
            if (((SpeedValue)object2).isValid()) {
                object = String.valueOf(DisplayUtils.roundedNumber(((SpeedValue)object2).getValue())) + " " + string3;
                this._speedLabel.setText(String.valueOf(LABEL_POINT_SPEED) + (String)object);
            } else {
                this._speedLabel.setText("");
            }
            SpeedCalculator.calculateVerticalSpeed(this._track, n2, (SpeedValue)object2);
            if (((SpeedValue)object2).isValid()) {
                object = I18nManager.getText(unitSet.getVerticalSpeedUnit().getShortnameKey());
                string = String.valueOf(DisplayUtils.roundedNumber(((SpeedValue)object2).getValue())) + " " + (String)object;
                this._vSpeedLabel.setText(String.valueOf(LABEL_POINT_VERTSPEED) + string);
            } else {
                this._vSpeedLabel.setText("");
            }
            object = dataPoint.getWaypointName();
            if (object != null && !((String)object).equals("")) {
                this._nameLabel.setText(String.valueOf(LABEL_POINT_WAYPOINTNAME) + (String)object);
            } else {
                this._nameLabel.setText("");
            }
            string = dataPoint.getFieldValue(Field.WAYPT_TYPE);
            if (string != null && !string.equals("")) {
                this._typeLabel.setText(String.valueOf(LABEL_POINT_WAYPOINTTYPE) + string);
            } else {
                this._typeLabel.setText("");
            }
            int n3 = this._trackInfo.getFileInfo().getNumFiles();
            String string4 = null;
            if (n3 > 1 && (sourceInfo = dataPoint.getSourceInfo()) != null) {
                string4 = sourceInfo.getName();
            }
            if (string4 != null) {
                this._filenameLabel.setText(String.valueOf(LABEL_POINT_FILENAME) + string4);
                this._filenameLabel.setToolTipText(string4);
            } else {
                this._filenameLabel.setText("");
                this._filenameLabel.setToolTipText("");
            }
        }
        if (this._track == null || !selection.hasRangeSelected()) {
            this._rangeLabel.setText(I18nManager.getText("details.norangeselection"));
            this._distanceLabel.setText("");
            this._durationLabel.setText("");
            this._altRangeLabel.setText("");
            this._updownLabel.setText("");
            this._aveSpeedLabel.setText("");
        } else {
            this._rangeLabel.setText(String.valueOf(LABEL_RANGE_SELECTED) + (selection.getStart() + 1) + " " + I18nManager.getText("details.range.to") + " " + (selection.getEnd() + 1));
            this._distanceLabel.setText(String.valueOf(LABEL_RANGE_DISTANCE) + DisplayUtils.roundedNumber(selection.getMovingDistance()) + " " + string2);
            long l = selection.getMovingSeconds();
            if (l > 0L) {
                this._durationLabel.setText(String.valueOf(LABEL_RANGE_DURATION) + DisplayUtils.buildDurationString(l));
                this._aveSpeedLabel.setText(String.valueOf(I18nManager.getText("details.range.avespeed")) + ": " + DisplayUtils.roundedNumber(selection.getMovingDistance() / (double)l * 3600.0) + " " + string3);
            } else {
                this._durationLabel.setText("");
                this._aveSpeedLabel.setText("");
            }
            object2 = selection.getAltitudeRange();
            object = Config.getUnitSet().getAltitudeUnit();
            string = I18nManager.getText(((Unit)object).getShortnameKey());
            if (((AltitudeRange)object2).hasRange()) {
                this._altRangeLabel.setText(String.valueOf(LABEL_RANGE_ALTITUDE) + ((AltitudeRange)object2).getMinimum((Unit)object) + string + " " + I18nManager.getText("details.altitude.to") + " " + ((AltitudeRange)object2).getMaximum((Unit)object) + string);
                this._updownLabel.setText(String.valueOf(LABEL_RANGE_CLIMB) + ((AltitudeRange)object2).getClimb((Unit)object) + string + LABEL_RANGE_DESCENT + ((AltitudeRange)object2).getDescent((Unit)object) + string);
            } else {
                this._altRangeLabel.setText("");
                this._updownLabel.setText("");
            }
        }
        this._photoDetailsPanel.setVisible(this._trackInfo.getPhotoList().hasAny());
        object4 = this._trackInfo.getPhotoList().get(this._trackInfo.getSelection().getCurrentPhotoIndex());
        if ((dataPoint == null || dataPoint.getPhoto() == null) && object4 == null) {
            this._photoLabel.setText(I18nManager.getText("details.nophoto"));
            this._photoPathLabel.setText("");
            this._photoPathLabel.setToolTipText("");
            this._photoTimestampLabel.setText("");
            this._photoConnectedLabel.setText("");
            this._photoBearingLabel.setText("");
            this._photoThumbnail.setVisible(false);
            this._rotationButtons.setVisible(false);
        } else {
            if (object4 == null) {
                object4 = dataPoint.getPhoto();
            }
            this._photoLabel.setText(String.valueOf(I18nManager.getText("details.photofile")) + ": " + ((MediaObject)object4).getName());
            object3 = ((MediaObject)object4).getFullPath();
            object2 = DetailsDisplay.shortenPath((String)object3);
            this._photoPathLabel.setText(object3 == null ? "" : String.valueOf(LABEL_FULL_PATH) + (String)object2);
            this._photoPathLabel.setToolTipText(((MediaObject)object4).getFullPath());
            this._photoTimestampLabel.setText(((MediaObject)object4).hasTimestamp() ? String.valueOf(LABEL_POINT_TIME) + ((MediaObject)object4).getTimestamp().getText(this._timezone) : "");
            this._photoConnectedLabel.setText(String.valueOf(I18nManager.getText("details.media.connected")) + ": " + (((MediaObject)object4).getCurrentStatus() == MediaObject.Status.NOT_CONNECTED ? I18nManager.getText("dialog.about.no") : I18nManager.getText("dialog.about.yes")));
            if (((Photo)object4).getBearing() >= 0.0 && ((Photo)object4).getBearing() <= 360.0) {
                this._photoBearingLabel.setText(String.valueOf(I18nManager.getText("details.photo.bearing")) + ": " + (int)((Photo)object4).getBearing() + " \u00b0");
            } else {
                this._photoBearingLabel.setText("");
            }
            this._photoThumbnail.setVisible(true);
            this._photoThumbnail.setPhoto((Photo)object4);
            this._rotationButtons.setVisible(true);
            if ((n & 0x10) > 0) {
                this._photoThumbnail.refresh();
            }
        }
        this._photoThumbnail.repaint();
        this._audioDetailsPanel.setVisible(this._trackInfo.getAudioList().hasAny());
        object3 = this._trackInfo.getAudioList().get(this._trackInfo.getSelection().getCurrentAudioIndex());
        if (object3 == null) {
            this._audioLabel.setText(I18nManager.getText("details.noaudio"));
            this._audioPathLabel.setText("");
            this._audioPathLabel.setToolTipText("");
            this._audioTimestampLabel.setText("");
            this._audioLengthLabel.setText("");
            this._audioConnectedLabel.setText("");
        } else {
            this._audioLabel.setText(String.valueOf(LABEL_AUDIO_FILE) + ((MediaObject)object3).getName());
            object2 = ((MediaObject)object3).getFullPath();
            object = DetailsDisplay.shortenPath((String)object2);
            this._audioPathLabel.setText(object2 == null ? "" : String.valueOf(LABEL_FULL_PATH) + (String)object);
            this._audioPathLabel.setToolTipText((String)(object2 == null ? "" : object2));
            this._audioTimestampLabel.setText(((MediaObject)object3).hasTimestamp() ? String.valueOf(LABEL_POINT_TIME) + ((MediaObject)object3).getTimestamp().getText(this._timezone) : "");
            int n4 = ((AudioClip)object3).getLengthInSeconds();
            this._audioLengthLabel.setText(n4 < 0 ? "" : String.valueOf(LABEL_RANGE_DURATION) + DisplayUtils.buildDurationString(n4));
            this._audioConnectedLabel.setText(String.valueOf(I18nManager.getText("details.media.connected")) + ": " + (((MediaObject)object3).getCurrentStatus() == MediaObject.Status.NOT_CONNECTED ? I18nManager.getText("dialog.about.no") : I18nManager.getText("dialog.about.yes")));
        }
        this._playAudioPanel.setVisible(object3 != null);
    }

    private static JPanel makeDetailsPanel(String string, Font font) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        JLabel jLabel = new JLabel(I18nManager.getText(string));
        jLabel.setFont(font);
        jPanel.add(jLabel);
        return jPanel;
    }

    private static JButton makeRotateButton(String string, GenericFunction genericFunction) {
        JButton jButton = new JButton(IconManager.getImageIcon(string));
        jButton.setToolTipText(genericFunction.getName());
        jButton.setMargin(new Insets(0, 2, 0, 2));
        jButton.addActionListener(new FunctionLauncher(genericFunction));
        return jButton;
    }

    private static String shortenPath(String string) {
        String string2 = string;
        String string3 = System.getProperty("user.home").toLowerCase();
        if (string != null && string.toLowerCase().startsWith(string3)) {
            string2 = string.substring(string3.length() + 1);
        }
        return DetailsDisplay.shortenString(string2);
    }

    private static String shortenString(String string) {
        if (string == null || string.length() < 21) {
            return string;
        }
        return String.valueOf(string.substring(0, 20)) + "...";
    }

    private int getSelectedCoordFormat() {
        switch (this._coordFormatDropdown.getSelectedIndex()) {
            case 1: {
                return 10;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 12;
            }
        }
        return 19;
    }
}

